<!-- IDC Sampler 1.1 29th June 1994  -->

<header start=Menu>
<title>An IDC Sampler</title>
<copyright>1993 Computer Based Learning Unit, The University of Leeds</copyright>
<caption>IDC Sampler 1.1</caption>
<credits>Designed and produced by Kenneth Tait</credits>
<date>29th June 1994</date>
</header>

<body>

<!-- -------------------------------------------- Introductory Menu -->

<f0 name=Menu>
Illustrative Formats
<o go=MCQ>Multiple-choice Questions</o>
<o go=Test-Teach>Test-Teach Exercises</o>
<o go=Presentation>Presentation</o>
<o go=Hyperbook>Hyperbook</o>
<o go=Linking>Linking other applications</o>
<o go="Interactive Image">Interactive Images</o>
<o go=Animation>Simple Animation</o>
</f0>

<!-- -------------------------------------------- Multiple Choice Questions -->

<f1 name=MCQ next=MCQ1>
<h1>Multiple-choice Questions</h1>
The following sequence of pages illustrates some possible styles of multiple-choice question.  <p>As with all formats changes in colour, layout of the screen and details of the interaction could be changed to meet particular requirements.
</f1>

<f1 name=MCQ1 next="Simple MCQ">
<h2>A simple multiple-choice question</h2>
In this question the learner has only <emp>one</emp> chance to pick the correct answer.  This results in either confirmation of the answer or the correct answer being displayed.  In either case the same short explanation is given.
<p>There is an active phrase in the explanation which when clicked gives further information.  This active phrase could have been a link to another page, another document or another application.
<p>Notice that the menu bar is not displayed for these pages.
</f1>

<f3 name="Simple MCQ" image=graph next=MCQ2>
In any interval of time which of the following is represented by the total area between the curve and the time axis?
<o ans=y>distance travelled during the interval</o>
<o>distance from starting point</o>
<o>mean acceleration during the interval</o>
<o>average speed over the interval</o>
<o>maximum velocity reached during the interval</o>
<x>If velocity is in metres per second and time in seconds then a unit of area which is one second by 1 metre per second will represent <a go=area>one metre, that is distance</a>.</x>
</f3>

<fn name=area>One metre per second multipled by one second
gives one metre: so area represents distance.  If the interval of time was zero then the area would be zero so the area must represent distance travelled in the interval.
</fn>

<f1 name=MCQ2 next=Pairs>
<h2>Matched Pairs</h2>
The next example requires the learner to match items from one list with another.  In this case there are exactly the same number of items in each list.  A variation of this format would allow extra items in the "answer" list.
<p>This particular example is based on an Italian exercise used with a system called LUISA developed atthe University of Leeds by Brian Richardson and his colleagues.
</f1>

<f4 name=Pairs next=MCQ3>
Combina la traduzione inglese con quella italiana
<i>the tail<m>la coda</m></i>
<i>the fur<m>il pelo</m></i>
<i>the lair<m>la tana</m></i>
<i>the trunk<m>la proboscide</m></i>
<i>the tusk<m>la zanna</m></i>
<i>the whisker<m>il baffo</m></i>
<i>the paw<m>la zampa</m></i>
<x>Notice the links with some English words: "pelt"  meaning the skin of an animal; "proboscis" a fancy word for trunk or similar appendage; and "coda" is a musical term (from the Italian) for a short piece at the end of a longer work.
<p>It might help you to remember that la zampa means paw by thinking that a paw could stamp which is a bit like "zampa".</x>
</f4>

<f1 name=MCQ3 next="Stem and Branch">
<h2>Stem-and-branch Question</h2>
This style of MCQ is widely used in the biological sciences and medicine.  The example you will see is taken from a large bank of such questions in Pharmacology which has been used at Leeds in various forms for more than ten years.
<p>A section of the bank is supplied with this IDC Sampler as a separate system.
</f1>

<f5 name="Stem and Branch" si=amphetamine next=Menu>
Possible biotransformation pathways for amphetamine include
<br ans=t>hydroxylation
</br>
<br ans=f>dehalogenation
</br>
<br ans=t>dealkylation
</br>
<br ans=f>deamination
</br>
<br ans=f>methylation
</br>
<x>MAO. No catechol groups thus COMT inactive. Look at functional groups.
Phenyl ring hydroxylated. Nitrogen is dealkylated.
<p>Note that deamination is very slow because of the alkyl group on the
alpha carbon of the sidechain.</x>
</f5>

<!-- -------------------------------------------- Test-Teach -->

<f1 name=Test-Teach next=Scotland>
<h1>Test-Teach</h1>
These are question-and-answer exercises which assume that the learner already has some knowledge, but is likely to make mistakes when answering questions.
<p>Exercises of this kind should be sufficiently difficult that some learners make mistakes.  However, it is important that mistakes are recognised so that informational feedback can be given to help the learner recognise and overcome the error.
<p>First a simple exercise as an illustration...
</f1>

<f6 name=Scotland next=Again>
Which is the largest city in Scotland?
<cr>Glasgow</cr>
<ar allow=s>Glasgow<fb>I think you mean have the right city, but you failed to spell it correctly.</fb></ar>
<ar allow=sx>Glasgow<fb>I think you mentioned the the right city - just type it's name by itself.</fb></ar>
<ar allow=x>Edinburgh<fb>Edinburgh is the capital of Scotland, but not its largest city.</fb></ar>
<ar allow=sx>Edinburgh<fb>I think you mean Edinburgh.  Edinburgh is the capital of Scotland, but not its largest city.</fb></ar>
<ar allow=sx>Aberdeen<fb>Although the centre of Scotland's oil industry it is not the largest city.</fb></ar>
<ca>The largest city in Scotland (in terms of population) is Glasgow.</ca>
<ht>The largest city in Scotland stands on the River Clyde and was once the centre of a large ship-building industry.</ht>
</f6>

<f1 name=Again next=Menu>
The Test-Teach format incorporates some simple matching algorithms which can tolerate different word order, allow extra words to be ignored and recognise an approximate spelling.
<p>The algorithms are not sophisticated, but could be improved if necessary.
<p>Although it cannot be tested with this example, the format will accept numerical answers within a specified range.
<p>If you would like to try the question again, click BACK...
</f1>

<!-- -------------------------------------------- Presentation -->

<f1 name=Presentation next=Introduction>
<h1>Presentation</h1>
What follows is a short presentation using a simple format.  Such a presentation could be used in front of an audience with the screen image projected on to a large display.
</f1>

<!-- ------- Screen 1 ------- -->
<f2 name=Introduction next=Leeds>
Getting Started with CBL

<pt>Off-the-shelf software</pt>
There is an abundance of CBL materials.  The CTI Centres for particular disciplines maintain
catalogues of these materials.  Will it adapt to you, or will you (and your students) have to
adapt to it?

<pt>Write it yourself</pt>
Authoring of CBL materials is a complex task.  It requires understanding of the subject
matter, pedagogical insight, design expertise, an appreciation of the strengths and weakness
of the technology and the ability to think like a programmer.  This remains true even when
using a powerful and sophisticated authoring system.

<pt>Buy in a programmer</pt>
May well get the materials produced, but will you be able to maintain them and develop them
as both educational requirements change and technology improves?

<pt>Collaborative development</pt>
Expertise and experience already exists.  It exists in this university.  Talk to people who have
learned important lessons.

<pt>Departmental project</pt>
In the end you will only be successful in using CBL materials if CBL is an integral part of your
department's plan.
</f2>

<!-- ------- Screen 2 ------- -->
<f2 name=Leeds next=Developments>
What is happening at Leeds?

<pt>Biochemistry</pt>
The Biological Sciences require all their students to be familiar with word processing and the
use of spreadsheets.  The CBL materials used in Biochemistry  include simulations and
diagnostic case studies.  Most of this has been developed at Leeds.

<pt>Languages</pt>
Both Russian and Italian have extensive software developed here at Leeds to support
language learning such as vocabulary and grammar exercises.

<pt>Pharmacology</pt>
For over ten years a bank of about 1500 interactive multiple-choice questions (MCQs) with
explanations has been made available to students of Dentistry and Medicine as well as those
on Pharmacology courses.  To this has been added material from other sources as well as
exercises which make use of spreadsheets.

<pt>Microbiology</pt>
A small bank of MCQs has been developed using the same system as Pharmacology.  In
addition there are a number of exercises which use the commercial Question Mark system.

<pt>Other Departments</pt>
Physical Chemistry, English, Computer Studies, Engineering all make use of some CBL
materials and there are many other departments that expect their students to use standard
software.
</f2>

<!-- ------- Screen 3 ------- -->
<f2 name=Developments next=Authoring>
What's happening in CBL?

<pt>TLTP</pt>
The Teaching and Learning Technology Programme is a nation-wide intitiative (1992-1995)
aimed at producing and supporting the use of CBL materials in higher education.  A number
of departments in the University are involved in TLTP projects.

<pt>CBL and Multimedia Support Unit</pt>
This is TLTP-funded and provides advice and supports a range of projects in the University.

<pt>The Computer Based Learning Unit</pt>
This unit was established at Leeds almost 25 years ago to investigate the potential of CBL.
It's activities cover both research and developement.  Current research is concerned with
advanced knowledge-based learning systems.  Development work is carried out in
collaboration with external bodies or departments within the University.
</f2>

<!-- ------- Screen 4 ------- -->
<f2 name=Authoring next=Menu>
Design and Production of CBL

<pt>Authoring</pt>
This is a multi-skilled activity.

<pt>A different approach</pt>
This separates out aspects of the design and automates the production.  This is approach is
suitable for the mass production of commonly used styles.

<pt>Aspects of design</pt>
Structuring of content. Design of the presentation. Programming of the interaction.
Specification of the control.

<pt>Interactive Document Compiler</pt>
This converts marked-up text together with an index of resources (such as images and other
applications) to create an 'interactive document'.  This can be a hypertext document or a
bank of MCQs or any kind of interactive activity which uses structured content.

<pt>Formats</pt>
IDC uses the concept of a 'format' which combines presentation and interaction.  There are
several versions of IDC each with a set of formats.  Each format requires the text input to be
marked-up appropriately, but a single interactive document may use several formats.
</f2>

<!-- -------------------------------------------- Hyperbook -->

<f1 name=Hyperbook next="University of Leeds">
<h1>The Hyperbook Format</h1>
This page has been produced using the Hyperbook Format.
<p>As you will see in addition to displaying text there can be a <a go=colours>picture</a>.
<p>Also links to other parts of a document (or to other documents and applications) can be added.  These links may be followed by clicking on one of the buttons that may appear at the bottom right or through active text like <a go=OK>this</a>.
<p>When you click the NEXT button you will see a more extended example.</f1>

<fn name=OK>Clicking active text or a button may bring up a window like this or take you to another page, or to another document.
</fn>

<f1 name=Colours image=C16>
<h2>Images</h2>
Most of the images in this sampler have only 16 colours, like the picture shown here of the Great Hall at the University of Leeds.  Quality would be improved if images with more colours had been used, but as yet not all systems are equipped to display a greater number of colours.  For comparison a <a go="More Colours">256 colour version</a> of the same picture is available.
</f1>

<f1 name="More Colours" image=C256>
<h2>The Great Hall, The University of Leeds</h2>
If this picture looks no better (or worse) than the one on the previous page then either your monitor is not capable of displaying an image with 256 colours or the display driver currently in use will only handle 16 colours.
</f1>

<f1 name="University of Leeds">
<h1>The University of Leeds</h1>
This example contains information about the <a go=University>University of Leeds</a>, about the <a go=City>City of Leeds</a> and something about the <a go=Region>region</a> in which it is set.
</f1>

<f1 name=University image="Great Hall">
<h2>The University of Leeds</h2>
Leeds is one of the largest and most successful universities
in the country with a long-established international
reputation for the high standard of its teaching and
research.  The University received its charter in 1904, but
its <a go=Origins>origins</a> lie in the nineteenth
century.
</f1>

<fn name=origins>The University has grown out of the
Yorkshire Technical College and the Leeds Medical School,
both of which were founded in the nineteenth century.
</fn>

<f1 name=City image="Town Hall" more=Green>
<h2>The City of Leeds</h2>
Leeds is a prosperous, commercial, industrial and manufacturing city,
and is also the cultural and sporting centre for much of the
region.  Impressive new shopping precincts complement
traditional Victorian arcades and have created a fine
regional shopping centre.
</f1>

<f1 name=Green image="Park">
<h2>A  green city</h2>
Leeds is a 'green' city, proud of its parks
and open spaces including Woodhouse Moor, close to the
University, Roundhay Park and the Temple Newsam estate.
</f1>

<f1 name=Region image=map next=Country>
<h2>Where is it?</h2>
Leeds lies in the heart of West Yorkshire close to the geographical centre of
Britain.  It has good motorway and rail connections to the
rest of the country.
</f1>

<f1 name=Country image=Country>
<h2>Areas of natural beauty</h2>
Within easy reach of Leeds are
many areas of outstanding natural beauty: the <a go=Wharfedale>Yorkshire
Dales</a>, the North York Moors and the Vale of York.
</f1>

<f1 name=Wharfedale image=Dales>
<h2>A view of Wharfedale from Beamsley Beacon</h2>
</f1>

<!-- -------------------------------------------- Linking other applications -->

<f1 name=Linking next="Link IDC">
<h1>Linking to other documents and applications</h1>
It is possible for a button or active text to either <a go=asynchronous>launch</a>  another Windows application or to enter another document that has been produced using IDC.
<p>In this latter case Quitting the second document will cause a return to the page of the first document from which the second document was called.  This enables several documents to be linked together in a <a go="MCQ Bank">unified system</a>.
</f1>

<fn name=asynchronous>
Windows applications are launched ASYNCHRONOUSLY.  This means that the document from which the new application was launched retains no control and the document and the application co-exist independently.
<p>The user remains responsible for closing the application.
</fn>

<fn name="MCQ Bank">
The Pharmacology MCQ Bank which in its entirety consists of about fifty documents is an example of such a system.  A fragment of the bank is supplied with this sampler.
</fn>

<f1 name="Link IDC" more="IDC example" next=Windows>
<h2>Linking a document produced with IDC</h2>
Both the MORE button and the active text will call up a completely separate document created with IDC.
<p>Click <a go="IDC example">this</a> or the MORE button to go to the document.
<p>To return to this page you must QUIT the document.
</f1>

<f1 name=Windows next=Menu>
<h2>Launching Windows applications</h2>
Any Windows application can be launched from an interactive document.  These are only a small number of examples.  The active text could be anything and the launch could be triggered by a button.
<p><a go=Notepad>Launch NOTEPAD</a> [The file opened will be the README.TXT supplied with this sampler.] 
<p><a go=WinHelp>Display the Windows Help File</a>.
<p><a go=Toolbook>Another Toolbook document</a> using a separate instance of Toolbook.
</f1>

<!-- -------------------------------------------- Interactive Images -->

<f1 name="Interactive Image" next=Nerve>
<h2>Interactive Images</h2>
Pictures and diagrams can be powerful organisers for information.  In the example which follows the picture of a primitive human is annotated with information about the effects of stimulating the sympathetic nerve system.  The annotation consists of labels and information (attached to <a go=circles>areas</a> on the image) which can be displayed or hidden by the user.
<p>The <a go=imu>specification of the active regions</a> is independent of the image.  It is only during compilation that the two are brought together.
</f1>

<fn name=imu>Images can be 'marked up' - that is have regions defined on them - using a separate tool also written in Toolbook.
</fn>

<fn name=circles>The areas here are all circles.  It is possible to markup an image with ellipses, rectangles or irregular polygonal regions.
</fn>

<f7 name=Nerve image=man next=Label>
<h3>The effects of sympathetic nerve stimulation</h3>

<t name=eye>Dilator pupillae muscle constricts, dilating pupil [alpha1].  Stimulation of
muscle in upper eyelid widens palpebral fissure (distance between upper and lower eyelid)
[alpha1].  Classical horror films show eyes widen and pupils dilate as fear develops.</t>

<t name=hair>pilomotor muscles constrict (hair stands on end with fear) [alpha1]</t>

<t name=heart>Rate of beat is increased (positive chronotropic effect) and force of
contraction increased (positive inotropic effect).  Dysrhythmias may be produced.  Classical
tachycardia of fear increases cardiac output to circulate more blood and prepare the body for
action. [beta1]</t>

<t name=gut> Muscle tone decreased but sphincters contract. [alpha1]</t>

<t name=mouth label="salivary secretion">Salivary secretion is stimulated (viscous saliva).
(Note that watery saliva is stimulated by cholinergic nerves.) [alpha1] </t>

<t name=lungs label=bronchioles>dilate to increase gas exchange in lungs. [beta2]</t>

<t name=skin label="blood vessels">Blood vessels in skin and gut constrict (pale with fear;
diverts blood from non-essential areas to those areas involved in action). [alpha1,alpha2]</t>

<t name=brain label="blood vessels">Blood vessels in muscle and brain dilate (to supply
oxygen and sugar  to muscles and brain in order to run, fight and think). [beta2]</t>

<t name=liver>Glycogenolysis increased, glycogen synthesis inhibited; blood sugar rises to
increase sugar supply to muscles and brain. [alpha1]</t>

<t name=spleen>Constricts to inject erythrocytes into blood stream to increase oxygen-carrying capacity</t>

<t name=testicles label="vas deferens">Vas deferens is contracted. [alpha1]</t>

<t name=uterus>Relaxed and labour contractions inhibited. [beta2]</t>

<t name=fat label="adipose tissue">Fat hydrolysed to glycerol and free fatty acids.
[beta3]</t>

</f7>

<f1 name=Label next=Computer>
<h2>Identification</h2>
The next page shows an image being used to test the user's (or learner's) ability to identify objects in the image.
<p>The example is only intended to be illustrative and not a real test of knowledge.
<p><emp>Note that all but one of the sensitive areas on the image are irregular polygons, and as there is no practical limit to the number of vertices, almost any shape can be specified for this purpose.</emp>
</f1>

<f8 name=Computer image=PC next=Menu>
Identify the parts of the computer shown in the picture.
<t name=screen>SCREEN</t>
<t name=disk>FLOPPY DISK DRIVE</t>
<t name=keyboard>KEYBOARD</t>
<t name=mouse>MOUSE</t>
<t name=monitor>MONITOR</t>
<t name=box>COMPUTER</t>
</f8>

<!-- -------------------------------------------- Animation -->

<f1 name=Animation next=Animate>
<h2>A simple animation</h2>
This animation is nothing more than a set of images (bit maps) each of which provides one frame in the sequence.  In this animation there are 16 frames which were all drawn using Paintbrush.
</f1>

<f9 name=Animate seq=ice next=Menu>
<h2>The four-stroke internal petrol combustion engine</h2>
</f9>

</body>
