// Contents ---------------------------------------------------------------
//
//   cm.c -- Common Dialog functions
//
//   Version 1.0, a Windows Socket Finger Daemon
//
//   Copyright (C) Frederick W. Bent 1994
//   All rights reserved.
//
//
// Description
//
//	The comman dialog functions to allow the user to select the
//	file that they wish to use as the "snark" file.
//
// Ends -------------------------------------------------------------------

// History ----------------------------------------------------------------
//
// 6/28/94  1.0  Fred Bent     	Started implementation
//
// Ends -------------------------------------------------------------------

// Interface Dependencies -------------------------------------------------

#define STRICT

#include <windows.h>
#include <windowsx.h>
#include <commdlg.h>
#include <ctl3d.h>
#include "fingerd.h"

// End Interface Dependencies ---------------------------------------------

// External Declarations --------------------------------------------------

extern const HINSTANCE hInst;

char szFilterSpec [128] =                       // file type filters
	     "Text Files (*.TXT)\0*.TXT\0All Files (*.*)\0*.*\0\0";

extern char szLocalFile[MAX_PATH];
extern char szFileDir[MAX_PATH];



// Common Dialog Hook Function

	BOOL CALLBACK OpenHook(HWND hwnd, UINT wm, WPARAM wParam, LPARAM lParam)

// Summary ----------------------------------------------------------------
//
//	This hook is needed to fix a bug in the common dialog box
//
// Parameters
//
//
// Return
//
//	BOOL	Returns FALSE if processed
//
// Ends -------------------------------------------------------------------

	{
		switch (wm)
		{
		case WM_INITDIALOG:
		    // We must call this to subclass the directory listbox even
		    // if the app calls Ctl3dAutoSubclass (commdlg bug)
#ifdef	USE_CTL3D
			Ctl3dSubclassDlg(hwnd, CTL3D_ALL);
#endif
			break;
 		}
		return FALSE;
	}


// Function

	void FileOpen(HWND hwndOwner)

// Summary ----------------------------------------------------------------
//
//	Uses the common dialog box to select a file name.
//
// Parameters
//
//      hwndOwner	The window handle of the owner of this dialog//
//
// Return
//
//	nothing
//
// Ends -------------------------------------------------------------------

	{
		OPENFILENAME ofn;

		/* fill in non-variant fields of OPENFILENAME struct. */

		if ( !LoadString(hInst, IDS_FILTER, (LPSTR) szFilterSpec, sizeof(szFilterSpec)))
			return;

		ofn.lStructSize     = sizeof(OPENFILENAME);
	        ofn.hwndOwner	    = hwndOwner;
	        ofn.lpstrFilter	    = szFilterSpec;
	        ofn.lpstrCustomFilter = NULL;
	        ofn.nMaxCustFilter  = 0;
		ofn.nFilterIndex    = 1;
	        ofn.lpstrFile       = szLocalFile;
	        ofn.nMaxFile	    = 120;
	        ofn.lpstrInitialDir = NULL;
	        ofn.lpstrFileTitle  = NULL;
		ofn.nMaxFileTitle   = 120;
		ofn.lpstrTitle      = "Browser";
		ofn.lpstrDefExt     = "TXT";
		ofn.Flags 	    = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_ENABLEHOOK | OFN_NOCHANGEDIR;
		ofn.lpfnHook 	    = (UINT (CALLBACK *)(HWND,UINT,WPARAM,LPARAM)) MakeProcInstance((FARPROC)OpenHook, hInst);
	        ofn.lCustData 	    = 0;
	        ofn.lpTemplateName  = 0;

	        GetOpenFileName ((LPOPENFILENAME)&ofn);
		FreeProcInstance((FARPROC)ofn.lpfnHook);

		return;
	}

