//
// Finger Version 1.0, a Windows Sockets Finger Client
//
// Copyright (C) 1994 by Zoran Dukic.
//
// Permission to use, modify, and distribute this software and its
// documentation for any purpose and without fee is hereby granted, provided
// that the above copyright notice appears in all copies and that both
// that copyright notice and this permission notice appear in supporting
// documentation.  Zoran Dukic makes no claims as to the suitability of this 
// software for any purpose.
//

#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include <winsock.h>
#include <memory.h>
#include <owl.h>
#include <object.h>
#include <combobox.h>
#include <edit.h>
#include <scrollba.h>

#include "fingerrc.h"

//
// Finger include holds all shared data, function & class definitions.
//

//
// Windows Sockets 1.0 versions define inet_addr as returning a struct,
// whereas later version use an unsigned long.  We use the latter
// definition and provide a #define for backwards compatability.
//


#define WSVERSION 0x101                   // Windows Sockets version

#if (WSVERSION == 0x100)
   #define INET_ADDR ul_inet_addr
   u_long ul_inet_addr(char *szIP);

   u_long ul_inet_addr(char *szIP)        // make our own inet_addr
   {
      IN_ADDR in;

      in = inet_addr(szIP);
      return in.s_addr;
   }
#else                               
   #define INET_ADDR inet_addr            // WS DLL has the right inet_addr
#endif


#define dim(x) (sizeof(x) / sizeof(x[0]))


#define MAXTEXT   132

#define FE_ERROR     1  // finger operation was not successful
#define FE_NOPORT    2  // failure to resolve finger service to a port 
#define FE_NOHOST    3  // failure to resolve host specifier
#define FE_NOSOCK    4  // failure to obtain socket for connection
#define FE_NOCONN    5  // failure to connect to remote finger server
#define FE_NOSEND    6  // failure to send finger query
#define FE_NORECV    7  // failure to receive finger data

// messages for windows sockets returns
#define WM_SERVICE            (WM_USER + 1)
#define WM_HOSTRESOLVED       (WM_USER + 2)
#define WM_CONNECTED          (WM_USER + 3)
#define WM_OKTORECV           (WM_USER + 4)
#define NETWINDOW "NetWindow"

#define MAXHOST   40
#define MAXUSER   40

#define  LF 10                         // linefeed
#define  CR 13                         // carriage return
#define  TABSTRING "        "          // 8 character tab


/***********************************
 * Class and structure declaration *
 ***********************************/

_CLASSDEF(TFingerApp)
_CLASSDEF(THostDlg)
_CLASSDEF(TFingerWnd)
_CLASSDEF(TNetWnd)
_CLASSDEF(THostTransfer)
_CLASSDEF(TLine)
_CLASSDEF(TOutputWnd)


typedef unsigned long IPA;
typedef IPA FAR *LPIPA;
typedef LPIPA FAR *LPPIPA;


typedef struct                      // associates an error code with text
{
   UINT err;
   char *sztext;
} ERRENTRY;


// transfer structure for host dialog

struct THostTransfer
{
     PTComboBoxData pHost;
     char pUser[41];
};


// application class

class TFingerApp : public TApplication
{
public:

     TFingerApp(LPSTR AName, HINSTANCE hInstance, HINSTANCE hPrevInstance,
             LPSTR lpCmdLine, int nCmdShow)
	   : TApplication(AName, hInstance, hPrevInstance, lpCmdLine, nCmdShow) {};
     virtual void InitMainWindow();
};


// Host Dialog class

class THostDlg : public TDialog
{
public:

     PTComboBox pHostCombo;

     THostDlg(PTWindowsObject AParent, LPSTR AName, PTModule AModule = NULL);

     virtual void WMControlColor(TMessage& Msg)
	       = [WM_FIRST + WM_CTLCOLOR];

     virtual void Cancel(RTMessage Msg)
     	       = [ID_FIRST + IDCANCEL];

     virtual void HandleFingerMsg(RTMessage Msg)
	       = [ID_FIRST + ID_FINGER];
     virtual void HandleCloseMsg(RTMessage Msg)
	       = [ID_FIRST + ID_CLOSE];
     virtual void HandleAboutMsg(RTMessage Msg)
	       = [ID_FIRST + ID_ABOUT];
     virtual void HandleDeleteMsg(RTMessage Msg)
	       = [ID_FIRST + ID_DELETEHOST];
     virtual void HandleSaveMsg(RTMessage Msg)
	       = [ID_FIRST + ID_SAVEHOST];
     virtual void WMMouseMove(RTMessage Msg)
          = [WM_FIRST + WM_MOUSEMOVE];
};



class TOutputWnd : public TWindow
{
public:

     PArray pViewList;            // ptr to displayed text
     int maxLen;
     int nClientLen;

     int nLineItems;          // number of items in display list

     int nClientLines;             // # of text lines in view
    
     TOutputWnd(PTWindowsObject AParent);
     
     virtual void Paint(HDC PaintDC, PAINTSTRUCT& PS);

     void SetRange();

     virtual void WMSize(RTMessage Msg)
	  = [WM_FIRST + WM_SIZE];
     virtual void WMMouseMove(RTMessage Msg)
          = [WM_FIRST + WM_MOUSEMOVE];
};


// Main Window - Finger Window class

class TFingerWnd : public TWindow
{
public:

     THostTransfer HostTransfer;

     PTHostDlg pHostDlg;
     PTOutputWnd pOutput;
     PTNetWnd pNetWnd;

     HCURSOR  hCursor;             // current cursor (either wait or normal)
          
     int CharY;                    // pixel character height

     TFingerWnd(PTWindowsObject AParent);
     ~TFingerWnd();

     void SetupWindow();
     
     LPSTR GetClassName();
     void GetWindowClass(WNDCLASS& AWndClass);

     void ReadHosts();
     void WriteHosts();
     virtual BOOL CanClose();

     void Repaint();

     void SetWinCaption();

     void FingerStart();
     void FingerFinish(UINT Err);
     void ReportFingerErr(UINT Err);
     void ReportWSError(UINT Err);

     void ActivationResponse(WORD Activated, BOOL IsIconified);

     virtual void WMMouseMove(RTMessage Msg)
          = [WM_FIRST + WM_MOUSEMOVE];
};



// Network window - receives WinSocket messages
 
class TNetWnd : public TWindow
{
public:

     PArray pReceiveList;              // ptr to received text

     char LineBuf[132];                // holds accumulating text line
     int LineLen;                      // length of text line
     int maxLineLen;

     WSADATA  WSAData;     	       // windows sockets info return

     char     szHostName[MAXHOST+1];    // name of host to finger
     char     szUser[MAXUSER+1];        // query for this user id (can be null)

     SOCKET   Sock;                     // connects to remote server's socket
     int      Port;                     // hold port for finger service
     char     EntBuf[MAXGETHOSTSTRUCT]; // buf for service & resolve returns

     TNetWnd(PTWindowsObject AParent);
     ~TNetWnd();

     LPSTR GetClassName();
     void GetWindowClass(WNDCLASS& AWndClass);

     void FingerStart();
     void FingerFinish(UINT Err);
     void ReportFingerErr(UINT Err);
     void LoadEntBuf(IPA ipa);

     void PushChar(char ch);
     void PushChars(char *buf, int buflen);
     void PushLine();

     virtual void DoResolveHost(RTMessage Msg)
          = [WM_FIRST + WM_SERVICE];
     virtual void DoConnect(RTMessage Msg)
	  = [WM_FIRST + WM_HOSTRESOLVED];
     virtual void DoQuery(RTMessage Msg)
          = [WM_FIRST + WM_CONNECTED];
     virtual void DoRetrieval(RTMessage Msg)
	  = [WM_FIRST + WM_OKTORECV];
};



class TLine: public Object
{
public:
    char *sztext;
    int LLen;

    TLine(char *srcbuf, int Len);

    virtual classType isA() const { return __firstUserClass; }
    virtual Pchar nameOf() const { return "TLine"; }
    virtual hashValueType hashValue() const { return 0; }
    virtual int isEqual(RCObject ALine) const
           { return LLen == ((RTLine)ALine).LLen; }
    virtual void printOn(Rostream outputStream) const
           { outputStream << LLen; }
};

/**************************************************************************/
