// Contents ---------------------------------------------------------------
//
//   ntime.rc -- Windows Resources
//
//   Version 1.0, a Freeware Windows Socket Time Client
//
//   Copyright (C) Frederick W. Bent 1994
//   All rights reserved.
//
//
// Redistribution and use in source and binary forms are permitted provided
// that the above copyright notice and this paragraph are duplicated in all
// such forms and that any documentation, advertising materials, and other
// materials related to such distribution and use acknowledge that the
// software was developed by Frederick W. Bent.  The name of the author may
// not be used to endorse or promote products derived from this software
// without specific prior written permission.  THIS SOFTWARE IS PROVIDED
// "AS IS" AND WITHOUT ANY EXPRESS OF IMPLIED WARRANTIES, INCLUDING,
// WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS 
// FOR A PARTICULAR PURPOSE.
//
// Ends -------------------------------------------------------------------

//
// Windows Sockets 1.0 versions define inet_addr as returning a struct,
// whereas later version use an unsigned long.  We use the latter
// definition and provide a #define for backwards compatability.
//
#include <winsock.h>

#ifdef USE_CTL3D
  #define CTL3DVERSION_REQ	0x200
  #define CTL3DVERSION_MAJOR	HIBYTE(CTL3DVERSION_REQ)
  #define CTL3DVERSION_MINOR 	LOBYTE(CTL3DVERSION_REQ)
#endif

#define WSVERSION 0x101                   // Windows Sockets version

#if (WSVERSION == 0x100)
   #define INET_ADDR ul_inet_addr
   u_long ul_inet_addr(char *szIP);

   u_long ul_inet_addr(char *szIP)        // make our own inet_addr
   {
      IN_ADDR in;

      in = inet_addr(szIP);
      return in.s_addr;
   }
#else                               
   #define INET_ADDR inet_addr            // WS DLL has the right inet_addr
#endif

#define WSVERSION_REQ	0x0101       	// windows sockets version 1.1
#define WSVERSION_MAJOR	LOBYTE(WSVERSION_REQ)
#define WSVERSION_MINOR HIBYTE(WSVERSION_REQ)

//
// miscellaneous
//


typedef struct                      // associates messages (or menu ids) 
{                                   // with a handler function
   UINT Code;
   LRESULT (*Fxn)(HWND, UINT, WPARAM, LPARAM);
} DECODEWORD;

#define dim(x) (sizeof(x) / sizeof(x[0]))

typedef unsigned long IPA;
typedef IPA FAR *LPIPA;
typedef LPIPA FAR *LPPIPA;


//
// exported from NETWRK_ 
//

#define FE_ERROR     	1  // finger operation was not successful
#define FE_NOPORT    	2  // failure to resolve finger service to a port 
#define FE_NOHOST    	3  // failure to resolve host specifier
#define FE_NOSOCK    	4  // failure to obtain socket for connection
#define FE_NOCONN    	5  // failure to connect to remote finger server
#define FE_NOSEND    	6  // failure to send finger query
#define FE_NORECV    	7  // failure to receive finger data
#define FE_SHUTDWN   	8  // failure to shutdown socket
#define IDS_EXIT_ACTIVE 9
#define IDS_EXITING	10
#define FE_INVLDTIME	11	// failed to get time from server
#define FE_INIT		12
#define FE_CANCEL	13
#define IDS_BAD_VERSION 14
#define FE_NOBIND	15	// failed to bind to local port
#define IDS_BRK_WINSOCK	16
#define IDS_CTL3D_VER	17

extern SOCKET sSocket;
extern int nUDPNumberRetry;
extern int nUDPTimeOutValue;

VOID FingerStart(PSTR szHost);
BOOL InitNetInst(HWND hWnd, int, int, int);
VOID InitNetApp(VOID);
VOID NetClose(VOID);
VOID FingerStop(VOID);

//
// exported from module FINGER
//

#define MAXHOST   	64		// maximum hostname
#define MAXUSER   	40
#define MAX_PATH	  (260)
#define APP_NAME  "Time Client"

extern char szUser[];        // user id for query
extern char szAppName[];
extern char szHelpFileName[MAX_PATH];
extern HINSTANCE hInst;                // this instance of finger
extern HWND	hFrame;
extern BOOL	bShouldUseTCP;		// use stream instead of datagram
extern BOOL	bUpdateSystemTime;	// should update the system time


VOID WinPrintf( HDC   hdc, int row, UINT   col, LPSTR pszFormat, ... );
VOID ReportFingerErr(UINT Err, int nWSErr);
VOID ReportWSError(int nWSErr);
VOID TimeFinish(UINT Err);
VOID SetWinCaption(PSTR szString);

//
// menu & dialog identifiers
//

#define IDM_OPEN     	1
#define IDM_SETUP    	2
#define IDM_EXIT     	3
#define IDM_HELP_INDEX 	4
#define IDM_ABOUT    	5

#define IDM_HOST1	10
#define IDM_HOST2	11
#define IDM_HOST3	12
#define IDM_HOST4	13
#define IDM_HOST5	14

#define IDC_HOSTNAME 	20
#define IDC_USER     	21
#define IDC_USETCP   	22
#define IDC_UPDATE   	23
#define IDB_CONNECT   	24
#define IDC_UDPRETRY	25
#define IDC_UDPTIME	26

#define IDT_UDP1	30
#define IDT_UDP2	31

