/* smtp.cpp -- SMTP access routines for CLMail
   Copyright 1994 by Dean Troyer

   This program is derived from Blat, a public domain Windows NT
   SMTP mailer.  Much of this code may be from WinVN.

   See clmail.cpp for complete copyright information
*/

#define NOEXT   // make declarations, not externals

#include <iostream.h>
#include "smtp.h"

void
gensock_error (char * function, int retval)
{
  cout << "error " << retval << " in function '" << function;
}  // gensock_error

// loads the GENSOCK DLL file
int load_gensock()
{
  if( (gensock_lib = LoadLibrary("gensock.dll")) == NULL )
  {
    cout << "Couldn't load 'GENSOCK.DLL'\n";
    return -1;
  }

  if( 
     ( pgensock_connect = 
      (  int (FAR PASCAL *)(char FAR *, char FAR *, socktag FAR *) )
      GetProcAddress(gensock_lib, "gensock_connect")
     ) == NULL
    )
  {
    cout << "couldn't getprocaddress for gensock_connect\n";
    return -1;
  }

  if (
      ( pgensock_getchar =
       ( int (FAR PASCAL *) (socktag, int, char FAR *) )
       GetProcAddress(gensock_lib, "gensock_getchar")
      ) == NULL
     )
  {
    cout << "couldn't getprocaddress for gensock_getchar\n";
    return -1;
  }

  if(
     ( pgensock_put_data =
       ( int (FAR PASCAL *) (socktag, char FAR *, unsigned long) )
       GetProcAddress(gensock_lib, "gensock_put_data")
     ) == NULL
    )
  {
    cout << "couldn't getprocaddress for gensock_put_data\n";
    return -1;
  }

  if(
     ( pgensock_close =
       (int (FAR PASCAL *) (socktag) )
       GetProcAddress(gensock_lib, "gensock_close")
     ) == NULL
    )
  {
    cout << "couldn't getprocaddress for gensock_close\n";
    return -1;
  }

  if(
     ( pgensock_gethostname =
       (int (FAR PASCAL *) (char FAR *, int) )       
       GetProcAddress(gensock_lib, "gensock_gethostname")
     ) == NULL
    )
  {
    cout << "couldn't getprocaddress for gensock_gethostname\n";
    return -1;
  }

  if(
     ( pgensock_put_data_buffered =
       ( int (FAR PASCAL *) (socktag, char FAR *, unsigned long) )
       GetProcAddress(gensock_lib, "gensock_put_data_buffered")
     ) == NULL
    )
  {
    cout << "couldn't getprocaddress for gensock_put_data_buffered\n";
    return -1;
  }

  if(
     ( pgensock_put_data_flush =
       ( int (FAR PASCAL *) (socktag) )
       GetProcAddress(gensock_lib, "gensock_put_data_flush")
     ) == NULL
    )
  {
    cout << "couldn't getprocaddress for gensock_put_data_flush\n";
    return -1;
  }

  return 0;
}  // load_gensock

int open_smtp_socket( void )
{
  int retval;

  /* load the library if it's not loaded */
//  if (!gensock_lib)
    if ( ( retval = load_gensock() ) ) return ( retval );

  if ( (retval = (*pgensock_connect) ((LPSTR) SMTPHost,
                                     (LPSTR)"smtp",
                                     &SMTPSock)))
  {
    if (retval == ERR_CANT_RESOLVE_SERVICE)
    {
     if ((retval = (*pgensock_connect) ((LPSTR)SMTPHost,
                                         (LPSTR)"25",
                                         &SMTPSock)))
     {
           gensock_error ("gensock_connect", retval);
           return -1;
     }
    }
  // error other than can't resolve service 
    else
    {
     gensock_error ("gensock_connect", retval);
     return -1;
    }
  }

  // we wait to do this until here because WINSOCK is
  // guaranteed to be already initialized at this point.

  // get the local hostname (needed by SMTP) 
  if ((retval = (*pgensock_gethostname) (my_hostname, sizeof(my_hostname))))
  {
    gensock_error ("gensock_gethostname", retval);
    return -1;
  }
//  strcpy( my_hostname, "pcfchb.dbs.aber.ac.uk");
  return 0;
}


int close_smtp_socket( void )
{
  int retval;

  if( (retval = (*pgensock_close) (SMTPSock)) )
  {
    gensock_error ("gensock_close", retval);
    return -1;
  }
  FreeLibrary( gensock_lib );
  return (0);
}

int get_smtp_line( void )
{
  char ch = '.';
  char in_data [MAXOUTLINE];
  char * index;
  int retval = 0;

  index = in_data;

  while (ch != '\n')
  {
   if( (retval = (*pgensock_getchar) (SMTPSock, 0, &ch) ) )
   {
      gensock_error ("gensock_getchar", retval);
      return -1;
    }
    else
    {
      *index = ch;
      index++;
    }
  }

  /* this is to support multi-line responses, common with */
  /* servers that speak ESMTP */

  /* I know, I know, it's a hack 8^) */
  if( in_data[3] == '-' ) return( get_smtp_line() );
  else return atoi(in_data);
}

int put_smtp_line( socktag sock, char far * line, unsigned int nchars )
{
  int retval;

  if( (retval = (*pgensock_put_data) (sock, line, (unsigned long) nchars)))
  {
    gensock_error ("gensock_put_data", retval);
    return -1;
  }
  return (0);
}
      
