/* smtp.h -- SMTP access routine headers for CLMail
   Copyright 1994 by Dean Troyer

   This program is derived from Blat, a public domain Windows NT
   SMTP mailer.

   See clmail.cpp for complete copyright information
*/

#ifndef _SMTP_H
#define _SMTP_H

#include "clmail.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifdef NOEXT
#define EXT
#else
#define EXT extern
#endif

EXT HINSTANCE gensock_lib;

EXT int (FAR PASCAL *pgensock_connect) (char FAR * hostname, char FAR * service, socktag FAR * pst);
EXT int (FAR PASCAL *pgensock_getchar) (socktag st, int wait, char FAR * ch);
EXT int (FAR PASCAL *pgensock_put_data) (socktag st, char FAR * data, unsigned long length);
EXT int (FAR PASCAL *pgensock_close) (socktag st);
EXT int (FAR PASCAL *pgensock_gethostname) (char FAR * name, int namelen);
EXT int (FAR PASCAL *pgensock_put_data_buffered) (socktag st, char FAR * data, unsigned long length);
EXT int (FAR PASCAL *pgensock_put_data_flush) (socktag st);

EXT socktag SMTPSock;
EXT char SMTPHost[SERVER_SIZE];
EXT char my_hostname[1024];

void gensock_error (char * function, int retval);
int load_gensock();

int open_smtp_socket(void);
int close_smtp_socket(void);
int get_smtp_line(void);
int put_smtp_line(socktag sock, char far * line, unsigned int nchars);

#ifdef __cplusplus
}
#endif

#endif  // !_SMTP_H


