@echo off

REM ========================================
REM Check if too many parameters were given.
REM ========================================

if not "%2"=="" goto USAGE

REM ===========================
REM Check if running Windows NT
REM ===========================

set CHIP=\perftool
if "%PROCESSOR_ARCHITECTURE%"=="" goto USAGE
if "%PROCESSOR_ARCHITECTURE%"=="x86" goto PROCESSORSUPPORTED
if "%PROCESSOR_ARCHITECTURE%"=="MIPS" goto PROCESSORSUPPORTED
if "%PROCESSOR_ARCHITECTURE%"=="ALPHA" goto PROCESSORSUPPORTED
goto USAGE

REM ==============================
REM If a parameter is given use it
REM ==============================

:PROCESSORSUPPORTED
if "%1"=="" goto FLOPPYCHECK
set RKROOT=%1\
goto SETUP

REM ============================================                     
REM Check if using floppies or current directory
REM ============================================                     

:FLOPPYCHECK
set CURRENT_DIR=.\
if not exist %CURRENT_DIR%install.inf goto CDCHECK
if not exist %CURRENT_DIR%install.bat goto CDCHECK
set RKROOT=%CURRENT_DIR%
goto SETUP

REM =================
REM Check if using CD
REM =================

:CDCHECK
if not exist %CHIP%install.inf goto USAGE
if not exist %CHIP%install.bat goto USAGE
set RKROOT=%CHIP%
goto SETUP

:USAGE
echo.
echo INSTALL.BAT installs the tools described in the book, 
echo "Optimizing Windows NT", by Russ Blake (Microsoft Press, 1993.)
echo You must be running Windows NT before starting INSTALL.
echo.
echo USAGE - INSTALL [Drive or directory that contains the tools files]
echo.
echo If you specify a Drive, do not include a trailing slash.
echo If you specify a directory, it must be an absolute path that includes
echo the drive specification.
echo.
echo Example - INSTALL A:
echo Example - INSTALL B:
echo Example - INSTALL D:\PERFTOOLS
echo Example - INSTALL \\SERVER\SHARE\PERFTOOLS
echo.
pause
goto END

:SETUP
setup /i %RKROOT%\install.inf /s %RKROOT%
goto END

:END
