// ImpCine.cpp : Defines the initialization routines for the DLL.
//

#include "stdafx.h"
#include "ImpCine.h"
#include "arrays.h"
#include "PropDlg.h"
#include <winreg.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// DLL data

struct listInfo* pAppList;
CStdioFile		 cFile;
int				 nKind;
CString			 strPath;
CString			 IniPath;

/////////////////////////////////////////////////////////////////////////////
// CFilterApp

BEGIN_MESSAGE_MAP(CFilterApp, CWinApp)
	//{{AFX_MSG_MAP(CFilterApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFilterApp construction

CFilterApp::CFilterApp()
{
	pAppList = NULL;
}

void CFilterApp::SetRegistryKey(LPCTSTR lpszRegistryKey, LPCTSTR lpszAppName)
{
	m_pszRegistryKey = lpszRegistryKey;
	m_pszProfileName = lpszAppName;
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CFilterApp object

CFilterApp theApp;
CPropertyDlg propDlg;

/////////////////////////////////////////////////////////////////////////////
// Others Functions

BOOL GetFunctionInfo(struct functionInfo* fInfo)
{
	fInfo->lpfnSetProps     = SetProperties;
	fInfo->lpfnGetFilters   = GetFilterInfo;
	fInfo->lpfnInit		    = Initialize;
	fInfo->lpfnClose		= CloseImport;
	fInfo->lpfnGetSteps		= GetStepsNb;
	fInfo->lpfnGetNextObj	= GetNextObject;

	return TRUE;
}

BOOL SetProperties(char* lpszFilePath, char* lpszRegKey, BOOL bShowDlg)
{
	// If you dynamically link MFC DLL to your DLL, add the line
	// below in functions when you want to access resources from
	// your DLL
	AFX_MANAGE_STATE(AfxGetStaticModuleState());

	CString strKey;
	strKey.LoadString(IDS_FILTERNAME);

	// here, we're using the CWinApp function to access
	// parameters because CWinApp knows with the same function
	// if it has to read in a INI file or in the Registry
	// If it's a INI File, lpszFilePath contains only the
	// INI name (ex MEDIATEK.INI) and lpszRegKey is NULL
	// if Mediathek uses the Registry, lpszRegKey contains the 
	// key, from HKEY_CURRENT_USER (not included), and 
	// lpszFilePath contains the Application Name.
	theApp.SetRegistryKey(lpszRegKey, lpszFilePath);
	
	// TODO : Load here your parameters from registry
	// Directly into Property Dialog's variables
	// IF YOU ARE NOT USING CWinApp and MFC, please implement
	// your code so it can access both INI files, or Registry
	// Example :
	// propDlg.m_bType    = theApp.GetProfileInt(strKey, "ShortType", 1);

	if (bShowDlg)
	{
		if (propDlg.DoModal() == IDOK)
		{
			// save here all params
		}
	}

	return TRUE;
}

BOOL GetFilterInfo(struct filterInfo* fInfo)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState());
	CString strDummy;

	strDummy.LoadString(IDS_FILEEXT);
	lstrcpy(fInfo->fileExt, strDummy);

	strDummy.LoadString(IDS_FILETYPE);
	lstrcpy(fInfo->fileString, strDummy);

	fInfo->uMediaType = IDX_VIDEO;

	return TRUE;
}

BOOL Initialize(char* lpszFilePath, struct listInfo* pListArray)
{
	pAppList = pListArray;

	if (!cFile.Open(lpszFilePath, CFile::modeRead | CFile::shareDenyNone))
		return FALSE;

	strPath = lpszFilePath;

	// TODO : After opening the file, you should do here your
	// initialization procedures. You can return FALSE if 
	// something went wrong.
	return TRUE;
}

BOOL CloseImport()
{
	cFile.Close();
	pAppList = NULL;

	// TODO : you should do here your end-of-import variables
	// dumping
	return TRUE;
}

int GetStepsNb()
{
	CString Entry;
	BOOL bStatus = TRUE;
	UINT nbEntry = 0;

	// TODO : this function must count the number of Steps
	// required for importation. This number of Steps is
	// used when the progress bar is showned from Mediathek,
	// and it doesn't have to be equal to the number of 
	// entries to import.

	// The sample code below, count the number of lines in 
	// an ASCII file. However, the number of lines doesn't
	// have to be equal to the number of entries to import.

	// Count the number of entries to read
	// cFile.SeekToBegin();
	// do
	// {
	//  	if (cFile.ReadString(Entry))
	// 		nbEntry++;
	// }
	// while (!Entry.IsEmpty());

	// After you've check the number of Steps, don't forget
	// to re-initialise the file seek at beginning !
	cFile.SeekToBegin();
	
	// This function should return the number of steps 
	// required before completion, or 0 if the specified file
	// doesn't contain any Media, or if it's not the expected
	// file type
	return nbEntry;
}

// return -2:Error/ -1:EOF/ 0:nothing, x:xEntry
int GetNextObject(void* pListObj, int* Kind)
{
	// AFX_MANAGE_STATE(AfxGetStaticModuleState()); / Need resources ?

	// TODO : Write here your import code. This code
	// should go one step at a time. In a step, you
	// can import one entry.

	// the return value must be one of the following :
	// -2 : an error has occured
	// -1 : the end of file has been reached
	// 0  : nothing was imported (next step)
	// x  : x entries were imported

	// the pListObj is a pointer to a Media Object
	// big enough to contain one type (CVideo, CAudio, CSoftw
	// or CBook). All you have to do is cast this variable
	// to the Media to be imported and set Kind to the 
	// correct Media type, so that Mediathek knows what kind
	// of Media has been filled ! 
	// Kind must be IDX_NONE, IDX_VIDEO, etc...
	// casting sample : CVideo* lpVideo = (CVideo*)pListObj;

	// If you need to look in the original list to retrieve
	// some information in order to set some attributes in
	// the new imported Media, you can use the listInfo 
	// structure (Global variable pAppList) which allows
	// you to access all the Mediathek list objects.
	// These features are used in the import filters for 
	// Cinemania'96 & Microsoft Cd-Player.

	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// Down here, you add your own functions.
