/*-----------------------------------------------------------------------------
    file:   boyer32.h
    desc:   Boyer-Moore text search algorithm (Win32 version) header
    by:     Patrick Ko
    date:   6 Mar 91 - born
    revi:   4 Apr 94 - port Windows 3.1
            13 Jan 95 - v0.4
            05 Sep 96 - v1.0
-----------------------------------------------------------------------------*/
#ifndef _BOYER32_H
#define _BOYER32_H

#ifdef __cplusplus

#define CHARSETSIZE     256

class BOYER {

private:
	UINT m_plen;

	// pattern
	BYTE *m_p;

	// pattern for ignore-case search
	BYTE *m_pIC;      

	// skip tables
	UINT m_skip[CHARSETSIZE];
	UINT m_skipb[CHARSETSIZE];
	UINT m_skipIC[CHARSETSIZE];
	UINT m_skipbIC[CHARSETSIZE];

	void Setup(BYTE *p, UINT plen);

public:
	// assume ASCIIZ
	BOYER (BYTE * p);

	// non-ASCIIZ
	BOYER (BYTE * p, UINT plen);
	~BOYER();

	BYTE * Find( BYTE * s, UINT slen );
	BYTE * FindBackward( BYTE * s, UINT slen );
	BYTE * FindIC( BYTE * s, UINT slen );
	BYTE * FindBackwardIC( BYTE * s, UINT slen );
};

#endif

typedef HANDLE HFIND;

#ifdef __cplusplus
extern "C" {
#endif

HFIND WINAPI CreateFindHandle( BYTE * p_Pattern, UINT p_Size );
void WINAPI FreeFindHandle( HFIND p_hFind );
BYTE * WINAPI Find(HFIND p_hFind, BYTE * p_s, UINT p_slength);
BYTE * WINAPI FindIC(HFIND p_hFind, BYTE * p_s, UINT p_slength);
BYTE * WINAPI FindBackward(HFIND p_hFind, BYTE * p_s, UINT p_slength);
BYTE * WINAPI FindBackwardIC(HFIND p_hFind, BYTE * p_s, UINT p_slength);
BYTE * WINAPI Find2(BYTE * p_p, UINT p_plength, BYTE * p_s, UINT p_slength);
BYTE * WINAPI Find3(BYTE * p_p, BYTE * p_s, UINT p_slength);
BYTE * WINAPI FindIC2(BYTE * p_p, UINT p_plength, BYTE * p_s, UINT p_slength);
BYTE * WINAPI FindIC3(BYTE * p_p, BYTE * p_s, UINT p_slength);
BYTE * WINAPI FindBackward2(BYTE * p_p, UINT p_plength, BYTE * p_s, UINT p_slength);
BYTE * WINAPI FindBackward3(BYTE * p_p, BYTE * p_s, UINT p_slength);
BYTE * WINAPI FindBackwardIC2(BYTE * p_p, UINT p_plength, BYTE * p_s, UINT p_slength);
BYTE * WINAPI FindBackwardIC3(BYTE * p_p, BYTE * p_s, UINT p_slength);

#ifdef __cplusplus
}
#endif

#endif
