/*---------------------------------------------------------------------------
    file:   huntc.c
    desc:   C example of using BOYER32
    by:     Patrick Ko
    date:   6 sep 96
---------------------------------------------------------------------------*/

#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

#include <boyer32.h>

#define ZOOSIZE     4
#define ZOOSIZEM    ZOOSIZE * 1024 * 1024

const char * target = "Tiger, Lion, Leopard, Jaguar, Puma, Wild Cat";
void usage();

void main(int argc, char ** argv)
{
    BYTE * s, * r;
    time_t t;
    UINT i, l;

    if (argc < 2)
    {
        usage();
    }

    if ((s = (BYTE *)malloc(sizeof(char) * ZOOSIZEM)) == NULL)
    {
        printf("Not enough space for the zoo\n");
        exit (1);
    }

    srand(time(NULL));
	for (i=0; i<ZOOSIZEM; i++)
	{
		s[i] = rand() % 256;
	}

    l = ZOOSIZEM / RAND_MAX * rand();
    printf("Animals offset = %u\n", l);
    strcpy((char *)s + l, target);

    t = time(NULL);
    if ((r = Find3((BYTE *)argv[1], (BYTE *)s, ZOOSIZEM)) != NULL)
        printf("Find3() offset = %u, time=%u msec\n", r - s, time(NULL) - t);
    else
        printf("Find3() not found\n");

    t = time(NULL);
    if ((r = FindIC3((BYTE *)argv[1], (BYTE *)s, ZOOSIZEM)) != NULL)
        printf("FindIC3() offset = %u, time=%u msec\n", r - s, time(NULL) - t);
    else
        printf("FindIC3() not found\n");

    t = time(NULL);
    if ((r = FindBackward3((BYTE *)argv[1], (BYTE *)s + ZOOSIZEM - 1, ZOOSIZEM)) != NULL)
        printf("FindBackward3() offset = %u, time=%u msec\n", r - s, time(NULL) - t);
    else
        printf("FindBackward3() not found\n");

    t = time(NULL);
    if ((r = FindBackwardIC3((BYTE *)argv[1], (BYTE *)s + ZOOSIZEM - 1, ZOOSIZEM)) != NULL)
        printf("FindBackwardIC3() offset = %u, time=%u msec\n", r - s, time(NULL) - t);
    else
        printf("FindBackwardIC3() not found\n");

    free(s);
}

void usage()
{
    printf("In the %dM space zoo, some targets are hidden:\n", ZOOSIZE);
    printf("\t%s\n", target);
    printf("Your mission is to hunt them.\n");
    printf("Usage:\n");
    printf("\thuntc <animal name>\n");

	exit (0);
}
