// =========================================================================
//       LEdit - Large Edit Control for Windows
//       ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//       Version 1.08(16-bit and 32-bit variants)
//       (c) 1995-1996 Andrey B. Yastrebov
//       Nobody can modify this file without written permission of author
//
//       Limitations of current version:
//       Summary length of all editing files: min(ca 60M,your memory)
//       Maximum line length: 8K
//
//       This file containts full definitions and documentation on constants
//       and functions needed to deal with LEdit control
//       !!! Many things have different meaning than in stanard "Edit" !!!
//       ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//
//       Windows      is a trademark of Microsoft corp.
//       Magma Editor is a trademark of Magma Systems
//
//       If you have some questions please contact:  xor@hawk.usr.pu.ru
// =========================================================================
#ifndef RC_INVOKED
#include <Windows.h>
#endif
#ifndef LEDIT_H
#define LEDIT_H

// $$$ 32-bit difference: In 32-bit environment use class names "LEdit32"
//     and "LEditGroup32" instead of "LEdit" and "LEditGroup"

#ifdef WIN32
#define LEDIT_CLASS "LEdit32"
#define LEDITGROUP_CLASS "LEditGroup32"
#else
#define LEDIT_CLASS "LEdit"
#define LEDITGROUP_CLASS "LEditGroup"
#endif


// EDIT STYLES
// =========================================================================
//  Here are possible styles that may be specified in CreateWindow. WS_XXX
//  styles may also apply, but are not listed. Class name when creating
//  control should be "LEdit". This is global class registered when LEDIT.DLL
//  is loaded


#define ES_HASFILE                 1
     // ** The control with this style automatically handles files, that is
     //    it stores file name, can automatically load and save files and
     //    checks whether user saved them

#define ES_HASMENU                 2
     // ** The control with this style has normal menu with the same structure
     //    as pop-up menu. Its handle may be received with GetMenu(). This
     //    style can't be combined with WS_CHILD. The menu actually contains
     //    the same submenus as pop-up menu if ES_HASNOTPOPUP isn't specified

#define ES_HASNOTPOPUP             4
     // ** The control with this style has NOT pop-up menu which appears when
     //    user clicks right mouse button. Menu allows file operations,
     //    undo/redo, block operations, searches and changing font. The menu
     //    may be changed by programmer. Its handle may be received with
     //    EM_GETHANDLE. May be combined with ES_HASMENU

#define ES_CANCHANGEFONT           8
     // ** Predefined menus contains an item allowing user to change font

#define ES_CANCHANGEFILE          16
     // ** Predefined menus contains items allowing user to open new or
     //    existing file. Requires ES_HASFILE style and one or both of
     //    ES_HASMENU and not ES_HASNOTPOPUP styles

#define ES_FOLLOWFILENAME         32
     // ** The control with this style changes its caption according to file
     //    loaded. Anyway window caption may be changed with SetWindowText()

#define ES_USESHORTNAME           64
     // ** The control with this style changes its caption according to file
     //    loaded. Caption contains only file name (no path is specified)
     //    This style makes sense only along with ES_FOLLOWFILENAME
     //    Anyway window caption may be changed with SetWindowText()

#define ES_FILELOWER             128
     // ** When this style is specified, file names are always represented in
     //    lower case [using AnsiLower()]. It makes sense only if ES_HASFILE
     //    is specified

#define ES_LOADFROMPARAM         256
     // ** Parameter is used to initialize control content. Otherwise window
     //    is initialized from the title supplied. In both cases it should be
     //    NULL-terminating string. Its meaning depends on whether ES_HASFILE
     //    style is specified.
     //
     //    If ES_HASFILE is specified the initialization string should
     //    represent file name. But if it is in form
     //    "LEdit-Ask-User-EXT/FileMask" the open file dialog appers and user
     //    is asked for filename. EXT should be replaced by actual default
     //    extension. FileMask should be replaced by file filter in the form
     //    required by GetOpenFileName() but with zeroes replaced by slashes
     //    ( "/" ). Real slashes must be doubled. For example the following
     //    string may be useful to load text files:
     //    "LEdit-Ask-User-txt/Text files/*.txt/All files/*.*/"
     //    Errors in the string after "LEdit-Ask-User-" may cause crash.
     //    File filter must not be longer than 255 characters
     //
     //    If ES_HASFILE is NOT specified the initialization string is
     //    directly loaded into control unless it is in form
     //    "LEdit-File-Init-FileName", in which case FileName should be
     //    replaced by actual file name. Then this file is loaded into the
     //    control. This does not mean that the control gets style ES_HASFILE.
     //    The file is used only initially
     //
     //    Both tockens "LEdit-Ask-User-" and "LEdit-File-Init-" are case
     //    sensative, that is "LEDIT-FILE-init-" won't work

#define ES_HIGHLIGHT             512
     // ** Induces control to send EM_CTLCOLOREX messages to determine colors
     //    when drawing each word. Otherwise, only standard WM_CTLCOLOR
     //    messages and EM_CTLCOLOR messages are to be sent with CTLCOLOR_EDIT
     //    identifiers

#define ES_TRANSPARENT          1024
     // ** Text appears transparent, not opaque. In this case an application
     //    sholuld handle EM_CTLCOLOREX function to draw background

//      ES_READONLY            = 2048;  defined in Windows.h
     // ** As in standard edit control, does not allow user to change text,
     //    but unlike it, hides caret

#define ES_SMALLINDENT          4096
     // ** Defines 2-pixel left indent

#define ES_BIGINDENT            8192
     // ** Defines 4-pixel left indent. This may be combined with
     //    ES_SMALLINDENT to give 6-pixel indent.

#define ES_SMALLSPACING        16384
     // ** Defines 2-pixel extra vertical spacing

#define ES_BIGSPACING          32768
     // ** Defines 4-pixel extra vertical spacing. This may be combined with
     //    ES_SMALLSPACING to give 6-pixel spacing

#define ES_STANDALONE           4147  //combination of styles 1+2+16+32+4096
     // ** ES_HASFILE + ES_HASMENU + es_CANCHANGEFILE +  ES_FOLLOWFILENAME +
     //    ES_SMALLINDENT
     //    This combination of styles is useful for top-level LEdit window

#define ES_MDICHILD             4129  //combination of styles 1+32+4096
     // ** ES_HASFILE + ES_FOLLOWFILENAME + ES_SMALLINDENT
     //    This is simple a combination of styles which are useful for MDI
     //    child. This does not implement that the window is MDI child. LEdit
     //    recognizes this automatically
// =========================================================================


// COMMAND IDENTIFIERS
// =========================================================================
// Here are indentifiers that LEdit accepts as wParam of WM_COMMAND messages
// Such messages may be sent to it from any window. If Ledit has some menu, as
// its style specifies, it receives these commands automatically from the menu.

#define EC_DEFAULT_LEDIT_ID     1000
     // ** That's default identifier used by LEdit to send WM_COMMAND messages
     //    to its parent if WS_CHILD style isn't specified. Otherwise it uses
     //    child identifier. This parameter may be changed using EM_SETHANDLE

#define EC_FILENEW              1001
     // ** Allows user to create <<untitled>> file. This command may be used
     //    only when ES_HASFILE is specified. It is excluded from menus if
     //    ES_CANCHANGEFILE style is specified but still can be executed

#define EC_FILEOPEN             1002
     // ** Allows user to open an existing or to create new file. This command
     //    may be used only when ES_HASFILE is specified. It is excluded from
     //    menus if ES_CANCHANGEFILE style is specified but still can be
     //    executed

#define EC_FILEREOPEN           1003
     // ** Allows user to reset file to the condition it had at the moment of
     //    last saving. This command may be used only when ES_HASFILE is
     //    specified.

#define EC_FILESAVE             1004
     // ** Allows user to save file. This command may be used only when
     //    ES_HASFILE style is specified.

#define EC_FILESAVEAS           1005
     // ** Allows user to save file with different name. This commands may be
     //    used only when ES_HASFILE is specified.

#define EC_EDITUNDO             1011
     // ** Allows user to undo last editing action. Undo buffer can be cleared
     //    using EC_TOOLSCLEARUNDOBUFFER command or with EM_EMPTYUNDOBUFFER
     //    message. The parameters of undo buffer may be changed with
     //    EM_SETUNDOPARAM. The possibility of Undo may be retrieved using
     //    EM_CANUNDO.

#define EC_EDITREDO             1012
     // ** Allows user to redo last editing action. Undo buffer can be cleared
     //    using EC_TOOLSCLEARUNDOBUFFER command or with EM_EMPTYUNDOBUFFER
     //    message. The parameters of undo buffer may be changed with
     //    EM_SETUNDOPARAM. The possibility of Redo may be retrieved using
     //    EM_CANUNDO.

#define EC_EDITCUT              1013
     // ** Allows user to delete currently selected block and save it in
     //    Clipboard. This is equivalent to EC_EDITCOPY command followed by
     //    EC_EDITCLEAR command

#define EC_EDITCOPY             1014
     // ** Allows user to copy currently selected block into clipboard

#define EC_EDITPASTE            1015
     // ** Allows user to paste block from clipboard. If at this moment some
     //    block is selected then it is previously cleared and then replaced
     //    by the content of clipboard

#define EC_EDITCLEAR            1016
     // ** Allows user to delete currently selected block without saving it.

#define EC_EDITDUPLICATE        1017
     // ** Allows user to duplicate currently selected block. This is
     //    equivalent to EC_EDITCOPY command followed by EC_EDITPASTE command,
     //    so clipboard is used.

#define EC_EDITSELECTALL        1018
     // ** Allows user to mark all the text as a block.

#define EC_SEARCHFIND           1021
     // ** Creates search dialog that allow user to find text [sub]string.
     //    Allows searches back and forth, match or do not match case, search
     //    words as determined by current syntax or not. If checkbox "Match
     //    whole words only" and input string contains many words then will
     //    find all those words. For example searching for "Function(Parm)"
     //    will find all needed expressions such as "Function ( Parm )" or
     //    even multilines such as
     //        Function (
     //                    Parm
     //                 )
     //    It also will find the match if it is broken by comments. But it
     //    won't find matches within comments. Neither will it do it within
     //    qouted text unless searching string is quoted.
     //    Backward search for whole word is highly uneffective (slow) and is
     //    to be optimized in further versions

#define EC_SEARCHNEXT           1022
     // ** Repeat search done by previous EC_SEARCHFIND command

#define EC_SEARCHREPLACE        1023
     // ** Creates replace dialog that allow user to find and replace
     //    [sub]string

#define EC_SEARCHBRACE          1024
     // ** Find match to the current brace. What's brace is determined by
     //    sending to the application EM_FINDBRACE message

#define EC_SEARCHLINE           1025
     // ** Shows a dialog where user must shoose line number. Then goes to the
     //    specified line

#define EC_SEARCHBOOKMARK       1026
     // ** Go to the line previously set by EC_SEARCHSETBOOKMARK command. This
     //    is not line number but actual line. Its position is traced as lines
     //    in the text appears or disappears. This is very fast way to jump
     //    over the text even if 90% of the text is stored in virtual memory
     //    and walking around becomes very slow

#define EC_SEARCHSETBOOKMARK    1027
     // ** Stores line, which may be used later by EC_SEARCHBOOKMARK command
     //    Current line is used.

#define EC_TOOLSCHANGEFONT      1031
     // ** Allows user to change current font. Choose font dialog from
     //    COMMDLG.DLL is displayed allowing user to change currently used
     //    font. This command appears in menus only when ES_CANCHANGEFONT
     //    style is specified

#define EC_TOOLSCLEARUNDOBUFFER 1032
     // ** Clears Undo buffer. This operation may increase an amount of memory

#define EC_TOOLSCLEARALL        1033
     // ** Clears contents of edit control, but preserves information on
     //    selected file
// =========================================================================
#ifndef RC_INVOKED


// MESSAGES
// =========================================================================
// All these messages but last five messages (EM_CTLCOLOR etc.) may be sent to
// the control to retrieve its state or change it. Aside these messages, the
// control understands all standard messages as any control does. In many
// cases when some error occurs, the control returns the following value:
#define EMP_ERROR                 -1

//      WM_SETTEXT             =   12; defined in Windows.h
#define EM_SETTEXT              1095
    // ** Changes text inside control as well as window title. If wParam is
    //    EMP_ALLTEXT then it changes editor text. Otherwise it acts just
    //    as Windows' WM_SETTEXT by changing Windows caption
    //
    //    wParam - EMP_ALLTEXT
    //    lParam - huge pointer to the text to be set. May occupy several
    //             segments. Text should be represented as NULL terminating
    //             string. Lines should be separated by CR-LF
    //    return - zero if successful
#define EMP_ALLTEXT              1

//      WM_GETTEXT             =   13; defined in Windows.h
#define EM_GETTEXT              1096  //WM_GETTEXT
    // ** Copies text from edit control to the buffer. If wParam is equal to
    //    EMP_ALLTEXT then it takes editor text. Otherwise it acts just as
    //    Windows' wm_GetText by taking Windows caption
    //
    //    wParam - EMP_ALLTEXT
    //    lParam - huge pointer to the buffer which should accept the text. It
    //             may be large enough to accept all the text. The length of
    //             the text may be determined by EM_GETTEXTLENGTH message.
    //             Please, note that this is 32-bit value which may be far
    //             more than 64K
    //    return - zero if successful

//      WM_GETTEXTLENGTH       =   14; defined in Windows.h
#define EM_GETTEXTLENGTH        1097  //WM_GETTEXTLENGTH
    // ** Determines the length of the text in edit control. If wParam is not
    //    equal to EMP_ALLTEXT then returns the size of caption in bytes as
    //    documented in Windows. Otherwise, returns text length (full 32-bit
    //    value). Line breaks are counted as two characters
    //
    //    wParam - EMP_ALLTEXT
    //    lParam - 0L
    //    return - size of the text in bytes

//      WM_SETFONT             =   48; defined in Windows.h
#ifndef EM_SETFONT
#define EM_SETFONT WM_SETFONT
#endif
//      EM_SETFONT             = 1043; defined in Windows.h
    // ** Sets font. Fully documented in Windows for WM_SETFONT. See also
    //    EM_SETLOGFONT and EM_GETLOGFONT

//      WM_HSCROLL             =  276; defined in Windows.h
//      WM_VSCROLL             =  277; defined in Windows.h
    // ** This messages may be used to scroll edit window. May be sent from
    //    any window

#define EM_CUT                   768  //WM_CUT
    // ** Deletes current selection while copying it into the clipboard
    //
    //    wParam - 0
    //    lParam - 0L
    //    return - zero if successful

#define EM_COPY                  769  //WM_COPY
    // ** Copies current selection into the clipboard without changing it
    //
    //    wParam - 0
    //    lParam - 0L
    //    return - zero if successful

#define EM_PASTE                 770  //WM_PASTE
    // ** Replaces current selection by the containts of clipboard
    //
    //    wParam - 0
    //    lParam - 0L
    //    return - zero if successful

#define EM_CLEAR                 771  //WM_CLEAR
    // ** Clear current selection or all the text. In latter case undo is
    //    impossible
    //
    //    wParam - EMP_SELECTION to clear current selection or EMP_ALLTEXT to
    //             delete all the text without undo
    //    lParam - 0L
    //    return - zero if successful
#define EMP_SELECTION            0

//      WM_UNDO                =  772;  defined in Windows.h
//      EM_UNDO                = 1047;  defined in Windows.h
#define EM_EX_UNDO              1047
    // ** Undoes or redoes action previously undone
    //
    //    wParam - one of the following
#define EMP_UNDO                 0  //undoes action
#define EMP_REDO                 1  //redoes action
    //    lParam - 0L
    //    return - zero if successful

//      EM_GETSEL              = 1024;  defined in Windows.h
#define EM_EX_GETSEL            1024
    // ** Totally different from Windows' EM_GETSEL. Actually it does the same,
    //    but the interface is very different.
    //
    //    wParam - 0
    //    lParam - far pointer to the LEDITPOSITION structure, which will
    //             receive the information on current selection
    //    return - does not matter

//      EM_SETSEL              = 1025;  defined in Windows.h
#define EM_EX_SETSEL           1025
    // ** Totally different from Windows' EM_SETSEL. Actually it does the same,
    //    but the interface is very different.
    //
    //    wParam - 0
    //    lParam - far pointer to the LEDITPOSITION structure, which contains
    //             the information on new current selection
    //    return - does not matter

#define EM_GETSELTEXTLENGTH     1026
    // ** Returns the length of selected text
    //
    //    wParam - 0
    //    lParam - 0L
    //    return - The length of currently selected text part

#define EM_GETSELTEXT           1027
    // ** Copies currently selected text from edit control to the buffer.
    //
    //    wParam - 0
    //    lParam - huge pointer to the buffer which should accept the text. It
    //             may be large enough to accept all the text. The length of
    //             the text may be determined by EM_GETSELTEXTLENGTH message.
    //             Please, note that this is 32-bit value which may be far
    //             more than 64K
    //    return - zero if successful

#define EM_SETTEXTFROMFILE      1028
    // ** Loads text from file into edit control. To do this control need not
    //    to have ES_HASFILE style. If control does have ES_HASFILE style
    //    then this acts completely as EC_FILEOPEN command
    //
    //    wParam - 0
    //    lParam -  far pointer to the NULL terminating name of the file
    //    return - zero if successful

#define EM_GETTEXTTOFILE        1029
    // ** Stores text from edit control in the file. To do this control need
    //    not to have ES_HASFILE style. If control does have ES_HASFILE style
    //    then the name of file isn't affected.
    //
    //    wParam - 0
    //    lParam -  far pointer to the NULL terminating name of the file
    //    return - zero if successful

#define EM_SETFILEFILTER        1030
    // ** Sets file filter for FileOpen dialogs. It must be no longer than 255
    //    characters and must be presented in a form:
    //    "EXT/Description/Mask/Descripton/Mask/ ... /". For example:
    //    "TXT/Text files/*.txt/All files/*.*/". Don't forget final slash. Any
    //    error here may crash LEdit.
    //
    //    wParam - 0
    //    lParam - far pointer to NULL-terminating string containing filter
    //    return - does not matter

#define EM_SETINSERTMODE        1031
    // ** Sets, clears or toggles insert mode
    //
    //    wParam - EMP_SET, EMP_CLEAR or EMP_TOGGLE
    //    lParam - 0L
    //    return - does not matter
#define EMP_SET                  1
#define EMP_CLEAR                0
#define EMP_TOGGLE               2

//      EM_GETMODIFY           = 1032;  defined in Windows.h
#define EM_EX_GETMODIFY         1032
    // ** Unlike standard edit control, LEdit allows to have multiple modify
    //    flags, which determines was the text changed since last event
    //    There may be up to 16 modify flags. Two ones are reserved. Number
    //    0 shows if the text has changed since last saving/loadsing. Flag
    //    number 1 shows if the next scanning operation (see EM_SETSCAN) is
    //    allowed. Other flags may be used as wanted along with EM_SETMODIFY
    //    message.
    //
    //    wParam - Number of modify flag (0 thru 15)
    //    lParam - 0L
    //    return - modify flag (TRUE when modified)

//      EM_SETMODIFY           = 1033;  defined in Windows.h
#define EM_EX_SETMODIFY         1033
    // ** Set one of modify flags or reset it.
    //
    //    wParam - EMP_SET OR EMP_CLEAR
    //    lParam - LOWORD - Number of modify flag (2 thru 15)
    //           - HIWORD - 0
    //    return - does not matter

//      EM_GETLINECOUNT        = 1034;  defined in Windows.h
#define EM_EX_GETLINECOUNT      1034
    // ** Returns number of lines in edit control
    //
    //    wParam - 0
    //    lParam - 0L
    //    return - Number of lines in the text

#define EM_SETLOGFONT           1035
    // ** Creates a font from LOGFONT structure (from Windows.h) and sets
    //    it as a current font. LEdit can also accept WM_SETFONT messages as
    //    described in Windows' documentation
    //
    //    wParam - 0
    //    lParam -  far pointer to the LOGFONT structure.
    //    return - does not matter

//      EM_SETHANDLE           = 1036;  defined in Windows.h
#define EM_EX_SETHANDLE         1036
    // ** Sets the handle of window which should receive WM_COMMAND messages
    //    from edit control. LEdit window may specify itself here, in which
    //    case it may be effectively subclassed to make front-end control with
    //    virtually any behaviour
    //
    //    wParam - 0
    //    lParam - LOWORD - handle of the window that will receive messages
    //             HIWORD - new identifier (ID) of Ledit window. Default is
    //                      EC_DEFAULT_LEDIT_ID if control is not child and
    //                      actual ID if it is child. If zero is specified
    //                      then old value does not change
    //    return - does not matter
    //
    // $$$ 32-bit difference: wParam and lParam meaning changed
    //
    //    wParam - new ID of LEdit window  (no more than 65535)
    //    lParam - handle of window to receive messages

//      EM_GETHANDLE           = 1037;  defined in Windows.h
#define EM_EX_GETHANDLE         1037
    // ** Retrieves handle of window currently receiving WM_COMMAND messages
    //    from the control or handles of its menus
    //
    //    wParam -                 EMP_HOST        or        EMP_MENU
    //    lParam - 0L                 V            I            V
    //    return - LOWORD - Handle of window that  I Hanle of LEdit menu or zero
    //                      receives WM_COMMAND    I if the menu does not exists
    //                      messages from LEdit    I
    //             HIWORD - LEdit identifier (ID)  I Handle of pop-up menu
    //    Note that both LEdit menus have the same submenus
#define EMP_HOST                 0
#define EMP_MENU                 1
    //    New value of wParam is available since V1.03, that causes group
    //    window handle to be returned
#define EMP_GROUP                4
    //
    // $$$ 32-bit difference: wParam and return meaning changed
    //
    //     wParam - one of the following:
#define EMP_32_HOST              0  //returns hanle of the window LEdit sends
                                 //messages to
#define EMP_32_MENU              1  //returns handle of menu if exists
#define EMP_32_POPUP             2  //returns handle of popup menu  if exists
#define EMP_32_ID                3  //returns ID of LEdit window
#define EMP_32_GROUP             4  //return hanle of LEditGroup window if exists
    //     return - handle according to wParam

#define EM_GETHORZPOSITION      1038
    // ** Returns horizontal scrolling position. This is measured in virtual
    //    units, which approximate maximum character width. Ranges from zero
    //    The units may be determined using EM_GETUNITS message
    //
    //    wParam - 0
    //    lParam - 0L
    //    return - The value of scrolling to the left

#define EM_GETFILENAME          1039
    // ** Retrieves file name. It may be also "<<untitled>>". If the style
    //    ES_HASFILE is not specified then returns empty string
    //
    //    wParam - 0
    //    lParam -  far pointer to the buffer that should accept file name.
    //    return - does not matter

#define EM_GETLOGFONT           1040
    // ** Retrieves LOGFONT structure (from Windows.h) which was last used
    //    by EM_SETLOGFONT message or created by EC_TOOLSCHANGEFONT command.
    //    Together with EM_SETLOGFONT this may be used to store font between
    //    session as a state variable. Note that messages WM_SETFONT and
    //    EM_SETFONT have no effect on result returned by EM_GETLOGFONT
    //
    //    wParam - 0
    //    lParam -  far pointer to the LOGFONT structure that will be filled
    //    return - does not matter

//      EM_LINELENGTH          = 1041;  defined in Windows.h
#define EM_EX_LINELENGTH        1041
    // ** Returns the length of specified line. It's much faster to take lines
    //    using EM_GETLINE and then analyze them, but this is remained for
    //    compatibility
    //
    //    wParam - Number of line if lParam = 0L
    //    lParam - 1-based umber of line or zero
    //    return - The length of the line
    //    Acknowledgement: This way to extend EM_LINELENGTH handler has been
    //                     taken from Magma Editor

//      EM_REPLACESEL          = 1042;  defined in Windows.h
#define EM_EX_REPLACESEL        1042
    // ** Replaces current selection by the specified text or simply insert
    //    the text at current position.
    //
    //    wParam - 0
    //    lParam - huge pointer to the text to be set. May occupy several
    //             segments. Text should be represented as NULL terminating
    //             string. Lines should be separated by CR-LF
    //    return - zero if successful

//      EM_GETLINE             = 1044;  defined in Windows.h
#define EM_EX_GETLINE           1044
    // ** Returns the text of the specified line.
    //
    //    wParam - 1-based number of line or zero
    //    lParam - far pointer to the buffer which will accept the text. If
    //             wParam is zero, then first four bytes of the buffer must
    //             contain the number of line, which allows to specify line
    //             index greater than 65535
    //    return - The length of the line

#define EM_FREE45               1045  //EM_LIMITTEXT
    // ** Reserved, has no effect

//      EM_CANUNDO             = 1046;  defined in Windows.h
#define EM_EX_CANUNDO           1046
    // ** Determines if Undo/Redo is possible
    //
    //    wParam - EMP_UNDO or EMP_REDO
    //    lParam - 0L
    //    return - TRUE if Undo/Redo is possible

#define EM_CANFINDNEXT          1048
    // ** Determines if the Search record exists
    //
    //    wParam - 0
    //    lParam - 0L
    //    return - TRUE if Search record exists and EC_SEARCHNEXT command may
    //             be executed

#define EM_GETUNITS             1049
    // ** Determines vertical (line height) and horizontal (maximum character
    //    width) scrolling units
    //
    //    wParam - 0
    //    lParam - 0L
    //    return - LOWORD - Horizontal scrolling unit in pixels
    //             HIWORD - Vertical scrolling units in pixels

#define EM_ENABLEMENU           1050  //the same value as Windows' EM_SETWORDBREAK
    // ** Enables menu according to control state. Very useful for MDI windows.
    //    LEdit enables its own menus by itself. Do not worry about this
    //    and NEVER use this function for menus created by LEdit control
    //    This function also enables menu items 1041-1050 that may be useful
    //    if these items should be activated when LEdit exists
    //
    //    wParam - Menu handle
    //    lParam - 0L
    //    return - does not matter

//      EM_SETTABSTOPS         = 1051;  defined in Windows.h
#define EM_EX_SETTABSTOPS       1051
    // ** Unlike standard edit control sets only one interval of tabstopping
    //    in avereage character units (1 throught 40)
    //
    //    wParam - Interval of tabstopping
    //    lParam - 0L
    //    return - does not matter

#define EM_SETSYNTAX            1052
    // ** Sets rules that will be used to break text into the words and when
    //    extracting these words using EM_GETWORD message. This should be done
    //    by specifying a set of symbols or symbol pairs that may be evaluated
    //    as words and also separate words from each other. Line ends, spaces
    //    and tabulations are regarded as natural word delimiters
    //    see also description of SYNTAX structure below
    //
    //    wParam - LOBYTE - Number of elements in the array of SYNTAX structu-
    //                      res. This value cannot be more than 254. If this
    //                      is zero then syntax become disabled (but if lParam
    //                      is also zero, then default syntax is set)
    //             HYBYTE - Flags. One of the following
#define EMP_ITEM2ASCOMMENT       1  //If this flag is specified then second item
                                 //is interpreted as alternative comment sign
                                 //not as an alternative quote.
    //    lParam -  far pointer to the array of SYNTAX structures containing
    //             description of syntactic items. The following elements of
    //             the array have special meaning:
    //             1      - Quoting character. Is used as a qoute.
    //                      In this case SYNTAX structure has special meaning
    //                      cFirst member represents quoting character
    //                      cSecond should contains in-quote modifier, that is
    //                      the character that changes the meaning of next
    //                      character. This permits inserting quoting
    //                      character into quoted text. If quoting character
    //                      (or any other character) occurs immediately after
    //                      the modifier it is disregarded and doesn't mark
    //                      end of qouted text. For example for C++ quoting
    //                      character is " and the modifier is \, that is when
    //                      \" occurs in the quoted text, its second symbol
    //                      (quote ") is not regarded as an end of quoted text
    //                      For Pascal quoted character is ' and the modifier
    //                      is also '
    //             2      - If EMP_ITEM2ASCOMMENT isn't specified then this is
    //                      alternative quote and its in-quote presentation
    //                      For C++ it may be '\. If EMP_ITEM2ASCOMMENT flag
    //                      is specified, then this is interpreted as comment
    //                      sign, which acts in the same way as 3-rd item
    //             3      - Comment sign. If the string begins with it, all
    //                      its content is skipped on EM_GETWORD and cannot be
    //                      highlighted. The same happens with the rest of a
    //                      line after this character (pair) occurs
    //             4      - Left comment sign. If it occurs in the line, the
    //                      part of the line till first occurence of right
    //                      comment sign is regarded as comment. If right
    //                      comment sign does not occur, then the comment
    //                      expands to the end of the line
    //             5      - Right comment sign.
    //
    //             All this position must be filled in. If you don't want them
    //             to function, then set BOTH members of the corresponding
    //             SYNTAX structure to 1. You can NOT use soft characters in
    //             comment items (see SYNTAX) that is cSecond member must
    //             be zero or true character with code more than 32
    //
    //             Others - symbols or symbol pairs that are threated as words
    //                      (no more than 254-5 = 249)
    //
    //             If lParam is NULL then default syntax is reset
    //             Note that LEdit analyses syntax only within lines. So,
    //             qouted strings and in-line comments cannot exceed line
    //
    //
    //    if no syntax is set, default syntax is used, which consists of the
    //    following:
    //    0 - "\  (Quoting character)
    //    1 - 0x101 (nothing)  (Alternative quoting character)
    //    2 - // (Comment sign)
    //    3 - /* (Left comment sign)
    //    4 - */ (Right comment sign)
    //    5 - !
    //    6 - %
    //    7 - (
    //    8 - )
    //    9 - *
    //   10 - ,
    //   11 - ". " - point with space after it, so-called soft point
    //               This is done to allow floating point number recognition
    //               Point will be regarded as separate word only at the ends
    //               of words. For example, point will be separate word in
    //               'Andrey B. Yastrebov', but 'xor@hawk.usr.pu.ru' all will
    //               be one big word
    //   12 - /
    //   13 - :
    //   14 - ;
    //   15 - <
    //   16 - =
    //   17 - >
    //   18 - ?
    //   19 - [
    //   20 - \
    //   21 - ]
    //   22 - ^
    //   23 - {
    //   24 - |
    //   25 - }
    //    Note, that "+" and "-" are missed in default syntax to allow
    //    recognition of numeric values starting with "+" or "-"
    //
    //    Obviously this default syntax won't match your need and is provided
    //    only as an example

//      EM_EMPTYUNDOBUFFER     = 1053;  defined in Windows.h
#define EM_EX_EMPTYUNDOBUFFER   1053
    // ** Clear undo buffer. This may be useful if there are memoty problems
    //
    //    wParam - 0
    //    lParam - 0L
    //    return - does not matter

//      EM_GETFIRSTVISIBLELINE = 1054;  defined in Windows.h
#define EM_EX_GETFIRSTVISIBLELINE  1054
    // ** Returns number of top visible line in the edit control
    //
    //    wParam - 0
    //    lParam - 0L
    //    return - Number of top line

//      EM_SETREADONLY         = 1055;  defined in Windows.h
#define EM_EX_SETREADONLY       1055
    // ** Sets or clears ReadOnly flag
    //
    //    wParam - EMP_SET or EMP_CLEAR
    //    lParam - 0L
    //    return - does not matter

#define EM_SETUNDOPARAM         1056
    // ** Changes the size of Undo buffer. It may be between 1 and value
    //    returned by EM_GETMAXUNDOBUFFER message. The function previously
    //    clears undo buffer
    //
    //    wParam - Size of Undo buffer (Undo level)
    //    lParam - 0L
    //    return - New size of Undo buffer

#define EM_GETMAXUNDOBUFFER     1057
    // ** Returns maximum size of undo buffer (Undo level) that can be set
    //    At the same time this is default value for Undo buffer. This value
    //    depends only on LEdit version
    //
    //    wParam - 0
    //    lParam - 0L
    //    return - Maximum size of Undo buffer

#define EM_FREE58          1058
    // ** Reserved. Has no effect

#define EM_SETSCAN              1059
    // ** Moves reading pointer to the top of the text and enables EM_GETWORD
    //    and EM_NEXTLINE operations. Any further changes of the text or
    //    reaching the end of the file by EM_GETWORD, EM_NEXTLINE,
    //    EM_GETRESTOFLINE and EM_GETSCAN disables these operations and force
    //    them to return EMP_ENDFILE. Therefore it is safer to turn LEdit to
    //    ReadOnly while scanning the text
    //
    //    wParam - 0
    //    lParam - 0L
    //    return - does not matter

#define EM_GETWORD              1060
    // ** Gets next word from reading position and moves this position after
    //    this word. What's word is determined by EM_SETSYNTAX. See EM_SETSCAN
    //
    //    wParam - one of the following
#define EMP_WITHINLINE           0  // pointer cannot jump over line break
#define EMP_WITHINTEXT           1  // pointer can jump over line break
    //    lParam -  far pointer to the WORDDESC structure that will be filled
    //             in by data on the word
    //    return - zero if successful or EMP_ENDFILE or EMP_ENDLINE
#define EMP_ENDFILE              1
#define EMP_ENDLINE              4

#define EM_NEXTLINE             1061
    // ** Moves reading position used by EM_GETWORD to the start of next line
    //    See EM_SETSCAN
    //
    //    wParam - 0
    //    lParam - 0L
    //    return - zero if successful or EMP_ENDFILE

#define EM_GETRESTOFLINE        1062
    // ** Retrieves the part of line from current reading position to the end
    //    of the line without moving reading position. This method is much
    //    faster than retrieving lines with EM_GETLINE. Note that the text is
    //    returned as is, including comments and quoted text. See EM_SETSCAN
    //
    //    wParam - 0
    //    lParam -  far pointer to the buffer that should accept the line. It
    //             should be large enough to accept longest line (8K)
    //    return - zero if successful or EMP_ENDFILE

#define EM_GETSCAN              1063
    // ** Retrieves the position of last item received by scanning commands.
    //    If last command was EM_NEWLINE then returns the pointer to the begin
    //    of the line. See EM_SETSCAN
    //
    //    wParam - 0
    //    lParam -  far pointer to the LEDITPOSITION structure that will
    //             receive the information. This structure may be passed to
    //             EM_SETSEL message to highlight last read item, for example
    //             to indicate user error in the text
    //    return - zero if successful or EMP_ENDFILE

#define EM_GETCURRENTWORD       1064
    // ** Gets word from caret position. What's word is determined by
    //    EM_SETSYNTAX
    //
    //    wParam - 0
    //    lParam -  far pointer to the WORDDESC structure that will be filled
    //             in by data on the word
    //    return - zero if successful or EMP_WHITESPACE
#define EMP_WHITESPACE           4

#define EM_CLOSE                1065  //the same action as WM_QUERYENDSESSION
    // ** Determines if the control can be closed. When is send to the control
    //    it responds by sending EN_GOINGTOCLOSE notification back. If an
    //    application responds 0 then checks whether there is modified
    //    file inside control. If it is, then send EN_STOREFILE notification.
    //    Returns true only if all this procedures allowed to close
    //    !!! Should never be sent from EN_GOINGTOCLOSE or EN_STOREFILE
    //    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    //        handlers because this will cause infinite loop !!!
    //        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    //
    //    wParam - 0
    //    lParam - 0L
    //    return - TRUE if control can be closed

#define EM_ISLEDITWINDOW        1066
    // ** Allows to check whether the window is LEdit window. This message
    //    returns the value of lParam sent to it plus 1
    //
    //    wParam - 0
    //    lParam - Any value
    //    return - lParam + 1

#define EM_SETRUNTIMEFLAGS      1067
    // ** Sets/Clears run-times flags. By default all flags are cleared
    //
    //    wParam - flags to be set
    //    lParam - LOWORD - flags to be cleared
    //             HIWORD - reserved - should be zero
    //    return - Doesn't matter
    //
    //    The following flags are available in current version:
#define EMP_DEFAULTSELECTION     1  // Forces selected text to be removed when
                                 // some char key, Del or BkSp is pressed
                                 // (by executing WM_CLEAR)
                                 // This is deefault Windows behaviuor
#define EMP_AUTOINDENT           2  // Turns on auto-indent
#define EMP_MULTILINEITEMS       4  // Allow using multiline strings/comments
                                 // Strings to be continued over line-break
                                 // must be ended with modifier (see the
                                 // description of EM_SETSYNTAX
                                 // Scanner takes strings line by line and
                                 // signal of them as of WD_BADLYQUOTEDTEXT
#define EMP_CURRENTWORDASTEXT    8  // All operations involving getting current
                                 // word are made as if no syntax were speci-
                                 // fied. That is word is treated as some
                                 // piece of line bounded with spaces or tabs
#define EMP_UNIXSTYLESAVE       16  // If this flag is set LEdit uses LF as line
                                 // breaks instead of CR-LF pairs. Note: when
                                 // LEdit read files it recognizes all CR, LF
                                 // or CR-LF as line breaks.
#define EMP_16_AS32             32  // Sets meaning of message parameters as in
                                 // 32-bit version. Cannot be changed in true
                                 // 32-bit LEdit. This setting doesn't affect
                                 // WM_CTLCOLOR, EM_CTLCOLOR and WM_COMMAND
                                 // messages because they are specific to
                                 // operating system
#define EMP_32_PRESERVEBITMAP   64  // Preserved bitmaps passed as a response to
                                 // WM_DRAW message from being deleted by
                                 // LEdit. If not set it deletes them. This
                                 // setting has effect in 32-bit LEdit only
                                 // or if EMP_16_AS32 flag is set
#define EMP_MACSTYLESAVE       128  // If this flag is set LEdit uses CR as line
                                 // breaks instead of CR-LF pairs. Note: when
                                 // LEdit read files it recognizes all CR, LF
                                 // or CR-LF as line breaks. EMP_UNIXSTYLESAVE
                                 // has priority over this flag
#define EMP_STARTINCOMMENTS    256  // Forces syntax analizer to think that the
                                 // left comment sign stays before the text
                                 // This flag works only if EMP_MULTILINEITEMS
                                 // is set also

#define EM_GETFILEFILTER        1068
    // ** Gets file filter for FileOpen dialogs. It will be no longer than 255
    //    characters and will be presented in a form:
    //    "EXT/Description/Mask/Descripton/Mask/ ... /". For example:
    //    "TXT/Text files/*.txt/All files/*.*/".
    //
    //    wParam - 0
    //    lParam - far pointer to NULL-terminating string containing filter
    //    return - 0 if successful

#define EM_SETBMLINE            1081
    // ** Sets bookmark. Totally 16 bookmarks are allowed, which are numbered
    //    from 0 to 15. Bookmark number 0 may be set from menu commands (see
    //    EC_SEARCHSETBOOKMARK)
    //
    //    wParam - number of bookmark to be set (0 - 15)
    //    lParam - number of line that bookmark will be attached on
    //    return - 0 if successful

#define EM_GETBMLINE            1082
    // ** Gets the location of bookmark set by EM_SETBMLINE message. As user
    //    edits text the number of line may change. If user removes bookmarked
    //    line, LEdit resets bookmark to the nearest line
    //
    //    wParam - number of bookmark to be get (0 - 15)
    //    lParam - 0
    //    return - number of bookmarked line

#define EM_SETBMATTRIBUTES      1083
    // ** Some bookmarks may be customizable coloured. This message is used to
    //    set/reset colouring and set its attributes. Bookmark highlighting
    //    has priority over syntax highlighting. If you need to set both
    //    text and background colors you need to send message twice
    //
    //    wParam - LOBYTE - number of bookmark to be used (0 - 15)
    //             HIBYTE - constant describing bookmark attributes
    //                      This should be one of the following, or any
    //                      possible combination of them
#define EMP_SETBKCOLOR           1  //Color should be submitted in lParam
                                 //Default BkColor is RED
#define EMP_SETTEXTCOLOR         2  //Color should be submitted in lParam
                                 //Default TextColor is YELLOW
#define EMP_STARTBKCOLOR         4  //Starts BkColor highlighting of the bookmark
#define EMP_STOPBKCOLOR          8  //Stops BkColor highlighting of the bookmark
#define EMP_STARTTEXTCOLOR      16  //Starts TextColor highlighting
#define EMP_STOPTEXTCOLOR       32  //Stops TextColor highlighting
#define EMP_STARTCOLORS         20  //EMP_STARTBKCOLOR + EMP_STARTTEXTCOLOR
#define EMP_STOPCOLORS          40  //EMP_STOPBKCOLOR + EMP_STOPTEXTCOLOR
    //    lParam - Color to be used to highlight bookmark
    //    return - 0 if successful

#define EM_ATTACH               1084
    // ** When there are many LEdit windows they may be organized into group
    //    LEdit controls from the same group share some attributes. Currently
    //    these are Find/Replace dialogs and Insert/Overwrite state. Group
    //    should be some real or dummy window of class "LEditGroup", that
    //    should be created before attachement. Alternatively you may create
    //    group and then send EM_ATTACH message to the group, in which case
    //    you should specify LEdit control handle in wParam. Group window may
    //    handle all the messages as if it was LEdit window. All the messages
    //    are resent to last active LEdit window, that is LEdit window that
    //    got focus the last, or first attached LEdit window. When the group
    //    is destroyed it destroys all attached LEdit controls. It is wise to
    //    create group as a child of some window, so that it may be destroyed
    //    automatically. Groups are extremely useful in MDI applications
    //
    //    wParam - handle of group window, that is window of "LEditGroup"
    //             class.
    //    lParam - flags. Currently must be 0
    //    return - zero if successful

#define EM_SETMETRICS           1085
    // ** This message allow to control appearence of LEdit
    //
    //    wParam - 0
    //    lParam - metrics to be set. They should be presented as follow:
    //             LOWORD - metrics themselves. The following groups of bits
    //                      make sense:
    //                      0-3 - Extra indent in pixels (see ES_SMALLINDENT
    //                            and ES_BIGINDENT)
    //                      4-7 - Extra spacing in pixels (see ES_SMALLSPACING
    //                            and ES_BIGSPACING)
    //                      8-15- Reserved. Must be 0
    //             HIWORD - flags - any combination of the following values
#define EMP_HSCROLL              1
#define EMP_VSCROLL              2
    //
    //    return - New metrics as they're set.

#define EM_GETMETRICS           1086
    // ** Retrieves metrics in the form required by EM_SETMETRICS
    //
    //    wParam - 0
    //    lParam - 0L
    //    return - metrics in the form required by EM_SETMETRICS

#define EM_SETHIGHLIGHT         1087
    // ** Sets or clears Highlight style  (see ES_HIGHLIGHT)
    //
    //    wParam - EMP_SET or EMP_CLEAR
    //    lParam - 0L
    //    return - does not matter

#define EM_SETTRANSPARENT       1088
    // ** Sets or clears Transparent style (see ES_TRANSPARENT)
    //
    //    wParam - EMP_SET or EMP_CLEAR
    //    lParam - 0L
    //    return - does not matter

#define EM_RESETFILESTATE       1089
    // ** Resets the state of the current file. This message actually allow to
    //    change ES_HASFILE style except that menu won't change
    //
    //    wParam - one of the following:
#define EMP_NOFILE               0  // LEdit stops handling any file information
                                 // as if EMP_HASFILE style was cleared
#define EMP_EMPTYFILE            1  // LEdit resets file info to <<untitled>>
                                 // If it didn't handle file names before this
                                 // it starts to as if EMP_HASFILE style was
                                 // set. Text is marked as modified
    //    lParam - 0L
    //    return - does not matter

#define EM_SETFINDTEXT          1090
    // ** Sets the text used to search words with Find/Replace dialog. This
    //    text may be also changed by user if he opens Find/Replace dialog
    //    You may send EM_CANFINDNEXT message to determine if actual search
    //    is possible.
    //
    //    wParam - one of the following:
    //             EMP_FIND    - Text to be searched for
    //             EMP_REPLACE - Text to replace text found
    //    lParam - far pointer to the null-terminating string containing the
    //             text - no more than 127 bytes
    //    return - 0 if successful

#define EM_GETFINDTEXT          1091
    // ** Gets the text used to search words with Find/Replace dialog. This
    //    text may be changed by user if he opens Find/Replace dialog or with
    //    EM_SETFINDTEXT message.
    //
    //    wParam - EMP_FIND or EMP_REPLACE
    //    lParam - far pointer to the buffer that should receive null-terrmi-
    //             nating string with the text - no more than 127 bytes
    //    return - 0 if successful

#define EM_SETFINDFLAGS         1092
    // ** Sets flags used with Find/Replace dialogs and with searches. These
    //    flags correspond to controls inside these dialogs.
    //    You may send EM_CANFINDNEXT message to determine if actual search
    //    is possible.
    //
    //    wParam - 0
    //    lParam - Combination of the following flags that control the search:
#define EMP_WRAPEND              1  // Wraps over the end of the text. This flag
                                 // is ignored if EMP_UP is set
#define EMP_UP                   2  // search up instead of search down.
#define EMP_WHOLEWORDS           4  // search only whole words
#define EMP_MATCHCASE            8  // match case
    //    return - 0 if successful

#define EM_GETFINDFLAGS         1093
    // ** Gets flags used with Find/Replace dialogs and with searches. These
    //    flags correspond to controls inside these dialogs.
    //    You may send EM_CANFINDNEXT message to determine if actual search
    //    is possible.
    //
    //    wParam - 0
    //    lParam - 0L
    //    return - One of the flags (see EM_SETFINDFLAGS)

#define EM_FIND                 1094
    // ** This message search for the text using current settings. Search
    //    starts at current position and the word found become highlighted
    //
    //    wParam - One of the following:
#define EMP_FIND                 0  // Search for the text
#define EMP_REPLACE              1  // If some match is currently selected then
                                 // replaces it, otherwise does nothing.
#define EMP_REPLACEALL           2  // Replaces all occurences in the text
    //    lParam - 0L
    //    return - if successfull one of the following
#define EMF_NOTFOUND             0
#define EMF_FOUND                1
    //    in case of EMP_REPLACEALL - number of items actually replaced

#define EM_CANEXECUTECOMMAND    1099
    // ** Returns TRUE if command may be executed or FALSE if not
    //
    //    wParam - one of EC_* constants describing the command
    //    lParam - 0L
    //    return - TRUE if command may be executed

#define EM_FREE80               1080
#define EM_FREE98               1098
#define EM_FREE99               1099
#define EM_FREE100              1100
#define EM_FREE101              1101
    // ** These values cannot be used in any case !!!

#define EM_NEXT_FREE            1102

#define EM_STARTRESERVED        1024
#define EM_ENDRESERVED          1199
    // ** Messages from this range are reserved for further usage
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

//      WM_CTLCOLOR           =    25;  defined in Windows.h
//  or  WM_CTLCOLOREDIT  defined in Windows.h for 32-bit systems
#define EM_CTLCOLOR             1069
    // ** Acts just as described in Window's documentation but is sent twice.
    //    One time the control sends WM_CTLCOLOR. In this case application
    //    may set text and background color as desired. After WM_CTLCOLOR,
    //    the control sends EM_CTLCOLOR message (EM_ not WM_). In this case
    //    application may change color of selected text. Messages are sent
    //    each time when the control draws itself. On receiving the message
    //    EM_CTLCOLOR an application may change also background mode and
    //    make it transparent. This may be done only if ES_TRANSPARENT style
    //    is specified and only when handling EM_CTLCOLOR (not WM_CTLCOLOR).
    //    Text drawing mode depends completely on ES_TRANSPARENT style.
    //    Application can't call any LEdit services while handling these
    //    messages
    //
    //    wParam - hDC where text and background modes may be changed, but
    //             nothing more can be done.
    //    lParam - LOWORD - Handle of control
    //           - HIWORD - COLOR_EDIT
    //    return - really does not matter
    //
    // $$$ 32-bit difference: meaning of lParam changed:
    //    lParam - Handle of control

#define EM_CTLCOLOREX           1070
    // ** This message is sent to the window accepting WM_COMMAND messages by
    //    LEdit (see EM_SETHANDLE message) to determine the color of text
    //    to be drawn for each word. It is sent only when ES_HIGHLIGHT style
    //    is specified. If you want to use your own palette then you should
    //    select and realize it when receiving WM_CTLCOLOR message, or if the
    //    window has ES_TRANSPARENT style, then while handling EM_DRAW message
    //    Application can't call any LEdit services while handling
    //    EM_CTLCOLOREX
    //
    //    wParam - hDC - the context which is used to draw. An application may
    //             execute SetTextColor() and/or SetBkColor(). Other actions
    //             may crash the control (the same applies to WM_CTLCOLOR)
    //    lParam - far pointer to the WORDDESC structure that contains the
    //             description of the word using current syntax set by
    //             EM_SETSYNTAX message
    //    return - does not matter

#define EM_DRAW                 1071
    // ** This message is sent to the application when ES_TRANSPARENT style is
    //    specified. Receiving this message means that application must draw
    //    background. !!!An application must not change DC when doing it!!!
    //                ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    //    An application should do drawing as fast as possible because LEdit
    //    redraws itself very frequently. If the drawing depends on scrolling
    //    then messages EM_GETUNITS, EM_GETFIRSTVISIBLELINE and
    //    EM_GETHORZPOSITION may be used to determine current scroll position
    //    No other LEdit services may be called while handling EM_DRAW
    //
    //    An application should cover all the client area of the window
    //
    //    To reduce blinking when scrolling window, an application may
    //    create bitmap with function CreateCompatibleBitmap(), draw on this
    //    bitmap and then pass the handle of this bitmap back to LEdit. In
    //    this case LEdit will draw its text on this bitmap and then draw it
    //    on the screen. The size of bitmap must be equal to the window size
    //    Using bitmap reduces blinking quite well but considerably slows down
    //    drawing. Otherwise an application should return zero.
    //
    //    wParam - hDC
    //    lParam - LOWORD - handle of LEdit control
    //             HIWORD - ID of LEdit control
    //    return - LOWORD - handle of memory bitmap that should be used to
    //                      draw the text on or zero if no bitmap should be
    //                      used
    //             HIWORD - one of the following:
#define EMF_NOBITMAP             0  // no bitmap is supplied
#define EMF_DELETEBITMAP         1  // bitmap should be deleted after drawing
#define EMF_PRESERVEBITMAP       2  // bitmap should not be deleted
    //    If bitmap isn't deleted then it's changed by LEdit drawing, so this
    //    option really preserves memory, not the bitmap itself
    //
    // $$$ 32-bit difference: meaning of lParam and return changed:
    //    lParam - handle of LEdit control
    //    return - handle of bitmap or zero if bimap isn't supplied. LEdit
    //             automatically deletes the bitmap unless the flag
    //             EMP_32_PRESERVEBITMAP is set with EM_SETRUNTIMEFLAGS

#define EM_FINDBRACE            1072
    // ** This message is sent to the window accepting WM_COMMAND messages
    //    from the control (see EM_SETHANDLE message) to determine the brace
    //    when the control accepts EC_SEARCHBRACE command message.
    //    Application can't change LEdit text while handling the message
    //
    //    wParam - hWnd, handle of LEdit window
    //    lParam -  far pointer to the WORDDESC structure that contains the
    //             description of a word under caret which is supposed to have
    //             a brace. If it has a brace, an application should refill in
    //             WORDDESC structure putting the description of brace word in
    //             LEdit doesn't try to find brace when caret is within
    //             commented or qouted text, nor does it try to numerically
    //             interpret the word. So, wCode member of WORDDESC may be
    //             only WD_SYNTAXITEM or WD_SIMPLEWORD. When changing WORDDESC,
    //             application also may set only one of these two flags. If it
    //             sets WD_SYNTAXITEM, HIWORD(dwValue) must contain valid index
    //             of syntax item and other fields do not matter. If it sets
    //             WD_SIMPLEWORD then the word must be placed into caWord
    //             member and other fields do not matter. Errors in answer may
    //             crash LEdit control
    //
    //             Current version of LEdit doesn't support multiple braces
    //             for example #ifndef and #ifdef are both braces to #endif
    //             This cannot be recognized in current version
    //
    //    return - application must return one of the following values
#define EMF_NOBRACE              0  // indicates that the element has no brace
#define EMF_HASLEFT              1  // the element has left brace
#define EMF_HASRIGHT             2  // the element has right brace
    //             An application can also add the following flag to the
    //             returned value to ensure case-insensitive search:
#define EMF_CASEINSENSITIVE      4
    //             This flag may be specified only when EMF_HASLEFT or
    //             EMF_HASRIGHT is returned

#define EM_WORDCLICK            1073
    // ** This message is sent to parent window when user doubleclick on word
    //    Application may perform some action, or return zero. If application
    //    returns zero LEdit select clicked word. What's word is determined by
    //    current syntax (see EM_SETSYNTAX message). Application may perform
    //    any action, for example find the word in dictionary or pronounce it.
    //    Application can't change LEdit text while handling the message if it
    //    is going to return zero
    //
    //    wParam - hWnd, handle of LEdit window
    //    lParam - far pointer to the WORDDESC structure, that contains
    //             an information on word clicked or zero if user clicked
    //             at white space or within comments
    //             !!!Application must NOT change this structure!!!
    //             ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    //    return - non-zero if application accepted the message or zero to
    //             perform default action

#define EM_DUMMY                1080
    // ** Dummy message. Should not be handled
// =========================================================================

// DATA STRUCTURES
// =========================================================================
// Here are few data structures used by LEdit

typedef struct tagLEDITPOSITION
 {
    WORD  StartPosition;
    WORD  EndPosition;
    DWORD StartLine;
    DWORD EndLine;
 }
 LEDITPOSITION, FAR *LPLEDITPOSITION;
   // TLEditPosition and PLEditPosition for Pascal
   // ** This structure describes the selection inside LEdit. Unlike standard
   //    edit control LEdit represents position as two values - 1-based number
   //    of line (DWORD) and 0-based position inside line (WORD). So, storage
   //    of currnt selection needs 12-byte structure. Note, that ending
   //    position may stay before starting one in the text

typedef struct tagSYNTAX
 {
    char cFirst;
    char cSecond;
 }
 SYNTAX, FAR *LPSYNTAX;
    // TSyntax and PSyntax for Pascal
    // ** This structure is used to represent an element of syntax array. Each
    //    combination of cFirst and cSecond characters will be interpreted as
    //    a separate word. cFirst mamber cannot be less than 33 (symbol coming
    //    next to space). cSecond may be within range 32-255 or zero. If it is
    //    between 33 and 255 then SYNTAX represents pair of symbols. If it is
    //    zero or 32 (space) then SYNTAX represents one character (cFirst).
    //    If cSecond is zero then this haracter is regarded as hard word, that
    //    is when cFirst occurs in the text it is treated as one-symbol word
    //    regardless of where it occurs. If cSecond is space then cFirst is so-
    //    called soft word. In this case cFirst is regarded as word only if a
    //    delimiter (space,tabulation or line end) comes immediately after it.
    //    See the description of EM_SETSYNTAX message above

#define WD_WORDLENGTH         1023
typedef struct tagWORDDESC
 {
    HWND   hwndSender;
    WORD   wCode;
    DWORD  dwValue;
    char   caWord[WD_WORDLENGTH + 1];
 }
 WORDDESC, FAR *LPWORDDESC;
    // TWordDesc and PWordDesc in Pascal
    // ** This structure is used by several messages to transfer information
    //   related to words according to current syntax set by message
    //   EM_SETSYNTAX
    //
    //
    //   hwndSender - handle of LEdit control which bears the structure
    //   wCode      - represents what the word is. One of the following:

#define WD_ERROR                 0
        // structure is not valid. Usually when the word
        // is larger than (WD_WORDLENGTH-1)

#define WD_SIMPLEWORD            1
        // text without qoutes. LOWORD(dwValue) contains
        // the shift of the word from the beginning of
        // the line. caWord is filled in by word

#define WD_QUOTEDTEXT        24577
        // text inside qoutes. May not be multiline
        // Quotes are included in caWord
        // LEdit never tries to interpret quoted text as
        // numeric values or something else
        // HIWORD(dwValue) contains 0 for main quotes
        // and 1 for alternative quotes (see EM_SETSYNTAX)
        // LOWORD(dwValue) contains the shift of the word
        // from the beginning of the line

#define WD_BADLYQUOTEDTEXT    8193
        // text with only left quote. Quote is included
        // in caWord. HIWORD(dwValue) contains 0 for main
        // quotes and 1 for alternative quotes
        // (see EM_SETSYNTAX). LOWORD(dwValue) contains
        // the shift of the word from the beginning of
        // the line

#define WD_SYNTAXITEM        32768
        // word is an item described in SYNTAX structure
        // HIWORD(dwValue) contains its index,
        // LOWORD(dwValue) contains the shift of the word
        // from the beginning of the line. caWord is also
        // valid

#define WD_NUMERIC               3
        // word starts with digit but cannot be
        // interpreted as integer, hex or float value
        // if "+" and "-" are NOT included in syntax
        // then all items started with "+" or "-"
        // followed by digit also fall here (see
        // EM_SETSYNTAX). dwValue says nothing
        // caWord is filled in by word

#define WD_HEXSHORT           1023
        // word is hex value in form 0x... which is less
        // than 0x80. dwValue contains the value
        // Values starting with "+" or "-" produce error
        // and will be interpreted as WD_NUMERIC. caWord
        // is valid.

#define WD_HEXBYTE            1007
        // word is hex value in form 0x... which is less
        // than 0x100 but grater than 0x7f. dwValue
        // contains the value. Values starting with "+"
        // or "-" will be interpreted as WD_NUMERIC.
        // caWord is valid.

#define WD_HEXINTEGER          975
        // word is hex value in form 0x... which is less
        // than 0x8000 but greater than 0xff
        // dwValue contains the value
        // Values starting with "+" or "-" produce error
        // and will be interpreted as WD_NUMERIC. caWord
        // is valid.

#define WD_HEXWORD             911
        // word is hex value in form 0x... which is less
        // than 0x10000 but greater than 0x7fff
        // dwValue contains the value
        // Values starting with "+" or "-" produce error
        // and will be interpreted as WD_NUMERIC. caWord
        // is valid.

#define WD_HEXLONG             783
        // word is hex value in form 0x... which is less
        // than 0x80000000 but greater than 0xffff
        // dwValue contains the value
        // Values starting with "+" or "-" produce error
        // and will be interpreted as WD_NUMERIC. caWord
        // is valid.

#define WD_HEXDWORD            527
        // word is hex value in form 0x... which is less
        // than 0x100000000 but greater than 0x7fffffff
        // dwValue contains the value.
        // Values starting with "+" or "-" produce error
        // and will be interpreted as WD_NUMERIC. caWord
        // is valid.

#define WD_HEXSIZE              15
        // word is hex value in form 0x... which is
        // grater than 0xffffffff. dwValue says nothing
        // Values starting with "+" or "-" produce error
        // and will be interpreted as WD_NUMERIC.
        // caWord is filled in by word

#define WD_NUMSHORT           1015
        // word is integer value which is less than 128
        // dwValue contains the value, possible negative
        // -128 falls in this category but +128 don't
        // caWord is also valid.

#define WD_NUMBYTE             999
        // word is integer value which is less than 256
        // but greater than 127. dwValue contains the
        // value, possible negative. caWord is also
        // valid

#define WD_NUMITEGER           967
        // word is integer value which is less than
        // 32768 but greater than 255. dwValue contains
        // the value, possible negative. -32768 falls
        // in this category but +32768 don't. caWord is
        // also valid

#define WD_NUMWORD             903
        // word is integer value which is less than
        // 65536 but greater than 32767. dwValue
        // contains the value, possible negative.
        // caWord is also valid

#define WD_NUMLONG             775
        // word is integer value which is less than
        // 2147483648 but greater than 65535. dwValue
        // contains the value, possible negative.
        // -2147483648 falls in this category, but
        // +2147483648 don't. caWord is also valid

#define WD_NUMDWORD            519
        // word is integer value which is less than
        // 4294967296 but greater than 2147483647.
        // dwValue contains the value. If the word
        // starts with "-" then this flag won't be
        // returned. LEdit returns WD_NUMSIZEFLOAT
        // instead. Note that to accept negative values
        // LEdit must NOT have "-" in current syntax.
        // caWord is also valid

#define WD_NUMSIZE               7
        // word is integer decimal which is grater than
        // 4294967295 or less than -2147483648. dwValue
        // says nothing. caWord is filled in by word

#define WD_NUMSIZEFLOAT       2055
        // the same as WD_NUMSIZE, but the value may
        // be represented as floating point value
        // (with loss of precision). (float) dwValue
        // contains this value. CaWord is valid

#define WD_FLOATSINGLE        3075
        // word may be represented as 32-bit floating
        // point value, but may not be integer, that is
        // it is in the form [+/-]ddd.ddddd, where d
        // represents any digit. Negative values may
        // appears only if "-" is not in LEdit syntax
        // (float) dwValue contains the value. CaWord
        // contains the word as it appears in the text
        // Floating values won't be recognized if point
        // is included in current syntax (see
        // EM_SETSYNTAX)

#define WD_FLOATSIZE          1027
        // word may be represented as valid floating
        // point value that is too large to fit in
        // 32-bit float. When value is too small, LEdit
        // returns WD_FLOATUNDERFLOW and fill in dwValue
        // with zero. Surely, an application may
        // try to interpret caWord as double by itself
        // dwValue says nothing. caWord contains the
        // word as it appears in the text. Floating
        // values won't be recognized if hard point is
        // included in current syntax (see EM_SETSYNTAX)

#define WD_FLOATUNDERFLOW     7171
        // word may be represented as valid floating
        // point value but is too small and is replaced
        // by zero. (float) dwValue contains zero with
        // appropriate sign


    //             Alternatively wCode may be regarded as a combination of
    //             any of the following flags:

#define WDF_WORDVALID            1  //caWord is valid
#define WDF_STARTWITHDIGIT       2  //recognized as number
#define WDF_VALIDNUMBER          4  //represents valid hex or integer
#define WDF_HEXNUMBER            8  //represents valid hex number
#define WDF_FILLBYTESIGN        16  //value may be stored in 7 bits
#define WDF_FILLBYTE            32  //value may be stored in 8 bits
#define WDF_FILLWORDSIGN        64  //value may be stored in 15 bits
#define WDF_FILLWORD           128  //value may be stored in 16 bits
#define WDF_FILLLONGSIGN       256  //value may be stored in 31 bits
#define WDF_FILLLONG           512  //value may be stored in 32 bits
#define WDF_INTEGER            512  //dwValue contains integer number
#define WDF_VALIDFLOAT        1024  //represents valid float value
#define WDF_FLOAT             2048  //(float) dwValue contains float
#define WDF_UNDERFLOW         4096  //float underflow occured
#define WDF_LEFTQUOTE         8192  //left quote was before the word
#define WDF_RIGHTQUOTE       16384  //right quote follows the text
#define WDF_SYNTAXITEM       32768  //word is found in syntax table

    //   dwValue - depends on wCode field. Usually contains numeric value of
    //             the word.
    //
    //   caWord  - sometimes conteins lexical item to be analysed
// =========================================================================


// NOTIFICATIONS
// =========================================================================
// All these messages are sent trough WM_COMMAND message to the parent of the
// control. If parent Window is missing then no messages are sent. LEdit
// automatically recognizes if it is MDI child and then send notifications to
// frame window, not to MDI client window. It is important not to pass these
// notifications to DefFrameProc!!! The window which the control sends
// messages to may be changed by sending it EM_SETHANDLE message
// Note that the meaning of WM_COMMAND parameters in 16-bit and 32-bit
// environment differ

//      EN_SETFOCUS            =  256;  defined in Windows.h
    // ** Sent when edit control catches focus

//      EN_KILLFOCUS           =  512;  defined in Windows.h
    // ** Sent when edit control looses focus

//      EN_CHANGE              =  768;  defined in Windows.h
    // ** Unlike standard edit control, this notification is sent not only
    //    when text is changing but also when caret position is changing. This
    //    is done to faciliate status line management. If you're interested in
    //    modification status you can use EM_GETMODIFY and EM_SETMODIFY which
    //    are much more powerful than in standard edit control

#define EN_INSERTMODE            800
    // ** Sent when Insertion mode is set to "Insert". It is sent only when
    //    insert mode is changed by user

#define EN_OVERWRITEMODE         801
    // ** Sent when Insertion mode is set to "Overwrite". It is sent only when
    //    insert mode is changed by user

#define EN_NEWFILE              1024
    // ** Sent when new file is loaded into control

#define EN_NEWFONT              1025
    // ** Sent when new font is selected to be used by LEdit

//      EN_ERRSPACE            = 1280;  defined in Windows.h
    // ** Sent when memory error appears.An application should respond:
    //    CMD_DOITYOURSELF  - show message box
    //    CMD_OK            - do not notify user

//      EN_MAXTEXT             = 1281;  defined in Windows.h
    // ** Sent when user action generate string greater than 8K (current
    // limitation). If such a string appears when loading file or inserting
    // from clipboard, the message is not generated and string is split
    // without notification. Do you really need strings larger than 8K ???
    //    An application should respond:
    //    CMD_DOITYOURSELF  - show message box
    //    CMD_OK            - do not notify user

#define EN_FILEERROR            1500
    // ** Sent when error occurs writing file. An application should respond:
    //    CMD_DOITYOURSELF  - show message box
    //    CMD_OK            - do not notify user

#define EN_CLIPBOARD            1501
    // ** Sent when some operation with clipboard failed
    //    An application should respond:
    //    CMD_DOITYOURSELF  - show message box
    //    CMD_OK            - do not notify user

//      EN_HSCROLL             = 1537;  defined in Windows.h
//      EN_VSCROLL             = 1538;  defined in Windows.h
    // ** Documented for Windows

#define EN_GOINGTOCLOSE         2048
    // ** Sent when closing notification comes. If the file in control was not
    //    saved this will be followed by EN_STOREFILE. Closing notification
    //    should be sent by application using EM_CLOSE message. If the control
    //    is top-level window it also comes with Windows' WM_CLOSE message.
    //    When user changes the file inside control to some other file, it
    //    also generates closing notification
    //    An application should reply:
    //    CMD_DOITYOURSELF    - proceed with closing
    //    CMD_REPLYNO         - stop closing

#define EN_STOREFILE            2049
    // ** Sent when unsaved file is to be closed. It is always preceded by
    //    EN_GOINGTOCLOSE. An application should explicitly choose an action:
    //    CMD_REPLYYES        - save file
    //    CMD_REPLYNO         - do not save file
    //    CMD_REPLYCANCEL     - do not close at all
    //    CMD_DOITYOURSELF    - let user decide

#define EN_CREATED              2100
    // ** Sent when LEdit control has been created. It's fully functional
    //    at this moment.

#define EN_DESTROY              2101
    // ** Sent when LEdit control is to be destroyed. It's window is already
    //    destroyed
// =========================================================================


// REPLIES TO NOTIFICATIONS
// =========================================================================
// These values should be used to answer WM_COMMAND messages coming from the
// control. DefWindowProc always returns CMD_DOITYOURSELF. If you answer
// CMD_DOITYOURSELF, the control shows message box where it ask the question
// you haven't answered from the handler of WM_COMMAND message

#define CMD_DOITYOURSELF           0
#define CMD_REPLYYES               1
#define CMD_REPLYOK                1
#define CMD_REPLYNO                2
#define CMD_REPLYCANCEL            3
// =========================================================================

// PROCEDURES
// =========================================================================
// These are exported by LEDIT.DLL

#ifdef __cplusplus
extern "C"
#endif
WORD WINAPI LVer(void);
  // ** This function returns the number of LEdit version. Currently 100.
  //    Calling this function is the best way to automatically load DLL
  //    Otherwise you need to use LoadLibrary() and FreeLibrary()

#ifdef __cplusplus
extern "C"
#endif
void WINAPI DisableMenu(HMENU);
  // ** This function disables all menu items with values 1003-1050 in the
  //    specified menu. Should be used in MDI window to disable menu when
  //    there are not any LEdit children.
// =========================================================================


// SUMMARY OF EDIT KEYS
// =========================================================================
// These are keys automatically processed by edit control

// Mouse left button            - cursor movement
// Mouse left button dblclk     - application defined action
//                                (see EM_WORDCLICK)
// Mouse right button           - tracking pop-up menu
//
// Arrows                       - cursor movement
// Ctrl+Left                    - one word left
// Ctrl+Right                   - one word right
// Ctrl+Vertical Arrows         - move cursor to the edge of visible area
// Home                         - to the beginning of the line
// End                          - to the end of the line
// PgDn                         - page down
// PgUp                         - page up
// Ctrl+Home,Ctrl+PgUp          - to the beginning of the text
// Ctrl+End,Ctrl+PgDown         - to the end of the text
// Shift                        - when combined with all previous keys
//                                (including mouse) expands current selection
//
// Insert                       - changes write mode
// Delete                       - deletes one symbol (doesn't clear selection)
// BkSp                         - deletes one symbol (doesn't clear selection)
// Ctrl+Y                       - deletes one line (doesn't clear selection)
// Ctrl+R                       - one word to right
// Ctrl+L                       - one word to left
//
// Ctrl+Z                       - Edit | Undo
// Ctrl+X                       - Edit | Cut
// Ctrl+C                       - Edit | Copy
// Ctrl+V                       - Edit | Paste
// Ctrl+A                       - Edit | Select All
// Ctrl+F                       - Search | Find
// Ctrl+H                       - Search | Replace
// Ctrl+G                       - Search | Goto Line Number
//
// Ctrl+Ins                     - Edit | Copy
// Shift+Ins                    - Edit | Paste
// Shift+Ctrl+Ins               - Edit | Duplicate
// Ctrl+Del                     - Edit | Clear
// Shift+Del                    - Edit | Cut
// Ctrl+BkSp                    - Edit | Undo
// Shift+Ctrl+BkSp              - Edit | Redo
// F3                           - Search | Search Next
//
// Esc                          - Disabled
//
// =========================================================================
#endif
#endif
