/***************************************************************************/
/*  This include file is the data structure for the Allocated Lock Entry.  */
/***************************************************************************/

     dcl 1 ale                based (ale_ptr) volatile,
           2 lock,
             3 name           char (32) var,
             3 address        pointer,
             3 state          bin (15), /* Locked etc   */
             3 mode           bin (15), /* Read/Write   */
             3 type           bin (15), /* Spin/Wait    */
           2 ple_ptr          pointer,
           2 locked_at        fixed dec (15), /* jiffy date time */
           2 list,
             3 next_ptr       pointer,
             3 prev_ptr       pointer,
           2 free,
             3 bit            bin (15),
             3 byte           bin (15),
           2 sublists,
             3 waiters,
               4 rle_ptr      pointer,
               4 num_rles     bin (15),
             3 holders,
               4 cle_ptr      pointer,
               4 num_cles     bin (15),
           2 meters,
             3 locks          bin (31),
             3 unlocks        bin (31),
             3 num_waits      bin (31),
             3 num_spins      bin (31),
             3 mean_time     fixed dec (15);   /* jiffies */
              
