#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <string.h>
#include <stdarg.h>
#include <stdlib.h>
#include "nndefs.h"

#define VERBOSE

	static char msg1[] = "Bad dimensions in alloc_2d_floats()\n";
	static char msg2[] = "Can't alloc storage for dimension 1 in alloc_2d_floats()\n";
	static char msg3[] = "Can't alloc storage for dimension 2 in alloc_2d_floats()\n";
	static char msg4[] = "Bad dimensions in free_2d_float()\n";
	void Logit(const char* fmt, ...);

	union {
		float f;
		long l;
		} MissingUnion;
#define MISSING (MissingUnion.f)

float  **alloc_2d_floats(int hi1d, int hi2d )
{
	int	 i;
	float **m;
	int len;
	/* check dimensions first */
	if( hi1d<1 || hi2d<1 ) {
		return NULL;
	}
	
	m = (float**) malloc (sizeof(float*) * hi1d);
	if( m == NULL ) {
		return NULL;
	}                  
	len = hi2d*sizeof(float);
	for( i=0; i<hi1d; ++i ) {
		m[i] = (float *) malloc (sizeof(float)*hi2d) ;
		if( m[i] == NULL ) {
			for( i--; i> 0; --i ) free (m[i]);
			free (m);
			return NULL;
		}
		memset (m[i],0,len);
	}
//	return NULL;                    
	// return pointer to array of pointers to rows 
//	Logit ("alloc_2d returning %lx\n",m);
	return m;

} // end alloc_2d_floats 

void free_2d_floats( float **matrix, int hi1d)
{
	int i;

	// check dimensions first 
	if( hi1d<1 ) {
		return;
	}
	if( matrix == NULL ) return;
	for( i=0; i<hi1d; i++ ) free (matrix[i]);
	free (matrix);

} // end free_2d_floats 

void ToUpper (char *s) {
	strupr(s);
}

// isstring - checks to see if the field is a string to a number 
// a number is '0123456789+-eE' but not '.'                      

int isstring (const char *s) {
	while (*s!=0) {
		if ((*s>='A') && ((*s != 'e') || (*s != 'E'))) return 1;
		s++;
	}
	return 0;
}

// Checks for see if the value should be clipped
            
int ChkClip (float f, float hi, float lo)
{
	if (f==MISSING) return 1;
	if ((hi!=MISSING) && (f > hi)) return 1;
	if ((lo!=MISSING) && (f < lo)) return 1;
	return 0;
}

void dump (const char *buf,int count)
{
    int i;
    char obuf[128];
    char tbuf[12];
    if (count==0) count=strlen(buf);

	obuf[0]=0;
	for (i=0; i < count; i++) {
		if ((i % 16) == 0) {
			strcat (obuf,"\n");
			Logit (obuf);
			sprintf (obuf,"%04x - ",i);
		} 
		sprintf (tbuf,"%02x ",(buf[i]&0xff));
		strcat (obuf,tbuf);
	}
	strcat (obuf,"\n");
	Logit (obuf);
}

void removeleadingblanks (char *s) {
	char *p = s;
	while (*p==32) p++;
	strcpy (s,p);
}

void fixfieldsize(char *s)
{
	int i;
	int l = strlen(s);
	if (l >= MAXSTRING) {
		s[MAXSTRING]=0;
		s[MAXSTRING-1]=32;
		return;
	}
	for (i=l; i < MAXSTRING; i++) s[i] = 32;
	s[MAXSTRING]=0;
}

void Logit(const char* fmt, ...)
{
	static FILE *fd;
	static char buf[512];
	extern int SessionLog;
	int ret;
	
	va_list args;
	va_start(args,fmt);
//	if (SessionLog) {
		ret = vsprintf(buf,fmt,args);
		fd = fopen("nnlib.log","a+");
		fputs (buf,fd);
		fclose(fd);
//	}
	va_end(args);
}

/* GASDEV  routine returns a gaussian dist number range approx -5 to +5 */
// example float gasdev(-13,dzdiv);


#define M1 259200
#define IA1 7141
#define IC1 54773
#define RM1 (1.0/M1)
#define M2 134456
#define IA2 8121
#define IC2 28411
#define RM2 (1.0/M2)
#define M3 243000
#define IA3 4561
#define IC3 51349

float ran1(int *idum)
{
	static long ix1,ix2,ix3;
	static float r[98];
	float temp;
	static int iff=0;
	int j;

	if (*idum < 0 || iff == 0) {
		iff=1;
		ix1=(IC1-(*idum)) % M1;
		ix1=(IA1*ix1+IC1) % M1;
		ix2=ix1 % M2;
		ix1=(IA1*ix1+IC1) % M1;
		ix3=ix1 % M3;
		for (j=1;j<=97;j++) {
			ix1=(IA1*ix1+IC1) % M1;
			ix2=(IA2*ix2+IC2) % M2;
			r[j]=(float) ((ix1+ix2*RM2)*RM1);
		}
		*idum=1;
	}
	ix1=(IA1*ix1+IC1) % M1;
	ix2=(IA2*ix2+IC2) % M2;
	ix3=(IA3*ix3+IC3) % M3;
	j=(int) (1 + ((97*ix3)/M3));
	if (j > 97 || j < 1) {
		Logit("RAN1: This cannot happen.");
	}
	temp=r[j];
	r[j]=(float) ((ix1+ix2*RM2)*RM1);
	return temp;
}

#undef M1
#undef IA1
#undef IC1
#undef RM1
#undef M2
#undef IA2
#undef IC2
#undef RM2
#undef M3
#undef IA3
#undef IC3

float gasdev(int *idum, float dzdiv)
{
	static int iset=0;
	static float gset;
	float fac,r,v1,v2;

	if  (iset == 0) {
		do {
			v1=2.0f*ran1(idum)-1.0f;
			v2=2.0f*ran1(idum)-1.0f;
			r=v1*v1+v2*v2;
		} while (r >= 1.0 || r == 0.0);
		fac=(float)sqrt(-2.0*log(r)/r);
		gset=v1*fac;
		iset=1;
		return v2*fac/dzdiv;
	} else {
		iset=0;
		return gset/dzdiv;
	}
}

int sign (float x, float y)
{
	if ((x>0) && (y>0)) return 1;
	if ((x<0) && (y<0)) return 1;
	return 0;
}

float sign_of_arg (float x)
{
    return (x < 0) ? -1 : 1;

} // end sign_of_arg 

float Max (float a, float b)
{
    if (a > b) return a;
    else return b;
}

// returns a number between -randz and +randz 

float Random(float randz) {
	float f;

	f = (float) rand() / 32767.0f;
	f = (.5f - f ) * randz * 2.f;

//      printf ("%10f",f);
	return f;
}

