/*  Project filter
					DCS, UP Olomouc
					Copyright  1995. All Rights Reserved.

					SUBSYSTEM:    filter.exe Application
					FILE:         matrix.cpp
					AUTHOR:       Robert Batusek

		implementace datovych struktur potrebnych k filtraci

		implementation of data structures needed to filtering
*/

#include <except.h>
#pragma hdrstop

//#include <math.h>

#include "matrix.h"

/////////////////////////////////////////////////
// class Complex
// -------------
// Popis: zakladni operace s komplexnimi cisly
// Description: basic operations with complex numbers
//
/*Complex::Complex()
{
	re = im = 0;
}

Complex::Complex(double real,double imag)
{
	SetNumber(real,imag);
}

Complex::Complex(Complex &c)
{
	re = c.Real();
	im = c.Imaginary();
}

void Complex::SetNumber(double real,double imag)
{
	re = real;
	im = imag;
}

//operators
Complex Complex::operator +=(Complex &c)
{
	re += c.Real();
	im += c.Imaginary();
	return *this;
}

Complex Complex::operator + (Complex &c)
{
	return Complex(re + c.Real(),im + c.Imaginary());
}


Complex Complex::operator - (Complex &c)
{
	return Complex(re - c.Real(),im - c.Imaginary());
}

Complex Complex::operator * (Complex &c)
{
	return Complex(re*c.Real() - im*c.Imaginary(), re*c.Imaginary() + im*c.Real());
}

Complex Complex::operator * (double f)
{
	return Complex(re*f,im*f);
}

Complex Complex::operator = (Complex &c)
{
	re = c.Real();
	im = c.Imaginary();
	return *this;
} */


/////////////////////////////////////////////////
// class TMatrix
// -------------
// Popis: matice pro ulozeni obrazovych dat
// Description: matrix for storing picture data
//
TMatrix::TMatrix(int x,int y)
{
		 xsize = x;
		 ysize = y;
		 Allocate(x,y);
}

TMatrix::TMatrix(TMatrix &m)
{ int i,j;

		 m.GetSize(xsize,ysize);

		 Allocate(xsize,ysize);

		 for(i=0;i<xsize;i++)
					for(j=0;j<ysize;j++)
							 SetElement(i,j,m.GetElement(i,j));
}


TMatrix::~TMatrix()
{ int i;

		 for (i=0;i<xsize;i++)
					delete [] data[i];

		 delete [] data;
}

void TMatrix::Allocate(int x, int y)
{ int j;

		 try {
					data = new Element *[x];

					for (j=0;j<x;j++)
							 data[j] = new Element[y];
		 }
		 catch (xalloc) {
					data = NULL;
		 }
}

void TMatrix::SetElement(int x,int y,Element value)
{
     data[x][y] = value;
}

Element TMatrix::GetElement(int x,int y)
{
     return data[x][y];
}

void TMatrix::GetSize(int &x,int &y)
{
     x = xsize;
     y = ysize;
}

BOOL TMatrix::Resize(int newxsize,int newysize,BOOL KeepOldValues)
{
     if (KeepOldValues);
     else {
          delete data;
          xsize = newxsize;
          ysize = newysize;
          Allocate(xsize,ysize);
     }
     return TRUE;
}


/////////////////////////////////////////////////
// class TMask
// -------------
// Popis: matice pro ulozeni filtracni masky
// Description: matrix for storing filter mask
//
TMask::TMask(int x,int y, int value,int div)
     : TMatrix(x,y)
{
     FillRect(0,0,xsize,ysize,value);
		 if (div) divisor = div;
     else CalculateDivisor();
}

void TMask::FillRect(int ltx,int lty,int rbx,int rby,int value)
{int i,j;

     for (i=ltx;i<rbx;i++)
          for (j=lty;j<rby;j++)
               SetElement(i,j,value);
}

void TMask::CalculateDivisor()
{ int i,j;

     divisor = 0;
     for (i=0;i<ysize;i++)
          for (j=0;j<xsize;j++)
               divisor+=GetElement(j,i);
}

/////////////////////////////////////////////////
// class TRotatingMask
// -------------
// Popis: rotujici maska v okoli 5x5
// Description: rotating mask in 5x5 environs
//
TRotatingMask::TRotatingMask()
     :TMask(5,5)
{
     SetDirection(Middle);
}

void TRotatingMask::SetDirection(TDirection newdirection)
{
     direction = newdirection;

     FillRect(0,0,xsize,ysize,0);

     switch(direction) {
          case Middle:
               FillRect(1,1,xsize-1,ysize-1,1);
               break;
          case North:
               FillRect(1,0,xsize-1,2,1);
               SetElement(2,2,1);
               break;
          case NorthWest:
							 FillRect(0,0,2,2,1);
               FillRect(1,1,3,3,1);
               break;
          case West:
               FillRect(0,1,2,ysize-1,1);
               SetElement(2,2,1);
               break;
          case SouthWest:
               FillRect(0,ysize-2,2,ysize,1);
							 FillRect(1,ysize-3,3,ysize-1,1);
               break;
          case South:
							 FillRect(1,ysize-2,xsize-1,ysize,1);
               SetElement(2,2,1);
               break;
					case SouthEast:
               FillRect(xsize-2,ysize-2,xsize,ysize,1);
               FillRect(xsize-3,ysize-3,xsize-1,ysize-1,1);
               break;
          case East:
               FillRect(xsize-2,1,xsize,ysize-1,1);
               SetElement(2,2,1);
               break;
          case NorthEast:
							 FillRect(xsize-2,0,xsize,2,1);
               FillRect(xsize-3,1,xsize-1,3,1);
               break;
     }
}

/////////////////////////////////////////////////
// class TComplexMatrix
// -------------
// Popis: matice pro praci s komplexnimi cisly (viz. TComplexFilter)
// Description: matrix for work with complex numbers (see TComplexFilter)
//
TComplexMatrix::TComplexMatrix(int x,int y)
	:TMatrix(x,y)
{
	Allocate(x,y);
}

TComplexMatrix::TComplexMatrix(TMatrix &m)
	:TMatrix(m)
{int i,j;

	Allocate(xsize,ysize);

	for(i=0;i<xsize;i++)
		for(j=0;j<ysize;j++)
			SetComplex(i,j,Complex(m.GetElement(i,j)));
}

TComplexMatrix::TComplexMatrix(TComplexMatrix &m)
	:TMatrix(m)
{int i,j;

	Allocate(xsize,ysize);

	for(i=0;i<xsize;i++)
		for(j=0;j<ysize;j++)
			SetComplex(i,j,Complex(m.GetComplex(i,j)));
}

TComplexMatrix::~TComplexMatrix()
{ int i;

	for (i=0;i<xsize;i++)
		delete [] complexdata[i];

	delete [] complexdata;
}

void TComplexMatrix::Allocate(int x,int y)
{int j;

	try {
		complexdata = new Complex *[x];

		for (j=0;j<x;j++)
			complexdata[j] = new Complex[y];
	}
	catch (xalloc) {
		complexdata = NULL;
	}
}

void TComplexMatrix::ConvertComplexToBMP()
{int i,j;
	double min,max,temp,scale;

	//calculating minimum and maximum of picture
	min = max = log10 (1 + sqrt(norm(GetComplex(0,0))));
	for (i=0;i<ysize;i++)
		for (j=0;j<xsize;j++) {
			temp = log10 (1 + sqrt(norm(GetComplex(j,i))));
			if (temp<min) min = temp;
			if (temp>max) max = temp;
		}

	//rescaling picture
	scale= 255/(max-min);
	for (i=0;i<ysize;i++)
		for (j=0;j<xsize;j++) {
			temp = log10 (1 + sqrt(norm(GetComplex(j,i))));
			SetElement(j,i, (Element) (scale * (temp - min)) );
		}

}

void TComplexMatrix::MoveComplexToBMP()
{int i,j;
	float N4;
	double temp;

	N4 = (float)ysize;
	N4 = N4*N4*N4*N4;
	for (i=0;i<ysize;i++)
		for (j=0;j<xsize;j++) {
			temp = real(GetComplex(j,i));
      if (temp<0) temp = -temp;
			if ((temp - floor(temp))>=0.5) temp += 1.0;
			SetElement(j,i,	(Element) (  temp / N4 ) );
    }
}

