/* This file contains the default values for almost everything
the parser reads.  Once you figure out how to decode it, you
can use it as the definitive version of what the default values
for all script elements and sub-elements are */

p_Vertex vals_Vertex;
p_Vertex def_Vertex = {
	{0,0,0},	/* pnt */
	0		/* name */
};

p_Quad vals_Quad;
p_Quad def_Quad = {
	{0,0,0},	/* loc */
	{0,0,0},	/* v1 */
	{0,0,0},	/* v2 */
	NULL,		/* surf */
	NULL,		/* text */
	{0,0,0},	/* origin */
	NULL,		/* p1 */
	NULL,		/* p2 */
	NULL,		/* p3 */
	0		/* flags */
};

p_Triangle vals_Triangle;
p_Triangle def_Triangle = {
	{0,0,0},	/* loc */
	{0,0,0},	/* v1 */
	{0,0,0},	/* v2 */
	NULL,		/* surf */
	NULL,		/* text */
	{0,0,0},	/* origin */
	NULL,		/* p1 */
	NULL,		/* p2 */
	NULL,		/* p3 */
	0		/* flags */
};

p_Plane vals_Plane;
p_Plane def_Plane = {
	{0,0,0},	/* loc */
	{0,0,0},	/* v1 */
	{0,0,0},	/* v2 */
	NULL,		/* surf */
	NULL,		/* text */
	{0,0,0},	/* origin */
	0		/* flags */
};

p_Sphere vals_Sphere;
p_Sphere def_Sphere = {
	{0,0,0},	/* loc */
	0,		/* radius */
	NULL,		/* surf */
	NULL,		/* text */
	{0,0,0},	/* origin */
	0		/* flags */
};

p_PSphere vals_PSphere;
p_PSphere def_PSphere = {
	{0,0,0},	/* loc */
	0,		/* radius */
	NULL,		/* surf */
	NULL,		/* text */
	{0,0,0},	/* origin */
	16,		/* horizontal segments */
	8,		/* vertical segments */
	0		/* flags */
};

p_Ring vals_Ring;
p_Ring def_Ring = {
	{0,0,0},	/* loc */
	{0,0,0},	/* v1 */
	{0,0,0},	/* v2 */
	0,		/* in */
	0,		/* out */
	NULL,		/* surf */
	NULL,		/* text */
	{0,0,0},	/* origin */
	0		/* flags */
};

p_Lamp vals_Lamp;
p_Lamp def_Lamp = {
	{0,0,0},	/* loc */
	{0,0,0},	/* pointat */
	{1,1,1},	/* color */
	{0,0,0},	/* direct */
	0,		/* spread */
	HUGE,		/* power */
	0,		/* radius */
	HUGE,		/* dist */
	1,		/* nrays */
	0		/* flags */
};

p_HeightField vals_HeightField;
p_HeightField def_HeightField = {
	{0,0,0},	/* loc */
	{1,0,0},	/* v1 */
	{0,0,1},	/* v2 */
	{0,1,0},	/* up */
	1,		/* height */
	0,		/* floor */
	NULL,		/* surf */
	NULL,		/* text */
	{0,0,0},	/* origin */
	NULL,		/* file */
	0		/* flags */
};


p_Spin vals_Spin;
p_Spin def_Spin = {
	{0,0,0},	/* loc */
	{0,1,0},	/* axis */
	8,		/* segments */
	NULL,		/* slice */
	NULL,		/* surf */
	NULL,		/* text */
	{0,0,0},	/* origin */
	0,		/* start */
	0,		/* end */
	0,		/* rise */
	0		/* flags */
};

p_Box vals_Box;
p_Box def_Box = {
	{0,0,0},	/* loc */
	{0,0,0},	/* v1 */
	{0,0,0},	/* v2 */
	{0,0,0},	/* v3 */
	NULL,		/* surf */
	NULL,		/* text */
	{0,0,0},	/* origin */
	0		/* flags */
};

static Pnt tubePnts[P_TUBE_MAX_POINTS];
static Real tubeRadii[P_TUBE_MAX_POINTS];

p_Tube vals_Tube;
p_Tube def_Tube = {
	8,		/* segs */
	tubePnts,	/* pnts */
	tubeRadii,	/* radii */
	0,		/* npnts */
	{0,0,0},	/* loc */
	NULL,		/* surf */
	NULL,		/* text */
	{0,0,0},	/* origin */
	0		/* flags */
};

p_Slice vals_Slice;
p_Slice def_Slice = {
	NULL,		/* pnts */
	0,		/* npnts */
	0,		/* name */
	0		/* flags */
};

p_Array vals_Array;
p_Array def_Array = {
	NULL,		/* pnts */
	0,		/* npnts */
	0,		/* name */
	0		/* flags */
};

p_Path vals_Path;
p_Path def_Path = {
	NULL,		/* pnts */
	0,		/* npnts */
	0,		/* name */
	0		/* flags */
};

p_Extrude vals_Extrude;
p_Extrude def_Extrude = {
	NULL,		/* slice */
	0,		/* length */
	{0,0,0},	/* loc */
	{0,0,0},	/* xaxis */
	{0,0,0},	/* yaxis */
	{0,0,0},	/* direct */
	NULL,		/* surf */
	NULL,		/* text */
	{0,0,0},	/* origin */
	0		/* flags */
};

p_Fill vals_Fill;
p_Fill def_Fill = {
	NULL,		/* slice */
	{0},		/* holes */
	0,		/* nholes */
	{0,0,0},	/* loc */
	{0,0,0},	/* xaxis */
	{0,0,0},	/* yaxis */
	NULL,		/* surf */
	NULL,		/* text */
	{0,0,0},	/* origin */
	0		/* flags */
};

static SlicePtr skinSlices[P_SKIN_MAX_SLICES];
static Pnt skinLocs[P_SKIN_MAX_SLICES];
static Vector skinXAxes[P_SKIN_MAX_SLICES];
static Vector skinYAxes[P_SKIN_MAX_SLICES];

p_Skin vals_Skin;
p_Skin def_Skin = {
	{0,0,0},	/* loc */
	skinSlices,	/* slices */
	skinLocs,	/* locs */
	skinXAxes,	/* xaxes */
	skinYAxes,	/* yaxes */
	0,		/* nslices */
	NULL,		/* surf */
	NULL,		/* text */
	{0,0,0},	/* origin */
	0		/* flags */
};

static SurfacePtr bbSurfs[P_BILL_MAX_SUBS];

p_BillBoard vals_BillBoard;
p_BillBoard def_BillBoard = {
	NULL,		/* bitmap */
	NULL,		/* surf */
	bbSurfs,	/* subs */
	0,		/* nsubs */
	{0,0,0},	/* loc */
	{0,0,0},	/* xaxis */
	{0,0,0},	/* yaxis */
	0,		/* xlen */
	0,		/* ylen */
	1,		/* xrep */
	1,		/* yrep */
	3,		/* filter */
	{0,0,0},	/* origin */
	0		/* flags */
};

static SurfacePtr instSurf1[P_INSTANCE_MAX_SUBS];
static SurfacePtr instSurf2[P_INSTANCE_MAX_SUBS];
static TexturePtr instText1[P_INSTANCE_MAX_SUBS];
static TexturePtr instText2[P_INSTANCE_MAX_SUBS];

p_Instance vals_Instance;
p_Instance def_Instance = {
	NULL,		/* object */
	instSurf1,	/* ssub1 */
	instSurf2,	/* ssub2 */
	0,		/* nsubs */
	instText1,	/* tsub1 */
	instText2,	/* tsub2 */
	0,		/* ntsubs */
	0,		/* flags */
	0		/* name */
};

static SurfacePtr blotchSurfs[P_BLOTCH_MAX_SURFS];

p_Blotch vals_Blotch;
p_Blotch def_Blotch = {
	1,		/* scale */
	blotchSurfs,	/* surfs */
	0,		/* nsurfs */
	0,		/* name */
	0		/* flags */
};

p_Clouds vals_Clouds;
p_Clouds def_Clouds = {
	NULL,	/* sky */
	NULL,	/* clouds */
	1,	/* scale */
	1,	/* power */
	1,	/* turb */
	0,	/* xphase */
	0,	/* yphase */
	0,	/* zphase */
	0,	/* name */
	0	/* flags */
};

SurfacePtr vals_SubSurfs[P_WRAP_MAX_SUBS];

p_WrapSp vals_WrapSp;
p_WrapSp def_WrapSp = {
	NULL,		/* bitmap */
	NULL,		/* surf */
	vals_SubSurfs,	/* subsurfs */
	0,		/* nsubs */
	1,		/* xrep */
	1,		/* yrep */
	3,		/* filter */
	0,		/* name */
	0		/* flags */
};

p_WrapCy vals_WrapCy;
p_WrapCy def_WrapCy = {
	NULL,		/* bitmap */
	NULL,		/* surf */
	vals_SubSurfs,	/* subsurfs */
	0,		/* nsubs */
	1,		/* xrep */
	0,		/* height */
	3,		/* filter */
	0,		/* name */
	0		/* flags */
};

p_WrapFl vals_WrapFl;
p_WrapFl def_WrapFl = {
	NULL,		/* bitmap */
	NULL,		/* surf */
	vals_SubSurfs,	/* subsurfs */
	0,		/* nsubs */
	3,		/* filter */
	{0,0,0},	/* loc */
	{1,0,0},	/* xaxis */
	{0,1,0},	/* yaxis */
	1,		/* xlen */
	1,		/* ylen */
	0,		/* name */
	0		/* flags */
};


p_Marble vals_Marble;
p_Marble def_Marble = {
	NULL,	/* surf */
	NULL,	/* grain */
	1,	/* scale */
	1,	/* power */
	0,	/* name */
	0	/* flags */
};

p_Wood vals_Wood;
p_Wood def_Wood = {
	NULL,	/* surf */
	NULL,	/* grain */
	1,	/* scale */
	0,	/* name */
	0	/* flags */
};

p_Check vals_Check;
p_Check def_Check = {
	1,	/* xsize */
	1,	/* ysize */
	1,	/* zsize */
	NULL,	/* surf1 */
	NULL,	/* surf2 */
	0,	/* name */
	0	/* flags */
};

p_Brick vals_Brick;
p_Brick def_Brick = {
	1,	/* xsize */
	.5,	/* ysize */
	.5,	/* zsize */
	NULL,	/* brick */
	NULL,	/* mortar */
	.2,	/* msize */
	.5,	/* yoffset */
	.5,	/* zoffset */
	0,	/* name */
	0	/* flags */
};


p_Color vals_Color;
p_Color def_Color = {
	{1,1,1},	/* diff */
	{.5,.5,.5},	/* amb */
	{0,0,0},	/* refl */
	{1,1,1},	/* filt */
	{0,0,0},	/* trans */
	1,		/* index */
	50,		/* pcoef */
	.5,		/* prefl */
	0,		/* arefl */
	0,		/* atrans */
	0,		/* name */
	0		/* flags */
};

p_Waves vals_Waves;
p_Waves def_Waves = {
	10,	/* ncenters */
	1,	/* scale */
	0,	/* phase */
	1,	/* size */
	0,	/* name */
	0	/* flags */
};

p_TFromP vals_TFromP;
p_TFromP def_TFromP = {
    0,	/* pattern */
	1,	/* size */
	0,	/* name */
	0	/* flags */
};

p_BumpSp vals_BumpSp;
p_BumpSp def_BumpSp = {
	NULL,	/* bitmap */
	1,	/* xrep */
	1,	/* yrep */
	1,	/* size */
	0,	/* name */
	0	/* flags */
};

p_BumpCy vals_BumpCy;
p_BumpCy def_BumpCy = {
	NULL,	/* bitmap */
	1,	/* xrep */
	0,	/* height */
	1,	/* size */
	0,	/* name */
	0	/* flags */
};

p_BumpFl vals_BumpFl;
p_BumpFl def_BumpFl = {
	NULL,		/* bitmap */
	{0,0,0},	/* loc */
	{1,0,0},	/* xaxis */
	{0,1,0},	/* yaxis */
	1,		/* xlen */
	1,		/* ylen */
	1,		/* size */
	0,		/* name */
	0,		/* flags */
};


p_Observer vals_Observer;
p_Observer def_Observer = {
	{0,0,0},	/* eye */
	{0,0,0},	/* target */
	{0,1,0},	/* up */
	640, 400,	/* xres, yres */
	1,		/* aspect */
	45, -1, 	/* hfov, vfov */
	0		/* flags */
};

p_Sky vals_Sky;
p_Sky def_Sky = {
	{.5,0,.5},	/* horizon */
	{0,0.5},	/* zenith */
	0,		/* nstars */
	{1,1,1},	/* starcolor */
	{0,1,0},	/* up */
	0		/* flags */
};

p_Fog vals_Fog;
p_Fog def_Fog = {
	{.5,.5,.5},	/* fogthin */
	-1,		/* thin */
	10,		/* dist */
	2,		/* power */
	0		/* flags */
};


	





	

