/* This is the file used to generate the parser.  By using
it and the file "scan.l" you can pretty much get a handle
on the definitive grammar of the parser.  If you can decode
it, that is... */

%token <real> TYPE_REAL
%token <integer> TYPE_INTEGER
%token <id> TYPE_IDENT
%token <filename> TYPE_FILENAME
%token <cmd> OPEN_BRACE CLOSE_BRACE OPEN_PAREN CLOSE_PAREN OPEN_VEC CLOSE_VEC
%token <text> TYPE_TEXT

%type <real> type_posreal type_nnegreal real_int type_real01 real_expr real_term 
%type <integer> type_posint type_nnegint int_expr int_term 
%type <vector3> type_color type_vector type_point vec_expr vec_term 
%type <vector2> type_vector2
%type <surface> type_surface
%type <texture> type_texture
%type <bitmap> type_bitmap
%type <object> type_object
%type <vertex> type_vertex
%type <slice> type_slice
%type <file> type_file
%type <id> vertex_ident var_ident
%type <instance> type_instance
%type <integer> csg_operand


%token <cmd> P_OBSERVER P_TARGET P_UP
%token <cmd> P_DIFFUSE P_AMBIENT P_PREFL
%token <cmd> P_PLANE P_LOC P_V1 P_V2
%token <cmd> P_LAMP P_POINTAT P_SPREAD P_POWER
%token <cmd> P_ASPECT P_HFOV P_VFOV
%token <cmd> P_INCLUDE P_UNSURF P_MAXAADEPTH P_MAXOCTDEPTH
%token <cmd> P_MAXOBCUBE P_SMOOTHOFF P_SMOOTHON P_ILLUMINATE
%token <cmd> P_NOREFL P_NOSHAD P_NOTRANS P_DUMPSURFACES P_DUMPOBJECTS
%token <cmd> P_DUMPLAMPS P_MAXAADIFF P_IFF P_RAW24LPO
%token <cmd> P_SKY P_HORIZON P_ZENITH P_NUMSTARS P_STARCOLOR
%token <cmd> P_FOG P_THIN P_DIST P_FILE P_RISE P_START P_END P_AXIS
%token <cmd> P_CLOUDS P_SCALE P_PERTURB P_XPHASE P_YPHASE P_ZPHASE
%token <cmd> P_WRAPSP P_BITMAP P_PATTERN P_SUB P_DOTRANS P_DOREFL P_DODIFF
%token <cmd> P_XREP P_YREP P_FILTER P_WRAPCY P_HEIGHT P_MARBLE P_GRAIN
%token <cmd> P_WOOD P_XSIZE P_YSIZE P_ZSIZE P_THICK P_NRINGS P_CHECK
%token <cmd> P_PATTERN1 P_PATTERN2 P_BRICK P_MORTAR P_MSIZE P_YOFFSET
%token <cmd> P_ZOFFSET P_REFLECT P_TRANSMIT P_INDEX P_PCOEF P_LUM
%token <cmd> P_LPCOEF P_LPREFL P_AREFL P_ATRANS P_VERTEX P_FLUSHVERTS
%token <cmd> P_QUAD P_TRIANGLE P_P1 P_P2 P_P3 P_SPHERE P_RADIUS P_RING
%token <cmd> P_IN P_OUT P_TEXTURE P_ORIGIN P_OFFTREE P_COLOR P_DIRECT
%token <cmd> P_NRAYS P_BLOTCH P_OBJECT P_ENDOBJECT P_INSTANCE P_SUBSURF
%token <cmd> P_SUBTEXT P_LOCK P_KILLOBJECT P_XROTATE P_YROTATE P_ZROTATE
%token <cmd> P_TRANSLATE P_RESET P_CHILD P_WAVES P_NCENTERS P_PHASE P_SIZE
%token <cmd> P_BUMPSP P_BUMPCY P_HFIELD P_FLOOR P_SMOOTH P_SPIN P_SEGMENTS
%token <cmd> P_POINT P_BOX P_V3 P_TUBE P_SLICE P_CLOSED P_EXTRUDE
%token <cmd> P_LENGTH P_XAXIS P_YAXIS P_DIR P_FRONT P_BACK P_FILL P_BUMPFL
%token <cmd> P_SKIN P_FILLFIRST P_FILLLAST P_BILLBOARD P_XLEN P_YLEN P_RES
%token <cmd> P_WRAPFL P_REPEATX P_REPEATY P_NOTE P_CSG P_ANDNOT P_AND P_USESURF P_NAME
%token <cmd> P_VARIABLE P_VREAL P_VINT P_EQSIGN P_PLUS P_MINUS P_MULT P_DIVIDE
%token <cmd> P_COMMA OPEN_BRACK CLOSE_BRACK P_NEWSCOPE P_ENDSCOPE
%token <cmd> P_ACOS P_ASIN P_ATAN P_COS P_SIN P_TAN P_COSH P_SINH P_TANH P_EXP
%token <cmd> P_LOG P_LOG10 P_SQRT P_CEIL P_ATAN2 P_HOLE P_ARRAY P_PATH
%token <cmd> P_DEG2RAD P_RAD2DEG P_PSPHERE P_HSEGS P_VSEGS P_VECTOR P_TFROMP
%token <cmd> P_BMP

%left P_PLUS P_MINUS
%left P_MULT P_DIVIDE
%left UMINUS

%%

lines:		/* empty */
	|	lines  line
		;

line:		'\n'
	|	primitives
	|	composites
	|	objects
	|	surfaces
	|	textures
	|	others
		;


/***************************************************
*
*	Primitive Primitives
*
***************************************************/

primitives:	plane
	|	lamp
	|	triangle
	|	quad
	|	sphere
	|	ring
	|	vertex
	|	flushverts
		;

vertex:		P_VERTEX 
			vertex_ident type_point
		;

vertex_ident:	TYPE_IDENT
		;

flushverts:	P_FLUSHVERTS
		;

quad:		P_QUAD 
			OPEN_BRACE quad_defs CLOSE_BRACE	
		;

quad_defs:	/* empty */
	|	quad_defs quad_def
		;

quad_def:	P_LOC type_point
	|	P_V1 type_vector
	|	P_V2 type_vector
	|	P_PATTERN type_surface
	|	P_TEXTURE type_texture
	|	P_ORIGIN type_point
	|	P_OFFTREE
		;

triangle:	P_TRIANGLE 
			OPEN_BRACE triangle_defs CLOSE_BRACE	
		;

triangle_defs:	/* empty */
	|	triangle_defs triangle_def
		;

triangle_def:	P_V1 type_vector	
	|	P_V2 type_vector
	|	P_P1 type_vertex
	|	P_P2 type_vertex
	|	P_P3 type_vertex
	|	P_LOC type_point
	|	P_PATTERN type_surface
	|	P_TEXTURE type_texture
	|	P_ORIGIN type_point
	|	P_OFFTREE
		;

plane:		P_PLANE 
			OPEN_BRACE plane_defs CLOSE_BRACE	
		;

plane_defs:	/* nothing */
	|	plane_defs plane_def
		;

plane_def:	P_LOC type_point
	|	P_V1 type_vector
	|	P_V2 type_vector
	|	P_PATTERN type_surface
	|	P_TEXTURE type_texture
	|	P_ORIGIN type_point
		;

sphere:		P_SPHERE OPEN_BRACE 
			sphere_defs CLOSE_BRACE
		;

sphere_defs:	/* empty */
	|	sphere_defs sphere_def
		;

sphere_def:	P_LOC type_point
	|	P_RADIUS type_posreal
	|	P_PATTERN type_surface
	|	P_TEXTURE type_texture
	|	P_ORIGIN type_point
	|	P_OFFTREE
		;

ring:		P_RING 
			OPEN_BRACE ring_defs CLOSE_BRACE
		;

ring_defs:	/* empty */
	|	ring_defs ring_def
		;

ring_def:	P_LOC type_point
	|	P_V1 type_vector
	|	P_V2 type_vector
	|	P_IN type_nnegreal
	|	P_OUT type_posreal
	|	P_PATTERN type_surface
	|	P_TEXTURE type_texture
	|	P_ORIGIN type_point
	|	P_OFFTREE
		;

lamp:		P_LAMP 
			OPEN_BRACE lamp_defs CLOSE_BRACE
		;

lamp_defs:	/* nothing */
	|	lamp_defs lamp_def
		;

lamp_def:	P_LOC type_point
	|	P_POINTAT type_point
	|	P_COLOR type_color
	|	P_DIRECT type_vector
	|	P_SPREAD type_posreal
	|	P_POWER type_posreal
	|	P_RADIUS type_nnegreal
	|	P_DIST type_nnegreal
	|	P_NRAYS type_posint
	|	P_NOSHAD
		;

/***************************************************
*
*	Composite Definitions
*
***************************************************/

composites:	hfield
	|	spin
	|	box
	|	tube
	|	billboard
	|	slice		/* these 3 don't really belong here any more */
	|	path		/* '' */
	|	array		/* '' */
	|	extrude
	|	fill
	|	skin
	|	psphere
		;

psphere:		P_PSPHERE OPEN_BRACE 
			psphere_defs CLOSE_BRACE
		;

psphere_defs:	/* empty */
	|	psphere_defs psphere_def
		;

psphere_def:	P_LOC type_point
	|	P_RADIUS type_posreal
	|	P_PATTERN type_surface
	|	P_TEXTURE type_texture
	|	P_ORIGIN type_point
	|	P_OFFTREE
	|	P_HSEGS type_posint
	|	P_VSEGS	type_posint
	|	P_SMOOTH
		;

hfield:		P_HFIELD 
			OPEN_BRACE hfield_defs CLOSE_BRACE	
		;

hfield_defs:	/* empty */
	|	hfield_defs hfield_def
		;

hfield_def:	P_LOC type_point
	|	P_V1 type_vector
	|	P_V2 type_vector
	|	P_UP type_vector
	|	P_HEIGHT real_expr
	|	P_FLOOR real_expr
	|	P_SMOOTH
	|	P_PATTERN type_surface
	|	P_TEXTURE type_texture
	|	P_ORIGIN type_point
	|	P_FILE type_file
		;

spin:		P_SPIN 
			OPEN_BRACE spin_defs CLOSE_BRACE
		;

spin_defs:	/* empty */
	|	spin_defs spin_def
		;

spin_def:	P_LOC type_point
	|	P_SEGMENTS type_posint
	|	P_SMOOTH
	|	P_PATTERN type_surface
	|	P_TEXTURE type_texture
	|	P_SLICE type_slice
	|	P_ORIGIN type_point
	|	P_START real_expr
	|	P_END real_expr
	|	P_RISE real_expr
	|	P_AXIS type_vector
	|	P_FILLFIRST
	|	P_FILLLAST
		;

box:		P_BOX 
			OPEN_BRACE box_defs CLOSE_BRACE	
		;

box_defs:	/* empty */
	|	box_defs box_def
		;

box_def:	P_LOC type_point
	|	P_V1 type_vector
	|	P_V2 type_vector
	|	P_V3 type_vector
	|	P_SMOOTH
	|	P_PATTERN type_surface
	|	P_TEXTURE type_texture
	|	P_ORIGIN type_point
		;

tube:		P_TUBE 
			OPEN_BRACE tube_defs CLOSE_BRACE	
		;

tube_defs:	/* empty */
	|	tube_defs tube_def
		;

tube_def:	P_SEGMENTS type_posint
	|	P_POINT type_point type_nnegreal
	|	P_LOC type_point
	|	P_SMOOTH
	|	P_PATTERN type_surface
	|	P_TEXTURE type_texture
	|	P_ORIGIN type_point
		;
	
slice:		P_SLICE TYPE_IDENT 
			P_EQSIGN OPEN_BRACE slice_defs CLOSE_BRACE
		;

slice_defs:	/* empty */
	|	slice_first_def slice_next_defs
		;

slice_first_def:	type_vector2
			;

slice_next_defs:	/* empty */
	|		slice_next_defs slice_next_def
			;

slice_next_def:		P_COMMA type_vector2
	|		P_CLOSED
		;

array:		P_ARRAY TYPE_IDENT 
			P_EQSIGN OPEN_BRACE array_defs CLOSE_BRACE
		;

array_defs:	/* empty */
	|	array_first_def array_next_defs 
		;

array_first_def:	real_expr
			;

array_next_defs:	/* empty */
	|		array_next_defs array_next_def
			;

array_next_def:		P_COMMA real_expr
	|		P_CLOSED
			;

path:		P_PATH TYPE_IDENT 
			P_EQSIGN OPEN_BRACE path_defs CLOSE_BRACE
		;

path_defs:	/* empty */
	|	path_first_def path_next_defs
		;

path_first_def:		type_point
			;

path_next_defs:		/* empty */
	|		path_next_defs path_next_def
			;

path_next_def:		P_COMMA type_point
	|		P_CLOSED
			;

extrude:	P_EXTRUDE 
			OPEN_BRACE extrude_defs CLOSE_BRACE
		;

extrude_defs:	/* empty */
	|	extrude_defs extrude_def
		;

extrude_def:	P_SLICE type_slice
	|	P_LENGTH type_posreal
	|	P_LOC type_point
	|	P_XAXIS type_vector
	|	P_YAXIS type_vector
	|	P_DIRECT type_vector
	|	P_FILLFIRST
	|	P_FILLLAST
	|	P_SMOOTH
	|	P_PATTERN type_surface
	|	P_TEXTURE type_texture
	|	P_ORIGIN type_point
		;

fill:		P_FILL
			OPEN_BRACE fill_defs CLOSE_BRACE
		;

fill_defs:	/* empty */
	|	fill_defs fill_def
		;

fill_def:	P_SLICE type_slice
	|	P_HOLE type_slice
	|	P_LOC type_point
	|	P_XAXIS type_vector
	|	P_YAXIS type_vector
	|	P_PATTERN type_surface
	|	P_TEXTURE type_texture
	|	P_ORIGIN type_point
		;

skin:		P_SKIN 
			OPEN_BRACE skin_defs CLOSE_BRACE
		;

skin_defs:	/* empty */
	|	skin_defs skin_def
		;

skin_def:	P_SLICE type_slice type_point type_vector type_vector

	|	P_FILLFIRST
	|	P_FILLLAST
	|	P_SMOOTH
	|	P_PATTERN type_surface
	|	P_TEXTURE type_texture
	|	P_ORIGIN type_point
		;

billboard:	P_BILLBOARD 
			OPEN_BRACE billboard_defs CLOSE_BRACE
		;

billboard_defs:	/* empty */
	|	billboard_defs billboard_def
		;

billboard_def:	P_BITMAP type_bitmap
	|	P_PATTERN type_surface
	|	P_SUB type_posint type_surface
	|	P_DOTRANS
	|	P_DODIFF
	|	P_DOREFL
	|	P_LOC type_point
	|	P_XAXIS type_vector
	|	P_YAXIS type_vector
	|	P_XLEN type_posreal
	|	P_YLEN type_posreal
	|	P_XREP type_posreal
	|	P_YREP type_posreal
	|	P_FILTER type_posint
		;

/***************************************************
*
*	Primitive Definitions
*
***************************************************/

objects: 	object
	|	endobject
	|	instance
	|	lock
	|	killobject
	|	xrotate
	|	yrotate
	|	zrotate
	|	scale
	|	translate
	|	reset
	|	child
		;

object:		P_OBJECT TYPE_IDENT
		;

endobject:	P_ENDOBJECT
		;

instance:	P_INSTANCE type_object	
	|	P_INSTANCE 
			OPEN_BRACE instance_defs CLOSE_BRACE
		;

instance_defs:	/* empty */
	|	instance_defs instance_def
		;

instance_def:	P_OBJECT type_object
	|	P_SUBSURF type_surface type_surface	
	|	P_SUBTEXT type_texture type_texture	
	|	P_NAME TYPE_IDENT
		;

lock:		P_LOCK type_object
		;

killobject:	P_KILLOBJECT type_object
		;

xrotate:	P_XROTATE type_object real_expr
		;

yrotate:	P_YROTATE type_object real_expr
		;

zrotate:	P_ZROTATE type_object real_expr
		;

scale:		P_SCALE type_object type_point
		;

translate:	P_TRANSLATE type_object type_point
		;

reset:		P_RESET type_object
		;

child:		P_CHILD type_object
		;


/****************************************************
*
*	Surface (Pattern) Type Definitions
*
****************************************************/

surfaces:	surface
	|	check
	|	brick
	|	marble
	|	wood
	|	clouds
	|	wrapsp
	|	wrapcy
	|	wrapfl
	|	blotch
		;

blotch:		P_BLOTCH TYPE_IDENT 
			OPEN_BRACE blotch_defs CLOSE_BRACE	
		;

blotch_defs:	/* empty */
	|	blotch_defs blotch_def
		;

blotch_def:	P_SCALE type_posreal
	|	P_PATTERN type_surface 
		;

clouds:		P_CLOUDS TYPE_IDENT 
			OPEN_BRACE clouds_defs CLOSE_BRACE
		;

clouds_defs:	/* empty */
			|	clouds_defs clouds_def
				;

clouds_def:	P_SKY type_surface
		|	P_CLOUDS type_surface
		|	P_SCALE type_posreal
		|	P_POWER type_posreal
		|	P_PERTURB type_nnegreal
		|	P_XPHASE real_expr
		|	P_YPHASE real_expr
		|	P_ZPHASE real_expr
			;

wrapsp:		P_WRAPSP TYPE_IDENT 
			OPEN_BRACE wrapsp_defs CLOSE_BRACE
			;

wrapsp_defs:	/* empty */
			|	wrapsp_defs wrapsp_def
			;

wrapsp_def:	P_BITMAP type_bitmap
		|	P_PATTERN type_surface
		|	P_SUB type_nnegint type_surface
		|	P_DOTRANS
		|	P_DOREFL
		|	P_DODIFF
		|	P_XREP type_posreal
		|	P_YREP type_posreal
		|	P_FILTER type_posint
			;

wrapfl:		P_WRAPFL TYPE_IDENT 
			OPEN_BRACE wrapfl_defs CLOSE_BRACE 
			;

wrapfl_defs:	/* empty */
		|	wrapfl_defs wrapfl_def
			;

wrapfl_def:	P_BITMAP type_bitmap
		|	P_PATTERN type_surface
		|	P_SUB type_nnegint type_surface
		|	P_DOTRANS
		|	P_DOREFL
		|	P_DODIFF
		|	P_FILTER type_posint
		|	P_LOC type_point
		|	P_XAXIS type_vector
		|	P_YAXIS type_vector
		|	P_XLEN type_posreal
		|	P_YLEN type_posreal
		|	P_REPEATX
		|	P_REPEATY
			;
	

wrapcy:		P_WRAPCY TYPE_IDENT 
			OPEN_BRACE wrapcy_defs CLOSE_BRACE
			;

wrapcy_defs:	/* empty */
			|	wrapcy_defs wrapcy_def
				;

wrapcy_def:	P_BITMAP type_bitmap
		|	P_PATTERN type_surface
		|	P_SUB type_nnegint type_surface
		|	P_DOTRANS
		|	P_DODIFF
		|	P_DOREFL
		|	P_XREP type_posreal
		|	P_HEIGHT type_posreal
		|	P_FILTER type_posint
			;

marble:		P_MARBLE TYPE_IDENT 
			OPEN_BRACE marble_defs CLOSE_BRACE
		;

marble_defs:	/* empty */
	|	marble_defs marble_def
		;

marble_def:	P_PATTERN type_surface
	|	P_GRAIN type_surface
	|	P_SCALE type_posreal
	|	P_POWER type_posreal
		;

wood:		P_WOOD TYPE_IDENT 
			OPEN_BRACE wood_defs CLOSE_BRACE
		;

wood_defs:	/* empty */
	|	wood_defs wood_def
		;

wood_def:	P_PATTERN type_surface
	|	P_GRAIN type_surface
	|	P_SCALE type_posreal
		;

check:		P_CHECK TYPE_IDENT 
			OPEN_BRACE check_defs CLOSE_BRACE
		;

check_defs:	/* empty */
	|	check_defs check_def
		;

check_def:	P_XSIZE type_posreal
	|	P_YSIZE type_posreal
	|	P_ZSIZE type_posreal
	|	P_PATTERN1 type_surface
	|	P_PATTERN2 type_surface
		;

brick:		P_BRICK TYPE_IDENT 
			OPEN_BRACE brick_defs CLOSE_BRACE
		;

brick_defs:	/* empty */
	|	brick_defs brick_def
		;

brick_def:	P_XSIZE type_posreal
	|	P_YSIZE type_posreal
	|	P_ZSIZE type_posreal
	|	P_BRICK	type_surface
	|	P_MORTAR type_surface
	|	P_MSIZE type_posreal
	|	P_YOFFSET type_nnegreal
	|	P_ZOFFSET type_nnegreal
		;

surface:	P_COLOR TYPE_IDENT 
			OPEN_BRACE surface_defs CLOSE_BRACE	
		;

surface_defs:	/* nothing */
	|	surface_defs surface_def
		;
surface_def:	P_DIFFUSE type_color
	|	P_AMBIENT type_color
	|	P_REFLECT type_color
	|	P_FILTER type_color
	|	P_TRANSMIT type_color
	|	P_INDEX type_posreal
	|	P_PCOEF type_posreal
	|	P_PREFL type_real01
	|	P_AREFL type_nnegreal
	|	P_ATRANS type_nnegreal
		;


/************************************************
*
*	Texture Definitions
*
************************************************/

textures:	waves
		|	bumpcy
		|	bumpsp
		|	bumpfl
        |	tfromp
			;

waves:		P_WAVES TYPE_IDENT 
			OPEN_BRACE waves_defs CLOSE_BRACE
		;

waves_defs:	/* empty */
		|	waves_defs waves_def
			;

waves_def:	P_NCENTERS type_posint
		|	P_SCALE type_posreal
		|	P_PHASE real_expr
		|	P_SIZE real_expr
			;

tfromp:		P_TFROMP TYPE_IDENT
			OPEN_BRACE tfromp_defs CLOSE_BRACE
		;

tfromp_defs:	/* empty */
		|	tfromp_defs tfromp_def
			;

tfromp_def:	P_PATTERN type_surface
		|	P_SIZE real_expr
			;

bumpsp:		P_BUMPSP TYPE_IDENT
			OPEN_BRACE bumpsp_defs CLOSE_BRACE
		;

bumpsp_defs:	/* nothing */
	|	bumpsp_defs bumpsp_def
		;

bumpsp_def:	P_BITMAP type_bitmap
	|	P_XREP type_posreal
	|	P_YREP type_posreal
	|	P_SIZE real_expr
		;

bumpcy:		P_BUMPCY TYPE_IDENT 
			OPEN_BRACE bumpcy_defs CLOSE_BRACE
		;

bumpcy_defs:	/* empty */
	|	bumpcy_defs bumpcy_def
		;

bumpcy_def:	P_BITMAP type_bitmap
	|	P_XREP type_posreal
	|	P_HEIGHT type_posreal
	|	P_SIZE real_expr
		;

bumpfl:		P_BUMPFL TYPE_IDENT 
			OPEN_BRACE bumpfl_defs CLOSE_BRACE 
		;

bumpfl_defs:	/* empty */
	|	bumpfl_defs bumpfl_def
		;

bumpfl_def:	P_BITMAP type_bitmap
	|	P_LOC type_point
	|	P_XAXIS type_vector
	|	P_YAXIS type_vector
	|	P_XLEN type_posreal
	|	P_YLEN type_posreal
	|	P_SIZE real_expr
	|	P_REPEATX
	|	P_REPEATY
		;

/************************************************
*
*	Other Definitions
*
************************************************/

others:		camera
	|	sky
	|	unsurf
	|	fog
	|	smoothon
	|	smoothoff
	|	maxaadepth
	|	maxaadiff
	|	maxoctdepth
	|	maxobcube
	|	noshad
	|	norefl
	|	notrans
	|	illuminate
	|	iff
	|	raw24lpo
    |	bmp
	|	note
	|	csg
	|	variable
	|	newscope
	|	endscope
	|	varexpr
		;

varexpr:	exprvar_id P_EQSIGN real_expr
			;

exprvar_id:	TYPE_IDENT
			;

newscope:	P_NEWSCOPE	
			;

endscope:	P_ENDSCOPE

variable:	P_VREAL var_ident P_EQSIGN real_expr
		|	P_VINT var_ident P_EQSIGN int_expr
		|	P_VINT var_ident
		|	P_VECTOR var_ident P_EQSIGN vec_expr
			;

var_ident:	TYPE_IDENT	
			;

csg:		P_CSG type_instance csg_operand type_instance P_USESURF type_instance
		|	P_CSG type_instance csg_operand type_instance P_PATTERN type_surface
			;

csg_operand:	P_AND
			|	P_ANDNOT
				;


note:		P_NOTE TYPE_TEXT

iff:		P_IFF type_file TYPE_IDENT
			;

raw24lpo:	P_RAW24LPO type_file TYPE_IDENT
			;

bmp:		P_BMP type_file TYPE_IDENT
			;

camera:		P_OBSERVER 
			OPEN_BRACE camera_defs CLOSE_BRACE	
			;

camera_defs:	/* nothing */
	|	camera_defs camera_def
		;

camera_def:	P_LOC type_point
	|	P_TARGET type_point
	|	P_UP type_vector
	|	P_RES type_posint type_posint
	|	P_ASPECT type_posreal
	|	P_HFOV type_posreal
	|	P_VFOV type_posreal
		;


sky:		P_SKY 
			OPEN_BRACE sky_defs CLOSE_BRACE	
		;

sky_defs:	/* nothing */
	|	sky_defs sky_def
		;

sky_def:	P_HORIZON type_color
	|	P_ZENITH type_color
	|	P_NUMSTARS type_nnegint
	|	P_STARCOLOR type_color
	|	P_UP type_vector
		;

unsurf:		P_UNSURF type_surface
		;

fog:		P_FOG
			OPEN_BRACE fog_defs CLOSE_BRACE	
		;

fog_defs:	/* nothing */
	|	fog_defs fog_def
		;

fog_def:	P_COLOR type_color
	|	P_THIN type_posreal
	|	P_DIST type_posreal
	|	P_POWER type_posreal
		;


noshad:		P_NOSHAD
		;

notrans:	P_NOTRANS
		;

norefl:		P_NOREFL
		;

illuminate:	P_ILLUMINATE
		;

smoothon:	P_SMOOTHON
		;

smoothoff:	P_SMOOTHOFF
		;

maxobcube:	P_MAXOBCUBE type_nnegint
		;

maxoctdepth:	P_MAXOCTDEPTH type_nnegint
		;

maxaadepth:	P_MAXAADEPTH type_nnegint
		;

maxaadiff:	P_MAXAADIFF type_color
		;

/* allow some grammatical checking of types */

type_posreal:	real_expr  
		;

type_nnegreal:	real_expr	
		;

type_posint:	int_expr   
		;

type_nnegint:	int_expr   
		;

type_real01:	real_expr	
		;

real_expr:	real_term
	|	real_expr P_PLUS real_expr
	|	real_expr P_MINUS real_expr
	|	real_expr P_MULT real_expr
	|	real_expr P_DIVIDE real_expr
	|	P_MINUS real_expr %prec UMINUS
	|	OPEN_PAREN real_expr CLOSE_PAREN
	|	P_ACOS OPEN_PAREN real_expr CLOSE_PAREN
	|	P_ASIN OPEN_PAREN real_expr CLOSE_PAREN
	|	P_ATAN OPEN_PAREN real_expr CLOSE_PAREN
	|	P_ATAN2 OPEN_PAREN real_expr P_COMMA real_expr CLOSE_PAREN	

	|	P_COS OPEN_PAREN real_expr CLOSE_PAREN
	|	P_SIN OPEN_PAREN real_expr CLOSE_PAREN
	|	P_TAN OPEN_PAREN real_expr CLOSE_PAREN
	|	P_COSH OPEN_PAREN real_expr CLOSE_PAREN
	|	P_SINH OPEN_PAREN real_expr CLOSE_PAREN
	|	P_TANH OPEN_PAREN real_expr CLOSE_PAREN
	|	P_EXP OPEN_PAREN real_expr CLOSE_PAREN
	|	P_LOG OPEN_PAREN real_expr CLOSE_PAREN
	|	P_LOG10 OPEN_PAREN real_expr CLOSE_PAREN
	|	P_POWER OPEN_PAREN real_expr P_COMMA real_expr CLOSE_PAREN	

	|	P_SQRT OPEN_PAREN real_expr CLOSE_PAREN
	|	P_CEIL OPEN_PAREN real_expr CLOSE_PAREN
	|	P_FLOOR OPEN_PAREN real_expr CLOSE_PAREN
	|	P_DEG2RAD OPEN_PAREN real_expr CLOSE_PAREN
	|	P_RAD2DEG OPEN_PAREN real_expr CLOSE_PAREN
		;

int_expr:	int_term
	|	int_expr P_PLUS int_expr
	|	int_expr P_MINUS int_expr
	|	int_expr P_MULT int_expr
	|	int_expr P_DIVIDE int_expr
		;

real_term:	array_id
	|	array_id OPEN_BRACK type_nnegint CLOSE_BRACK
	|	real_int
		;


array_id:	TYPE_IDENT
		;

real_int:	TYPE_REAL
	|	TYPE_INTEGER
		;


int_term:	TYPE_IDENT
	|	TYPE_INTEGER
		;


type_color:	vec_expr	
		;

type_point:	vec_expr

type_vector:	vec_expr   
		;

vec_expr:	vec_term
		;

vec_term:	path_id
	|	path_id OPEN_BRACK type_nnegint CLOSE_BRACK
	|	OPEN_VEC real_expr P_COMMA real_expr P_COMMA real_expr CLOSE_VEC
		;

path_id:	TYPE_IDENT
		;

type_vector2:	OPEN_VEC real_expr P_COMMA real_expr CLOSE_VEC
		;

type_surface:	TYPE_IDENT	
		;

type_bitmap:	TYPE_IDENT	
		;

type_vertex:	TYPE_IDENT  
		;

type_texture:	TYPE_IDENT	
		;

type_object:	TYPE_IDENT  
		;

type_slice:	TYPE_IDENT	
		;

type_file:	TYPE_IDENT 
	|	TYPE_FILENAME	
		;

type_instance:	TYPE_IDENT 
		;

