
integer		([0-9]+)
dreal		([0-9]*"."[0-9]+)
ereal		([0-9]*"."[0-9]+[eE][+-]?[0-9]+)
real		({dreal}|{ereal})
realint		({real}|{integer})
comment		;.*
ws			([ \t])
id			([_]*[a-zA-Z]+[_.a-zA-Z0-9]*)
filename	(\"[a-zA-Z0-9\/\'\._\\]+\")
text		\"[^\"\n]*\"

%%
"/*"			
"*/"
{ws}			;

{integer}
{real}
{comment}		;

\<			if (!flag_comment_open) RETURN (yylval.cmd = OPEN_VEC);
\>			if (!flag_comment_open) RETURN (yylval.cmd = CLOSE_VEC);
\{			if (!flag_comment_open) RETURN (yylval.cmd = OPEN_BRACE);
\}			if (!flag_comment_open) RETURN (yylval.cmd = CLOSE_BRACE);
\(			if (!flag_comment_open) RETURN (yylval.cmd = OPEN_PAREN);
\)			if (!flag_comment_open) RETURN (yylval.cmd = CLOSE_PAREN);
\[			if (!flag_comment_open) RETURN (yylval.cmd = OPEN_BRACK);
\]			if (!flag_comment_open) RETURN (yylval.cmd = CLOSE_BRACK);
"="			if (!flag_comment_open) RETURN (yylval.cmd = P_EQSIGN);
"+"			if (!flag_comment_open) RETURN (yylval.cmd = P_PLUS);
"-"			if (!flag_comment_open) RETURN (yylval.cmd = P_MINUS);
"*"			if (!flag_comment_open) RETURN (yylval.cmd = P_MULT);
"/"			if (!flag_comment_open) RETURN (yylval.cmd = P_DIVIDE);
","			if (!flag_comment_open) RETURN (yylval.cmd = P_COMMA);

\n
"include"

<incl>[ \t]*
<incl>[^ \t\n]+

<<EOF>>

acos				if (!flag_comment_open) RETURN (yylval.cmd = P_ACOS);
and		   			if (!flag_comment_open) RETURN (yylval.cmd = P_AND);
andnot	   			if (!flag_comment_open) RETURN (yylval.cmd = P_ANDNOT);
amb(ient)?			if (!flag_comment_open) RETURN (yylval.cmd = P_AMBIENT);
a(lpha)?refl		if (!flag_comment_open) RETURN (yylval.cmd = P_AREFL);
array				if (!flag_comment_open) RETURN (yylval.cmd = P_ARRAY);
asin				if (!flag_comment_open) RETURN (yylval.cmd = P_ASIN);
aspect				if (!flag_comment_open) RETURN (yylval.cmd = P_ASPECT);
a(lpha)?trans		if (!flag_comment_open) RETURN (yylval.cmd = P_ATRANS);
atan				if (!flag_comment_open) RETURN (yylval.cmd = P_ATAN);
atan2				if (!flag_comment_open) RETURN (yylval.cmd = P_ATAN2);
axis				if (!flag_comment_open) RETURN (yylval.cmd = P_AXIS);
back				if (!flag_comment_open) RETURN (yylval.cmd = P_BACK);
billboard			if (!flag_comment_open) RETURN (yylval.cmd = P_BILLBOARD);
bitmap				if (!flag_comment_open) RETURN (yylval.cmd = P_BITMAP);
blotch				if (!flag_comment_open) RETURN (yylval.cmd = P_BLOTCH);
bmp					if (!flag_comment_open) RETURN (yylval.cmd = P_BMP);
box					if (!flag_comment_open) RETURN (yylval.cmd = P_BOX);
brick				if (!flag_comment_open) RETURN (yylval.cmd = P_BRICK);
bumpcy(linder)?		if (!flag_comment_open) RETURN (yylval.cmd = P_BUMPCY);
bumpfl(at)?			if (!flag_comment_open) RETURN (yylval.cmd = P_BUMPFL);
bumpsp(here)?		if (!flag_comment_open) RETURN (yylval.cmd = P_BUMPSP);
check				if (!flag_comment_open) RETURN (yylval.cmd = P_CHECK);
ceil				if (!flag_comment_open) RETURN (yylval.cmd = P_CEIL);
child				if (!flag_comment_open) RETURN (yylval.cmd = P_CHILD);
closed				if (!flag_comment_open) RETURN (yylval.cmd = P_CLOSED);
clouds				if (!flag_comment_open) RETURN (yylval.cmd = P_CLOUDS);
color				if (!flag_comment_open) RETURN (yylval.cmd = P_COLOR);
cos					if (!flag_comment_open) RETURN (yylval.cmd = P_COS);
cosh				if (!flag_comment_open) RETURN (yylval.cmd = P_COSH);
csg					if (!flag_comment_open) RETURN (yylval.cmd = P_CSG);
deg2rad				if (!flag_comment_open) RETURN (yylval.cmd = P_DEG2RAD);
diff(use)?			if (!flag_comment_open) RETURN (yylval.cmd = P_DIFFUSE);
dir(ect)?			if (!flag_comment_open) RETURN (yylval.cmd = P_DIRECT);
dist(ance)?			if (!flag_comment_open) RETURN (yylval.cmd = P_DIST);
dodiff(use)?		if (!flag_comment_open) RETURN (yylval.cmd = P_DODIFF);
dorefl(ect)?		if (!flag_comment_open) RETURN (yylval.cmd = P_DOREFL);
dotrans(mit)?		if (!flag_comment_open) RETURN (yylval.cmd = P_DOTRANS);
end					if (!flag_comment_open) RETURN (yylval.cmd = P_END);
endobj(ect)?		if (!flag_comment_open) RETURN (yylval.cmd = P_ENDOBJECT);
endscope			if (!flag_comment_open) RETURN (yylval.cmd = P_ENDSCOPE);
exp					if (!flag_comment_open) RETURN (yylval.cmd = P_EXP);
extrude				if (!flag_comment_open) RETURN (yylval.cmd = P_EXTRUDE);
file				if (!flag_comment_open) RETURN (yylval.cmd = P_FILE);
fill				if (!flag_comment_open) RETURN (yylval.cmd = P_FILL);
(fill)?first		if (!flag_comment_open) RETURN (yylval.cmd = P_FILLFIRST);
(fill)?last			if (!flag_comment_open) RETURN (yylval.cmd = P_FILLLAST);
filt(er)?			if (!flag_comment_open) RETURN (yylval.cmd = P_FILTER);
floor				if (!flag_comment_open) RETURN (yylval.cmd = P_FLOOR);
flushverts			if (!flag_comment_open) RETURN (yylval.cmd = P_FLUSHVERTS);
fog					if (!flag_comment_open) RETURN (yylval.cmd = P_FOG);
front				if (!flag_comment_open) RETURN (yylval.cmd = P_FRONT);
grain				if (!flag_comment_open) RETURN (yylval.cmd = P_GRAIN);
height				if (!flag_comment_open) RETURN (yylval.cmd = P_HEIGHT);
h(eight)?field		if (!flag_comment_open) RETURN (yylval.cmd = P_HFIELD);
hfov				if (!flag_comment_open) RETURN (yylval.cmd = P_HFOV);
horizon				if (!flag_comment_open) RETURN (yylval.cmd = P_HORIZON);
hole				if (!flag_comment_open) RETURN (yylval.cmd = P_HOLE);
hseg(ment)?s		if (!flag_comment_open) RETURN (yylval.cmd = P_HSEGS);
iff					if (!flag_comment_open) RETURN (yylval.cmd = P_IFF);
illum(inate)?		if (!flag_comment_open) RETURN (yylval.cmd = P_ILLUMINATE);
in					if (!flag_comment_open) RETURN (yylval.cmd = P_IN);
index				if (!flag_comment_open) RETURN (yylval.cmd = P_INDEX);
instance			if (!flag_comment_open) RETURN (yylval.cmd = P_INSTANCE);
int(eger)?			if (!flag_comment_open) RETURN (yylval.cmd = P_VINT);
killobj(ect)?		if (!flag_comment_open) RETURN (yylval.cmd = P_KILLOBJECT);
lamp				if (!flag_comment_open) RETURN (yylval.cmd = P_LAMP);
length				if (!flag_comment_open) RETURN (yylval.cmd = P_LENGTH);
loc(ation)?			if (!flag_comment_open) RETURN (yylval.cmd = P_LOC);
lockobj(ect)?		if (!flag_comment_open) RETURN (yylval.cmd = P_LOCK);
log					if (!flag_comment_open) RETURN (yylval.cmd = P_LOG);
log10				if (!flag_comment_open) RETURN (yylval.cmd = P_LOG10);
marble				if (!flag_comment_open) RETURN (yylval.cmd = P_MARBLE);
maxaadepth			if (!flag_comment_open) RETURN (yylval.cmd = P_MAXAADEPTH);
maxaadiff			if (!flag_comment_open) RETURN (yylval.cmd = P_MAXAADIFF);
maxobcube			if (!flag_comment_open) RETURN (yylval.cmd = P_MAXOBCUBE);
maxoctdepth			if (!flag_comment_open) RETURN (yylval.cmd = P_MAXOCTDEPTH);
mortar				if (!flag_comment_open) RETURN (yylval.cmd = P_MORTAR);
m(ortar)?size		if (!flag_comment_open) RETURN (yylval.cmd = P_MSIZE);
name				if (!flag_comment_open) RETURN (yylval.cmd = P_NAME);
n(um)?centers		if (!flag_comment_open) RETURN (yylval.cmd = P_NCENTERS);
norefl(ect)?		if (!flag_comment_open) RETURN (yylval.cmd = P_NOREFL);
note				if (!flag_comment_open) RETURN (yylval.cmd = P_NOTE);
noshad(ows)?		if (!flag_comment_open) RETURN (yylval.cmd = P_NOSHAD);
notrans(mit)?		if (!flag_comment_open) RETURN (yylval.cmd = P_NOTRANS);
n(um)?rays			if (!flag_comment_open) RETURN (yylval.cmd = P_NRAYS);
newscope			if (!flag_comment_open) RETURN (yylval.cmd = P_NEWSCOPE);
numstars			if (!flag_comment_open) RETURN (yylval.cmd = P_NUMSTARS);
object				if (!flag_comment_open) RETURN (yylval.cmd = P_OBJECT);
camera				if (!flag_comment_open) RETURN (yylval.cmd = P_OBSERVER);
offtree				if (!flag_comment_open) RETURN (yylval.cmd = P_OFFTREE);
origin				if (!flag_comment_open) RETURN (yylval.cmd = P_ORIGIN);
out					if (!flag_comment_open) RETURN (yylval.cmd = P_OUT);
p1					if (!flag_comment_open) RETURN (yylval.cmd = P_P1);
p2					if (!flag_comment_open) RETURN (yylval.cmd = P_P2);
p3					if (!flag_comment_open) RETURN (yylval.cmd = P_P3);
path				if (!flag_comment_open) RETURN (yylval.cmd = P_PATH);
patt(ern)?			if (!flag_comment_open) RETURN (yylval.cmd = P_PATTERN);
patt(ern)?1			if (!flag_comment_open) RETURN (yylval.cmd = P_PATTERN1);
patt(ern)?2			if (!flag_comment_open) RETURN (yylval.cmd = P_PATTERN2);
s(pec)?(ular)?coef	if (!flag_comment_open) RETURN (yylval.cmd = P_PCOEF);
s(pec)?(ular)?refl	if (!flag_comment_open) RETURN (yylval.cmd = P_PREFL);
(per)?turb			if (!flag_comment_open) RETURN (yylval.cmd = P_PERTURB);
phase				if (!flag_comment_open) RETURN (yylval.cmd = P_PHASE);
plane				if (!flag_comment_open) RETURN (yylval.cmd = P_PLANE);
point				if (!flag_comment_open) RETURN (yylval.cmd = P_POINT);
pointat				if (!flag_comment_open) RETURN (yylval.cmd = P_POINTAT);
pow(er)?			if (!flag_comment_open) RETURN (yylval.cmd = P_POWER);
psphere				if (!flag_comment_open) RETURN (yylval.cmd = P_PSPHERE);
para(llelo)?gram	if (!flag_comment_open) RETURN (yylval.cmd = P_QUAD);
radius				if (!flag_comment_open) RETURN (yylval.cmd = P_RADIUS);
rad2deg				if (!flag_comment_open) RETURN (yylval.cmd = P_RAD2DEG);
raw24				if (!flag_comment_open) RETURN (yylval.cmd = P_RAW24LPO);
real				if (!flag_comment_open) RETURN (yylval.cmd = P_VREAL);
refl(ect)?			if (!flag_comment_open) RETURN (yylval.cmd = P_REFLECT);
reset				if (!flag_comment_open) RETURN (yylval.cmd = P_RESET);
res(olution)?		if (!flag_comment_open) RETURN (yylval.cmd = P_RES);
ring				if (!flag_comment_open) RETURN (yylval.cmd = P_RING);
rise				if (!flag_comment_open) RETURN (yylval.cmd = P_RISE);
scale				if (!flag_comment_open) RETURN (yylval.cmd = P_SCALE);
seg(ment)?s			if (!flag_comment_open) RETURN (yylval.cmd = P_SEGMENTS);
size				if (!flag_comment_open) RETURN (yylval.cmd = P_SIZE);
sin					if (!flag_comment_open) RETURN (yylval.cmd = P_SIN);
sinh				if (!flag_comment_open) RETURN (yylval.cmd = P_SINH);
skin				if (!flag_comment_open) RETURN (yylval.cmd = P_SKIN);
sky					if (!flag_comment_open) RETURN (yylval.cmd = P_SKY);
slice				if (!flag_comment_open) RETURN (yylval.cmd = P_SLICE);
smooth				if (!flag_comment_open) RETURN (yylval.cmd = P_SMOOTH);
smoothoff			if (!flag_comment_open) RETURN (yylval.cmd = P_SMOOTHOFF);
smoothon			if (!flag_comment_open) RETURN (yylval.cmd = P_SMOOTHON);
sphere				if (!flag_comment_open) RETURN (yylval.cmd = P_SPHERE);
spin				if (!flag_comment_open) RETURN (yylval.cmd = P_SPIN);
spread				if (!flag_comment_open) RETURN (yylval.cmd = P_SPREAD);
sqrt				if (!flag_comment_open) RETURN (yylval.cmd = P_SQRT);
starcolor			if (!flag_comment_open) RETURN (yylval.cmd = P_STARCOLOR);
start				if (!flag_comment_open) RETURN (yylval.cmd = P_START);
sub					if (!flag_comment_open) RETURN (yylval.cmd = P_SUB);
subpatt(ern)?		if (!flag_comment_open) RETURN (yylval.cmd = P_SUBSURF);
subtext(ure)?		if (!flag_comment_open) RETURN (yylval.cmd = P_SUBTEXT);
tan					if (!flag_comment_open) RETURN (yylval.cmd = P_TAN);
tanh				if (!flag_comment_open) RETURN (yylval.cmd = P_TANH);
target				if (!flag_comment_open) RETURN (yylval.cmd = P_TARGET);
text(ure)?			if (!flag_comment_open) RETURN (yylval.cmd = P_TEXTURE);
text(ure)?frompatt(ern)?	if (!flag_comment_open) RETURN (yylval.cmd = P_TFROMP);
thin(ness)?			if (!flag_comment_open) RETURN (yylval.cmd = P_THIN);
trans(mit)?			if (!flag_comment_open) RETURN (yylval.cmd = P_TRANSMIT);
translate			if (!flag_comment_open) RETURN (yylval.cmd = P_TRANSLATE);
tri(angle)			if (!flag_comment_open) RETURN (yylval.cmd = P_TRIANGLE);
tube				if (!flag_comment_open) RETURN (yylval.cmd = P_TUBE);
undef(ine)?patt(ern)?	if (!flag_comment_open) RETURN (yylval.cmd = P_UNSURF);
usepatt(ern)?		if (!flag_comment_open) RETURN (yylval.cmd = P_USESURF);
up		   			if (!flag_comment_open) RETURN (yylval.cmd = P_UP);
v1		   			if (!flag_comment_open) RETURN (yylval.cmd = P_V1);
v2		   			if (!flag_comment_open) RETURN (yylval.cmd = P_V2);
v3		   			if (!flag_comment_open) RETURN (yylval.cmd = P_V3);
var(iable)?			if (!flag_comment_open) RETURN (yylval.cmd = P_VARIABLE);
vector	   			if (!flag_comment_open) RETURN (yylval.cmd = P_VECTOR);
vertex	   			if (!flag_comment_open) RETURN (yylval.cmd = P_VERTEX);
vfov	   			if (!flag_comment_open) RETURN (yylval.cmd = P_VFOV);
vseg(ment)?s		if (!flag_comment_open) RETURN (yylval.cmd = P_VSEGS);
waves	   			if (!flag_comment_open) RETURN (yylval.cmd = P_WAVES);
wood	   			if (!flag_comment_open) RETURN (yylval.cmd = P_WOOD);
wrapcy(linder)?		if (!flag_comment_open) RETURN (yylval.cmd = P_WRAPCY);
wrapsp(here)?		if (!flag_comment_open) RETURN (yylval.cmd = P_WRAPSP);
wrapfl(at)?			if (!flag_comment_open) RETURN (yylval.cmd = P_WRAPFL);
xaxis	   			if (!flag_comment_open) RETURN (yylval.cmd = P_XAXIS);
xlen(gth)? 			if (!flag_comment_open) RETURN (yylval.cmd = P_XLEN);
xphase	   			if (!flag_comment_open) RETURN (yylval.cmd = P_XPHASE);
xrep(eat)? 			if (!flag_comment_open) RETURN (yylval.cmd = P_XREP);
rep(eat)?x 			if (!flag_comment_open) RETURN (yylval.cmd = P_REPEATX);
rep(eat)?y 			if (!flag_comment_open) RETURN (yylval.cmd = P_REPEATY);
xrot(ate)? 			if (!flag_comment_open) RETURN (yylval.cmd = P_XROTATE);
xsize	   			if (!flag_comment_open) RETURN (yylval.cmd = P_XSIZE);
yaxis	   			if (!flag_comment_open) RETURN (yylval.cmd = P_YAXIS);
ylen(gth)? 			if (!flag_comment_open) RETURN (yylval.cmd = P_YLEN);
yoffset	   			if (!flag_comment_open) RETURN (yylval.cmd = P_YOFFSET);
yphase	   			if (!flag_comment_open) RETURN (yylval.cmd = P_YPHASE);
yrep(eat)? 			if (!flag_comment_open) RETURN (yylval.cmd = P_YREP);
yrot(ate)? 			if (!flag_comment_open) RETURN (yylval.cmd = P_YROTATE);
ysize	   			if (!flag_comment_open) RETURN (yylval.cmd = P_YSIZE);
zenith	   			if (!flag_comment_open) RETURN (yylval.cmd = P_ZENITH);
zoffset	   			if (!flag_comment_open) RETURN (yylval.cmd = P_ZOFFSET);
zphase	   			if (!flag_comment_open) RETURN (yylval.cmd = P_ZPHASE);
zrot(ate)? 			if (!flag_comment_open) RETURN (yylval.cmd = P_ZROTATE);
zsize	   			if (!flag_comment_open) RETURN (yylval.cmd = P_ZSIZE);

{id}		{
				if (!flag_comment_open) 
				{	
					yylval.id = yytext;
					return TYPE_IDENT;
				}
			}

{filename}	{
				if (!flag_comment_open) 
				{	
					yylval.filename = yytext;
					return TYPE_FILENAME;
				}
			}

{text}		{
				if (!flag_comment_open)
				{
					yylval.text = yytext;
					return TYPE_TEXT;
				}
			}

.	{
		if (!flag_comment_open)
		{
			sprintf(MsgBuff, "Unrecognized lexical token %s on line %d",
					yytext, LineNumber);
			yyerror(MsgBuff);
		}
	}

%%

