/**********************
*
*	a demo of using arrays for animation.
*
*	this is a simple bouncing ball.  note that this could have
*	been done easier, but that wouldn't show how the array can be used
*
*	the anim has 20 frames.
*
**********************/


/*
*	change these at will
*/

real ball_radius = 1.0		; the radius of the ball
real bounce_height = 5.0	; the distance the ball travels in the bounce
real ground_height = 0.0	; the Y value of the ground

/*
*	don't change these
*/

int numframes = 20				; the number of frames in the anim
real bounce_min = ground_height+ball_radius	; add in ball_radius 'cause the loc
						; of the sphere is the center of
						; the ball, not the bottom
real bounce_max = bounce_min+bounce_height	; the height of the ball at its apex

/*****
*
*	the distance the ball has fallen is computed by
*
*		x = 0.5*a*t*t
*
*	where x is the distance fallen, t is the number of frames since
*	the ball was dropped, and a is the acceleration.  since the ball
*	falls bounce_height in numframes/2, we can solve for a...
*
*/

real accel = bounce_height/(0.5*(numframes/2)*(numframes/2))

/*
*	plug the values into the equation.  the ball falls 10 frame,
*	then rises for ten.  bounce_y[0] is the value for the 1st frame, etc.
*/

array bounce_y = {
	bounce_max-0.5*accel*0*0,
	bounce_max-0.5*accel*1*1,
	bounce_max-0.5*accel*2*2,
	bounce_max-0.5*accel*3*3,
	bounce_max-0.5*accel*4*4,
	bounce_max-0.5*accel*5*5,
	bounce_max-0.5*accel*6*6,
	bounce_max-0.5*accel*7*7,
	bounce_max-0.5*accel*8*8,
	bounce_max-0.5*accel*9*9,
	bounce_max-0.5*accel*10*10,
	bounce_max-0.5*accel*9*9,
	bounce_max-0.5*accel*8*8,
	bounce_max-0.5*accel*7*7,
	bounce_max-0.5*accel*6*6,
	bounce_max-0.5*accel*5*5,
	bounce_max-0.5*accel*4*4,
	bounce_max-0.5*accel*3*3,
	bounce_max-0.5*accel*2*2,
	bounce_max-0.5*accel*1*1
}

color yellow {
	diff	<1, 1, 0>
}

sphere {
	loc	<0, bounce_y[FRAME], 0>
	radius	ball_radius
	patt	yellow
}

/**
*
*	this all just sets up the frame
*
**/

camera {
	loc	<15, 3, 2>
	target	<0, bounce_max/2, 0>
;	target	<0, bounce_y[FRAME], 0>	; for fun, uncomment this and build the
					; anim.  the camera tracks the ball!!
					; the anim file will be huge, though...
}

lamp {
	loc	<9, 15, 4>
}

color red {
	diff	<1, 0, 0>
}

color mirror {
	diff	<.1, .1, .1>
;	refl	<.5, .5, .5>
}

check red_mir {
	patt1	red
	patt2	mirror
	xsize	1
	ysize	1
	zsize	1
}

plane {
	loc	<0, ground_height, 0>
	v1	<1, 0, 0>
	v2	<0, 0, 1>
	patt	red_mir
}

color off_white {
	diff	<.85, .8, 1>
	srefl	0
}

plane {
	loc	<-5, 0, 0>
	v1	<0, 1, 0>
	v2	<0, 0, 1>
	patt	off_white
}


