int xres = 200
int yres = xres*3/4

camera {
	loc	<25, 4, 3>
	target	<0, 0, 0>
	hfov	25
	res	xres yres
}

lamp {
	loc	<10, 25, 15>
}

int numframes = LASTFRAME-FIRSTFRAME+1

real boxXsize = 8
real boxYsize = boxXsize/8
real boxZsize = boxXsize

real bigballrad = boxYsize/2
real smallballrad = bigballrad/2

real outlooprad = boxXsize/2 - bigballrad
real inlooprad = outlooprad/2

real ballheight = bigballrad*1.5

int ballsinnloop = 8
int ballsoutloop = 8

color red {
	diff	<1, 0, 0>
}

color white {
	diff	<1, 1, 1>
}

check boxsurf {
	patt1	red
	patt2	white
	xsize	boxXsize/2
	ysize	boxYsize/2
	zsize	boxZsize/2
}

box {
	patt	boxsurf
	loc	<-boxXsize/2, -boxYsize, -boxZsize/2>
	v1	<boxXsize, 0, 0>
	v2	<0, boxYsize, 0>
	v3	<0, 0, boxZsize>
}

color silver {
	diff	<.7, .7, .7>
	refl	<.5, .5, .5>
	scoef	100
	srefl	1
}


/* for now, since I haven't written a 'for' loop yet, 
	we have to manually drop the proper # of
	balls in each loop
*/

real ballangle = 360/ballsoutloop
real frameangle = ballangle/numframes*FRAME
int ballno = 0

real angle = ballno*ballangle+frameangle
sphere {
	loc	<outlooprad*cos(angle), ballheight, outlooprad*sin(angle)>
	radius	bigballrad
	patt	silver
}

ballno = ballno+1
angle = ballno*ballangle+frameangle
sphere {
	loc	<outlooprad*cos(angle), ballheight, outlooprad*sin(angle)>
	radius	bigballrad
	patt	silver
}

ballno = ballno+1
angle = ballno*ballangle+frameangle
sphere {
	loc	<outlooprad*cos(angle), ballheight, outlooprad*sin(angle)>
	radius	bigballrad
	patt	silver
}

ballno = ballno+1
angle = ballno*ballangle+frameangle
sphere {
	loc	<outlooprad*cos(angle), ballheight, outlooprad*sin(angle)>
	radius	bigballrad
	patt	silver
}

ballno = ballno+1
angle = ballno*ballangle+frameangle
sphere {
	loc	<outlooprad*cos(angle), ballheight, outlooprad*sin(angle)>
	radius	bigballrad
	patt	silver
}

ballno = ballno+1
angle = ballno*ballangle+frameangle
sphere {
	loc	<outlooprad*cos(angle), ballheight, outlooprad*sin(angle)>
	radius	bigballrad
	patt	silver
}

ballno = ballno+1
angle = ballno*ballangle+frameangle
sphere {
	loc	<outlooprad*cos(angle), ballheight, outlooprad*sin(angle)>
	radius	bigballrad
	patt	silver
}

ballno = ballno+1
angle = ballno*ballangle+frameangle
sphere {
	loc	<outlooprad*cos(angle), ballheight, outlooprad*sin(angle)>
	radius	bigballrad
	patt	silver
}

/* the inner ring of balls, rotates opposite the outer */

ballangle = 360/ballsoutloop
frameangle = ballangle/numframes*(numframes-FRAME)
ballno = 0

ballno = ballno+1
angle = ballno*ballangle+frameangle
sphere {
	loc	<inlooprad*cos(angle), ballheight, inlooprad*sin(angle)>
	radius	smallballrad
	patt	silver
}

ballno = ballno+1
angle = ballno*ballangle+frameangle
sphere {
	loc	<inlooprad*cos(angle), ballheight, inlooprad*sin(angle)>
	radius	smallballrad
	patt	silver
}

ballno = ballno+1
angle = ballno*ballangle+frameangle
sphere {
	loc	<inlooprad*cos(angle), ballheight, inlooprad*sin(angle)>
	radius	smallballrad
	patt	silver
}

ballno = ballno+1
angle = ballno*ballangle+frameangle
sphere {
	loc	<inlooprad*cos(angle), ballheight, inlooprad*sin(angle)>
	radius	smallballrad
	patt	silver
}

ballno = ballno+1
angle = ballno*ballangle+frameangle
sphere {
	loc	<inlooprad*cos(angle), ballheight, inlooprad*sin(angle)>
	radius	smallballrad
	patt	silver
}

ballno = ballno+1
angle = ballno*ballangle+frameangle
sphere {
	loc	<inlooprad*cos(angle), ballheight, inlooprad*sin(angle)>
	radius	smallballrad
	patt	silver
}

ballno = ballno+1
angle = ballno*ballangle+frameangle
sphere {
	loc	<inlooprad*cos(angle), ballheight, inlooprad*sin(angle)>
	radius	smallballrad
	patt	silver
}

ballno = ballno+1
angle = ballno*ballangle+frameangle
sphere {
	loc	<inlooprad*cos(angle), ballheight, inlooprad*sin(angle)>
	radius	smallballrad
	patt	silver
}



