/*
	This file is meant to demonstrate the affects of "perturb" and "power" on the
	"clouds" pattern.  "preturb" increases across the X axis of the image,
	and "power" increases on the Y axis.

	 -----------> increasing turbulence ----------->
	|
	|	O	O	O	O	O
	|
	\/	O	O	O	O	O
    increasing
      power	O	O	O	O	O	<-- 25 spheres
	|
	|	O	O	O	O	O
	|
	\/	O	O	O	O	O
*/

maxobcube 4
maxoctdepth 3

sky {
	horizon	<0, 0, 0>
	zenith	<0, 0, 0>
}

color blue {
	diff	<0, 0, 1>
	amb	<1, 1, 1>
}

color white {
	diff	<1, 1, 1>
	amb	<1, 1, 1>
}

real turb0 = 1/3
real turb1 = 1/2
real turb2 = 1
real turb3 = 2
real turb4 = 3

real power0 = 1/3
real power1 = 1/2
real power2 = 1
real power3 = 2
real power4 = 3

real patt_scale = .25

real sphere_radius = 2
real sphere_spacing = sphere_radius*2.5

camera {
	loc	<sphere_spacing*20, 0, 0>
	target	<0, 0, 0>
	hfov	2*atan((sphere_spacing*5+sphere_radius*2)/2/(sphere_spacing*20))
}

clouds pattern00 {
	sky	white
	clouds	blue
	turb	turb0
	power	power0
	scale	patt_scale
}
	
clouds pattern01 {
	sky	white
	clouds	blue
	turb	turb0
	power	power1
	scale	patt_scale
}
	
clouds pattern02 {
	sky	white
	clouds	blue
	turb	turb0
	power	power2
	scale	patt_scale
}
	
clouds pattern03 {
	sky	white
	clouds	blue
	turb	turb0
	power	power3
	scale	patt_scale
}
	
clouds pattern04 {
	sky	white
	clouds	blue
	turb	turb0
	power	power4
	scale	patt_scale
}

clouds pattern10 {
	sky	white
	clouds	blue
	turb	turb1
	power	power0
	scale	patt_scale
}
	
clouds pattern11 {
	sky	white
	clouds	blue
	turb	turb1
	power	power1
	scale	patt_scale
}
	
clouds pattern12 {
	sky	white
	clouds	blue
	turb	turb1
	power	power2
	scale	patt_scale
}
	
clouds pattern13 {
	sky	white
	clouds	blue
	turb	turb1
	power	power3
	scale	patt_scale
}
	
clouds pattern14 {
	sky	white
	clouds	blue
	turb	turb1
	power	power4
	scale	patt_scale
}

clouds pattern20 {
	sky	white
	clouds	blue
	turb	turb2
	power	power0
	scale	patt_scale
}
	
clouds pattern21 {
	sky	white
	clouds	blue
	turb	turb2
	power	power1
	scale	patt_scale
}
	
clouds pattern22 {
	sky	white
	clouds	blue
	turb	turb2
	power	power2
	scale	patt_scale
}
	
clouds pattern23 {
	sky	white
	clouds	blue
	turb	turb2
	power	power3
	scale	patt_scale
}
	
clouds pattern24 {
	sky	white
	clouds	blue
	turb	turb2
	power	power4
	scale	patt_scale
}

clouds pattern30 {
	sky	white
	clouds	blue
	turb	turb3
	power	power0
	scale	patt_scale
}
	
clouds pattern31 {
	sky	white
	clouds	blue
	turb	turb3
	power	power1
	scale	patt_scale
}
	
clouds pattern32 {
	sky	white
	clouds	blue
	turb	turb3
	power	power2
	scale	patt_scale
}
	
clouds pattern33 {
	sky	white
	clouds	blue
	turb	turb3
	power	power3
	scale	patt_scale
}
	
clouds pattern34 {
	sky	white
	clouds	blue
	turb	turb3
	power	power4
	scale	patt_scale
}

clouds pattern40 {
	sky	white
	clouds	blue
	turb	turb4
	power	power0
	scale	patt_scale
}
	
clouds pattern41 {
	sky	white
	clouds	blue
	turb	turb4
	power	power1
	scale	patt_scale
}
	
clouds pattern42 {
	sky	white
	clouds	blue
	turb	turb4
	power	power2
	scale	patt_scale
}
	
clouds pattern43 {
	sky	white
	clouds	blue
	turb	turb4
	power	power3
	scale	patt_scale
}
	
clouds pattern44 {
	sky	white
	clouds	blue
	turb	turb4
	power	power4
	scale	patt_scale
}


sphere {
	loc	<0, -(0-2)*sphere_spacing, -(0-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern00
}

sphere {
	loc	<0, -(0-2)*sphere_spacing, -(1-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern10
}

sphere {
	loc	<0, -(0-2)*sphere_spacing, -(2-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern20
}

sphere {
	loc	<0, -(0-2)*sphere_spacing, -(3-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern30
}

sphere {
	loc	<0, -(0-2)*sphere_spacing, -(4-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern40
}

sphere {
	loc	<0, -(1-2)*sphere_spacing, -(0-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern01
}

sphere {
	loc	<0, -(1-2)*sphere_spacing, -(1-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern11
}

sphere {
	loc	<0, -(1-2)*sphere_spacing, -(2-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern21
}

sphere {
	loc	<0, -(1-2)*sphere_spacing, -(3-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern31
}

sphere {
	loc	<0, -(1-2)*sphere_spacing, -(4-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern41
}

sphere {
	loc	<0, -(2-2)*sphere_spacing, -(0-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern02
}

sphere {
	loc	<0, -(2-2)*sphere_spacing, -(1-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern12
}

sphere {
	loc	<0, -(2-2)*sphere_spacing, -(2-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern22
}

sphere {
	loc	<0, -(2-2)*sphere_spacing, -(3-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern32
}

sphere {
	loc	<0, -(2-2)*sphere_spacing, -(4-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern42
}

sphere {
	loc	<0, -(3-2)*sphere_spacing, -(0-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern03
}

sphere {
	loc	<0, -(3-2)*sphere_spacing, -(1-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern13
}

sphere {
	loc	<0, -(3-2)*sphere_spacing, -(2-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern23
}

sphere {
	loc	<0, -(3-2)*sphere_spacing, -(3-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern33
}

sphere {
	loc	<0, -(3-2)*sphere_spacing, -(4-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern43
}

sphere {
	loc	<0, -(4-2)*sphere_spacing, -(0-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern04
}

sphere {
	loc	<0, -(4-2)*sphere_spacing, -(1-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern14
}

sphere {
	loc	<0, -(4-2)*sphere_spacing, -(2-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern24
}

sphere {
	loc	<0, -(4-2)*sphere_spacing, -(3-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern34
}

sphere {
	loc	<0, -(4-2)*sphere_spacing, -(4-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern44
}


