
color platinum {
	diff	<.95, 1, .9>
}

color black {
	diff 	<0, 0, 0>
}

color flatblack {
	diff	<0, 0, 0>
	srefl	1
}

/* the case */

object case

slice caseslice = {
	<0, 3/8>,
	<0, 14+3/8>,
	<1/8, 14+1/2>,
	<6+7/8, 14+1/2>,
	<7, 14+3/8>,
	<7, 3/8>,
	<6+7/8, 1/4>,
	<1/8, 1/4>
	closed
}


extrude {
	loc		<0, 0, 0>
	patt	platinum
	direct	<0, 0, -1>
	length	20
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	last
	slice	caseslice
}

/* a black matte to block this inside of the case & hide gaps */

paragram {
	loc		<1/8, 3/8, -1>
	v1		<6+3/4, 0, 0>
	v2		<0, 14, 0>
	patt	flatblack
}



/* front facing */

slice fftop = {
	<0, 10+3/4>,
	<0, 14+3/8>,
	<1/8, 14+1/2>,
	<6+7/8, 14+1/2>,
	<7, 14+3/8>,
	<7, 10+3/4>
	closed
}

slice fftophole = {
	<7/16, 10+15/16>,
	<7/16, 14+1/16>,
	<6+9/16, 14+1/16>,
	<6+9/16, 10+15/16>
	closed
}

slice fftopholein = {
	<1/2, 11>,
	<1/2, 14>,
	<6+1/2, 14>,
	<6+1/2, 11>
	closed
}

fill {
	loc		<0, 0, 0>
	patt	platinum
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	slice	fftop
	hole	fftophole
}

skin {
	patt	platinum
	slice	fftophole	<0, 0, 0> <1, 0, 0> <0, 1, 0>
	slice	fftopholein	<0, 0, -1/16> <1, 0, 0> <0, 1, 0>
}	


slice ffmid = {
	<0, 8+1/2>,
	<0, 10+3/4>,
	<7, 10+3/4>,
	<7, 8+1/2>
	closed
}

slice ffmidhole = {
	<7/16, 8+15/16>,
	<7/16, 10+9/16>,
	<4+9/16, 10+9/16>,
	<4+9/16, 8+15/16>
	closed
}

slice ffmidholein = {
	<1/2, 9>,
	<1/2, 10+1/2>,
	<4+1/2, 10+1/2>,
	<4+1/2, 9>
	closed
}


fill {
	loc		<0, 0, 0>
	patt	platinum
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	slice	ffmid
	hole	ffmidhole
}

skin {
	patt	platinum
	slice	ffmidhole	<0, 0, 0> <1, 0, 0> <0, 1, 0>
	slice	ffmidholein	<0, 0, -1/16> <1, 0, 0> <0, 1, 0>
}	



slice ffbot1 = {
	<0, 6>,
	<0, 8+1/2>,
	<3+1/2, 8+1/2>,
	<3+1/2, 6>
	closed
}

slice ffbot1hole = {
	<1/2, 6+1/2>,
	<1/2, 8>,
	<3+1/4, 8>,
	<3+1/4, 6+1/2>
	closed
}

slice ffbot1holein = {
	<5/8, 6+5/8>,
	<5/8, 7+7/8>,
	<3+1/8, 7+7/8>,
	<3+1/8, 6+5/8>
	closed
}


fill {
	loc		<0, 0, 0>
	patt	platinum
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	slice	ffbot1
	hole	ffbot1hole
}

skin {
	patt	platinum
	slice	ffbot1hole	<0, 0, 0> <1, 0, 0> <0, 1, 0>
	slice	ffbot1holein	<0, 0, -1/8> <1, 0, 0> <0, 1, 0>
	last
}	

slice ffbot2 = {
	<3+1/2, 6>,
	<3+1/2, 8+1/2>,
	<5+1/8, 8+1/2>,
	<5+1/8, 6>
	closed
}

slice ffbot2hole = {
	<4+1/2+.5*cos(0*360/20), 7+1/4+.5*sin(0*360/20)>,
	<4+1/2+.5*cos(1*360/20), 7+1/4+.5*sin(1*360/20)>,
	<4+1/2+.5*cos(2*360/20), 7+1/4+.5*sin(2*360/20)>,
	<4+1/2+.5*cos(3*360/20), 7+1/4+.5*sin(3*360/20)>,
	<4+1/2+.5*cos(4*360/20), 7+1/4+.5*sin(4*360/20)>,
	<4+1/2+.5*cos(5*360/20), 7+1/4+.5*sin(5*360/20)>,
	<4+1/2+.5*cos(6*360/20), 7+1/4+.5*sin(6*360/20)>,
	<4+1/2+.5*cos(7*360/20), 7+1/4+.5*sin(7*360/20)>,
	<4+1/2+.5*cos(8*360/20), 7+1/4+.5*sin(8*360/20)>,
	<4+1/2+.5*cos(9*360/20), 7+1/4+.5*sin(9*360/20)>,
	<4+1/2+.5*cos(10*360/20), 7+1/4+.5*sin(10*360/20)>,
	<4+1/2+.5*cos(11*360/20), 7+1/4+.5*sin(11*360/20)>,
	<4+1/2+.5*cos(12*360/20), 7+1/4+.5*sin(12*360/20)>,
	<4+1/2+.5*cos(13*360/20), 7+1/4+.5*sin(13*360/20)>,
	<4+1/2+.5*cos(14*360/20), 7+1/4+.5*sin(14*360/20)>,
	<4+1/2+.5*cos(15*360/20), 7+1/4+.5*sin(15*360/20)>,
	<4+1/2+.5*cos(16*360/20), 7+1/4+.5*sin(16*360/20)>,
	<4+1/2+.5*cos(17*360/20), 7+1/4+.5*sin(17*360/20)>,
	<4+1/2+.5*cos(18*360/20), 7+1/4+.5*sin(18*360/20)>,
	<4+1/2+.5*cos(19*360/20), 7+1/4+.5*sin(19*360/20)>
	closed
}

fill {
	loc		<0, 0, 0>
	patt	platinum
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	slice	ffbot2
	hole	ffbot2hole
}

slice ffbot3 = {
	<5+1/8, 6>,
	<5+1/8, 8+1/2>,
	<7, 8+1/2>,
	<7, 6>
	closed
}

slice ffbot3hole = {
	<5+3/4+.5*cos(0*360/20), 7+1/4+.5*sin(0*360/20)>,
	<5+3/4+.5*cos(1*360/20), 7+1/4+.5*sin(1*360/20)>,
	<5+3/4+.5*cos(2*360/20), 7+1/4+.5*sin(2*360/20)>,
	<5+3/4+.5*cos(3*360/20), 7+1/4+.5*sin(3*360/20)>,
	<5+3/4+.5*cos(4*360/20), 7+1/4+.5*sin(4*360/20)>,
	<5+3/4+.5*cos(5*360/20), 7+1/4+.5*sin(5*360/20)>,
	<5+3/4+.5*cos(6*360/20), 7+1/4+.5*sin(6*360/20)>,
	<5+3/4+.5*cos(7*360/20), 7+1/4+.5*sin(7*360/20)>,
	<5+3/4+.5*cos(8*360/20), 7+1/4+.5*sin(8*360/20)>,
	<5+3/4+.5*cos(9*360/20), 7+1/4+.5*sin(9*360/20)>,
	<5+3/4+.5*cos(10*360/20), 7+1/4+.5*sin(10*360/20)>,
	<5+3/4+.5*cos(11*360/20), 7+1/4+.5*sin(11*360/20)>,
	<5+3/4+.5*cos(12*360/20), 7+1/4+.5*sin(12*360/20)>,
	<5+3/4+.5*cos(13*360/20), 7+1/4+.5*sin(13*360/20)>,
	<5+3/4+.5*cos(14*360/20), 7+1/4+.5*sin(14*360/20)>,
	<5+3/4+.5*cos(15*360/20), 7+1/4+.5*sin(15*360/20)>,
	<5+3/4+.5*cos(16*360/20), 7+1/4+.5*sin(16*360/20)>,
	<5+3/4+.5*cos(17*360/20), 7+1/4+.5*sin(17*360/20)>,
	<5+3/4+.5*cos(18*360/20), 7+1/4+.5*sin(18*360/20)>,
	<5+3/4+.5*cos(19*360/20), 7+1/4+.5*sin(19*360/20)>
	closed
}

fill {
	loc		<0, 0, 0>
	patt	platinum
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	slice	ffbot3
	hole	ffbot3hole
}

slice ffvbot = {
	<0, 3/8>,
	<0, 6>,
	<7, 6>,
	<7, 3/8>,
	<6+7/8, 1/4>,
	<1/8, 1/4>
	closed
}

slice ffvbothole = {
	<2+1/2, 4>,
	<2+1/2, 5+1/2>,
	<6+1/2, 5+1/2>,
	<6+1/2, 4>
	closed
}

fill {
	loc		<0, 0, 0>
	patt	platinum
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	slice	ffvbot
	hole	ffvbothole
}

/* the vent holes */

slice ventsl = {
	<0, 4>,
	<-1/8, 4>,
	<-1/8, 4+1*1.5/9>,
	<0, 4+1*1.5/9>,
	<0, 4+2*1.5/9>,
	<-1.8, 4+2*1.5/9>,
	<-1/8, 4+3*1.5/9>,
	<0, 4+3*1.5/9>,
	<0, 4+4*1.5/9>,
	<-1.8, 4+4*1.5/9>,
	<-1/8, 4+5*1.5/9>,
	<0, 4+5*1.5/9>,
	<0, 4+6*1.5/9>,
	<-1.8, 4+6*1.5/9>,
	<-1/8, 4+7*1.5/9>,
	<0, 4+7*1.5/9>,
	<0, 4+8*1.5/9>,
	<-1.8, 4+8*1.5/9>,
	<-1/8, 4+9*1.5/9>,
	<0, 4+9*1.5/9>
}

extrude {
	slice	ventsl
	loc		<2.5, 0, 0>
	xaxis	<0, 0, 1>
	yaxis	<0, 1, 0>
	direct	<1, 0, 0>
	length	4
	patt	platinum
}

endobject lockobject case

/* a blank 5+1/4" facing */

object blank5.25

slice b5face = {
	<1/2, 11>,
	<1/2, 12+1/2-1/64>,
	<6+1/2, 12+1/2-1/64>,
	<6+1/2, 11>
	closed
}

fill {
	loc		<0, 0, -1/16>
	patt	platinum
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	slice	b5face
}

endobject lockobject blank5.25

/* LED's */


bmp "mapfiles\power.bmp" power.map
bmp "mapfiles\turbo.bmp" turbo.map
bmp "mapfiles\hdisk.bmp" hdisk.map
bmp "mapfiles\reset.bmp" reset.map

wrapflat power.patt {
	bitmap	power.map
	patt	platinum
	sub		0 platinum
	sub		1 black
	loc		<0, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, -1, 0>
	xlen	1/2
	ylen	1/8
	filter	1
	repeatx repeaty
	dodiff
}

wrapflat reset.patt {
	bitmap	reset.map
	patt	platinum
	sub		0 platinum
	sub		1 black
	loc		<0, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, -1, 0>
	xlen	1/2
	ylen	1/8
	filter	1
	repeatx repeaty
	dodiff
}

wrapflat hdisk.patt {
	bitmap	hdisk.map
	patt	platinum
	sub		0 platinum
	sub		1 black
	loc		<0, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, -1, 0>
	xlen	1/2
	ylen	1/8
	filter	1
	repeatx repeaty
	dodiff
}

wrapflat turbo.patt {
	bitmap	turbo.map
	patt	platinum
	sub		0 platinum
	sub		1 black
	loc		<0, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, -1, 0>
	xlen	1/2
	ylen	1/8
	filter	1
	repeatx repeaty
	dodiff
}

object label

paragram {
	patt	power.patt
	loc		<-1/4, 7/32, .001>
	v1		<1/2, 0, 0>
	v2		<0, -1/8, 0>
}

endobject lockobject label


color redled {
	diff	<1, 0, 0>
	amb		<1, 1, 1>
}

color greenled {
	diff	<0, .7, 0>
	amb		<1, 1, 1>
}

color amberled {
	diff	<.8, .8, 0>
	amb		<1, 1, 1>
}

object led

box {
	loc		<-3/32, -1/32, 0>
	v1		<3/16, 0, 0>
	v2		<0, 1/16, 0>
	v3		<0, 0, 1/32>
	patt	greenled
}

endobject /* led */

object ledpanel

translate led <1+3/32, 7+1/4, -1/8>
instance led
translate label <1+3/32, 7+1/4, -1/8>
instance label

translate led <3/4, 0, 0>
instance {
	object	led
	subpatt	greenled redled
}
translate label <3/4, 0, 0>
instance {
	object	label
	subpatt	power.patt hdisk.patt
}


translate led <3/4, 0, 0>
instance {
	object	led
	subpatt	greenled amberled
}
translate label <3/4, 0, 0>
instance {
	object	label
	subpatt	power.patt turbo.patt
}


reset led
reset label

endobject lockobject ledpanel

/* buttons */

slice buttonsl = {
	<.5-1/16-1/32, -3/16>,
	<.5-1/16-1/32, -1/16>,
	<(.5-1/16-1/32)*.66, 1/16>,
	<0, 3/32>
}

object button
spin {
	slice	buttonsl
	loc		<0, 0, 0>
	patt	platinum
	segs	20
	smooth
}
endobject /* button */

object turbresetbuttons

slice butbev1 = {                             
	<4+1/2+.5-1/16*cos(0*360/20), 7+1/4+.5-1/16*sin(0*360/20)>,
	<4+1/2+.5-1/16*cos(1*360/20), 7+1/4+.5-1/16*sin(1*360/20)>,
	<4+1/2+.5-1/16*cos(2*360/20), 7+1/4+.5-1/16*sin(2*360/20)>,
	<4+1/2+.5-1/16*cos(3*360/20), 7+1/4+.5-1/16*sin(3*360/20)>,
	<4+1/2+.5-1/16*cos(4*360/20), 7+1/4+.5-1/16*sin(4*360/20)>,
	<4+1/2+.5-1/16*cos(5*360/20), 7+1/4+.5-1/16*sin(5*360/20)>,
	<4+1/2+.5-1/16*cos(6*360/20), 7+1/4+.5-1/16*sin(6*360/20)>,
	<4+1/2+.5-1/16*cos(7*360/20), 7+1/4+.5-1/16*sin(7*360/20)>,
	<4+1/2+.5-1/16*cos(8*360/20), 7+1/4+.5-1/16*sin(8*360/20)>,
	<4+1/2+.5-1/16*cos(9*360/20), 7+1/4+.5-1/16*sin(9*360/20)>,
	<4+1/2+.5-1/16*cos(10*360/20), 7+1/4+.5-1/16*sin(10*360/20)>,
	<4+1/2+.5-1/16*cos(11*360/20), 7+1/4+.5-1/16*sin(11*360/20)>,
	<4+1/2+.5-1/16*cos(12*360/20), 7+1/4+.5-1/16*sin(12*360/20)>,
	<4+1/2+.5-1/16*cos(13*360/20), 7+1/4+.5-1/16*sin(13*360/20)>,
	<4+1/2+.5-1/16*cos(14*360/20), 7+1/4+.5-1/16*sin(14*360/20)>,
	<4+1/2+.5-1/16*cos(15*360/20), 7+1/4+.5-1/16*sin(15*360/20)>,
	<4+1/2+.5-1/16*cos(16*360/20), 7+1/4+.5-1/16*sin(16*360/20)>,
	<4+1/2+.5-1/16*cos(17*360/20), 7+1/4+.5-1/16*sin(17*360/20)>,
	<4+1/2+.5-1/16*cos(18*360/20), 7+1/4+.5-1/16*sin(18*360/20)>,
	<4+1/2+.5-1/16*cos(19*360/20), 7+1/4+.5-1/16*sin(19*360/20)>
	closed
}


slice butbev2 = {
	<5+3/4+.5-1/16*cos(0*360/20), 7+1/4+.5-1/16*sin(0*360/20)>,
	<5+3/4+.5-1/16*cos(1*360/20), 7+1/4+.5-1/16*sin(1*360/20)>,
	<5+3/4+.5-1/16*cos(2*360/20), 7+1/4+.5-1/16*sin(2*360/20)>,
	<5+3/4+.5-1/16*cos(3*360/20), 7+1/4+.5-1/16*sin(3*360/20)>,
	<5+3/4+.5-1/16*cos(4*360/20), 7+1/4+.5-1/16*sin(4*360/20)>,
	<5+3/4+.5-1/16*cos(5*360/20), 7+1/4+.5-1/16*sin(5*360/20)>,
	<5+3/4+.5-1/16*cos(6*360/20), 7+1/4+.5-1/16*sin(6*360/20)>,
	<5+3/4+.5-1/16*cos(7*360/20), 7+1/4+.5-1/16*sin(7*360/20)>,
	<5+3/4+.5-1/16*cos(8*360/20), 7+1/4+.5-1/16*sin(8*360/20)>,
	<5+3/4+.5-1/16*cos(9*360/20), 7+1/4+.5-1/16*sin(9*360/20)>,
	<5+3/4+.5-1/16*cos(10*360/20), 7+1/4+.5-1/16*sin(10*360/20)>,
	<5+3/4+.5-1/16*cos(11*360/20), 7+1/4+.5-1/16*sin(11*360/20)>,
	<5+3/4+.5-1/16*cos(12*360/20), 7+1/4+.5-1/16*sin(12*360/20)>,
	<5+3/4+.5-1/16*cos(13*360/20), 7+1/4+.5-1/16*sin(13*360/20)>,
	<5+3/4+.5-1/16*cos(14*360/20), 7+1/4+.5-1/16*sin(14*360/20)>,
	<5+3/4+.5-1/16*cos(15*360/20), 7+1/4+.5-1/16*sin(15*360/20)>,
	<5+3/4+.5-1/16*cos(16*360/20), 7+1/4+.5-1/16*sin(16*360/20)>,
	<5+3/4+.5-1/16*cos(17*360/20), 7+1/4+.5-1/16*sin(17*360/20)>,
	<5+3/4+.5-1/16*cos(18*360/20), 7+1/4+.5-1/16*sin(18*360/20)>,
	<5+3/4+.5-1/16*cos(19*360/20), 7+1/4+.5-1/16*sin(19*360/20)>
	closed
}

skin {
	patt	platinum
	slice	ffbot2hole <0, 0, 0> <1, 0, 0> <0, 1, 0>
	slice	butbev1 <0, 0, -1/8> <1, 0, 0> <0, 1, 0>
	slice	butbev1 <0, 0, -1/4> <1, 0, 0> <0, 1, 0>
}

skin {
	patt	platinum
	slice	ffbot3hole <0, 0, 0> <1, 0, 0> <0, 1, 0>
	slice	butbev2 <0, 0, -1/8> <1, 0, 0> <0, 1, 0>
	slice	butbev2 <0, 0, -1/4> <1, 0, 0> <0, 1, 0>
}

xrot button 90
translate button <4+1/2, 7+1/4, -1/16>
instance button
translate label <4+1/2, 7+7/8, 0>
instance {
	object	label
	subpatt	power.patt reset.patt
}

translate button <1+1/4, 0, 0>
instance button
translate label <1+1/4, 0, 0>
instance {
	object	label
	subpatt	power.patt turbo.patt
}

reset button
reset label

endobject lockobject turbresetbuttons

/* 3.5" disk drive */

/* uses ffmidholdin */

object disk3.5

slice fd3cutout = {
	<3/4, 10>,
	<1+3/4, 10>,
	<1+3/4, 10+1/16>,
	<3+1/4, 10+1/16>,
	<3+1/4, 10>,
	<4+1/4, 10>,
	<4+1/4, 9+3/4>,
	<3+1/4, 9+3/4>,
	<3+1/4, 9+1/4>,
	<1+3/4, 9+1/4>,
	<1+3/4, 9+3/4>,
	<3/4, 9+3/4>
	closed
}

fill {
	slice	ffmidholein
	hole	fd3cutout
	loc		<0, 0, -1/16>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	patt	platinum
}

slice fd3holeedge = {
	<1+3/4, 9+3/4>,
	<3/4, 9+3/4>,
	<3/4, 10>,
	<1+3/4, 10>,
	<1+3/4, 10+1/16>,
	<3+1/4, 10+1/16>,
	<3+1/4, 10>,
	<4+1/4, 10>,
	<4+1/4, 9+3/4>,
	<3+1/4, 9+3/4>
}

extrude {
	slice	fd3holeedge
	loc		<0, 0, -1/16>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir	   	<0, 0, -1/8>
	length	1/8
	patt	platinum
}

slice fd3door = {
	<3/4, 9+3/4>,
	<3/4, 10>,
	<1+3/4, 10>,
	<1+3/4, 10+1/16>,
	<3+1/4, 10+1/16>,
	<3+1/4, 10>,
	<4+1/4, 10>,
	<4+1/4, 9+3/4>
	closed
}

fill {
	slice	fd3door
	loc		<0, 0, -1/8-1/16>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	patt	platinum
}

slice fd3bevel = {
	<-1/8, 9+3/4>,
	<0, 9+1/4>
}

slice fd3bevelside = {
	<-1/8, 9+3/4>,
	<0, 9+1/4>,
	<0, 9+3/4>
	closed
}

extrude {
	slice	fd3bevel
	loc		<1+3/4, 0, -1/16>
	xaxis	<0, 0, 1>
	yaxis	<0, 1, 0>
	dir		<1, 0, 0>
	length	1+1/2
	patt	platinum
}

fill {
	slice	fd3bevelside
	loc		<1+3/4, 0, -1/16>
	xaxis	<0, 0, 1>
	yaxis	<0, 1, 0>
	patt	platinum
}

fill {
	slice	fd3bevelside
	loc		<3+1/4, 0, -1/16>
	xaxis	<0, 0, 1>
	yaxis	<0, 1, 0>
	patt	platinum
}

box {
	loc		<3+1/2, 9+1/4, -1/16>
	v1		<1/2, 0, 0>
	v2		<0, 1/4, 0>
	v3		<0, 0, 3/8>
	patt	platinum
}

translate led <1, 9+1/4, -1/16>
instance led
reset led

endobject lockobject disk3.5

/* badging */

object badge

slice badgesl1 = {
	<1/2, 4>,
	<1/2, 5+1/2>,
	<2, 5+1/2>,
	<2, 4>
	closed
}	

slice badgesl2 = {
	<3/4, 4+1/4>,
	<3/4, 5+1/4>,
	<1+3/4, 5+1/4>,
	<1+3/4, 4+1/4>
	closed
}

color badgeblue {
	diff	<0, 0, .7>
	srefl	1
	scoef	100
}

color badgeyellow {
	diff	<1, 1, 0>
	srefl	1
	scoef	100
}

bmp "mapfiles\label.bmp" badge.bmp

wrapflat badgepatt {
	patt	badgeblue
	bitmap	badge.bmp
	sub		1 badgeblue
	sub		0 badgeyellow
	loc		<1/2, 5+1/2, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, -1, 0>
	filter	1
	xlen	1+1/2
	ylen	1+1/2
	dodiff
}

skin {
	patt	badgepatt
	slice	badgesl1	<0, 0, 0> <1, 0, 0> <0, 1, 0>
	slice	badgesl2	<0, 0, 1/8> <1, 0, 0> <0, 1, 0>
	last
	smooth
}

endobject lockobject badge

/* CD-ROM drive */

/* headphone jack */

slice hjsl = {
	<1/8, 0>,
	<1/8, 1/16>,
	<1/16, 1/16>,
	<1/16, -3/4>,
	<0, -3/4>
}

color silver {
	diff	<.75, .75, .75>
	refl	<.5, .5, .5>
	scoef	200
	srefl	1
}

object hjobj
spin {
	slice	hjsl
	patt	silver
	loc		<0, 0, 0>
	smooth
}
endobject /* hjobj */

object cdromdrive

slice cdtopface = {
	<1/2, 13+3/16>,
	<1/2, 14>,
	<6+1/2, 14>,
	<6+1/2, 13+3/16>
	closed
}

slice cdtrayhole = {
	<7/8, 13+1/4>,
	<7/8, 13+3/4>,
	<6+1/8, 13+3/4>,
	<6+1/8, 13+1/4>
	closed
}

fill {
	slice	cdtopface
	hole	cdtrayhole
	loc		<0, 0, -1/16>
	patt	platinum
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

slice cdbotface1 = {
	<1/2, 12+1/2>,
	<1/2, 13+3/16>,
	<1+3/8, 13+3/16>,
	<1+3/8, 12+1/2>
	closed
}

slice cdplughole = {
	<1+1/8+1/8*cos(0*360/8), 12+3/4+1/8*sin(0*360/8)>,
	<1+1/8+1/8*cos(1*360/8), 12+3/4+1/8*sin(1*360/8)>,
	<1+1/8+1/8*cos(2*360/8), 12+3/4+1/8*sin(2*360/8)>,
	<1+1/8+1/8*cos(3*360/8), 12+3/4+1/8*sin(3*360/8)>,
	<1+1/8+1/8*cos(4*360/8), 12+3/4+1/8*sin(4*360/8)>,
	<1+1/8+1/8*cos(5*360/8), 12+3/4+1/8*sin(5*360/8)>,
	<1+1/8+1/8*cos(6*360/8), 12+3/4+1/8*sin(6*360/8)>,
	<1+1/8+1/8*cos(7*360/8), 12+3/4+1/8*sin(7*360/8)>
}

fill {
	slice	cdbotface1
	hole	cdplughole
	loc		<0, 0, -1/16>
	patt	platinum
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

slice cdbotface2 = {
	<1+3/8, 12+1/2>,
	<1+3/8, 13+3/16>,
	<5, 13+3/16>,
	<5, 12+1/2>
	closed
}

slice cdvolhole = {
	<1+1/2, 12+5/8>,
	<1+1/2, 12+3/4>,
	<2+1/8, 12+3/4>,
	<2+1/8, 12+5/8>
	closed
} 

fill {
	slice	cdbotface2
	hole	cdvolhole
	loc		<0, 0, -1/16>
	patt	platinum
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

slice cdbotface3 = {
	<5, 12+1/2>,
	<5, 13+3/16>,
	<6+1/2, 13+3/16>,
	<6+1/2, 12+1/2>
	closed
}

slice cdejecthole = {
	<5+1/2, 12+5/8>,
	<5+1/2, 12+7/8>,
	<6, 12+7/8>,
	<6, 12+5/8>
	closed
} 

fill {
	slice	cdbotface3
	hole	cdejecthole
	loc		<0, 0, -1/16>
	patt	platinum
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

xrot hjobj 90
translate hjobj <1+1/8, 12+3/4, -1/16>
instance hjobj
reset hjobj

translate led <2+3/4, 12+7/8, -1/16>
instance led
reset led

/* volume wheel */

slice volsl1 = {
	<0, 0>,
	<.3789, 0>
}

slice volsl2 = {
	<.3789, 0>,
	<.3789, 7/64>
}

slice volsl3 = {
	<.3789, 7/64>,
	<0, 7/64>
}

spin {
	slice	volsl1
	loc		<1+13/16, 12+5/8+1/128, -1/16-.3789+1/8>
	segs	20
	patt	platinum
}

spin {
	slice	volsl2
	loc		<1+13/16, 12+5/8+1/128, -1/16-.3789+1/8>
	segs	20
	smooth
	patt	platinum
}

spin {
	slice	volsl3
	loc		<1+13/16, 12+5/8+1/128, -1/16-.3789+1/8>
	segs	20
	patt	platinum
}

/* eject button */

box {
	loc		<5+1/2+1/64, 12+5/8+1/64, -1/4>
	v1		<1/2-1/32, 0, 0>
	v2		<0, 1/4-1/32, 0>
	v3		<0, 0, 1/2>
	patt	platinum
}

/* volume decal */

bmp "mapfiles\volume.bmp" volume.bmp

wrapfl volume.patt {
	bitmap	volume.bmp
	patt	platinum
	sub		1 platinum
	sub		0 black
	loc		<0, 1/8, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, -1, 0>
	xlen	5/8
	ylen	1/8
	filter	1
	repeatx repeaty
	dodiff
}

paragram {
	patt	volume.patt
	loc		<1+1/2, 12+3/4+1/8+1/32, -1/16+.001>
	v1		<5/8, 0, 0>
	v2		<0, -1/8, 0>
}

bmp "mapfiles\cdrom.bmp" cdrom.bmp

wrapfl cdrom.patt {
	bitmap	cdrom.bmp
	patt	platinum
	sub		1 platinum
	sub		0 black
	loc		<0, 3/8, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, -1, 0>
	xlen	1
	ylen	3/8
	filter	1
	repeatx repeaty
	dodiff
}

paragram {
	patt	cdrom.patt
	loc		<4, 13, -1/16+.001>
	v1		<1, 0, 0>
	v2		<0, -3/8, 0>
}

/* the tray door */

slice cdtraydoor1 = {
	<7/8+1/32, 13+1/4+1/32>,
	<7/8+1/32, 13+3/4-1/32>,
	<6+1/8+1/32, 13+3/4-1/32>,
	<6+1/8+1/32, 13+1/4+1/32>
	closed
}

slice cdtraydoor2 = {
	<7/8+1/32+1/4, 13+1/4+1/32+1/8>,
	<7/8+1/32+1/4, 13+3/4-1/32-1/8>,
	<6+1/8+1/32-1/4, 13+3/4-1/32-1/8>,
	<6+1/8+1/32-1/4, 13+1/4+1/32+1/8>
	closed
}

skin {
	patt	platinum
	slice	cdtraydoor1 <0, 0, -1/2> <1, 0, 0> <0, 1, 0>
	slice	cdtraydoor1 <0, 0, 1/16> <1, 0, 0> <0, 1, 0>
	slice	cdtraydoor2 <0, 0, 1/8> <1, 0, 0> <0, 1, 0>
	last
	smooth
}

endobject lockobject cdromdrive

/* and some feet to stand on... */

object rubberfeet

slice footsl = {
	<0, 0>,
	<3/16, 0>,
	<1/4, 1/4>
}

spin {
	slice	footsl
	patt	flatblack
	loc		<3/4, 0, -3/4>
	segs	12
}

spin {
	slice	footsl
	patt	flatblack
	loc		<7-3/4, 0, -3/4>
	segs	12
}

spin {
	slice	footsl
	patt	flatblack
	loc		<3/4, 0, -20+3/4>
	segs	12
}

spin {
	slice	footsl
	patt	flatblack
	loc		<7-3/4, 0, -20+3/4>
	segs	12
}

endobject lockobject rubberfeet

/* build the computer */

object computer_cpu.obj

instance case
instance blank5.25
instance ledpanel
instance turbresetbuttons
instance disk3.5
instance badge
instance cdromdrive
instance rubberfeet

endobject lockobject computer_cpu.obj

killobject case
killobject blank5.25
killobject label
killobject led
killobject ledpanel
killobject button
killobject turbresetbuttons
killobject disk3.5
killobject badge
killobject hjobj
killobject cdromdrive
killobject rubberfeet


/* stage */

include "monitor.mco"

translate computer_monitor.obj <9, 0, 0>
instance computer_monitor.obj

instance computer_cpu.obj

lamp {
	loc		<2, 10, 6>
	color	<.3, .3, .3>
}

lamp {
	loc		<-4, 15, 2>
	color	<.3, .3, .3>
}

camera {
	loc		<14, 18, 50>
	target	<11, 8.5, 0>
	hfov	30
}

sky {
	zenith	<0, 0, 0>
	horizon	<0, 0, 0>
}

color reflblack {
	diff	<0, 0, 0>
	refl	<.4, .4, .4>
}

color reflwhite {
	diff	<.9, .9, .9>
	refl	<.4, .4, .4>
}

check checks {
	patt1	reflblack
	patt2	reflwhite
	xsize	3
	ysize	3
	zsize	3
}

paragram {
	patt	checks
	loc		<-10, 0, 11.5>
	v1		<43, 0, 0>
	v2		<0, 0, -43>
}
	