maxaadepth 2

maxobcube 3
maxoctdepth 6


camera {
	loc	<39, 12, 23>
	target	<0, 8, 0>
	hfov 	50
}

lamp {
	loc	<10, 29.98, 10>
	color	<.4, .4, .4>
}


lamp {
	loc	<-10, 29.98, 10>
	color	<.4, .4, .4>
}

lamp {
	loc	<10, 29.98, -10>
	color	<.4, .4, .4>
}

lamp {
	loc	<-10, 29.98, -10>
	color	<.4, .4, .4>
}


color whiteglow {
	diff	<1, 1, 1>
	amb	<1, 1, 1>
	srefl	0
}

paragram {
	patt	whiteglow
	loc	<-15, 29.99, -15>
	v1	<10, 0, 0>
	v2	<0, 0, 10>
}

paragram {
	patt	whiteglow
	loc	<5, 29.99, -15>
	v1	<10, 0, 0>
	v2	<0, 0, 10>
}

paragram {
	patt	whiteglow
	loc	<-15, 29.99, 5>
	v1	<10, 0, 0>
	v2	<0, 0, 10>
}

paragram {
	patt	whiteglow
	loc	<5, 29.99, 5>
	v1	<10, 0, 0>
	v2	<0, 0, 10>
}

color turnstylewhite {
	diff	<.7, .7, .7>
	refl	<.3, .3, .3>
	scoef	50
	srefl	1
}

color turnstyleblack {
	diff	<0, 0, 0>
	refl	<.5, .5, .5>
	scoef	50
	srefl	1
}

marble turnstylepattern {
	patt	turnstylewhite
	grain	turnstyleblack
	scale	.5
	pow	.5
}

object turnstyle

slice _turn1.slice = {
	<0, 1>,
	<15, 1>
}

spin {
	patt	turnstylepattern
	segs	40
	loc	<0, 0, 0>
	slice	_turn1.slice
}

slice _turn2.slice = {
	<15, 0>,
	<15, 1>
}

spin {
	patt	turnstylepattern
	segs	40
	smooth
	loc	<0, 0, 0>
	slice	_turn2.slice
}

endobject	/* turnstyle */

lockobj turnstyle

color aluminum {
	diff	<.5, .5, .5>
	refl	<.5, .5, .5>
	scoef	100
	srefl	1
}

color basesurf {
	diff	<.5, .5, .5>
	scoef	100
	srefl	1
}

bmp "mapfiles\duffs.bmp" duffslabel.img

wrapcy duffslabel {
	bitmap	duffslabel.img
	patt	basesurf
	dodiff
	height	16
	xrep	1
	filter	1
}
	
object duffscan 

slice _can.slice = {
	<4.5, 0>,
	<5.0, .5>,
	<5.0, 17>,
	<4.5, 17.5>,
	<4.75, 17.5>,
	<4.75, 17.25>,
	<4.5, 17.25>,
	<4.5, 17>,
	<4.6, 17.2>,
	<0, 17.3>
}

spin {
	patt	aluminum
	segs	20
	smooth
	loc	<0, 1, 0>
	slice	_can.slice
}

slice _label.slice = {
	<5.01, 0>,
	<5.01, 16>
}

spin {
	patt	duffslabel
	segs	20
	smooth
	loc	<0, 2, 0>
	slice	_label.slice
}

endobject	/* duffscan */

lockobj duffscan

color reflblack {
	diff	<0, 0, 0>
	refl	<.3, .3, .3>
}

color reflwhite {
	diff	<.8, .8, .8>
	refl	<.3, .3, .3>
}

check tiles {
	patt1	reflblack
	patt2	reflwhite
	xsize	5
	ysize	5
	zsize	5
}

				/* floor */
plane {
	patt	tiles
	loc	<0, 0, 0>
	v1	<1, 0, 0>
	v2	<0, 0, 1>
}

color offwhite {
	diff	<.9, .9, .8>
	scoef	5
	srefl	.3
}

				/* room walls & ceiling */
box {
	patt	offwhite
	loc	<-40, -1, -40>
	v1	<80, 0, 0>
	v2	<0, 31, 0>
	v3	<0, 0, 80>
}

color redcarpet {
	diff	<.7, 0, 0>
	srefl	0
}

color blackedge {
	diff	<0, 0, 0>
	srefl	0
}

				/* red carpet with black edge */
slice _carpet.slice = {
	<0, 0>,
	<20, 0>
}

spin {
	patt 	redcarpet
	segs	40
	loc	<0, .01, 0>
	slice	_carpet.slice
}

slice _edge.slice = {
	<20, 0>,
	<21, 0>
}

spin {
	patt	blackedge
	segs	40
	loc	<0, .01, 0>
	slice	_edge.slice
}

				/* turnstyle */
instance turnstyle

				/* can */
instance duffscan

color n15basesurf {
	diff	<0, 0, 0>
	scoef	5
	srefl	.1
}

color lightwood {
	diff	<.7, .5, 0>
}

color darkwood {
	diff	<.3, .1, 0>
}

wood woodframe {
	patt	lightwood
	grain	darkwood
	scale	10
}

paragram {
	loc	<-39.99, 27.5, 9.25>
	v1	<0, 0, -18.5>
	v2	<0, -15, 0>
	patt	woodframe
}

bmp "mapfiles\n15.bmp" n15.img

billboard {
	bitmap	n15.img
	patt	n15basesurf
	dodiff
	loc	<-39.98, 27, 8.75>
	xaxis	<0, 0, -1>
	yaxis	<0, -1, 0>
	xlen	17.5
	ylen	14
	filter	1
}

paragram {
	loc	<10.5, 23.5, -39.99>
	v1	<-21, 0, 0>
	v2	<0, -17, 0>
	patt	woodframe
}

bmp "mapfiles\n10.bmp" n10.img

billboard {
	bitmap	n10.img
	patt	n15basesurf
	dodiff
	loc	<10, 23, -39.98>
	xaxis	<-1, 0, 0>
	yaxis	<0, -1, 0>
	xlen	20
	ylen	16
	filter	1
}

color darkerwood {
	diff	<.5, .3, .0>
}

wood tablewood {
	patt	darkerwood
	grain	darkwood
	scale	15
}

object tableleg

slice _leg.slice = {
	<0, 0>,
	<.4, 0>,
	<.2, .5>,
	<.3, 1.5>,
	<.4, 2.5>,
	<.3, 3.5>,
	<.2, 4.5>,
	<.3, 4.75>,
	<.2, 5>,
	<.3, 5.25>,
	<.2, 5.5>
}

spin {
	patt	tablewood
	smooth
	segs	10
	loc	<0, 0, 0>
	slice	_leg.slice
}

endobject	/* tableleg */

object table
box {
	patt	tablewood
	loc	<6, 5.5, 4>
	v1	<-12, 0, 0>
	v2	<0, .5, 0>
	v3	<0, 0, -8>
}

translate tableleg <-5, 0, -3>
instance tableleg
reset tableleg

translate tableleg <-5, 0, 3>
instance tableleg
reset tableleg

translate tableleg <5, 0, -3>
instance tableleg
reset tableleg

translate tableleg <5, 0, 3>
instance tableleg
reset tableleg

endobject /* table */

translate table <-26, 0, -36>
instance table

color vaseblue {
	diff	<.3, .6, 1>
	scoef	10
	srefl	.4
}

slice _vase.slice = {
	<0, 0>,
	<1.25, 0>,
	<1.5, 1.125>,
	<1.65, 2.25>,
	<1.5, 3.375>,
	<1.25, 4.5>,
	<1.45, 4.5>,
	<1.45, 4.7>,
	<.75, 4.7>,
	<1.35, 3>,
	<1.35, 1.5>,
	<.9, .4>,
	<0, .4>
}

spin {
	patt	vaseblue
	segs	14
	smooth
	loc	<-26, 6, -36>
	slice	_vase.slice
}

color mirror {
	diff	<0, 0, 0>
	refl	<.7, .7, .7>
}

paragram {
	patt	woodframe
	loc	<-21, 6.5, -39.99>
	v1	<-10, 0, 0>
	v2	<0, 15, 0>
}

paragram {
	patt	mirror
	loc	<-21.5, 7, -39.98>
	v1	<-9, 0, 0>
	v2	<0, 14, 0>
}

/* *********************************** */


color couch_blue {
	diff	<0, 0, 1>
}

color couch_white {
	diff	<.8, .8, .8>
}

slice couch_end_slice = {
	<-5, 1>,
	<6, 1>,
	<6, 8>,
	<-1.66, 8>,
	<-2, 12>,
	<-6, 12>
	closed
}

slice couch_middle_slice = {
	<-5, 1>,
	<6, 1>,
	<6, 5>,
	<-4, 5>,
	<-5, 12>,
	<-6, 12>
	closed
}

check couch_patt {
	patt1	couch_blue
	patt2	couch_white
	xsize	.5
	zsize	.5
	ysize	10000
}


object couchleg

slice _couchleg.slice = {
	<.25, 0>,
	<.5, 1>
}

spin {
	patt	tablewood
	loc	<0, 0, 0>
	slice	_couchleg.slice
}

endobject /* couchleg */

object couchpillow

box {
	loc	<-2.5, -2.5, -1>
	v1	<2, 0, 0>
	v2	<0, 5, 0>
	v3	<0, 0, 5>
	origin	<0, 25, 0>
	patt	couch_blue
}

endobject /* couchpillow */

lockobj couchpillow

object couch_cushion

box {
	loc	<-.5, -5, -4.33>
	v1	<1, 0, 0>
	v2	<0, 8.66, 0>
	v3	<0, 0, 10>
	patt	couch_blue
}

endobject /* couch_cushion */

lockobj couch_cushion


object couch

extrude {
	slice	couch_end_slice
	patt	couch_blue
	first
	last
	loc	<0, 0, -16>
	yaxis	<0, 1, 0>
	xaxis	<1, 0, 0>
	dir	<0, 0, 1>
	length	3
}

extrude {
	slice	couch_end_slice
	patt	couch_blue
	first
	last
	loc	<0, 0, 16>
	yaxis	<0, 1, 0>
	xaxis	<1, 0, 0>
	dir	<0, 0, -1>
	length	3
}

extrude {
	slice	couch_middle_slice
	patt	couch_blue
	loc	<0, 0, 13>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir	<0, 0, -1>
	length	26
}

xrotate couch_cushion 90
zrotate couch_cushion 90
translate couch_cushion <1, 5.5, -8.66>
instance couch_cushion

translate couch_cushion <0, 0, 8.66>
instance couch_cushion

translate couch_cushion <0, 0, 8.66>
instance couch_cushion

yrotate couchpillow 15
zrotate couchpillow 10
xrotate couchpillow 45
translate couchpillow <-3, 9.82, 10.17>
instance couchpillow

translate couchpillow <0, 0, -5.65>
instance couchpillow

translate couchpillow <0, 0, -5.65>
instance couchpillow

translate couchpillow <0, 0, -5.65>
instance couchpillow

translate couchpillow <0, 0, -5.65>
instance couchpillow

translate couchleg <-4, 0, -15>
instance couchleg
reset couchleg

translate couchleg <-4, 0, 15>
instance couchleg
reset couchleg

translate couchleg <5, 0, -15>
instance couchleg
reset couchleg

translate couchleg <5, 0, 15>
instance couchleg
reset couchleg

endobject /* couch */

translate couch <-34, 0, 0>
instance couch

/* *********************************** */


/* the piece de resistance */

/*
include "crow.obj"

zrotate crow_t_robot 25
yrotate crow_t_robot 90
translate crow_t_robot <-6, 4, 2>
instance crow_t_robot

killobject crow_t_robot
*/