
maxaadepth 1
maxaadiff <.05, .05, .05>

maxobcube 2
maxoctdepth 5

/* camera */

camera {
	loc	<-4, 10, 30>
	target	<6, 5, 0>
	up	<0, 1, 0>
	hfov	45
	res 	640 480
	aspect 	1.0
}

/* sky */

sky {
	zenith	<0, 0, 0.6>
	horizon	<0, 0, 0.3>
}

color blue {
	amb	<1, 1, 1>
	diff	<0, 0, 1>
}

color white {
	amb	<1, 1, 1>
	diff	<1, 1, 1>
}

clouds skysurf {
	sky	blue
	clouds	white
	scale	.005
}

plane {
	loc	<0, 25, 0>
	v1	<1, 0, 0>
	v2	<0, 0, 1>
	patt	skysurf
}


/* patts */

color dk_red {
	diff	<1, 0, 0>
	scoef	75
	srefl	1.0
}

color dk_mirror {
	diff	<0, 0, 0>
	refl	<0.7, 0.7, 0.7>
	scoef	75
	srefl	1
}

color dk_green {
	diff	<0, 0.7, 0>
}

/* left column of 'H' */


box {
	loc	<0, 1, 0>
	v1	<2, 0, 0>
	v2	<0, 0, 2>
	v3	<0, 8, 0>
	patt	dk_red
}

/* right column of 'H' */

box {
	loc	<4, 1, 0>
	v1	<2, 0, 0>
	v2	<0, 0, 2>
	v3	<0, 8, 0>
	patt	dk_red
}

/* horizontal of 'H' */

box {
	loc	<2, 4, 0>
	v1	<2, 0, 0>
	v2	<0, 2, 0>
	v3	<0, 0, 2>
	patt	dk_red
}


/* the column of the 'i' */


box {
	loc	<8, 1, 0>
	v1	<2, 0, 0>
	v2	<0, 0, 2>
	v3	<0, 5, 0>
	patt	dk_red
}

/* dot the 'i' */

sphere {
	loc	<9, 8.5, 1>
	radius	1
	patt	dk_red
}


/* huge reflective ball off to one side */

sphere {
	loc	<17, 8, -6>
	radius	8
	patt	dk_mirror
}

/* and the ground */

color green {
	diff	<0, 1, 0>
}

color yellow {
	diff	<1, 1, 0>
}

check checks {
	patt1	green
	patt2	yellow
	xsize	3
	zsize	3
}

slice ped_slice = {
	<10, 0>,
	<10, 1>,
	<0, 1>
}

spin {
	slice	ped_slice
	patt	checks
	segs	25
	loc	<5, 0, 1>
}

color blue {
	diff	<0, 0, .8>
	scoef	10
	srefl	.3
}

plane {
	loc	<0, 0, 0>
	v1	<1, 0, 0>
	v2	<0, 0, 1>
	patt	blue
}

/* some light */

lamp {
	loc	<-10, 30, 5>
	color	<1, 1, 1>
}

lamp {
	loc	<15, 20, 15>
	color	<0.8, 0.8, 0.8>
}

