
include "ldr.mco"
include "tldend.mco"

sky {
	zenith	<0, 0, 0>
	horizon	<0, 0, 0>
}


color blue {
	diff	<0, 0, .8>
}


real xloc = 0
real extlen = 3
real spacing = .5

real tld_start = xloc

fill {
	slice	Arial_20_L_00
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

fill {
	slice	Arial_20_L_00
	patt	blue
	loc		<xloc, 0, extlen>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

extrude {
	slice	Arial_20_L_00
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length		extlen
}

xloc = xloc + Arial_20_L_w + spacing

fill {
	slice	Arial_20_e_00
	hole	Arial_20_e_01
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

fill {
	slice	Arial_20_e_00
	hole	Arial_20_e_01
	patt	blue
	loc		<xloc, 0, extlen>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

extrude {
	slice	Arial_20_e_00
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length		extlen
}

extrude {
	slice	Arial_20_e_01
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length	extlen
}

xloc = xloc + Arial_20_e_w + spacing

fill {
	slice	Arial_20_a_00
	hole	Arial_20_a_01
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

fill {
	slice	Arial_20_a_00
	hole	Arial_20_a_01
	patt	blue
	loc		<xloc, 0, extlen>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

extrude {
	slice	Arial_20_a_00
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length		extlen
}

extrude {
	slice	Arial_20_a_01
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length		extlen
}

xloc = xloc + Arial_20_a_w + spacing

fill {
	slice	Arial_20_d_00
	hole	Arial_20_d_01
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

fill {
	slice	Arial_20_d_00
	hole	Arial_20_d_01
	patt	blue
	loc		<xloc, 0, extlen>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

extrude {
	slice	Arial_20_d_00
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length		extlen
}

extrude {
	slice	Arial_20_d_01
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length		extlen
}

xloc = xloc + Arial_20_d_w + spacing * 2

fill {
	slice	Arial_20_D_00
	hole	Arial_20_D_01
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

fill {
	slice	Arial_20_D_00
	hole	Arial_20_D_01
	patt	blue
	loc		<xloc, 0, extlen>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

extrude {
	slice	Arial_20_D_00
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length		extlen
}

extrude {
	slice	Arial_20_D_01
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length		extlen
}

xloc = xloc + Arial_20_D_w + spacing 

fill {
	slice	Arial_20_o_00
	hole	Arial_20_o_01
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

fill {
	slice	Arial_20_o_00
	hole	Arial_20_o_01
	patt	blue
	loc		<xloc, 0, extlen>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

extrude {
	slice	Arial_20_o_00
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length		extlen
}

extrude {
	slice	Arial_20_o_01
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length		extlen
}

xloc = xloc + Arial_20_o_w + spacing 

real tld_end = xloc

fill {
	slice	Arial_20_g_00
	hole	Arial_20_g_01
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

fill {
	slice	Arial_20_g_00
	hole	Arial_20_g_01
	patt	blue
	loc		<xloc, 0, extlen>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

extrude {
	slice	Arial_20_g_00
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length		extlen
}

extrude {
	slice	Arial_20_g_01
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length		extlen
}

xloc = xloc + Arial_20_g_w

real end_start = xloc

xloc = xloc + spacing * 2

fill {
	slice	Arial_20_R_00
	hole	Arial_20_R_01
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

fill {
	slice	Arial_20_R_00
	hole	Arial_20_R_01
	patt	blue
	loc		<xloc, 0, extlen>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

extrude {
	slice	Arial_20_R_00
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length		extlen
}

extrude {
	slice	Arial_20_R_01
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length		extlen
}

xloc = xloc + Arial_20_R_w + spacing 

fill {
	slice	Arial_20_a_00
	hole	Arial_20_a_01
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

fill {
	slice	Arial_20_a_00
	hole	Arial_20_a_01
	patt	blue
	loc		<xloc, 0, extlen>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

extrude {
	slice	Arial_20_a_00
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length		extlen
}

extrude {
	slice	Arial_20_a_01
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length		extlen
}

xloc = xloc + Arial_20_a_w + spacing

fill {
	slice	Arial_20_c_00
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

fill {
	slice	Arial_20_c_00
	patt	blue
	loc		<xloc, 0, extlen>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

extrude {
	slice	Arial_20_c_00
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length		extlen
}

xloc = xloc + Arial_20_c_w + spacing

fill {
	slice	Arial_20_i_00
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

fill {
	slice	Arial_20_i_00
	patt	blue
	loc		<xloc, 0, extlen>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

extrude {
	slice	Arial_20_i_00
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length		extlen
}

fill {
	slice	Arial_20_i_01
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

fill {
	slice	Arial_20_i_01
	patt	blue
	loc		<xloc, 0, extlen>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

extrude {
	slice	Arial_20_i_01
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length		extlen
}

xloc = xloc + Arial_20_i_w + spacing

fill {
	slice	Arial_20_n_00
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

fill {
	slice	Arial_20_n_00
	patt	blue
	loc		<xloc, 0, extlen>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

extrude {
	slice	Arial_20_n_00
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length		extlen
}

xloc = xloc + Arial_20_n_w + spacing

real end_end = xloc

fill {
	slice	Arial_20_g_00
	hole	Arial_20_g_01
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

fill {
	slice	Arial_20_g_00
	hole	Arial_20_g_01
	patt	blue
	loc		<xloc, 0, extlen>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

extrude {
	slice	Arial_20_g_00
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length		extlen
}

extrude {
	slice	Arial_20_g_01
	patt	blue
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length		extlen
}

xloc = xloc + Arial_20_g_w

color red {
	diff	<1, 0, 0>
}

real ldr_len = xloc

object tld.obj

real smspace = spacing*.75
real smextlen = extlen/2

xloc = 0

fill {
	slice	Arial_10_T_00
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

fill {
	slice	Arial_10_T_00
	patt	red
	loc		<xloc, 0, smextlen>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

extrude {
	slice	Arial_10_T_00
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length	smextlen
}

xloc = xloc + Arial_10_T_w + smspace

fill {
	slice	Arial_10_h_00
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

fill {
	slice	Arial_10_h_00
	patt	red
	loc		<xloc, 0, smextlen>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

extrude {
	slice	Arial_10_h_00
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length		smextlen
}

xloc = xloc + Arial_10_h_w + smspace

fill {
	slice	Arial_10_e_00
	hole	Arial_10_e_01
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

fill {
	slice	Arial_10_e_00
	hole	Arial_10_e_01
	patt	red
	loc		<xloc, 0, smextlen>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

extrude {
	slice	Arial_10_e_00
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length	smextlen
}

extrude {
	slice	Arial_10_e_01
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length	smextlen
}

xloc = xloc + Arial_10_e_w + smspace * 2

fill {
	slice	Arial_10_L_00
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

fill {
	slice	Arial_10_L_00
	patt	red
	loc		<xloc, 0, smextlen>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

extrude {
	slice	Arial_10_L_00
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length		smextlen
}

xloc = xloc + Arial_10_L_w + smspace

fill {
	slice	Arial_10_e_00
	hole	Arial_10_e_01
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

fill {
	slice	Arial_10_e_00
	hole	Arial_10_e_01
	patt	red
	loc		<xloc, 0, smextlen>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

extrude {
	slice	Arial_10_e_00
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length	smextlen
}

extrude {
	slice	Arial_10_e_01
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length	smextlen
}

xloc = xloc + Arial_10_e_w + smspace

fill {
	slice	Arial_10_a_00
	hole	Arial_10_a_01
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

fill {
	slice	Arial_10_a_00
	hole	Arial_10_a_01
	patt	red
	loc		<xloc, 0, smextlen>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

extrude {
	slice	Arial_10_a_00
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length	smextlen
}

extrude {
	slice	Arial_10_a_01
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length	smextlen
}

xloc = xloc + Arial_10_a_w + smspace

fill {
	slice	Arial_10_d_00
	hole	Arial_10_d_01
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

fill {
	slice	Arial_10_d_00
	hole	Arial_10_d_01
	patt	red
	loc		<xloc, 0, smextlen>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

extrude {
	slice	Arial_10_d_00
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length	smextlen
}

extrude {
	slice	Arial_10_d_01
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length	smextlen
}

xloc = xloc + Arial_10_d_w + smspace * 2

fill {
	slice	Arial_10_D_00
	hole	Arial_10_D_01
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

fill {
	slice	Arial_10_D_00
	hole	Arial_10_D_01
	patt	red
	loc		<xloc, 0, smextlen>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

extrude {
	slice	Arial_10_D_00
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length	smextlen
}

extrude {
	slice	Arial_10_D_01
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length	smextlen
}

xloc = xloc + Arial_10_D_w + smspace

fill {
	slice	Arial_10_o_00
	hole	Arial_10_o_01
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

fill {
	slice	Arial_10_o_00
	hole	Arial_10_o_01
	patt	red
	loc		<xloc, 0, smextlen>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

extrude {
	slice	Arial_10_o_00
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length	 smextlen
}

extrude {
	slice	Arial_10_o_01
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length	smextlen
}

xloc = xloc + Arial_10_o_w + smspace

fill {
	slice	Arial_10_g_00
	hole	Arial_10_g_01
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

fill {
	slice	Arial_10_g_00
	hole	Arial_10_g_01
	patt	red
	loc		<xloc, 0, smextlen>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

extrude {
	slice	Arial_10_g_00
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length	smextlen
}

extrude {
	slice	Arial_10_g_01
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length	smextlen
}

xloc = xloc + Arial_10_g_w

real tld_len = xloc

endobject lockobject tld.obj


object end.obj

xloc = 0

fill {
	slice	Arial_10_E_00
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

fill {
	slice	Arial_10_E_00
	patt	red
	loc		<xloc, 0, smextlen>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

extrude {
	slice	Arial_10_E_00
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length	smextlen
}

xloc = xloc + Arial_10_E_w + smspace

fill {
	slice	Arial_10_a_00
	hole	Arial_10_a_01
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

fill {
	slice	Arial_10_a_00
	hole	Arial_10_a_01
	patt	red
	loc		<xloc, 0, smextlen>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

extrude {
	slice	Arial_10_a_00
	patt	red      
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length		smextlen
}

extrude {
	slice	Arial_10_a_01
	patt	red      
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length		smextlen
}

xloc = xloc + Arial_10_a_w + smspace

fill {
	slice	Arial_10_t_00
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

fill {
	slice	Arial_10_t_00
	patt	red
	loc		<xloc, 0, smextlen>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

extrude {
	slice	Arial_10_t_00
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length	smextlen
}

xloc = xloc + Arial_10_t_w + smspace

fill {
	slice	Arial_10_s_00
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

fill {
	slice	Arial_10_s_00
	patt	red
	loc		<xloc, 0, smextlen>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

extrude {
	slice	Arial_10_s_00
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length		smextlen
}

xloc = xloc + Arial_10_s_w + smspace * 2

fill {
	slice	Arial_10_N_00
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

fill {
	slice	Arial_10_N_00
	patt	red
	loc		<xloc, 0, smextlen>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

extrude {
	slice	Arial_10_N_00
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length	smextlen
}

xloc = xloc + Arial_10_N_w + smspace

fill {
	slice	Arial_10_o_00
	hole	Arial_10_o_01
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

fill {
	slice	Arial_10_o_00
	hole	Arial_10_o_01
	patt	red
	loc		<xloc, 0, smextlen>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

extrude {
	slice	Arial_10_o_00
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length	smextlen
}

extrude {
	slice	Arial_10_o_01
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length	smextlen
}

xloc = xloc + Arial_10_o_w + smspace * 2

fill {
	slice	Arial_10_D_00
	hole	Arial_10_D_01
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

fill {
	slice	Arial_10_D_00
	hole	Arial_10_D_01
	patt	red
	loc		<xloc, 0, smextlen>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

extrude {
	slice	Arial_10_D_00
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length	smextlen
}

extrude {
	slice	Arial_10_D_01
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length	smextlen
}

xloc = xloc + Arial_10_D_w + smspace

fill {
	slice	Arial_10_u_00
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

fill {
	slice	Arial_10_u_00
	patt	red
	loc		<xloc, 0, smextlen>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

extrude {
	slice	Arial_10_u_00
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length	smextlen
}

xloc = xloc + Arial_10_u_w + smspace

fill {
	slice	Arial_10_s_00
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

fill {
	slice	Arial_10_s_00
	patt	red
	loc		<xloc, 0, smextlen>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

extrude {
	slice	Arial_10_s_00
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length	 smextlen
}

xloc = xloc + Arial_10_s_w + smspace

fill {
	slice	Arial_10_t_00
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

fill {
	slice	Arial_10_t_00
	patt	red
	loc		<xloc, 0, smextlen>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
}

extrude {
	slice	Arial_10_t_00
	patt	red
	loc		<xloc, 0, 0>
	xaxis	<1, 0, 0>
	yaxis	<0, 1, 0>
	dir		<0, 0, 1>
	length	smextlen
}

xloc = xloc + Arial_10_t_w

real end_len = xloc

endobject lockobject end.obj

real descend = Arial_20_n_ymin - Arial_20_g_ymin

scale tld.obj <(tld_end-tld_start-spacing)/tld_len, descend*.85/Arial_10_T_h, 1>
translate tld.obj <tld_start, -descend, smextlen*.5>
instance tld.obj

scale end.obj <(end_end-end_start-spacing)/end_len, descend*.85/Arial_10_T_h, 1>
translate end.obj <end_start, -descend, smextlen*.5>
instance end.obj

real stripe_space = (Arial_20_L_h/5)/4

real stripe_h = (Arial_20_L_h-stripe_space*4)/3.051
real stripe_y = Arial_20_L_h

box {
	patt	red
	loc		<0, stripe_y, -extlen*.5>
	v1		<ldr_len, 0, 0>
	v2		<0, -stripe_h, 0>
	v3		<0, 0, extlen>
}

stripe_y = stripe_y - stripe_h - stripe_space
stripe_h = stripe_h * .75

box {
	patt	red
	loc		<0, stripe_y, -extlen*.5>
	v1		<ldr_len, 0, 0>
	v2		<0, -stripe_h, 0>
	v3		<0, 0, extlen>
}

stripe_y = stripe_y - stripe_h - stripe_space
stripe_h = stripe_h * .75

box {
	patt	red
	loc		<0, stripe_y, -extlen*.5>
	v1		<ldr_len, 0, 0>
	v2		<0, -stripe_h, 0>
	v3		<0, 0, extlen>
}

stripe_y = stripe_y - stripe_h - stripe_space
stripe_h = stripe_h * .75

box {
	patt	red
	loc		<0, stripe_y, -extlen*.5>
	v1		<ldr_len, 0, 0>
	v2		<0, -stripe_h, 0>
	v3		<0, 0, extlen>
}

stripe_y = stripe_y - stripe_h - stripe_space
stripe_h = stripe_h * .75

box {
	patt	red
	loc		<0, stripe_y, -extlen*.5>
	v1		<ldr_len, 0, 0>
	v2		<0, -stripe_h, 0>
	v3		<0, 0, extlen>
}


color white {
	diff	<1, 1, 1>
}

color black {
	diff	<0, 0, 0>
}

check checks {
	patt1	white
	patt2	black
	xsize	ldr_len/20
	ysize	ldr_len/20
	zsize	ldr_len/20
}

plane {
	loc		<0, 0, -extlen*3>
	v1		<1, 0, 0>
	v2		<0, 1, 0>
	patt	checks
}

camera {
	loc		<ldr_len*.2, Arial_20_L_h*.85, ldr_len>
	target	<ldr_len*.45, Arial_20_L_h*.5, 0>
	hfov	1.05*2*asin(1/2)
}


lamp {
	loc		<ldr_len*.8, Arial_20_L_h*7, ldr_len*.5>
	pointat	<ldr_len*.66, Arial_20_L_h*.5, 0>
	pow		.5
	spread	45
	radius	5
	nrays	3
}

lamp {
	loc		<ldr_len*.5, Arial_20_L_h*9, ldr_len*.5>
	pointat	<ldr_len*.33, Arial_20_L_h*.5, 0>
	pow		.5
	spread	45
	radius	5
	nrays	3
}
