/*
	This file demonstrates the use of "turb" and "power" on the "marble"
	pattern. "turb" increases across the X axis of the image, and "power"
	increases across the Y axis of the image.

	 -------------> increasing turbulence ----------->
	|
	|	O	O	O	O	O
	|
	\/	O	O	O	O	O
    increasing
      power	O	O	O	O	O	<-- 25 spheres
	|
	|	O	O	O	O	O
	|
	\/	O	O	O	O	O
*/

maxobcube 3
maxoctdepth 5

color black {
	diff	<0, 0, 0>
	amb	<1, 1, 1>
}

color white {
	diff	<1, 1, 1>
	amb	<1, 1, 1>
}

real turb0 = 0
real turb1 = 1
real turb2 = 1.5
real turb3 = 2
real turb4 = 2.5

real power0 = .25
real power1 = .5
real power2 = 1
real power3 = 2
real power4 = 4

real sphere_radius = 2
real sphere_spacing = sphere_radius*2.5

camera {
	loc	<sphere_spacing*20, 0, 0>
	target	<0, 0, 0>
	hfov	2*atan((sphere_spacing*5+sphere_radius*2)/2/(sphere_spacing*20))
}

marble pattern00 {
	pattern	white
	grain	black
	turb	turb0
	power	power0
	scale	2
}

marble pattern01 {
	pattern	white
	grain	black
	turb	turb0
	power	power1
	scale	2
}

marble pattern02 {
	pattern	white
	grain	black
	turb	turb0
	power	power2
	scale	2
}
	
marble pattern03 {
	pattern	white
	grain	black
	turb	turb0
	power	power3
	scale	2
}
	
marble pattern04 {
	pattern	white
	grain	black
	turb	turb0
	power	power4
	scale	2
}

marble pattern10 {
	pattern	white
	grain	black
	turb	turb1
	power	power0
	scale	2
}

marble pattern11 {
	pattern	white
	grain	black
	turb	turb1
	power	power1
	scale	2
}
	
marble pattern12 {
	pattern	white
	grain	black
	turb	turb1
	power	power2
	scale	2
}
	
marble pattern13 {
	pattern	white
	grain	black
	turb	turb1
	power	power3
	scale	2
}

marble pattern14 {
	pattern	white
	grain	black
	turb	turb1
	power	power4
	scale	2
}

marble pattern20 {
	pattern	white
	grain	black
	turb	turb2
	power	power0
	scale	2
}
	
marble pattern21 {
	pattern	white
	grain	black
	turb	turb2
	power	power1
	scale	2
}
	
marble pattern22 {
	pattern	white
	grain	black
	turb	turb2
	power	power2
	scale	2
}

marble pattern23 {
	pattern	white
	grain	black
	turb	turb2
	power	power3
	scale	2
}
	
marble pattern24 {
	pattern	white
	grain	black
	turb	turb2
	power	power4
	scale	2
}

marble pattern30 {
	pattern	white
	grain	black
	turb	turb3
	power	power0
	scale	2
}
	
marble pattern31 {
	pattern	white
	grain	black
	turb	turb3
	power	power1
	scale	2
}

marble pattern32 {
	pattern	white
	grain	black
	turb	turb3
	power	power2
	scale	2
}
	
marble pattern33 {
	pattern	white
	grain	black
	turb	turb3
	power	power3
	scale	2
}
	
marble pattern34 {
	pattern	white
	grain	black
	turb	turb3
	power	power4
	scale	2
}

marble pattern40 {
	pattern	white
	grain	black
	turb	turb4
	power	power0
	scale	2
}
	
marble pattern41 {
	pattern	white
	grain	black
	turb	turb4
	power	power1
	scale	2
}
	
marble pattern42 {
	pattern	white
	grain	black
	turb	turb4
	power	power2
	scale	2
}
	
marble pattern43 {
	pattern	white
	grain	black
	turb	turb4
	power	power3
	scale	2
}

marble pattern44 {
	pattern	white
	grain	black
	turb	turb4
	power	power4
	scale	2
}


sphere {
	loc	<0, -(0-2)*sphere_spacing, -(0-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern00
}

sphere {
	loc	<0, -(0-2)*sphere_spacing, -(1-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern10
}

sphere {
	loc	<0, -(0-2)*sphere_spacing, -(2-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern20
}

sphere {
	loc	<0, -(0-2)*sphere_spacing, -(3-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern30
}

sphere {
	loc	<0, -(0-2)*sphere_spacing, -(4-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern40
}

sphere {
	loc	<0, -(1-2)*sphere_spacing, -(0-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern01
}

sphere {
	loc	<0, -(1-2)*sphere_spacing, -(1-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern11
}

sphere {
	loc	<0, -(1-2)*sphere_spacing, -(2-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern21
}

sphere {
	loc	<0, -(1-2)*sphere_spacing, -(3-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern31
}

sphere {
	loc	<0, -(1-2)*sphere_spacing, -(4-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern41
}

sphere {
	loc	<0, -(2-2)*sphere_spacing, -(0-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern02
}

sphere {
	loc	<0, -(2-2)*sphere_spacing, -(1-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern12
}

sphere {
	loc	<0, -(2-2)*sphere_spacing, -(2-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern22
}

sphere {
	loc	<0, -(2-2)*sphere_spacing, -(3-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern32
}

sphere {
	loc	<0, -(2-2)*sphere_spacing, -(4-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern42
}

sphere {
	loc	<0, -(3-2)*sphere_spacing, -(0-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern03
}

sphere {
	loc	<0, -(3-2)*sphere_spacing, -(1-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern13
}

sphere {
	loc	<0, -(3-2)*sphere_spacing, -(2-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern23
}

sphere {
	loc	<0, -(3-2)*sphere_spacing, -(3-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern33
}

sphere {
	loc	<0, -(3-2)*sphere_spacing, -(4-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern43
}

sphere {
	loc	<0, -(4-2)*sphere_spacing, -(0-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern04
}

sphere {
	loc	<0, -(4-2)*sphere_spacing, -(1-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern14
}

sphere {
	loc	<0, -(4-2)*sphere_spacing, -(2-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern24
}

sphere {
	loc	<0, -(4-2)*sphere_spacing, -(3-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern34
}

sphere {
	loc	<0, -(4-2)*sphere_spacing, -(4-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern44
}


