maxaadepth 1
maxoctdepth 5
maxobcube 2

camera {
	loc	<15, 8, 25>
	target	<-1, 5, 0>
}

lamp {
	loc	<40, 499, 90>
	color	<.9, .9, .9>
}

lamp {
	loc	<1, 9.9, 2>
	pointat	<0, 6.5, 0>
	spread	40
	dist	10
}

lamp {
	loc	<-1, 9.9, 2>
	pointat	<0, 6.5, 0>
	dist	10
	spread	40
}

lamp {
	loc	<0, 9.9, 0>
	color	<.5, .5, .5>
	dist	30
}


color off_white_shiny {
	diff 	<1, .95, .8>
	scoef	100
	srefl	1
}

color grass_green { 
	diff	<0, .6, 0>
	srefl	0
}

color med_grey {
	diff	<.5, .5, .5>
	srefl	.2
	scoef	1
}

color gold_plate {
	diff	<.85, .8, 0>
	scoef	200
	srefl	1
}

color lt_blue_glow {
	diff	<.3, .3, 1>
	amb	<1, 1, 1>
}

color white_glow {
	diff	<1, 1, 1>
	amb	<1, 1, 1>
}

clouds cloudy {
	sky	lt_blue_glow
	clouds	white_glow
	scale	.0002
	turb	3
}

plane {
	loc	<0, 500, 0>
	v1	<1, 0, 0>
	v2	<0, 0, 1>
	pattern	cloudy
}

plane {
	loc	<0, 0, 0>
	v1	<1, 0, 0>
	v2	<0, 0, 1>
	pattern	grass_green
}

paragram {
	loc	<-15, 0.001, -15>
	v1	<30, 0, 0>
	v2	<0, 0, 30>
	pattern	med_grey
}


/* ******************************
*
*	the temple-o-crow
*
****************************** */

object column	/* a simple column */

slice column.slice = {
	<1, 0>,
	<1, 6>
}

spin {
	pattern	off_white_shiny
	segs	20
	loc	<0, 0, 0>
	slice	column.slice
}

endobject	/* column */


object small_column	/* columns for top decoration */

slice small.slice = {
	<.15, 0>,
	<.15, 1>
}

spin {
	pattern	off_white_shiny
	segs	10
	loc	<0, 0, 0>
	slice	small.slice
}

endobject	/* small_column */

object top_decor	/* the top decoration */

box {
	pattern	off_white_shiny
	loc	<-5, 0, -.16>
	v1	<10, 0, 0>
	v2	<0, .5, 0>
	v3	<0, 0, .32>
}

translate small_column <-4, .5, 0>
instance small_column 
translate small_column <1, 0, 0>
instance small_column 
translate small_column <1, 0, 0>
instance small_column 
translate small_column <1, 0, 0>
instance small_column 
translate small_column <1, 0, 0>
instance small_column 
translate small_column <1, 0, 0>
instance small_column 
translate small_column <1, 0, 0>
instance small_column 
translate small_column <1, 0, 0>
instance small_column 
translate small_column <1, 0, 0>
instance small_column 

endobject /* top_decor */


object temple

/* steps */

box {
	pattern	off_white_shiny
	origin	<51, 13, 22>
	loc	<-8, 0, -8>
	v1	<16, 0, 0>
	v2	<0, .5, 0>
	v3	<0, 0, 16>
}

box {
	pattern	off_white_shiny
	origin	<27, 256, 67>
	loc	<-7.5, .5, -7.5>
	v1	<15, 0, 0>
	v2	<0, .5, 0>
	v3	<0, 0, 15>
}

box {
	pattern	off_white_shiny
	origin	<76, 27, 19>
	loc	<-7, 1, -7>
	v1	<14, 0, 0>
	v2	<0, .5, 0>
	v3	<0, 0, 14>
}

box {
	pattern	off_white_shiny
	origin	<57, 104, 431>
	loc	<-6.5, 1.5, -6.5>
	v1	<13, 0, 0>
	v2	<0, .5, 0>
	v3	<0, 0, 13>
}

box {
	pattern	off_white_shiny
	origin	<0, 42, 13>
	loc	<-6, 2, -6>
	v1	<12, 0, 0>
	v2	<0, .5, 0>
	v3	<0, 0, 12>
}

/* cornerstones */

box {
	pattern	off_white_shiny
	origin	<34, 73, 21>
	loc	<-8, 0, -8>
	v1	<3, 0, 0>
	v2	<0, 2.5, 0>
	v3	<0, 0, 3>
}

box {
	pattern	off_white_shiny
	origin	<32, 65, 8>
	loc	<5, 0, -8>
	v1	<3, 0, 0>
	v2	<0, 2.5, 0>
	v3	<0, 0, 3>
}

box {
	pattern	off_white_shiny
	origin	<1, 5, 76>
	loc	<-8, 0, 5>
	v1	<3, 0, 0>
	v2	<0, 2.5, 0>
	v3	<0, 0, 3>
}

box {
	pattern	off_white_shiny
	origin	<90, 2, 43>
	loc	<5, 0, 5>
	v1	<3, 0, 0>
	v2	<0, 2.5, 0>
	v3	<0, 0, 3>
}

/* columns */

translate column <-6.5, 2.5, -6.5>
instance column 
reset column

yrotate column 90
translate column <6.5, 2.5, -6.5>
instance column 
reset column

yrotate column 180
translate column <-6.5, 2.5, 6.5>
instance column 
reset column

yrotate column 270
translate column <6.5, 2.5, 6.5>
instance column 
reset column

/* column cap stones */

box {
	pattern	off_white_shiny
	origin	<2352, 435, 452>
	loc	<-8, 8.5, -8>
	v1	<3, 0, 0>
	v2	<0, 1.5, 0>
	v3	<0, 0, 3>
}

box {
	pattern	off_white_shiny
	origin	<456, 5832, 1344>
	loc	<5, 8.5, -8>
	v1	<3, 0, 0>
	v2	<0, 1.5, 0>
	v3	<0, 0, 3>
}

box {
	pattern	off_white_shiny
	origin	<325, 784, 1324>
	loc	<-8, 8.5, 5>
	v1	<3, 0, 0>
	v2	<0, 1.5, 0>
	v3	<0, 0, 3>
}

box {
	pattern	off_white_shiny
	origin	<4356, 152, 5673>
	loc	<5, 8.5, 5>
	v1	<3, 0, 0>
	v2	<0, 1.5, 0>
	v3	<0, 0, 3>
}


/* top decorations */

translate top_decor <0, 8.5, 6.5>
instance top_decor 
translate top_decor <0, 0, -13>
instance top_decor 
reset top_decor

yrotate top_decor 90

translate top_decor <6.5, 8.5, 0>
instance top_decor 
translate top_decor <-13, 0, 0>
instance top_decor 

slice roof_bottom = {
	<-8, -8>,
	<8, -8>,
	<8, 8>,
	<-8, 8>
	closed
}

slice roof_top = {
	<-7, -7>,
	<7, -7>,
	<7, 7>,
	<-7, 7>
	closed
}

skin {
	patt	off_white_shiny
	origin	<5436, 3215, 7845>
	slice	roof_bottom	<0, 10, 0>	<1, 0, 0>	<0, 0, 1>
	slice	roof_top	<0, 12, 0>	<1, 0, 0>	<0, 0, 1>
	fillfirst
	filllast
}


/* pedistal for crow */

slice pedistal.slice = {
	<.75, 0>,
	<.75, 2.1>
}

spin {
	pattern	off_white_shiny
	loc	<0, 2.5, 0>
	segs	20
	slice	pedistal.slice
}

box {
	pattern	off_white_shiny
	loc	<-1.25, 4.6, -1.25>
	v1	<2.5, 0, 0>
	v2	<0, .4, 0>
	v3	<0, 0, 2.5>
}

/* pool of water */

box {
	pattern	off_white_shiny
	loc	<-4, 2.5, -4>
	v1	<8, 0, 0>
	v2	<0, 1, 0>
	v3	<0, 0, .5>
}

box {
	pattern	off_white_shiny
	loc	<-4, 2.5, 3.5>
	v1	<8, 0, 0>
	v2	<0, 1, 0>
	v3	<0, 0, .5>
}

box {
	pattern	off_white_shiny
	loc	<-4, 2.5, -4>
	v1	<.5, 0, 0>
	v2	<0, 1, 0>
	v3	<0, 0, 8>
}

box {
	pattern	off_white_shiny
	loc	<3.5, 2.5, -4>
	v1	<.5, 0, 0>
	v2	<0, 1, 0>
	v3	<0, 0, 8>
}

color water {
	diff	<.6, .6, 1>
	refl	<.7, .7, .7>
	scoef	200
	srefl	1
}

waves water {
	scale	4
	size	.1
}

paragram {
	loc	<-3.5, 3, -3.5>
	v1	<7, 0, 0>
	v2	<0, 0, 7>
	pattern	water
	texture	water
}

endobject

instance temple 

;include "scripts\crow.obj"

;scale crow_t_robot <.33, .33, .33>
;translate crow_t_robot <0, 5, 0>
;instance crow_t_robot 

/* fence around temple */

object spike1

slice spike.slice = {
	<.25, 0>,
	<.25, 4>,
	<0, 4.5>
}

spin {
	pattern	gold_plate
	loc	<0, 0, 0>
	segs	4
	slice	spike.slice
}

endobject /* spike 1 */

object spike5

instance spike1 
translate spike1 <2, 0, 0>
instance spike1 
translate spike1 <2, 0, 0>
instance spike1 
translate spike1 <2, 0, 0>
instance spike1 
translate spike1 <2, 0, 0>
instance spike1 
reset spike1

endobject 	/* spike5 */

object spike31

instance spike5 
translate spike5 <10, 0, 0>
instance spike5 
translate spike5 <10, 0, 0>
instance spike5 
translate spike5 <10, 0, 0>
instance spike5 
translate spike5 <10, 0, 0>
instance spike5 
translate spike5 <10, 0, 0>
instance spike5 
reset spike5
translate spike1 <60, 0, 0>
instance spike1 
reset spike1

endobject	/* spike31 */

object onewall

box {
	pattern	off_white_shiny
	loc	<-31, 0, -1>
	v1	<61, 0, 0>
	v2	<0, 5, 0>
	v3	<0, 0, 2>
}

translate spike31 <-31, 5, 0>
instance spike31 

box {
	pattern	gold_plate
	loc	<-31, 7.5, -.25>
	v1	<62, 0, 0>
	v2	<0, .5, 0>
	v3	<0, 0, .5>
}

endobject	/* onewall */

translate onewall <0, 0, -31>
instance onewall 
translate onewall <0, 0, 62>
instance onewall 
reset onewall

yrotate onewall 90
translate onewall <-31, 0, 0>
instance onewall 
translate onewall <62, 0, 0>
instance onewall 


