; This file Copyright 1994 Dan Wesnor
;
; This file may be freely distributed as long as no 
; information is changed, no charge is made for
; the file, and the archive in which the file was
; contained is distributed in tact.  Any violation 
; of these conditions requires written authorization 
; by the copyright holder.

/*
	This is a script for the Magic Camera rendering system.
	Magic Camera (MC) uses ray-tracing for realisting rendering
	of shadows, reflections, and transparency.  It is in the
	final phase of completion and should be released shortly.
	Plans are for release as shareware with a nominal charge
	for a full working version.

	See comments for a description of features.
	Comments are either C-style (like this one), or a semi-colon
	followed by text	; like this.
*/

/*
	Primitive object include triangles and parallelograms,
	both of which may be phong smoothed, spheres, rings (or disks),
	and planes.

	Compound objects, which allow complex shapes to be built,
	include extrusions, spins, skin-over-frame, filled complex
	2-d polygons (with holes), heightfields, boxes, and
	polygon spheres.

	Available patterns are check, wood, marble, brick,
	several types of bitmap wraps, blotch, and clouds.

	Textures include waves and several type of bumpmaps.

	Lamps include point-source, directional, directional
	spotlights (w/ beam width and beam falloff sharpness
	controls), or spherical extended.

	Variables, which may be used in complex expressions, include
	real numbers, integers, 3d-vectors, and arrays of reals, 2-d vectors,
	and 3-d vectors.  Variables and arrays may be used to facilitate
	animation.
*/

/*
	This file shows how complex patterns can be built from simpler ones.

	The pattern tree looks like:

	main_patt (blotch)
		|
		+---------- marb_check (check)
		|		|
		|		+--------- red_marb (marble)
		|		|		|
		|		|		+-------------- red (color)
		|		|		|
		|		|		+-------------- black (color)
		|		|
		|		+--------- blue_marb (marble)
		|		|		|
		|		|		+-------------- blue (color)
		|		|		|
		|		|		+-------------- black (color)
		|		|
		|
		+---------- red_brick (brick)
		|		|
		|		+--------- red (color)
		|		|
		|		+--------- white (color)
		|
		+---------- green_clouds (clouds)
		|		|
		|		+--------- black (color)
		|		|
		|		+--------- green (color)
		|
		+---------- blue_yellow (check)
		|		|
		|		+--------- blue (color)
		|		|
		|		+--------- yellow (color)
		|
		+---------- wooden (wood)
		|		|
		|		+--------- brown (color)
		|		|
		|		+--------- black (color)
		|
		+---------- tiny_blotch (blotch)
		|		|
		|		+--------- red_pastelle (color)
		|		|
		|		+--------- green_pastelle (color)
		|		|
		|		+--------- blue_pastelle (color)
		|		|
		|		+--------- yellow_pastelle (color)
		|		|
		|		+--------- magenta_pastelle (color)
		|		|
		|		+--------- cyan_pastelle (color)
		|
		+---------- wrap (wrapcylinder)
		|		|
		|		+--------- white (color)
		|
		+---------- white_marble (marble)
				|
				+--------- white (color)
				|
				+--------- black (color)

*/

camera {	; the camera definition
	loc	<10, 1.5, 5>
	target	<0, 0, 0>
	hfov	16		; zoom in on the box
}

lamp {
	loc	<6, 11, 2>	; simple point source lamp
}

/*
	these are very basic, simple color definitions
*/

color black { diff <0, 0, 0> }
color white { diff <1, 1, 1> }
color red { diff <1, 0, 0> }
color green { diff <0, 1, 0> }
color blue { diff <0, 0, 1> }
color yellow { diff <1, 1, 0> }
color magenta { diff <1, 0, 1> }
color cyan { diff <0, 1, 1> }
color brown { diff <.5, .3, 0> }

color red_pastelle { diff <1, .5, .5> }
color green_pastelle { diff <.5, 1, .5> }
color blue_pastelle { diff <.5, .5, 1> }
color yellow_pastelle { diff <1, 1, .5> }
color magenta_pastelle { diff <1, .5, 1> }
color cyan_pastelle { diff <.5, 1, 1> }

/* 
	an easy blotch pattern using the pastelles above.
	a blotch pattern is a semi-interesting conglomeration
	of other patterns.
*/

blotch tiny_blotch {
	patt	red_pastelle
	patt	green_pastelle
	patt	blue_pastelle
	patt	yellow_pastelle
	patt	magenta_pastelle
	patt	cyan_pastelle
	scale	15
}

/*
	wood.  fairly simple, brown with black "rings".
	change the scale to 80 and see how it affects the final image.
	the rings should appear smaller and closer together.
*/

wood wooden {
	patt	brown
	grain	black
	scale	40
}

/* 
   a cylinder wrap.  note the distortion between the edges and center of the cube...
   the image is wider at the edges than in the center.  this is because wrapcy
   uses a cylinder as an intermediate surface for the transformation.  since a 
   cylinder cannot be wrapped around a cube perfectly, it must be "stretched"
   in some areas in order to fit

   for fun, change this to a spherical wrap (wrapsy).  note how the image now becomes
   distorted near the top and bottom of the cube also.  you'll have to change
   "height" into "yrep".  try a value of 8 for "yrep".
*/

bmp "mapfiles\n10.bmp" n7.map	; load in a raw24 file as a bitmap

wrapcy wrap {
	bitmap	n7.map		; use the bitmap loaded above
	xrep	16		; the pattern repeats 16 time horizontally around the
				; cylinder
	height	.5		; and repeats every 0.5 units (starting at 0.0) in
				; the vertical direction
	patt	white		; this pattern is the one actually used.  it is altered
				; by the bitmap image
	dodiff			; "dodiff" specifies that the diffuse part of the 
				; "white" pattern (from above) is to be altered
				; "dotrans" and/or "dorefl" could also have been used
}

/*
	marble.  again, fairly simple.  note than any colors could have been used,
	not just black and white.  go ahead, change them, and see what happens
*/

marble white_marble {
	patt	white
	grain	black
	scale	3
}

/*
	checkerboard pattern.  note that if "blue" and "yellow" are swapped, 
	their positions in the checkerboard will also swap.
*/

check blue_yellow {
	patt1	blue
	patt2	yellow
	xsize	.5
	ysize	.5
	zsize	.5
}

/*
	bricks.  again, any colors can be used
*/

brick red_brick {
	brick	red
	mortar	white
	xsize	.25
	ysize	.25
	zsize	.5
	msize	.05
	yoffset	.25
	zoffset	.25
}	

/*
	clouds... but green on black.  versatile, huh!  change the power to 
	see how it changes the pattern.
*/

clouds green_clouds {
	sky	black
	clouds	green
	scale	3
	power	.5
}

/*
	these two marbles are used in the next checker board.  the pattern tree 
	can be a deep as your memory will allow.  try putting "green_clouds"
	(or any other pattern from above) in place of "red", "black", or "blue"
	below.  then change "green" or black" in "green_clouds" to "wood" (or any
	other surface from above).  neat, huh!

	also, try changing the scale on only one of the two marbles.  the grains
	will no longer match up, making it appears as though the red and blue
	checks are from different blocks of marble.
*/

marble red_marb {
	patt	red
	grain	black
	scale	8
}

marble blue_marb {
	patt	blue
	grain	black
	scale	8
}

/*
	ties "red_marb" and "blue_marb" together.
*/

check marb_check {
	patt1	red_marb
	patt2	blue_marb
	xsize	.2
	ysize	.2
	zsize	.2
}

/* 
	ties all of the patterns together.  try moving lines around
	(put red_brick first, for example).  the patterns will move into
	different places accordingly (the first pattern always appears in 
	the same place in the blotch).
*/


blotch main_patt {
	patt	marb_check
	patt	red_brick
	patt	green_clouds
	patt	blue_yellow
	patt	wooden
	patt	tiny_blotch
	patt	wrap
	patt	white_marble
	scale	3
}

/*
	the box command builds a box out of six parallelograms.
	v1, v2, and v3, define the location of 3 vertices relative
	to loc.  the other 4 vertices are loc+v1+v2, loc+v1+v3,
	loc+v2+v3, and loc+v1+v2+v3.  if v1, v2, and v3 are not
	orthoganol, then the box will be slanted or skewed.
*/

box {
	patt	main_patt
	loc	<-1, -1, -1>
	v1	<2, 0, 0>
	v2	<0, 2, 0>
	v3	<0, 0, 2>
	origin	<.01, .01, .01>	; origin redefines the origin of
				; pattern space as it is applied to the
				; object, so that by changing the origin,
				; patterns can be forced to "move around"
				; on the object.  this allows objects
				; using the same pattern to look 
				; different by placing them in different
				; areas of pattern space
}


