; This file Copyright 1994 Dan Wesnor
;
; This file may be freely distributed as long as no 
; information is changed, no charge is made for
; the file, and the archive in which the file was
; contained is distributed in tact.  Any violation 
; of these conditions requires written authorization 
; by the copyright holder.

/*
	This is a script for the Magic Camera rendering system.
	Magic Camera (MC) uses ray-tracing for realisting rendering
	of shadows, reflections, and transparency.  It is in the
	final phase of completion and should be released shortly.
	Plans are for release as shareware with a nominal charge
	for a full working version.

	See comments for a description of features.
	Comments are either C-style (like this one), or a semi-colon
	followed by text	; like this.
*/

/*
	Primitive object include triangles and parallelograms,
	both of which may be phong smoothed, spheres, rings (or disks),
	and planes.

	Compound objects, which allow complex shapes to be built,
	include extrusions, spins, skin-over-frame, filled complex
	2-d polygons (with holes), heightfields, boxes, and
	polygon spheres.

	Available patterns are check, wood, marble, brick, 
	several types of bitmap wraps, blotch, and clouds.

	Textures include waves and several type of bumpmaps.

	Lamps include point-source, directional, directional
	spotlights (w/ beam width and beam falloff sharpness
	controls), or spherical extended.

	Variables, which may be used in complex expressions, include
	real numbers, integers, 3d-vectors, and arrays of reals, 2-d vectors, 
	and 3-d vectors.  Variables and arrays may be used to facilitate
	animation.
*/


; If you have enough memory, use the first psp_vsegs 
; If not, use the second
int psp_vsegs = 12		; Variables!  Allows easy location of key
;int psp_vsegs = 8		; values at the top of the script, can
int psp_hsegs = psp_vsegs * 2	; be used in expressions to save
				; you the trouble of hand-computing things.
				; Can also be used for simple animation.

camera {
	loc	<-30, 14, -10>	; location of the camera
	target	<0, 2.5, 0>	; location to point at
				; field-of-view, image resolution,
				; and pixel aspect ratio may also
				; be defined
}

sky {
	zenith	<0, 0, .5>	; color of the sky straight up
	horizon	<0, 0, .5>	; color of the sky at the horizon
}

lamp {
	loc	<-60, 180, -40>	; location of the lamp
	color	<.8, .8, .8>	; color of the lamp
				; lamps may also be 'spotlight' type
				; lamps or may cast 'fuzzy' shadows.
}

lamp {
	loc	<-30, 200, 90>	; another lamp
	color	<.8, .8, .8>
}

color black {		; create a 'color' type pattern and name it 'black'
	diff	<0, 0, 0>	; diffuse color (apparent color) in RGB
	scoef	100		; specular coefficient (hot spot size)
	srefl	1		; specular reflection (hot spot brightness)
}

color white {		; another 'color' called 'white'	
	diff	<1, 1, 1>
	scoef	100
	srefl	1
}

color red_mirror {	; another 'color' called 'red_mirror'
	diff	<.7, 0, 0>
	refl	<.5, .5, .5>	; this one is partially reflective
	scoef	100
	srefl	1
}

color blue_mirror {
	diff	<0, 0, .7>
	refl	<.5, .5, .5>
	scoef	100
	srefl	1
}

color yellow_mirror {
	diff	<.7, .7, 0>
	refl	<.5, .5, .5>
	scoef	100
	srefl	1
}

color silver_mirror {
	diff	<.5, .5, .5>
	refl	<.7, .7, .7>
	scoef	100
	srefl	1
}


bmp "mapfiles\ctapcny.bmp" mc.map		; load a bitmap for patterns

wrapsp redmc {		; a wrapped pattern called 'redmc'
	bitmap	mc.map		; use the bitmap loaded above
	patt	red_mirror	; use characteristics of red mirror
	sub	1 red_mirror	; substitute the pattern 'red_mirror'
				; for pen 0 in the iff bitmap
	sub	0 white		; same for pen 1
;	sub	2 black		; pen 2
;	sub	3 black		; pen 3
	dodiff			; any additional colors found in the
				; bitmap will be applied to the
				; 'diff' propery of 'red_mirror'
	xrep	1		; the pattern repeats itself once
				; around the object's equator
	yrep	1		; and one between the poles
	filter	1		; turn bitmap pre-filtering off
}
	
wrapsp yellowmc {	; same as above w/ some colors changed
	filter	1
	bitmap	mc.map
	patt	yellow_mirror
	sub	1 yellow_mirror
	sub	0 white
;	sub	2 black
;	sub	3 black
	xrep	1
	yrep	1
	dodiff
}
	
wrapsp bluemc {		; same as above w/ some colors changed
	filter	1
	bitmap	mc.map
	patt	blue_mirror
	sub	1 blue_mirror
	sub	0 white
;	sub	2 black
;	sub	3 black
	xrep	1
	yrep	1
	dodiff
}
	
wrapsp silvermc {	; same as above w/ some colors changed
	filter	1
	bitmap	mc.map
	patt	silver_mirror
	sub	1 silver_mirror
	sub	0 white
;	sub	2 black
;	sub	3 black
	xrep	1
	yrep	1
	dodiff
}

color black_refl {		; another 'color' called 'black_refl'
	diff	<0, 0, 0>
	refl	<.5, .5, .5>
	scoef	100
}

color white_refl {		; another 'color' called 'white_refl'
	diff	<.9, .9, .9>
	refl	<.5, .5, .5>
	scoef	100
}

check squares {			; a checkerboard pattern
	patt1	black_refl	; use 'black_refl' and
	patt2	white_refl	; 'white_refl' to form the pattern
	xsize	2.5		; the checks are 2.5
	zsize	2.5		; units square
}

real floorsize = 100.0	; this variable will be used to control
			; the size of the floor.  If this is changed
			; then the computations below will make
			; everything turn out ok.

paragram {		; 'paragram' is short hand for parallelogram,
			; so this builds one of those
	patt	squares		; apply the pattern called 'squares'
				; which is the checkerboard from above
	loc	<-floorsize/2, 0, -floorsize/2>	; the location of the
						; parallelogram. it will
						; have its center at <0,0,0>
	v1	<floorsize, 0, 0>	; v1 and v2 define the vectors to
	v2	<0, 0, floorsize>	; two vertices of the parallelogram.
					; because of the geometrical definition
					; of a parallelogram, the fourth vertex
					; is at loc+v1+v2
}

real sphere_rad = 3.0	; the radius of the spheres

object sphere_ob1	; create an object called 'sphere_ob1'.
			; this is done primarily to allows the
			; object to be transformed and reproduced.
			; everything between here and 'endobject'
			; below belongs to 'sphere_ob1'

psphere {	; a psphere is a polygon-based sphere
	radius	sphere_rad	; the radius of this sphere
	loc	<0, 0, 0>	; the center of the sphere
	patt	yellowmc	; apply the pattern 'yellowmc'
	vsegs	psp_vsegs	; these two define the number of
	hsegs	psp_hsegs	; segments used to build the sphere,
				; i.e. the number of polygons
	smooth			; apply the phong smoothing routines
				; to the psphere to make it look smooth
}

endobject 	; the end of 'sphere_ob1'

lockobject sphere_ob1	; lock the object into pattern space so that
			; as it is rotated, the pattern will not 
			; slide around on it

object sphere_ob	; create an object called 'sphere_ob'

translate sphere_ob1 <sphere_rad/cos(30), sphere_rad, 0>
			; the above line translates sphere_ob1
			; into position to make it look as if it's
			; resting on the above parallelogram.

child sphere_ob1	; make 'sphere_ob1' a 'child' of
			; 'sphere_ob'.  child object can
			; be transformed independently of
			; its parent, but will still
			; follow the parent transformations.

endobject 	; end of sphere_ob

lockobject sphere_ob	; and lock it into pattern space


instance sphere_ob	; a simple instance of 'sphere_ob'
			; simple drops it into the scene

xrotate sphere_ob1 43	; rotate sphere_ob1 so that the patterns
yrotate sphere_ob1 275	; don't line up too neatly
zrotate sphere_ob1 154
yrotate sphere_ob 120	; rotate 'sphere_ob' 120 degrees, since we're
			; going to create a circle of three.

instance {	; a more complex instance
	object	sphere_ob
	subpatt	yellowmc silvermc	; substitute every occurence
					; of 'yellowmc' with
					; 'silvermc'.  allows instances
					; of the same object to have
					; different colors
}

xrotate sphere_ob1 175	; again rotate 'sphere_ob1' to
yrotate sphere_ob1 294	; 'unalign' the patterns
zrotate sphere_ob1 32
yrotate sphere_ob 120	; and rotate into position

instance {	; and instance it, but blue this time
	object	sphere_ob
	subpatt	yellowmc bluemc
}

object sphere_2		; create another object called 'sphere_2'

psphere {
	radius	sphere_rad	; the radius
	loc	<0, sphere_rad*(1+sin(60)+cos(60)), 0>
		; if my geometry is correct (not a good bet)
		; the above line positions the sphere on top
		; of the three just created
	patt	redmc		; apply the 'redmc' pattern
	vsegs	psp_vsegs
	hsegs	psp_hsegs
	smooth
}

endobject 	; end it

lockobject sphere_2	; lock it

yrotate sphere_2 225	; rotate it so the text in the pattern is
			; visible
instance sphere_2	; and drop it into the scene


