/*
	This file is meant to demonstrate the affects of "seccoef" and "secrefl" on the
	"color" pattern.  "seccoef" increases across the X axis of the image,
	and "secrefl" increases on the Y axis.

	 -----------> increasing speccoef ----------->
	|
	|	O	O	O	O	O
	|
	\/	O	O	O	O	O
    increasing
     secrefl	O	O	O	O	O	<-- 25 spheres
	|
	|	O	O	O	O	O
	|
	\/	O	O	O	O	O
*/

sky {
	horizon	<0, 0, 0>
	zenith	<0, 0, 0>
}


real coef0 = 10
real coef1 = 20
real coef2 = 40
real coef3 = 80
real coef4 = 160

real refl0 = .2
real refl1 = .4
real refl2 = .6
real refl3 = .8
real refl4 = 1

real sphere_radius = 2
real sphere_spacing = sphere_radius*2.5

camera {
	loc	<sphere_spacing*20, 0, 0>
	target	<0, 0, 0>
	hfov	2*atan((sphere_spacing*5+sphere_radius*2)/2/(sphere_spacing*20))
}

lamp {
	direct	<-.7, -1, -.2>
}

color pattern00 {
	diff	<0, .7, .2>
	scoef	coef0
	srefl	refl0
}
	
color pattern01 {
	diff	<0, .7, .2>
	scoef	coef0
	srefl	refl1
}
	
color pattern02 {
	diff	<0, .7, .2>
	scoef	coef0
	srefl	refl2
}
	
color pattern03 {
	diff	<0, .7, .2>
	scoef	coef0
	srefl	refl3
}
	
color pattern04 {
	diff	<0, .7, .2>
	scoef	coef0
	srefl	refl4
}
	
color pattern10 {
	diff	<0, .7, .2>
	scoef	coef1
	srefl	refl0
}
	
color pattern11 {
	diff	<0, .7, .2>
	scoef	coef1
	srefl	refl1
}
	
color pattern12 {
	diff	<0, .7, .2>
	scoef	coef1
	srefl	refl2
}
	
color pattern13 {
	diff	<0, .7, .2>
	scoef	coef1
	srefl	refl3
}
	
color pattern14 {
	diff	<0, .7, .2>
	scoef	coef1
	srefl	refl4
}
	
color pattern20 {
	diff	<0, .7, .2>
	scoef	coef2
	srefl	refl0
}
	
color pattern21 {
	diff	<0, .7, .2>
	scoef	coef2
	srefl	refl1
}
	
color pattern22 {
	diff	<0, .7, .2>
	scoef	coef2
	srefl	refl2
}
	
color pattern23 {
	diff	<0, .7, .2>
	scoef	coef2
	srefl	refl3
}
	
color pattern24 {
	diff	<0, .7, .2>
	scoef	coef2
	srefl	refl4
}
	
color pattern30 {
	diff	<0, .7, .2>
	scoef	coef3
	srefl	refl0
}
	
color pattern31 {
	diff	<0, .7, .2>
	scoef	coef3
	srefl	refl1
}
	
color pattern32 {
	diff	<0, .7, .2>
	scoef	coef3
	srefl	refl2
}
	
color pattern33 {
	diff	<0, .7, .2>
	scoef	coef3
	srefl	refl3
}
	
color pattern34 {
	diff	<0, .7, .2>
	scoef	coef3
	srefl	refl4
}
	
color pattern40 {
	diff	<0, .7, .2>
	scoef	coef4
	srefl	refl0
}
	
color pattern41 {
	diff	<0, .7, .2>
	scoef	coef4
	srefl	refl1
}
	
color pattern42 {
	diff	<0, .7, .2>
	scoef	coef4
	srefl	refl2
}
	
color pattern43 {
	diff	<0, .7, .2>
	scoef	coef4
	srefl	refl3
}
	
color pattern44 {
	diff	<0, .7, .2>
	scoef	coef4
	srefl	refl4
}
	
sphere {
	loc	<0, -(0-2)*sphere_spacing, -(0-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern00
}

sphere {
	loc	<0, -(0-2)*sphere_spacing, -(1-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern10
}

sphere {
	loc	<0, -(0-2)*sphere_spacing, -(2-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern20
}

sphere {
	loc	<0, -(0-2)*sphere_spacing, -(3-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern30
}

sphere {
	loc	<0, -(0-2)*sphere_spacing, -(4-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern40
}

sphere {
	loc	<0, -(1-2)*sphere_spacing, -(0-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern01
}

sphere {
	loc	<0, -(1-2)*sphere_spacing, -(1-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern11
}

sphere {
	loc	<0, -(1-2)*sphere_spacing, -(2-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern21
}

sphere {
	loc	<0, -(1-2)*sphere_spacing, -(3-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern31
}

sphere {
	loc	<0, -(1-2)*sphere_spacing, -(4-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern41
}

sphere {
	loc	<0, -(2-2)*sphere_spacing, -(0-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern02
}

sphere {
	loc	<0, -(2-2)*sphere_spacing, -(1-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern12
}

sphere {
	loc	<0, -(2-2)*sphere_spacing, -(2-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern22
}

sphere {
	loc	<0, -(2-2)*sphere_spacing, -(3-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern32
}

sphere {
	loc	<0, -(2-2)*sphere_spacing, -(4-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern42
}

sphere {
	loc	<0, -(3-2)*sphere_spacing, -(0-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern03
}

sphere {
	loc	<0, -(3-2)*sphere_spacing, -(1-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern13
}

sphere {
	loc	<0, -(3-2)*sphere_spacing, -(2-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern23
}

sphere {
	loc	<0, -(3-2)*sphere_spacing, -(3-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern33
}

sphere {
	loc	<0, -(3-2)*sphere_spacing, -(4-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern43
}

sphere {
	loc	<0, -(4-2)*sphere_spacing, -(0-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern04
}

sphere {
	loc	<0, -(4-2)*sphere_spacing, -(1-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern14
}

sphere {
	loc	<0, -(4-2)*sphere_spacing, -(2-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern24
}

sphere {
	loc	<0, -(4-2)*sphere_spacing, -(3-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern34
}

sphere {
	loc	<0, -(4-2)*sphere_spacing, -(4-2)*sphere_spacing>
	radius	sphere_radius
	pattern	pattern44
}


