/***********************************************************************
*
*	This script is designed to show the difference in the 'trans'
*	and 'filt' subelements of the 'color' element.  'trans'
*	increases left to right, 'filt' increases top to bottom.
*	What you should notice is that the spheres towards the bottom
*	of the picture (higher 'filt') have a yellowish tint, which
*	is stronger at the center of the sphere.  Since 'filt' is
*	dependent upon the length of the ray as it passes through the
*	sphere, and the sphere is thicker in the center than the edges,
*	more 'filt' is applied.  The spheres are tinted yellow because
*	the 'filt' is set to filter out blue, leaving red and green,
*	which make yellow.  Notice that the spheres in the top row
*	don't appear as three-dimensional as those on the bottom row.
*
**********************************************************************/

real sphere_rad = 1
real sphere_space = sphere_rad*1.5*2
real check_size = sphere_rad


camera {
	loc	<-sphere_rad*20, sphere_rad, sphere_rad>
	target	<0, 0, 0>
	hfov	2*atan((sphere_space*4+sphere_rad*2)/2/(sphere_rad*20))
}

lamp {
	loc	<-sphere_space*2, sphere_space*10, sphere_space*3>
}


color glass00 {
	diff	<0, 0, 0>
	trans	<1, 1, 1>
	filt	<0, 0, 0>
	index 1.2
}

color glass01 {
	diff	<0, 0, 0>
	trans	<.75, .75, .75>
	filt	<0, 0, 0>
	index 1.2
}

color glass02 {
	diff	<0, 0, 0>
	trans	<.5, .5, .5>
	filt	<0, 0, 0>
	index 1.2
}

color glass03 {
	diff	<0, 0, 0>
	trans	<.25, .25, .25>
	filt	<0, 0, 0>
	index 1.2
}

color glass10 {
	diff	<0, 0, 0>
	trans	<1, 1, 1>
	filt	<0, 0, .1>
	index 1.2
}

color glass11 {
	diff	<0, 0, 0>
	trans	<.75, .75, .75>
	filt	<0, 0, .1>
	index 1.2
}

color glass12 {
	diff	<0, 0, 0>
	trans	<.5, .5, .5>
	filt	<0, 0, .1>
	index 1.2
}

color glass13 {
	diff	<0, 0, 0>
	trans	<.25, .25, .25>
	filt	<0, 0, .1>
	index 1.2
}

color glass20 {
	diff	<0, 0, 0>
	trans	<1, 1, 1>
	filt	<0, 0, .2>
	index 1.2
}

color glass21 {
	diff	<0, 0, 0>
	trans	<.75, .75, .75>
	filt	<0, 0, .2>
	index 1.2
}

color glass22 {
	diff	<0, 0, 0>
	trans	<.5, .5, .5>
	filt	<0, 0, .2>
	index 1.2
}

color glass23 {
	diff	<0, 0, 0>
	trans	<.25, .25, .25>
	filt	<0, 0, .2>
	index 1.2
}

color glass30 {
	diff	<0, 0, 0>
	trans	<1, 1, 1>
	filt	<0, 0, .3>
	index 1.2
}

color glass31 {
	diff	<0, 0, 0>
	trans	<.75, .75, .75>
	filt	<0, 0, .3>
	index 1.2
}

color glass32 {
	diff	<0, 0, 0>
	trans	<.5, .5, .5>
	filt	<0, 0, .3>
	index 1.2
}

color glass33 {
	diff	<0, 0, 0>
	trans	<.25, .25, .25>
	filt	<0, 0, .3>
	index 1.2
}

sphere {
	patt	glass00
	loc	<0, 1.5*sphere_space, -1.5*sphere_space>
	radius	sphere_rad
}

sphere {
	patt	glass01
	loc	<0, 1.5*sphere_space, -.5*sphere_space>
	radius	sphere_rad
}

sphere {
	patt	glass02
	loc	<0, 1.5*sphere_space, .5*sphere_space>
	radius	sphere_rad
}

sphere {
	patt	glass03
	loc	<0, 1.5*sphere_space, 1.5*sphere_space>
	radius	sphere_rad
}

sphere {
	patt	glass10
	loc	<0, .5*sphere_space, -1.5*sphere_space>
	radius	sphere_rad
}

sphere {
	patt	glass11
	loc	<0, .5*sphere_space, -.5*sphere_space>
	radius	sphere_rad
}

sphere {
	patt	glass12
	loc	<0, .5*sphere_space, .5*sphere_space>
	radius	sphere_rad
}

sphere {
	patt	glass13
	loc	<0, .5*sphere_space, 1.5*sphere_space>
	radius	sphere_rad
}

sphere {
	patt	glass20
	loc	<0, -.5*sphere_space, -1.5*sphere_space>
	radius	sphere_rad
}

sphere {
	patt	glass21
	loc	<0, -.5*sphere_space, -.5*sphere_space>
	radius	sphere_rad
}

sphere {
	patt	glass22
	loc	<0, -.5*sphere_space, .5*sphere_space>
	radius	sphere_rad
}

sphere {
	patt	glass23
	loc	<0, -.5*sphere_space, 1.5*sphere_space>
	radius	sphere_rad
}

sphere {
	patt	glass30
	loc	<0, -1.5*sphere_space, -1.5*sphere_space>
	radius	sphere_rad
}

sphere {
	patt	glass31
	loc	<0, -1.5*sphere_space, -.5*sphere_space>
	radius	sphere_rad
}

sphere {
	patt	glass32
	loc	<0, -1.5*sphere_space, .5*sphere_space>
	radius	sphere_rad
}

sphere {
	patt	glass33
	loc	<0, -1.5*sphere_space, 1.5*sphere_space>
	radius	sphere_rad
}


color red {
	diff	<1, 0, 0>
	srefl	0
}

color white {
	diff	<1, 1, 1>
	srefl	0
}

check checks {
	patt1	red
	patt2	white
	xsize	check_size
	ysize	check_size
	zsize	check_size
}


plane {
	loc	<sphere_rad*2, 0, 0>
	v1	<0, 1, 0>
	v2	<0, 0, 1>
	patt	checks
}

