/*

	Chat Demonstration Server
	Capabilities:
	multi-user chat facility
	Users telnet to <your IP address> on port 4444
		e.g. telnet <box_wsserver_is_running_on_IP> 4444
	Anything the user types will be broadcast to all connected
	users.

	This could be written w/ about 15 lines of code -- but,
	then you wouldn't get as many status messages...

	Just search for zinCommand to see all the pertinent calls -- the
	rest of the code is just 'windows' overhead...

*/

#include <windows.h>            /* required for all Windows applications */
#include <windowsx.h>            /* required for all Windows applications */
#include <stdlib.h>

#include "wsserver.h"
#include	"..\..\zincon.h"

HANDLE hInst;               /* current instance              */

/*

	Handle list of all clients

*/
typedef struct
{
	int		client;
	void *	next;
} CLIENT, far * PCLIENT;

PCLIENT	pclienttop;

/****************************************************************************

    FUNCTION: WinMain(HANDLE, HANDLE, LPSTR, int)

    PURPOSE: calls initialization function, processes message loop

    COMMENTS:

        Windows recognizes this function by name as the initial entry point
        for the program.  This function calls the application initialization
        routine, if no other instance of the program is running, and always
        calls the instance initialization routine.  It then executes a message
        retrieval and dispatch loop that is the top-level control structure
        for the remainder of execution.  The loop is terminated when a WM_QUIT
        message is received, at which time this function exits the application
        instance by returning the value passed by PostQuitMessage().

        If this function must abort before entering the message loop, it
        returns the conventional value NULL.

****************************************************************************/

int PASCAL WinMain(hInstance, hPrevInstance, lpCmdLine, nCmdShow)
HANDLE hInstance;                /* current instance         */
HANDLE hPrevInstance;            /* previous instance        */
LPSTR lpCmdLine;                 /* command line             */
int nCmdShow;                    /* show-window type (open/icon) */
{
    MSG msg;                     /* message              */

    if (!hPrevInstance)          /* Other instances of app running? */
    if (!InitApplication(hInstance)) /* Initialize shared things */
        return (FALSE);      /* Exits if unable to initialize     */


    /* Perform initializations that apply to a specific instance */

    if (!InitInstance(hInstance, nCmdShow))
        return (FALSE);

    /* Acquire and dispatch messages until a WM_QUIT message is received. */

    while (GetMessage(&msg,    /* message structure              */
        NULL,          /* handle of window receiving the message */
        NULL,          /* lowest message to examine          */
        NULL))         /* highest message to examine         */
    {
    TranslateMessage(&msg);    /* Translates virtual key codes       */
    DispatchMessage(&msg);     /* Dispatches message to window       */
    }

    return (msg.wParam);       /* Returns the value from PostQuitMessage */
}


/****************************************************************************

    FUNCTION: InitApplication(HANDLE)

    PURPOSE: Initializes window data and registers window class

    COMMENTS:

        This function is called at initialization time only if no other
        instances of the application are running.  This function performs
        initialization tasks that can be done once for any number of running
        instances.

        In this case, we initialize a window class by filling out a data
        structure of type WNDCLASS and calling the Windows RegisterClass()
        function.  Since all instances of this application use the same window
        class, we only need to do this when the first instance is initialized.


****************************************************************************/

BOOL InitApplication(hInstance)
HANDLE hInstance;                  /* current instance       */
{
    WNDCLASS  wc;

    /* Fill in window class structure with parameters that describe the       */
    /* main window.                                                           */

    wc.style = NULL;                    /* Class style(s).                    */
    wc.lpfnWndProc = MainWndProc;       /* Function to retrieve messages for  */
                                        /* windows of this class.             */
    wc.cbClsExtra = 0;                  /* No per-class extra data.           */
    wc.cbWndExtra = 0;                  /* No per-window extra data.          */
    wc.hInstance = hInstance;           /* Application that owns the class.   */
    wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName =  "GenericMenu";   /* Name of menu resource in .RC file. */
    wc.lpszClassName = "GenericWClass"; /* Name used in call to CreateWindow. */

    /* Register the window class and return success/failure code. */

    return (RegisterClass(&wc));

}


/****************************************************************************

    FUNCTION:  InitInstance(HANDLE, int)

    PURPOSE:  Saves instance handle and creates main window

    COMMENTS:

        This function is called at initialization time for every instance of
        this application.  This function performs initialization tasks that
        cannot be shared by multiple instances.

        In this case, we save the instance handle in a static variable and
        create and display the main program window.

****************************************************************************/

BOOL InitInstance(hInstance, nCmdShow)
    HANDLE          hInstance;          /* Current instance identifier.       */
    int             nCmdShow;           /* Param for first ShowWindow() call. */
{
    HWND            hWnd;               /* Main window handle.                */

    /* Save the instance handle in static variable, which will be used in  */
    /* many subsequence calls from this application to Windows.            */

    hInst = hInstance;

    /* Create a main window for this application instance.  */

    hWnd = CreateWindow(
        "GenericWClass",                /* See RegisterClass() call.          */
        "Generic Sample Application",   /* Text for window title bar.         */
        WS_OVERLAPPEDWINDOW,            /* Window style.                      */
        CW_USEDEFAULT,                  /* Default horizontal position.       */
        CW_USEDEFAULT,                  /* Default vertical position.         */
        CW_USEDEFAULT,                  /* Default width.                     */
        CW_USEDEFAULT,                  /* Default height.                    */
        NULL,                           /* Overlapped windows have no parent. */
        NULL,                           /* Use the window class menu.         */
        hInstance,                      /* This instance owns this window.    */
        NULL                            /* Pointer not needed.                */
    );

    /* If window could not be created, return "failure" */

    if (!hWnd)
        return (FALSE);

    /* Make the window visible; update its client area; and return "success" */

    ShowWindow(hWnd, nCmdShow);  /* Show the window                        */
    UpdateWindow(hWnd);          /* Sends WM_PAINT message                 */
    return (TRUE);               /* Returns the value from PostQuitMessage */

}

/*
	Broadcast to all clients
*/
void broadcast(BYTE far * c, int len)
{
	PCLIENT pclient;

	pclient = pclienttop;
	while (pclient != NULL)
	{
		(int)zinCommand(ZIN_WRITE, pclient->client, c, len);
		pclient = pclient->next;
	}
}

/****************************************************************************

    FUNCTION: MainWndProc(HWND, UINT, WPARAM, LPARAM)

    PURPOSE:  Processes messages

    MESSAGES:

    WM_COMMAND    - application menu (About dialog box)
    WM_DESTROY    - destroy window

    COMMENTS:

    To process the IDM_ABOUT message, call MakeProcInstance() to get the
    current instance address of the About() function.  Then call Dialog
    box which will create the box according to the information in your
    generic.rc file and turn control over to the About() function.  When
    it returns, free the intance address.

****************************************************************************/

long CALLBACK __export MainWndProc(hWnd, message, wParam, lParam)
HWND hWnd;                      /* window handle                 */
UINT message;                   /* type of message               */
WPARAM wParam;                  /* additional information        */
LPARAM lParam;                  /* additional information        */
{
	static int	srv;
	static int	sclient;

	switch (message)
	{
		case WM_CREATE:
		{
			// Start the server on port 4444
			srv = (int)zinCommand(ZIN_IPSERVER, 0, NULL, 4444);

			// Set a timer to poll for incoming data
			// and check for new connections
			// 250 = polls every 1/4 of a second...
			SetTimer(hWnd, 1, 250, NULL);
			pclienttop = NULL;
			break;
		}

	//
	// Check for incoming connections
	// and check the recieve buffer for new data
	//
		case	WM_TIMER:
		{
			BYTE far * c;
			int		r;
			HDC 		hdc;
			int		iNewClient;
			PCLIENT	pclient;

			c = GlobalAllocPtr(GMEM_DDESHARE, 4096);
		//
		// Any new clients to start monitoring?
		//	If so, put them in the list and monitor their data, too
		// 
			iNewClient = (int)zinCommand(ZIN_IPPOLL, srv, c, 4096);
			if (iNewClient > -1)
			{
				pclient = (PCLIENT)GlobalAllocPtr(GMEM_DDESHARE, sizeof(CLIENT));
				pclient->client = iNewClient;
				pclient->next = pclienttop;
				pclienttop = pclient;
			}

		// 
		//	Process any recieved data
			pclient = pclienttop;
			while (pclient != NULL)
			{
				r = (int)zinCommand(ZIN_READ, pclient->client, c, 4096);

				if (r > 0)
				{
					hdc = GetDC(hWnd);
					TextOut(hdc, 0, pclient->client*15, c, r);
					ReleaseDC(hWnd, hdc);
				//
				// Broadcast all data to all connected clients
				// (this is not a zinCommand)
				//
					broadcast(c, r);
				}
				pclient = pclient->next;
			}
			GlobalFreePtr(c);

			break;

		}

		case WM_COMMAND:       /* message: command from application menu */
		{
			switch (wParam)
			{

				case IDM_ABOUT:
				{
					
                DialogBox(hInst,        /* current instance          */
                    "AboutBox",         /* resource to use           */
                    hWnd,               /* parent handle             */
                    About);             /* About() instance address  */

                break;
				}

				default:
                return (DefWindowProc(hWnd, message, wParam, lParam));

				break;
			}
			break;
		}
		case WM_DESTROY:          /* message: window being destroyed */
			PostQuitMessage(0);
			break;

		default:                  /* Passes it on if unproccessed    */
			return (DefWindowProc(hWnd, message, wParam, lParam));
	}
	return (NULL);
}


/****************************************************************************

    FUNCTION: About(HWND, unsigned, WORD, LONG)

    PURPOSE:  Processes messages for "About" dialog box

    MESSAGES:

    WM_INITDIALOG - initialize dialog box
    WM_COMMAND    - Input received

    COMMENTS:

    No initialization is needed for this particular dialog box, but TRUE
    must be returned to Windows.

    Wait for user to click on "Ok" button, then close the dialog box.

****************************************************************************/

BOOL __export CALLBACK About(hDlg, message, wParam, lParam)
HWND hDlg;               /* window handle of the dialog box */
unsigned message;        /* type of message                 */
WORD wParam;             /* message-specific information    */
LONG lParam;
{
    switch (message)
    {
        case WM_INITDIALOG:            /* message: initialize dialog box */
        {
				// Test area... ignore this code...
				char	c[100];
				lstrcpy(c, "server.gslink.com");
				zinCommand(ZIN_RESOLVE, 0, c, 0);
				MessageBox(NULL, c, "Resolved?", MB_OK);


            return (TRUE);
		  }

        case WM_COMMAND:               /* message: received a command */
            if (wParam == IDOK         /* "OK" box selected?          */
                || wParam == IDCANCEL) /* System menu close command?  */
            {
                EndDialog(hDlg, TRUE); /* Exits the dialog box        */
                return (TRUE);
            }
            break;
    }
    return (FALSE);               /* Didn't process a message    */
}

