{
  Program: BmpFilm
  Date: 20/2/1995
  Purpose: To create a custom control (vbx) for Visual Basic or Delphi
}
Library BmpFilm;
{$R BmpFilm}
Uses WinTypes,WinProcs,VBApi,Messages;
{ Custom control data and structs }
Type PBmpFilm=^TBmpFilm;
     TBmpFilm=Record
      About:Enum;
      Picture:hPic;
      Interval:Integer;
      Cols:Integer;
      Rows:Integer;
      Col,Row:Integer;
     End;
Const 
{ Declare Property }
      Property_About:TPROPINFO=(
      npszName:NPnt(PChar('(About)'));
      fl:DT_ENUM or PF_fGetData or PF_fSetData or PF_fSetMsg;
      offsetData:Byte(0);
      infoData:0;
      dataDefault:0;
      npszEnumList:Npnt(PChar('Click on "..." for About Box'+#0+#0));
      enumMax:0);
      Property_Picture:TPROPINFO=(
      npszName:NPnt(PChar('Picture'));
      fl:DT_PICTURE or PF_fGetData or PF_fSaveData or PF_fSetData or PF_fSetMsg;
      offsetData:Byte(1);
      infoData:0;
      dataDefault:0;
      npszEnumList:Npnt(PChar(+#0+#0));
      enumMax:0);
      Property_Interval:TPROPINFO=(
      npszName:NPnt(PChar('Interval'));
      fl:DT_SHORT or PF_fGetData or PF_fSaveData or PF_fSetData or PF_fSetMsg;
      offsetData:Byte(3);
      infoData:0;
      dataDefault:0;
      npszEnumList:Npnt(PChar(+#0+#0));
      enumMax:0);
      Property_Cols:TPROPINFO=(
      npszName:NPnt(PChar('Cols'));
      fl:DT_SHORT or PF_fGetData or PF_fSaveData or PF_fSetData or PF_fSetMsg;
      offsetData:Byte(5);
      infoData:0;
      dataDefault:0;
      npszEnumList:Npnt(PChar(+#0+#0));
      enumMax:0);
      Property_Rows:TPROPINFO=(
      npszName:NPnt(PChar('Rows'));
      fl:DT_SHORT or PF_fGetData or PF_fSaveData or PF_fSetData or PF_fSetMsg;
      offsetData:Byte(7);
      infoData:0;
      dataDefault:0;
      npszEnumList:Npnt(PChar(+#0+#0));
      enumMax:0);
{ Declare Events }
      Event_Paint:TEVENTINFO=(
      npszName:NPnt(PChar('Paint'));
      cParms:0;
      cwParms:2*0;
      npParmTypes:0;
      npszParmProf:NPnt(PChar(''));
      fl:0);
{ Property List }
      PropListBmpFilm:array[0..14] of PPropInfo=(
      PPropInfo_Std_CTLNAME,
      PPropInfo_Std_HWND,
      PPropInfo_Std_INDEX,
      PPropInfo(@Property_About),
      PPropInfo_Std_ENABLED,
      PPropInfo_Std_HEIGHT,
      PPropInfo_Std_LEFT,
      PPropInfo_Std_TOP,
      PPropInfo_Std_VISIBLE,
      PPropInfo_Std_WIDTH,
      PPropInfo(@Property_Picture),
      PPropInfo(@Property_Interval),
      PPropInfo(@Property_Cols),
      PPropInfo(@Property_Rows),0);
{ Event List }
      EventListBmpFilm:array[0..6] of PEventInfo=(
      PEventInfo_Std_CLICK,
      PEventInfo_Std_DBLCLICK,
      PEventInfo_Std_MOUSEDOWN,
      PEventInfo_Std_MOUSEMOVE,
      PEventInfo_Std_MOUSEUP,
      PEventInfo(@Event_Paint),0);
{ This routine handles the 'About' Dialog messages }
function AboutDlgProc(Dlg:HWnd;Msg,wParam:Word;lParam:LongInt):Bool; export;
begin
  AboutDlgProc:=False;
  case Msg of
    WM_Create:AboutDlgProc:=True;
    WM_InitDialog:Exit;
    WM_Command:if (wParam=id_OK)or(wParam=id_Cancel) then EndDialog(Dlg,0);
  end;{End of Case}
end;
{ Constans and Variables }
{ Control Procedure }
{ This routine is called for all VB and Windows Messages }
function BmpFilmCtlProc(Control:hCtl;Wnd:hWnd;Msg,wParam:Word;lParam:LongInt):LongInt; Export;
const hBrOld:hBrush=0;
var BmpFilm:PBmpFilm;
    TP:TPaintStruct;
    Pic:Tpic;
    hPicture:hPic;
    BMP:TBitmap;
    hBR:hBrush;
    MemDC:hDC;
begin
  BmpFilm:=PBmpFilm(VBDerefControl(Control));
  case Msg of
    WM_NCCREATE:
    begin 
      BmpFilm^.Col:=0;
      BmpFilm^.Row:=0;
      VBSetControlProperty(Control,11,200);
      VBSetControlProperty(Control,12,3);
      VBSetControlProperty(Control,13,6);
    end;
    WM_TIMER:
    begin
      if BmpFilm^.Row=BmpFilm^.Rows-1 then
      begin
        BmpFilm^.Row:=0;
        Inc(BmpFilm^.Col);
      end else Inc(BmpFilm^.Row);
      if BmpFilm^.Col=BmpFilm^.Cols then
      begin
        BmpFilm^.Row:=0;
        BmpFilm^.Col:=0;
      end;
      InvalidateRect(Wnd,nil,False);
    end;
    WM_PAINT:
    begin
      BeginPaint(Wnd,TP);
      if VBGetMode=MODE_RUN then VBFireEvent(Control,5,nil);
      VBGetControlProperty(Control,10,@hPicture);
      if hPicture<>0 then
        begin
          VBGetPic(hPicture,@Pic);
          hBR:=GetBrushOrg(TP.hDC);
          if Bool(hbr) then hbrOld:=SelectObject(TP.hDC,hBR);
          GetObject(Pic.PicData.Bitmap,sizeof(TBitMap),PChar(@Bmp));
          MemDC:=CreateCompatibleDC(TP.hDC);
          SelectObject(MemDC,Pic.PicData.Bitmap);
          BitBlt(TP.hDC,0,0,Bmp.bmWidth div BmpFilm^.Rows,Bmp.bmHeight div BmpFilm^.Cols,MemDC
                ,BmpFilm^.Row*(Bmp.bmWidth div BmpFilm^.Rows),BmpFilm^.Col*(Bmp.bmHeight div BmpFilm^.Cols),SRCCOPY);
          SelectObject(TP.hDC,hbrOld);
          DeleteDC(MemDC);
        end;
      EndPaint(Wnd,TP);
      Exit;
    end;
    VBM_SETPROPERTY:
    case wParam of
      10:InvalidateRect(Wnd,nil,True);
      11:
      begin
        if VBGetMode=MODE_RUN then
        begin
          VBGetControlProperty(Control,11,@BmpFilm^.Interval);
          SetTimer(Wnd,100,BmpFilm^.Interval,nil);
        end;
        InvalidateRect(Wnd,nil,True);
      end;
      12:
      begin
        VBGetControlProperty(Control,12,@BmpFilm^.Cols);
        InvalidateRect(Wnd,nil,True);
      end;
      13:
      begin
        VBGetControlProperty(Control,13,@BmpFilm^.Rows);
        InvalidateRect(Wnd,nil,True);
      end;
    end;
    WM_USER:VBDialogBoxParam(hInstance,'ABOUT',@AboutDlgProc,0);WM_USER+1:VBDialogBoxParam(hInstance,'ABOUT',@AboutDlgProc,0);
    VBM_INITPROPPOPUP:if wParam=3 then
    begin
      BmpFilmCtlProc:=LoWord(lParam+1);
      PostMessage(Wnd,WM_USER,0,0);
      Exit;
    end;
  end;    { End of case Msg }
  BmpFilmCtlProc:=VBDefControlProc(Control,Wnd,Msg,wParam,lParam);
end; {End of Control function}
{ Model struct                               }
{ Define the control model                   }
{ (using the event and property structures). }
Const ModelBmpFilm:TModel=(
      UsVersion:VB300_VERSION;    { VB version used by control }
      Fl:0;
      CtlProc:TFarProc(@BmpFilmCtlProc);
      FsClassStyle:0 or cs_HRedraw or cs_VRedraw;
      FlWndStyle:0;
      CbCtlExtra:SizeOf(TBmpFilm);
      IdBmpPalette:8000;          { Bitmap ID for tool palette }
      DefCtlName:NPnt(PChar('BmpFilm'));
      ClassName:NPnt(PChar('BmpFilm'));
      ParentClassName:0;
      PropList:Ofs(PropListBmpFilm);
      EventList:Ofs(EventListBmpFilm);
      NDefProp:0;                 { Index of default property }
      NDefEvent:0);               { Index of default event }
{ Register custom control.                     }
{ This routine is called by VB when the custom }
{ control DLL is loaded for use.               }
function VBInitCC(usVersion:Word;fRunTime:Boolean):Boolean; Export;
begin
  VBInitCC:=VBRegisterModel(hInstance,ModelBmpFilm);
end;
Exports
  VBInitCC         index 2,
  BmpFilmCtlProc index 3,
  AboutDlgProc;
Begin
End. { End of Custom Control }