// Hangman32Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "Hangman32.h"
#include "Hangman32Dlg.h"
#include "GenericDlg.h"
#include "HintDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT

}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHangman32Dlg dialog

CHangman32Dlg::CHangman32Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CHangman32Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CHangman32Dlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CHangman32Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CHangman32Dlg)
	DDX_Control(pDX, IDC_PICTURE, m_cntrlPic);
	DDX_Control(pDX, IDC_BUTTON26, m_btn26Z);
	DDX_Control(pDX, IDC_BUTTON25, m_btn25Y);
	DDX_Control(pDX, IDC_BUTTON24, m_btn24X);
	DDX_Control(pDX, IDC_BUTTON23, m_btn23W);
	DDX_Control(pDX, IDC_BUTTON22, m_btn22V);
	DDX_Control(pDX, IDC_BUTTON21, m_btn21U);
	DDX_Control(pDX, IDC_BUTTON20, m_btn20T);
	DDX_Control(pDX, IDC_BUTTON19, m_btn19S);
	DDX_Control(pDX, IDC_BUTTON18, m_btn18R);
	DDX_Control(pDX, IDC_BUTTON17, m_btn17Q);
	DDX_Control(pDX, IDC_BUTTON16, m_btn16P);
	DDX_Control(pDX, IDC_BUTTON15, m_btn15O);
	DDX_Control(pDX, IDC_BUTTON14, m_btn14N);
	DDX_Control(pDX, IDC_BUTTON13, m_btn13M);
	DDX_Control(pDX, IDC_BUTTON12, m_btn12L);
	DDX_Control(pDX, IDC_BUTTON11, m_btn11K);
	DDX_Control(pDX, IDC_BUTTON10, m_btn10J);
	DDX_Control(pDX, IDC_BUTTON9, m_btn9I);
	DDX_Control(pDX, IDC_BUTTON8, m_btn8H);
	DDX_Control(pDX, IDC_BUTTON7, m_btn7G);
	DDX_Control(pDX, IDC_BUTTON6, m_btn6F);
	DDX_Control(pDX, IDC_BUTTON5, m_btn5E);
	DDX_Control(pDX, IDC_BUTTON4, m_btn4D);
	DDX_Control(pDX, IDC_BUTTON3, m_btn3C);
	DDX_Control(pDX, IDC_BUTTON2, m_btn2B);
	DDX_Control(pDX, IDC_BUTTON1, m_btn1A);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CHangman32Dlg, CDialog)
	//{{AFX_MSG_MAP(CHangman32Dlg)
	ON_WM_SYSCOMMAND()
	ON_WM_DESTROY()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1_A)
	ON_BN_CLICKED(IDC_BUTTON2, OnButton2_B)
	ON_BN_CLICKED(IDC_BUTTON3, OnButton3_C)
	ON_BN_CLICKED(IDC_BUTTON4, OnButton4_D)
	ON_BN_CLICKED(IDC_BUTTON5, OnButton5_E)
	ON_BN_CLICKED(IDC_BUTTON6, OnButton6_F)
	ON_BN_CLICKED(IDC_BUTTON7, OnButton7_G)
	ON_BN_CLICKED(IDC_BUTTON8, OnButton8_H)
	ON_BN_CLICKED(IDC_BUTTON9, OnButton9_I)
	ON_BN_CLICKED(IDC_BUTTON10, OnButton10_J)
	ON_BN_CLICKED(IDC_BUTTON11, OnButton11_K)
	ON_BN_CLICKED(IDC_BUTTON12, OnButton12_L)
	ON_BN_CLICKED(IDC_BUTTON13, OnButton13_M)
	ON_BN_CLICKED(IDC_BUTTON14, OnButton14_N)
	ON_BN_CLICKED(IDC_BUTTON15, OnButton15_O)
	ON_BN_CLICKED(IDC_BUTTON16, OnButton16_P)
	ON_BN_CLICKED(IDC_BUTTON17, OnButton17_Q)
	ON_BN_CLICKED(IDC_BUTTON18, OnButton18_R)
	ON_BN_CLICKED(IDC_BUTTON19, OnButton19_S)
	ON_BN_CLICKED(IDC_BUTTON20, OnButton20_T)
	ON_BN_CLICKED(IDC_BUTTON21, OnButton21_U)
	ON_BN_CLICKED(IDC_BUTTON22, OnButton22_V)
	ON_BN_CLICKED(IDC_BUTTON23, OnButton23_W)
	ON_BN_CLICKED(IDC_BUTTON24, OnButton24_X)
	ON_BN_CLICKED(IDC_BUTTON25, OnButton25_Y)
	ON_BN_CLICKED(IDC_BUTTON26, OnButton26_Z)
	ON_COMMAND(ID_GAME_HINT, OnGameHint)
	ON_COMMAND(ID_GAME_NEW, OnGameNew)
	ON_COMMAND(ID_HELP_ABOUTHANGMAN32, OnHelpAbouthangman32)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHangman32Dlg message handlers

BOOL CHangman32Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.
	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	CString strAboutMenu;
	strAboutMenu.LoadString(IDS_ABOUTBOX);
	if (!strAboutMenu.IsEmpty())
	{
		pSysMenu->AppendMenu(MF_SEPARATOR);
		pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	((CHangman32App *)AfxGetApp())->m_hwndDialog = m_hWnd;
	if( m_Hangman.LoadDictionary() == FALSE )
		m_Hangman.LoadErrorDictionary();
	m_Hangman.LoadNewWord();
	RefreshScoreDisplay();
	DrawPic();

	return FALSE;  // return TRUE  unless you set the focus to a control
}

void CHangman32Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		((CHangman32App *)AfxGetApp())->m_doAccel = FALSE;	// Block key presses
		dlgAbout.DoModal();
		((CHangman32App *)AfxGetApp())->m_doAccel = TRUE;	// Allow key presses
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

void CHangman32Dlg::OnDestroy()
{
	WinHelp(0L, HELP_QUIT);
	CDialog::OnDestroy();
	((CHangman32App *)AfxGetApp())->m_hwndDialog = NULL;
	((CHangman32App *)AfxGetApp())->m_doAccel = FALSE;	// Block key presses
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.
void CHangman32Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CHangman32Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

// Handle the button presses
void CHangman32Dlg::OnButton1_A() 
{
	if( m_btn1A.IsWindowVisible() )				// If visible handle button press  
	{
		m_btn1A.ShowWindow(SW_HIDE);			// Make it disappear
		ProcessButtonPress('A');				// Send in the actual letter
	}
	else
		MessageBeep( MB_ICONEXCLAMATION );		//Else user pressed letter for button
}												//that has already been processed

void CHangman32Dlg::OnButton2_B() 
{
	if( m_btn2B.IsWindowVisible() )				// If visible handle button press
	{
		m_btn2B.ShowWindow(SW_HIDE);			// Make it disappear
		ProcessButtonPress('B');				// Send in the actual letter
	}
	else
		MessageBeep( MB_ICONEXCLAMATION );		//Else user pressed letter for button
}												//that has already been processed

void CHangman32Dlg::OnButton3_C() 
{
	if( m_btn3C.IsWindowVisible() )				// If visible handle button press
	{
		m_btn3C.ShowWindow(SW_HIDE);			// Make it disappear
		ProcessButtonPress('C');				// Send in the actual letter
	}
	else
		MessageBeep( MB_ICONEXCLAMATION );		//Else user pressed letter for button			
}												//that has already been processed

void CHangman32Dlg::OnButton4_D() 
{
	if( m_btn4D.IsWindowVisible() )				// If visible handle button press
	{
		m_btn4D.ShowWindow(SW_HIDE);			// Make it disappear
		ProcessButtonPress('D');				// Send in the actual letter
	}
	else
		MessageBeep( MB_ICONEXCLAMATION );		//Else user pressed letter for button
}												//that has already been processed

void CHangman32Dlg::OnButton5_E() 
{
	if( m_btn5E.IsWindowVisible() )				// If visible handle button press
	{
		m_btn5E.ShowWindow(SW_HIDE);			// Make it disappear
		ProcessButtonPress('E');				// Send in the actual letter
	}
	else
		MessageBeep( MB_ICONEXCLAMATION );		//Else user pressed letter for button		
}												//that has already been processed

void CHangman32Dlg::OnButton6_F() 
{
	if( m_btn6F.IsWindowVisible() )				// If visible handle button press
	{
		m_btn6F.ShowWindow(SW_HIDE);			// Make it disappear
		ProcessButtonPress('F');				// Send in the actual letter
	}
	else
		MessageBeep( MB_ICONEXCLAMATION );		//Else user pressed letter for button			
}												//that has already been processed

void CHangman32Dlg::OnButton7_G() 
{	
	if( m_btn7G.IsWindowVisible() )				// If visible handle button press
	{
		m_btn7G.ShowWindow(SW_HIDE);			// Make it disappear
		ProcessButtonPress('G');				// Send in the actual letter
	}
	else
		MessageBeep( MB_ICONEXCLAMATION );		//Else user pressed letter for button		
}												//that has already been processed

void CHangman32Dlg::OnButton8_H() 
{	
	if( m_btn8H.IsWindowVisible() )				// If visible handle button press
	{
		m_btn8H.ShowWindow(SW_HIDE);			// Make it disappear
		ProcessButtonPress('H');				// Send in the actual letter
	}
	else
		MessageBeep( MB_ICONEXCLAMATION );		//Else user pressed letter for button		
}												//that has already been processed

void CHangman32Dlg::OnButton9_I() 
{	
	if( m_btn9I.IsWindowVisible() )				// If visible handle button press
	{
		m_btn9I.ShowWindow(SW_HIDE);			// Make it disappear
		ProcessButtonPress('I');				// Send in the actual letter
	}
	else
		MessageBeep( MB_ICONEXCLAMATION );		//Else user pressed letter for button		
}												//that has already been processed

void CHangman32Dlg::OnButton10_J() 
{	
	if( m_btn10J.IsWindowVisible() )			// If visible handle button press
	{
		m_btn10J.ShowWindow(SW_HIDE);			// Make it disappear
		ProcessButtonPress('J');				// Send in the actual letter
	}
	else
		MessageBeep( MB_ICONEXCLAMATION );		//Else user pressed letter for button		
}												//that has already been processed

void CHangman32Dlg::OnButton11_K() 
{
	if( m_btn11K.IsWindowVisible() )			// If visible handle button press
	{
		m_btn11K.ShowWindow(SW_HIDE);			// Make it disappear
		ProcessButtonPress('K');				// Send in the actual letter
	}
	else
		MessageBeep( MB_ICONEXCLAMATION );		//Else user pressed letter for button		
}												//that has already been processed

void CHangman32Dlg::OnButton12_L() 
{
	if( m_btn12L.IsWindowVisible() )			// If visible handle button press
	{
		m_btn12L.ShowWindow(SW_HIDE);			// Make it disappear
		ProcessButtonPress('L');				// Send in the actual letter
	}
	else
		MessageBeep( MB_ICONEXCLAMATION );		//Else user pressed letter for button		
}												//that has already been processed

void CHangman32Dlg::OnButton13_M() 
{	
	if( m_btn13M.IsWindowVisible() )			// If visible handle button press
	{
		m_btn13M.ShowWindow(SW_HIDE);			// Make it disappear
		ProcessButtonPress('M');				// Send in the actual letter
	}
	else
		MessageBeep( MB_ICONEXCLAMATION );		//Else user pressed letter for button		
}												//that has already been processed

void CHangman32Dlg::OnButton14_N() 
{
	if( m_btn14N.IsWindowVisible() )			// If visible handle button press
	{
		m_btn14N.ShowWindow(SW_HIDE);			// Make it disappear
		ProcessButtonPress('N');				// Send in the actual letter
	}
	else
		MessageBeep( MB_ICONEXCLAMATION );		//Else user pressed letter for button		
}												//that has already been processed

void CHangman32Dlg::OnButton15_O() 
{
	if( m_btn15O.IsWindowVisible() )			// If visible handle button press
	{
		m_btn15O.ShowWindow(SW_HIDE);			// Make it disappear
		ProcessButtonPress('O');				// Send in the actual letter
	}
	else
		MessageBeep( MB_ICONEXCLAMATION );		//Else user pressed letter for button		
}												//that has already been processed

void CHangman32Dlg::OnButton16_P() 
{
	if( m_btn16P.IsWindowVisible() )			// If visible handle button press
	{
		m_btn16P.ShowWindow(SW_HIDE);			// Make it disappear
		ProcessButtonPress('P');				// Send in the actual letter
	}
	else
		MessageBeep( MB_ICONEXCLAMATION );		//Else user pressed letter for button		
}												//that has already been processed

void CHangman32Dlg::OnButton17_Q() 
{
	if( m_btn17Q.IsWindowVisible() )			// If visible handle button press
	{
		m_btn17Q.ShowWindow(SW_HIDE);			// Make it disappear
		ProcessButtonPress('Q');				// Send in the actual letter
	}
	else
		MessageBeep( MB_ICONEXCLAMATION );		//Else user pressed letter for button		
}												//that has already been processed

void CHangman32Dlg::OnButton18_R() 
{	
	if( m_btn18R.IsWindowVisible() )			// If visible handle button press
	{
		m_btn18R.ShowWindow(SW_HIDE);			// Make it disappear
		ProcessButtonPress('R');				// Send in the actual letter
	}
	else
		MessageBeep( MB_ICONEXCLAMATION );		//Else user pressed letter for button		
}												//that has already been processed

void CHangman32Dlg::OnButton19_S() 
{
	if( m_btn19S.IsWindowVisible() )			// If visible handle button press
	{
		m_btn19S.ShowWindow(SW_HIDE);			// Make it disappear
		ProcessButtonPress('S');				// Send in the actual letter
	}
	else
		MessageBeep( MB_ICONEXCLAMATION );		//Else user pressed letter for button		
}												//that has already been processed

void CHangman32Dlg::OnButton20_T() 
{
	if( m_btn20T.IsWindowVisible() )			// If visible handle button press
	{
		m_btn20T.ShowWindow(SW_HIDE);			// Make it disappear
		ProcessButtonPress('T');				// Send in the actual letter
	}
	else
		MessageBeep( MB_ICONEXCLAMATION );		//Else user pressed letter for button		
}												//that has already been processed

void CHangman32Dlg::OnButton21_U() 
{
	if( m_btn21U.IsWindowVisible() )			// If visible handle button press
	{
		m_btn21U.ShowWindow(SW_HIDE);			// Make it disappear
		ProcessButtonPress('U');				// Send in the actual letter
	}
	else
		MessageBeep( MB_ICONEXCLAMATION );		//Else user pressed letter for button			
}												//that has already been processed

void CHangman32Dlg::OnButton22_V() 
{
	if( m_btn22V.IsWindowVisible() )			// If visible handle button press
	{
		m_btn22V.ShowWindow(SW_HIDE);			// Make it disappear
		ProcessButtonPress('V');				// Send in the actual letter
	}
	else
		MessageBeep( MB_ICONEXCLAMATION );		//Else user pressed letter for button			
}												//that has already been processed

void CHangman32Dlg::OnButton23_W() 
{
	if( m_btn23W.IsWindowVisible() )			// If visible handle button press
	{
		m_btn23W.ShowWindow(SW_HIDE);			// Make it disappear
		ProcessButtonPress('W');				// Send in the actual letter
	}
	else
		MessageBeep( MB_ICONEXCLAMATION );		//Else user pressed letter for button		
}												//that has already been processed

void CHangman32Dlg::OnButton24_X() 
{	
	if( m_btn24X.IsWindowVisible() )			// If visible handle button press
	{
		m_btn24X.ShowWindow(SW_HIDE);			// Make it disappear
		ProcessButtonPress('X');				// Send in the actual letter
	}
	else
		MessageBeep( MB_ICONEXCLAMATION );		//Else user pressed letter for button		
}												//that has already been processed

void CHangman32Dlg::OnButton25_Y() 
{
	if( m_btn25Y.IsWindowVisible() )			// If visible handle button press
	{
		m_btn25Y.ShowWindow(SW_HIDE);			// Make it disappear
		ProcessButtonPress('Y');				// Send in the actual letter
	}
	else
		MessageBeep( MB_ICONEXCLAMATION );		//Else user pressed letter for button		
}												//that has already been processed

void CHangman32Dlg::OnButton26_Z() 
{	
	if( m_btn26Z.IsWindowVisible() )			// If visible handle button press
	{	
		m_btn26Z.ShowWindow(SW_HIDE);			// Make it disappear
		ProcessButtonPress('Z');				// Send in the actual letter
	}
	else
		MessageBeep( MB_ICONEXCLAMATION );		//Else user pressed letter for button		
}												//that has already been processed

void CHangman32Dlg::ProcessButtonPress(char Letter)
{
	BOOL boolean;
	char Str[30];
	UINT OldGuessRemaining;

	OldGuessRemaining = m_Hangman.GetGuessRemain();	// Get # of guess remaining
    boolean = m_Hangman.CheckLetter(Letter);		// Check the letter
    if(boolean)
		SetDlgItemText( IDC_GUESS, m_Hangman.GetCurrentGuess() );  // If true update

	_itoa( m_Hangman.GetGuessRemain(), Str, 10 );	// Update GuessRemain in dialog
	SetDlgItemText( IDC_GUESS_REMAINING, Str );

	if( OldGuessRemaining != m_Hangman.GetGuessRemain() )
		DrawPic();									// Only draw picture if have to

	if( m_Hangman.GetGuessRemain() == 0 )
		DoLoser();									// We have a loser do processing
	else
	if( m_Hangman.CheckWordCompleted() )
		DoWinner();									// We have a winner do processing
}

void CHangman32Dlg::ResetButtons()
{
	// Reset all the buttons to visible
	// Also make sure no button is a default button
    m_btn1A.SetButtonStyle( m_btn1A.GetButtonStyle() & ~BS_DEFPUSHBUTTON, FALSE );
	m_btn1A.ShowWindow(SW_SHOW);	
	m_btn2B.SetButtonStyle( m_btn2B.GetButtonStyle() & ~BS_DEFPUSHBUTTON, FALSE );
	m_btn2B.ShowWindow(SW_SHOW);
	m_btn3C.SetButtonStyle( m_btn3C.GetButtonStyle() & ~BS_DEFPUSHBUTTON, FALSE );
	m_btn3C.ShowWindow(SW_SHOW);
	m_btn4D.SetButtonStyle( m_btn4D.GetButtonStyle() & ~BS_DEFPUSHBUTTON, FALSE );
	m_btn4D.ShowWindow(SW_SHOW);
	m_btn5E.SetButtonStyle( m_btn5E.GetButtonStyle() & ~BS_DEFPUSHBUTTON, FALSE );
	m_btn5E.ShowWindow(SW_SHOW);
	m_btn6F.SetButtonStyle( m_btn6F.GetButtonStyle() & ~BS_DEFPUSHBUTTON, FALSE );
	m_btn6F.ShowWindow(SW_SHOW);
	m_btn7G.SetButtonStyle( m_btn7G.GetButtonStyle() & ~BS_DEFPUSHBUTTON, FALSE );
	m_btn7G.ShowWindow(SW_SHOW);
	m_btn8H.SetButtonStyle( m_btn8H.GetButtonStyle() & ~BS_DEFPUSHBUTTON, FALSE );
	m_btn8H.ShowWindow(SW_SHOW);
	m_btn9I.SetButtonStyle( m_btn9I.GetButtonStyle() & ~BS_DEFPUSHBUTTON, FALSE );
	m_btn9I.ShowWindow(SW_SHOW);
	m_btn10J.SetButtonStyle( m_btn10J.GetButtonStyle() & ~BS_DEFPUSHBUTTON, FALSE );	
	m_btn10J.ShowWindow(SW_SHOW);
	m_btn11K.SetButtonStyle( m_btn11K.GetButtonStyle() & ~BS_DEFPUSHBUTTON, FALSE ); 	
	m_btn11K.ShowWindow(SW_SHOW);
	m_btn12L.SetButtonStyle( m_btn12L.GetButtonStyle() & ~BS_DEFPUSHBUTTON, FALSE );	
	m_btn12L.ShowWindow(SW_SHOW);
	m_btn13M.SetButtonStyle( m_btn13M.GetButtonStyle() & ~BS_DEFPUSHBUTTON, FALSE );	
	m_btn13M.ShowWindow(SW_SHOW);
	m_btn14N.SetButtonStyle( m_btn14N.GetButtonStyle() & ~BS_DEFPUSHBUTTON, FALSE );	
	m_btn14N.ShowWindow(SW_SHOW);
	m_btn15O.SetButtonStyle( m_btn15O.GetButtonStyle() & ~BS_DEFPUSHBUTTON, FALSE );	
	m_btn15O.ShowWindow(SW_SHOW);
	m_btn16P.SetButtonStyle( m_btn16P.GetButtonStyle() & ~BS_DEFPUSHBUTTON, FALSE );	
	m_btn16P.ShowWindow(SW_SHOW);
	m_btn17Q.SetButtonStyle( m_btn17Q.GetButtonStyle() & ~BS_DEFPUSHBUTTON, FALSE );	
	m_btn17Q.ShowWindow(SW_SHOW);
	m_btn18R.SetButtonStyle( m_btn18R.GetButtonStyle() & ~BS_DEFPUSHBUTTON, FALSE );	
	m_btn18R.ShowWindow(SW_SHOW);
	m_btn19S.SetButtonStyle( m_btn19S.GetButtonStyle() & ~BS_DEFPUSHBUTTON, FALSE );	
	m_btn19S.ShowWindow(SW_SHOW);
	m_btn20T.SetButtonStyle( m_btn20T.GetButtonStyle() & ~BS_DEFPUSHBUTTON, FALSE );	
	m_btn20T.ShowWindow(SW_SHOW);
	m_btn21U.SetButtonStyle( m_btn21U.GetButtonStyle() & ~BS_DEFPUSHBUTTON, FALSE );	
	m_btn21U.ShowWindow(SW_SHOW);
	m_btn22V.SetButtonStyle( m_btn22V.GetButtonStyle() & ~BS_DEFPUSHBUTTON, FALSE );	
	m_btn22V.ShowWindow(SW_SHOW);
	m_btn23W.SetButtonStyle( m_btn23W.GetButtonStyle() & ~BS_DEFPUSHBUTTON, FALSE );	
	m_btn23W.ShowWindow(SW_SHOW);
	m_btn24X.SetButtonStyle( m_btn24X.GetButtonStyle() & ~BS_DEFPUSHBUTTON, FALSE );	
	m_btn24X.ShowWindow(SW_SHOW);
	m_btn25Y.SetButtonStyle( m_btn25Y.GetButtonStyle() & ~BS_DEFPUSHBUTTON, FALSE );	
	m_btn25Y.ShowWindow(SW_SHOW);
	m_btn26Z.SetButtonStyle( m_btn26Z.GetButtonStyle() & ~BS_DEFPUSHBUTTON, FALSE );	
	m_btn26Z.ShowWindow(SW_SHOW);
}

void CHangman32Dlg::OnGameHint() 
{
	CHintDlg hintDlg;
	CStringArray strArray;
	CString tmpStr;
	int Index;

	strArray.SetSize(10,10);	// Initialize to some size.  Ten is good for now.
	strArray.SetAtGrow(0,"If I were you I'd try the letter ");
	strArray.SetAtGrow(1,"You cheater!  Try the letter ");
	strArray.SetAtGrow(2,"The magic eight ball says to try the letter ");
	strArray.SetAtGrow(3,"Smart money is on the letter ");
	strArray.SetAtGrow(4,"You can't go wrong with the letter ");
	strArray.SetAtGrow(5,"It doesn't take a genius to know to try the letter ");
	strArray.SetAtGrow(6,"Confucius says to try the letter ");
	strArray.SetAtGrow(7,"A wise man would try the letter ");

	Index = rand() % 8;		// mod by the number of elements in strArray
	tmpStr   = strArray.GetAt( Index ) + m_Hangman.GetHintLetter() + ".";
	hintDlg.SetQuote(tmpStr);
	((CHangman32App *)AfxGetApp())->m_doAccel = FALSE;	// Block key presses
	hintDlg.DoModal();
	((CHangman32App *)AfxGetApp())->m_doAccel = TRUE;	// Allow key presses

	m_Hangman.DecrementGuessRemain();	// Subtract two for cheating
	m_Hangman.DecrementGuessRemain();
	DrawPic();							// Load in proper picture

	if( m_Hangman.GetGuessRemain() == 0 )	// Check if we hit zero
    {
		RefreshScoreDisplay();
		DoLoser();
	}

	RefreshScoreDisplay();				// Refresh everything
}

void CHangman32Dlg::RefreshScoreDisplay()
{
	char tmpStr[30];
	
	// Refresh all the text in the main dialog
	SetDlgItemText( IDC_GUESS, m_Hangman.GetCurrentGuess() );
	_itoa( m_Hangman.GetGamesPlayed(), tmpStr, 10 );
	SetDlgItemText( IDC_GAMES_PLAYED, tmpStr );
	_itoa( m_Hangman.GetGamesWon(), tmpStr, 10 );
	SetDlgItemText( IDC_GAMES_WON, tmpStr );
	_itoa( m_Hangman.GetPercentage(), tmpStr, 10 );
	SetDlgItemText( IDC_PERCENT_WON, tmpStr );	
	_itoa( m_Hangman.GetGuessRemain(), tmpStr, 10 );
	SetDlgItemText( IDC_GUESS_REMAINING, tmpStr );
}

void CHangman32Dlg::DoLoser()
{
	CGenericDlg genericDlg;
	CString tmpStr1;

	// Display what the word was to the player
	tmpStr1 = "Sorry, the word was " + m_Hangman.GetCurrentWord();
	
	genericDlg.SetQuote( tmpStr1 );
	((CHangman32App *)AfxGetApp())->m_doAccel = FALSE;	// Block key presses
	genericDlg.DoModal();
	((CHangman32App *)AfxGetApp())->m_doAccel = TRUE;	// Alllow key presses

	// Reset everything and do another round
	ResetButtons();
	m_Hangman.LoadNewWord();
	m_Hangman.IncrementGamesPlayed();
	DrawPic();
	RefreshScoreDisplay();
}

void CHangman32Dlg::DoWinner()
{
	CGenericDlg genericDlg;
	CString tmpStr1;
	char tmpStr2[30];

	_itoa( m_Hangman.GetTotalGuesses(), tmpStr2, 10 );

	// Display message to player
	tmpStr1 =  "Good job!  You won in ";
	tmpStr1 += tmpStr2;
	tmpStr1 += " guesses.";

	genericDlg.SetQuote( tmpStr1 );
	((CHangman32App *)AfxGetApp())->m_doAccel = FALSE;	// Block key presses
	genericDlg.DoModal();
	((CHangman32App *)AfxGetApp())->m_doAccel = TRUE;	// Allow key presses

	// Reset everything and do another round
	ResetButtons();
	m_Hangman.LoadNewWord();
	m_Hangman.IncrementGamesPlayed();
	m_Hangman.IncrementGamesWon();
	DrawPic();
	RefreshScoreDisplay();
}

void CHangman32Dlg::OnGameNew() 
{
	// On new game reset all variables as if just started
	m_Hangman.Reset();
	m_Hangman.LoadNewWord();
	ResetButtons();
	DrawPic();
	RefreshScoreDisplay();
}

void CHangman32Dlg::OnHelpAbouthangman32() 
{
	CAboutDlg aboutDlg;
	((CHangman32App *)AfxGetApp())->m_doAccel = FALSE;	// Block key presses
	aboutDlg.DoModal();
	((CHangman32App *)AfxGetApp())->m_doAccel = TRUE;	// Allow key presses
}

void CHangman32Dlg::DrawPic()
{
	// Just load in the picture from the resource
	switch( m_Hangman.GetGuessRemain() )
	{
		case 10 :	VERIFY(m_cntrlPic.LoadBitmaps(IDB_BITMAP10, NULL, NULL));
				    break;
		case 9  :	VERIFY(m_cntrlPic.LoadBitmaps(IDB_BITMAP9, NULL, NULL));
				    break;
		case 8  :	VERIFY(m_cntrlPic.LoadBitmaps(IDB_BITMAP8, NULL, NULL));
				    break;
		case 7  :	VERIFY(m_cntrlPic.LoadBitmaps(IDB_BITMAP7, NULL, NULL));
				    break;
		case 6  :	VERIFY(m_cntrlPic.LoadBitmaps(IDB_BITMAP6, NULL, NULL));
				    break;
		case 5  :	VERIFY(m_cntrlPic.LoadBitmaps(IDB_BITMAP5, NULL, NULL));
				    break;
		case 4  :	VERIFY(m_cntrlPic.LoadBitmaps(IDB_BITMAP4, NULL, NULL));
				    break;
		case 3  :	VERIFY(m_cntrlPic.LoadBitmaps(IDB_BITMAP3, NULL, NULL));
					break;
		case 2  :	VERIFY(m_cntrlPic.LoadBitmaps(IDB_BITMAP2, NULL, NULL));
				    break;
		case 1  :	VERIFY(m_cntrlPic.LoadBitmaps(IDB_BITMAP1, NULL, NULL));
					break;
		case 0  :	VERIFY(m_cntrlPic.LoadBitmaps(IDB_BITMAP0, NULL, NULL));	
				    break;
		default:	TRACE("CHangman32Dlg::ProcessButtonPress: Switch Default");
					break;
	}
	// Invalidate so that the new picture will get drawn
	m_cntrlPic.Invalidate();
}

void CHangman32Dlg::OnOK()
{
	// Do nothing here so that hitting return in the main
	// dialog will not exit the program
}
