#ifndef _STATE

#define MAXINVALIDATE      10  // Taille max du tableau des controles invalides.

#include "statelis.hpp"

#include "state.cfg"           // fichier de configuration dependant de l'application

class State
{
//=========== variables de classe pour la gestion
#ifdef STATE_DEBUG
  protected:
	  static int        nbAlive;    // pour faire du debug
	  static long       nbCreated;  // pour faire du debug
#endif
  public:
	  static const char* version;   // nom de la version liee aux outils de taduction
  protected:
	  static StateList* pile;
	  static void*      invalidateCtrl[MAXINVALIDATE];
	  static int        nbInvalidated;
	  /* ===== tableaux ====== */
	  static int*       tabInitial;
	  static int*       tabFinal;
	  static int*       tabAncestor;  // tableau des lignees d'etats
	  static int*       tabClassAnc;  // tableau des lignees de classes
	  static int*       tabPermise;
	  static int*       tabInterdite;
#if STATE_LIGHT == 0
	  static int*       tabExitStates;
#endif
	  /* ===================== */
  public:
          static int        ppConditionInUse; //pour eviter les recursions sur les pre/post conditions
	  static int        globalError;    // pour compenser les faiblesses du "deroulement de pile"
	  static void       warning(char*); // pour afficher des messages
#ifdef STATE_DEBUG
	  static int        getStackSize();// pour faire du debug
	  static int        getNbAlive();  // pour faire du debug
	  static long       getNbCreated();// pour faire du debug
	  static void       audit();       // pour faire de l'audit
#endif
//===============================================
  protected:
	  int*  value;
	  int   currentSize;
  protected:
		  State(State&);
  public:
		  State(int = 0);
		 ~State();
	  State*  estPermise(int classCode,int methodCode,int light);
#if STATE_LIGHT == 0
	  State*  estCorrecte(void);
#endif
	  State*  estInitial(int classCode);
	  State*  estFinal(int classCode);

	  void  display(char* = 0);
	  void  set(int,int);
	  int   rang(int stateCode);
	  int   etendre(void);
  private: // plutot des fonctions libres que de veritables methodes
	  int   etatDescendDe(int,int);
	  int   classeDefiniEtatP(int,int);
	  int   classeDefiniEtatI(int,int);
// ========== methodes de classe
  public:
  static  void  terminate(void);
#ifdef STATE_DEBUG
  static  void  memoryError(void);
#endif
  static  void  invalidateCtrlFor(void*);
  static  void  activateCtrlFor(void*);
  static  int   testActivatedFor(void*);
};

#define _STATE
#endif


