#ifdef TRACE
#include <iostream.h>
#endif

#include "statelis.hpp"
#include "stateerr.hpp"
#include "state.hpp"

/* ========== Classe "StateListElem" ========== */
StateListElem::StateListElem(State* contenuS,int contenuC)
{
  valeur    = contenuS;
  code      = contenuC;
  precedent = 0;
}

StateListElem::~StateListElem()
{
  delete valeur;
  precedent = 0;
}


/* ========== Classe "StateList" ========== */
StateList::StateList()
{
  premier = 0;
  dernier = 0;
}

StateList::~StateList()
{
  this->purge();
}

int    StateList::estVide()
{
  return (premier==0);
}

void   StateList::addLast(State* elem,int code)
{
#ifdef TRACE
  cout << "StateList::addLast" << endl;
#endif

  StateListElem* ptr = new StateListElem(elem,code);
  ptr->precedent     = dernier;
  dernier            = ptr;
  if (!premier)
  {
    premier = ptr;
  }
}

void   StateList::removeLast()
{
#ifdef TRACE
  cout << "StateList::removeLast" << endl;
#endif

  if(dernier)
  {
    if (premier==dernier)
    {
      premier = 0;
    }
    StateListElem* ptr = dernier->precedent;
    delete dernier;
    dernier = ptr;
  }
}

void   StateList::purge()
{
#ifdef TRACE
  cout << "StateList::purge" << endl;
#endif

  while(premier)
  {
    this->removeLast();
  }
}

int    StateList::size()
{
  int            result = 0;
  StateListElem* ptr    = dernier;
  while(ptr)
  {
    ptr = ptr->precedent;
    result++;
  }
  return result;
}

State* StateList::getLastState()
{
  if(dernier)
  {
    return dernier->valeur;
  }
  if (!State::globalError)
  { /* pour ne pas perdre la cause initiale de l'erreur */
    State::globalError = 5;
  }
#if STATE_USE_EXCEPT == 1
  throw  StateInternalError(5);
#else
  State::terminate();
#endif
  return (State*)0;  /* pour calmer lint */
}

int StateList::getLastCode()
{
  if(dernier)
  {
    return dernier->code;
  }
  if (!State::globalError)   
  { /* pour ne pas perdre la cause initiale de l'erreur */
    State::globalError = 5;
  }
#if STATE_USE_EXCEPT == 1
  throw  StateInternalError(5);
#else
  State::terminate();
#endif
  return -1;  /* pour calmer lint */
}
