/* ========================================================== */
/* Ce fichier contient les classes:                           */
/*  - StateList     : liste d'objets de type "StateListeElem" */
/*  - StateListElem : objets ayant pour contenu un "State"    */
/* ========================================================== */

#ifndef _STATELIST

class State; // Predeclaration necessaire

class StateListElem
{
  private:
    State*         valeur;
    int            code;
    StateListElem* precedent;
  private:
     StateListElem(State*,int);
    ~StateListElem();
  friend class StateList;
};

class StateList
{
  protected:
    StateListElem* premier;
    StateListElem* dernier;
  public:
	    StateList();
	   ~StateList();
    int     estVide();
    void    addLast(State*,int);
    void    removeLast();
    State*  getLastState();
    int     getLastCode();
    void    purge();
    int     size();
};

#define _STATELIST
#endif
