#include <classlib\arrays.h>
#include <owl\owlpch.h>
#include <owl\applicat.h>
#include <owl\decframe.h>
#include <owl\dialog.h>
#include <owl\inputdia.h>
#include <owl\controlb.h>
#include <owl\statusba.h>
#include <stdlib.h>
#include <string.h>
// === Les fichiers ci-dessous sont ajoutes A LA MAIN ===
// le traducteur ne supportant pas ce fichier !!!
#include "securdor.hpp"
#include "stateerr.hpp"
#include "statctrl.def"
#include "demowin.rc"

#define MAXNAMELEN  35

//==============================================================================
//========== DECLARATION DES CLASSES ===========================================
//==============================================================================
class KeyDlg : public TDialog
{
  private:
	 TEdit* CustomEdit;
  public:
		KeyDlg(TWindow* parent, const char* name, char* transfer):TDialog(parent, name),TWindow(parent)
		{
		  TEdit* edit    = new TEdit(this, NAMECODE_ID,MAXNAMELEN);
		  TransferBuffer = (void far*)transfer;
		}
};
//------------------------------------------------------------------------------
class ObjShape
{
  public:
		  ObjShape() {}
		 ~ObjShape() {}
	 virtual void  draw(TDC&,SecurityDoor*) = 0;
};
class ClassShape : public ObjShape
{
  protected:
	 char*  name;
	 TRect  shape;
	 TPoint point;
  public:
			 ClassShape();
			 ClassShape(int,int,int,int,int,int,char*);
			~ClassShape();
	 void  draw(TDC&,SecurityDoor*);
};
class StateShape : public ObjShape
{
  protected:
	 char*  name;
	 TRect  shape;
	 TPoint point;
	 int    stateCode;
	 int    classCode;
  public:
			 StateShape();
			 StateShape(int,int,int,int,int,int,char*,int,int);
			~StateShape();
	 void  draw(TDC&,SecurityDoor*);
};

typedef ObjShape*                PtrShape;
typedef TArray<PtrShape>         ShapeLst;
typedef TArrayIterator<PtrShape> ShapeLstIterator;

class TMyWindow : public TWindow
{
  protected:
	 ShapeLst*     listeStates;
	 SecurityDoor* securDoor;
	 char          KeyCodeName[MAXNAMELEN];
  public:
	 TMyWindow(TWindow *parent = 0);
  protected:
	 // Override member function of TDecoratedFrame
		BOOL CanClose();
		void Paint(TDC&,BOOL,TRect&);
	 // Event handlers
		void CloseWindow() {TWindow::CloseWindow(); }
		void CmOpen();
		void CmClose();
		void CmLock();
		void CmUnLock();
		void CmVersion();
		void CmAbout();
		void CmNew();
		void CmStartHelp();
	 // Others
		void Erreur();
	 DECLARE_RESPONSE_TABLE(TMyWindow);
};

DEFINE_RESPONSE_TABLE1(TMyWindow, TWindow)
  EV_COMMAND(CM_ABOUT, CmAbout),
  EV_COMMAND(CM_VERSION, CmVersion),
  EV_COMMAND(CM_EXEMPLE,CmStartHelp),
  EV_COMMAND(CM_NEW, CmNew),
  EV_COMMAND(CM_QUIT, CloseWindow),
  EV_COMMAND(CM_OPEN, CmOpen),
  EV_COMMAND(CM_CLOSE, CmClose),
  EV_COMMAND(CM_LOCK, CmLock),
  EV_COMMAND(CM_UNLOCK, CmUnLock),
END_RESPONSE_TABLE;

class TMyApp : public TApplication
{
  public:
	 TMyApp() : TApplication() {}

  protected:
	 // Override methods of TApplication
	 void InitMainWindow();

};
class TMyFrame : public TDecoratedFrame
{
  public:
	 TMyFrame(TWindow* parent,const char* far title,TWindow* clientWnd,
				 BOOL trackMenu = FALSE,TModule* module = 0)
				 : TDecoratedFrame(parent,title,clientWnd,trackMenu,module)
	 {
		Attr.W     = 420;
		Attr.H     = 345;
		Attr.Style = WS_BORDER|WS_CAPTION|WS_MINIMIZEBOX|WS_OVERLAPPED|WS_SYSMENU;
	 }
};
//==============================================================================
//========== IMPLEMENTATION DES CLASSES ========================================
//==============================================================================

// ***** classe STATE_SHAPE *****

StateShape::StateShape()
{
  name = 0;
}
StateShape::StateShape(int x1,int y1, int x2, int y2, int x3, int y3,
							  char* nom,int state,int classe)
{
  shape = TRect(x1,y1,x2,y2);
  point = TPoint(x3,y3);
  name  = new char[strlen(nom)+1];
  strcpy(name,nom);
  stateCode = state;
  classCode = classe;
}
StateShape::~StateShape()
{
  if (name)
  {
	 delete name;
  }
  name = 0;
}
void StateShape::draw(TDC& dc,SecurityDoor* securDoor)
{
  TPen * pen;
  if(securDoor)
  {
	 if (securDoor->isInState(stateCode))
	 {
		pen = new TPen(TColor::LtRed,2);
	 }
	 else
	 {
		pen = new TPen(TColor::Black,1);
	 }
  }
  else
  {
	 pen = new TPen(TColor::Gray,1);
  }
  dc.SelectObject(*pen);
  dc.MoveTo(shape.left,shape.top);
  dc.LineTo(shape.right,shape.top);
  dc.LineTo(shape.right,shape.bottom);
  dc.LineTo(shape.left,shape.bottom);
  dc.LineTo(shape.left,shape.top);
  dc.RestorePen();
  delete pen;
  dc.TextOut(point, name, strlen(name));
}
// ***** classe CLASS_SHAPE *****

ClassShape::ClassShape()
{
  name = 0;
}
ClassShape::ClassShape(int x1,int y1, int x2, int y2, int x3, int y3,
							  char* nom)
{
  shape = TRect(x1,y1,x2,y2);
  point = TPoint(x3,y3);
  name  = new char[strlen(nom)+1];
  strcpy(name,nom);
}
ClassShape::~ClassShape()
{
  if (name)
  {
	 delete name;
  }
  name = 0;
}
void ClassShape::draw(TDC& dc,SecurityDoor* securDoor)
{
  TPen * pen;
  if(securDoor)
  {
	 pen = new TPen(TColor::Black,1);
  }
  else
  {
	 pen = new TPen(TColor::Gray,1);
  }
  dc.SelectObject(*pen);
  dc.MoveTo(shape.left,shape.top);
  dc.LineTo(shape.right,shape.top);
  dc.LineTo(shape.right,shape.bottom);
  dc.LineTo(shape.left,shape.bottom);
  dc.LineTo(shape.left,shape.top);
  dc.RestorePen();
  delete pen;
  pen = new TPen(TColor::Gray,1);
  dc.MoveTo(shape.left,shape.top+27);
  dc.LineTo(shape.right,shape.top+27);
  dc.RestorePen();
  delete pen;
  dc.TextOut(point, name, strlen(name));
}

// ***** classe TMYWINDOW *****

TMyWindow::TMyWindow(TWindow *parent)
{
  Init(parent, 0, 0);

  StateShape* etat;
  ClassShape* classe;
  listeStates = new ShapeLst(10, 0, 10);
  classe = new ClassShape(10,40,410,120,15,45,"DOOR");
  listeStates->Add(classe);
  etat = new StateShape(20,80,100,110,30,85,"Open",position_open,Door_Code);
  listeStates->Add(etat);
  etat = new StateShape(110,80,400,110,220,85,"Closed",position_closed,Door_Code);
  listeStates->Add(etat);
  classe = new ClassShape(10,130,410,250,15,135,"SECURITY DOOR");
  listeStates->Add(classe);
  etat = new StateShape(20,170,100,200,30,175,"Open",position_open,SecurityDoor_Code);
  listeStates->Add(etat);
  etat = new StateShape(20,210,100,240,30,215,"Open",position_open,SecurityDoor_Code);
  listeStates->Add(etat);
  etat = new StateShape(110,170,400,200,220,175,"Closed",position_closed,SecurityDoor_Code);
  listeStates->Add(etat);
  etat = new StateShape(110,210,240,240,155,215,"Locked",position_locked,SecurityDoor_Code);
  listeStates->Add(etat);
  etat = new StateShape(250,210,400,240,295,215,"Unlocked",position_unlocked,SecurityDoor_Code);
  listeStates->Add(etat);
  securDoor = (SecurityDoor*)0;

  new TButton(this, CM_OPEN,  "Open",   10,  5, 100, 30, FALSE);
  new TButton(this, CM_CLOSE, "Close",  110, 5, 100, 30, FALSE);
  new TButton(this, CM_LOCK,  "Lock",   210, 5, 100, 30, FALSE);
  new TButton(this, CM_UNLOCK,"Unlock", 310, 5, 100, 30, FALSE);

  strcpy(KeyCodeName,"125");
}
BOOL TMyWindow::CanClose()
{
  int choix;
  if (securDoor)
  {
	 choix = MessageBox("Deleting the present security door?","Creating a Security door",MB_YESNO | MB_ICONQUESTION);
	 if (choix==IDYES)
	 {
		delete securDoor;
		securDoor = 0;
		return TRUE;
	 }
	 else
	 {
		return FALSE;
	 }
  }
  else
  {
	 return TRUE;
  }
}
void TMyWindow::Erreur()
{
  MessageBox("Action unavailable as no dor has been created","ERROR",MB_OK | MB_ICONEXCLAMATION);
}
void TMyWindow::CmStartHelp()
{
  WinHelp("demowin.hlp", HELP_INDEX, 0);
}
void TMyWindow::CmOpen()
{
  if(securDoor)
  {
	 securDoor->openDoor();
	 Invalidate();
  }
  else
  {
	 Erreur();
  }
}
void TMyWindow::CmClose()
{
  if(securDoor)
  {
	 securDoor->closeDoor();
	 Invalidate();
  }
  else
  {
	 Erreur();
  }
}
void TMyWindow::CmLock()
{
  if(securDoor)
  { KeyDlg* theDlg= new KeyDlg(this,"KEY_INFO", KeyCodeName);
	 if (theDlg->Execute() == IDOK)
	 {
		securDoor->lockDoor(atoi(KeyCodeName));
		Invalidate();
	 }
  }
  else
  {
	 Erreur();
  }
}
void TMyWindow::CmUnLock()
{
  if(securDoor)
  { KeyDlg* theDlg= new KeyDlg(this,"KEY_INFO", KeyCodeName);
	 if (theDlg->Execute() == IDOK)
	 {
		securDoor->unlockDoor(atoi(KeyCodeName));
		Invalidate();
	 }
  }
  else
  {
	 Erreur();
  }
}

void TMyWindow::CmAbout()
{
  TDialog(this, IDD_ABOUT).Execute();
}
void TMyWindow::CmVersion()
{
  char msgBuff [100];
  strcpy(msgBuff,"Object Oriented programming with States\n");
  strcat(msgBuff,State::version);
  MessageBox(msgBuff,"OOPS Toolset",MB_OK | MB_ICONINFORMATION);
}

void TMyWindow::CmNew()
{
  int choix;
  if (securDoor)
  {
	 choix = MessageBox("Delete the present Security Door?","Create New Security Door",MB_YESNO | MB_ICONQUESTION);
	 if (choix==IDYES)
	 { char string[10];
		char buffer[125];
		strcpy(buffer,"door code: ");
		itoa(securDoor->getKeyNumber(),string,10);
		strcat(buffer,string);
		MessageBox(buffer,"Deleting Security Door",MB_OK | MB_ICONINFORMATION);
		delete securDoor;
		securDoor = (SecurityDoor*)0;
		KeyDlg* theDlg= new KeyDlg(this,"KEY_INFO", KeyCodeName);
		if (theDlg->Execute() == IDOK)
		{
		  securDoor = new SecurityDoor(atoi(KeyCodeName));
		}
		Invalidate();
	 }
  }
  else
  {
	 KeyDlg* theDlg= new KeyDlg(this,"KEY_INFO", KeyCodeName);
	 if (theDlg->Execute() == IDOK)
	 {
		securDoor = new SecurityDoor(atoi(KeyCodeName));
		Invalidate();
	 }
  }
}

void TMyWindow::Paint(TDC& dc, BOOL, TRect&)
{
  ShapeLstIterator i(*listeStates);
  while (i)
  {
	 PtrShape ptrSt = i++;
	 ptrSt->draw(dc,securDoor);
  }
}

// ***** classe TMYAPP *****

void TMyApp::InitMainWindow()
{
  // Construct the decorated frame window
  //TDecoratedFrame* frame = new TDecoratedFrame(0, "DOCUMENT", new TMyWindow, TRUE);
  TMyFrame* frame = new TMyFrame(0, "SECURITY DOOR", new TMyWindow, TRUE);

  // Construct a status bar
  TStatusBar* sb = new TStatusBar(frame, TGadget::Recessed);

  // Insert the status bar and control bar into the frame
  frame->Insert(*sb, TDecoratedFrame::Bottom);

  // Set the main window and its menu
  SetMainWindow(frame);
  GetMainWindow()->AssignMenu("COMMANDS");
  // Set the ICON
  GetMainWindow()->SetIcon(this,"OOPSDEMO");
}

//==============================================================================
//========== PROGRAMME PRINCIPAL ===============================================
//==============================================================================

int OwlMain(int /*argc*/, char* /*argv*/ [])
{
#ifdef BEHAVIOR_CTRL_ON
  BEGIN_BEHAVIOR_CTRL
  return TMyApp().Run();
  END_BEHAVIOR_CTRL
#else
  MessageBox(0,"Error: No state control inserted !!!","Object Oriented Programming with States",MB_OK | MB_ICONSTOP);
#endif
}



