LPBITMAPINFO LoadDIB(LPSTR pszPath);
void DeleteDIB(LPBITMAPINFO pDIB);
BOOL IsWinDIB(LPBITMAPINFOHEADER pBIH);
WORD NumDIBColorEntries(LPBITMAPINFO lpBmpInfo);
char HUGE *GetDIBPixelAddress(LPBITMAPINFO pDIB, cpix x, cpix y);
short GetDIBPixelValue(LPBITMAPINFO pDIB, cpix x, cpix y);
rcode SetDIBPixelValue(LPBITMAPINFO pDIB, cpix x, cpix y,uchar val);
COLORREF GetDIBPixelColor(LPBITMAPINFO pDIB, cpix x, cpix y);
void DumpDIB(LPBITMAPINFO pDIB);
void DumpDIBRGB(LPBITMAPINFO pDIB);
LPBITMAPINFO CreateCompatibleDIB(LPBITMAPINFO pOld);

//
// macros to access the fields in a BITMAPINFO struct
// field_value = macro(pBitmapInfo)
//

#define BI_WIDTH(pBI)       (int)((pBI)->bmiHeader.biWidth)
#define BI_HEIGHT(pBI)      (int)((pBI)->bmiHeader.biHeight)
#define BI_PLANES(pBI)      ((pBI)->bmiHeader.biPlanes)
#define BI_BITCOUNT(pBI)    ((pBI)->bmiHeader.biBitCount)
#define BI_CLRUSED(pBI)     ((pBI)->bmiHeader.biClrUsed)

//
// macros to access BITMAPINFO fields in a DIB
// field_value = macro(pDIB)
//

#define DIB_WIDTH(pDIB)     (BI_WIDTH((LPBITMAPINFO)(pDIB)))
#define DIB_HEIGHT(pDIB)    (BI_HEIGHT((LPBITMAPINFO)(pDIB)))
#define DIB_PLANES(pDIB)    (BI_PLANES((LPBITMAPINFO)(pDIB)))
#define DIB_BITCOUNT(pDIB)  (BI_BITCOUNT((LPBITMAPINFO)(pDIB)))
#define DIB_CLRUSED(pDIB)   (BI_CLRUSED((LPBITMAPINFO)(pDIB)))
#define DIB_COLORS(pDIB)    (NumDIBColorEntries((LPBITMAPINFO)(pDIB)))
#define DIB_PCLRTAB(pDIB)   ((LPRGBQUAD)(((LPSTR)((LPBITMAPINFO)(pDIB))) \
                            + sizeof(BITMAPINFOHEADER)))
#define DIB_BISIZE(pDIB)    (sizeof(BITMAPINFOHEADER) \
                            + DIB_COLORS(pDIB) * sizeof(RGBQUAD))
#define DIB_PBITS(pDIB)     (((LPSTR)((LPBITMAPINFO)(pDIB))) \
                            + DIB_BISIZE(pDIB))
#define DIB_PBI(pDIB)       ((LPBITMAPINFO)(pDIB))
#define DIB_STORAGEWIDTH(pDIB) ((DIB_WIDTH(pDIB) + 3) & ~3)

WORD NumDIBColorEntries(LPBITMAPINFO lpBmpInfo) ;
