#ifndef _SNDCHAN_H_
#define _SNDCHAN_H_

#include "expdef.h"

#include "explib.h"

class   WaveInfo    {

 public:

    ushort  nchannels;  // 1 = mono, 2 = stereo
    ushort  speed;      // in samples per second

    uchar   HUGE *sdata;    // sample data RAM adress
    char    *name;          // OR filename

    lsize_t ssize;      // sample data size 

    WaveInfo()  {sdata=0; name=0; ssize=0;}

    };

ulong   ChanManVersion(void);
rcode   OpenChanMan(WaveInfo FAR * parms = 0, uchar stereo = 1);
void    CloseChanMan();
rcode   ChanManPlay(WaveInfo FAR * wi, ulong howoften = 1, ulong opts = 0);
void    ChanManStop(WaveInfo FAR * wi = 0);
//short ChanManVolume(short newvol = -1); // not yet supported

//  playing options:

#   define  SND_PLAYLEFT    (1<<0)
#   define  SND_PLAYRIGHT   (1<<1)

#endif  // not already included
