#include "ledit.h"
#include "ledit_2.h"

#define NOTHING_OPEN   "  No open files"
#define INSERT_MODE    "Insert"
#define OVERWRITE_MODE "Overwrite"
#define MODIFIED       "Modified"
#define UNMODIFIED     ""
#define LINE_INFO      "  Line: %ld   Position: %d"
#define MAGIC          1233218 

typedef struct tagPOS
  {
    DWORD Line;
    WORD  Pos;
  }
  POS;

static MSG Msg;
static LONG Header = (LONG)
"LEdit-Ask-User-TXT/Header files/*.h/C++ source/*.cpp/Pascal source/*.pas/\
Text files/*.txt/All files/*.*";
static HWND WndClient;                // Client window
static HWND WndModify;                // "Modify" part of status bar
static HWND WndInsert;                // "Insert" part of status bar
static HWND WndStatus;                // The rest of status bar
static WORD StatusBarHeight;
static WORD InsertWidth;
static WORD NumWin  = 0;
static WORD InsertMode = EMP_SET;
static HINSTANCE  hInst;
static char Buffer[64];

// CanClose determines if the application can be closed by asking
// all LEdit children
WORD CanClose (void)
{
  // Take first child
  HWND Child = GetWindow(WndClient, GW_CHILD);
  while ( Child )
    {
      // If this is LEdit then ask it if it is possible to close now
      if (SendMessage(Child,EM_ISLEDITWINDOW,0,MAGIC) == (MAGIC + 1) )
	{
	  if ( !SendMessage(Child,EM_CLOSE,0,0L) )
	    return FALSE; 
	}

      // Take next child 
		Child = GetWindow(Child, GW_HWNDNEXT);
	 }
  return TRUE;
}

// Main frame function
LRESULT CALLBACK _export FrameProc (HWND     Wnd,
					 UINT     Msg,
					 WORD     wParam,
					 DWORD    lParam)
{
  switch (Msg)
	 {
		case WM_CREATE:
		  {
			 // Create MDI Client
	  CLIENTCREATESTRUCT csClient;
	  csClient.hWindowMenu  = GetSubMenu(GetMenu(Wnd),4);
	  csClient.idFirstChild = START_WIN + 1;
	  WndClient = CreateWindow("MDICLIENT",
					NULL,
					WS_CHILD | WS_CLIPCHILDREN | WS_VISIBLE |
					WS_HSCROLL | WS_VSCROLL,
					0,0,0,0,
					Wnd, 4, hInst, &csClient);

			 // Create status bar windows
	  WndModify = CreateWindow("STATIC",
					NULL,
					WS_CHILD | WS_VISIBLE | WS_BORDER
					| SS_CENTER,
					0,0,0,0,
					Wnd, -1, hInst, NULL);
	  WndInsert = CreateWindow("STATIC",
					INSERT_MODE,
					WS_CHILD | WS_VISIBLE | WS_BORDER
					| SS_CENTER,
					0,0,0,0,
					Wnd, -1, hInst, NULL);
	  WndStatus = CreateWindow("STATIC",
					NOTHING_OPEN,
					WS_CHILD | WS_VISIBLE | WS_BORDER,
					0,0,0,0,
					Wnd, -1, hInst, NULL);
			 break;
		  }
		case WM_SIZE:
	{
			 // Move MDI client
			 MoveWindow(WndClient,0,0,
			  LOWORD(lParam),HIWORD(lParam)-StatusBarHeight,FALSE);

			 // Move status bar windows
			 MoveWindow(WndModify,0,HIWORD(lParam)-StatusBarHeight,
			  InsertWidth,StatusBarHeight,FALSE);
			 MoveWindow(WndInsert,InsertWidth,HIWORD(lParam)-StatusBarHeight,
			  InsertWidth,StatusBarHeight,FALSE);
			 MoveWindow(WndStatus,InsertWidth*2,HIWORD(lParam)-StatusBarHeight,
			  LOWORD(lParam)-2*InsertWidth,StatusBarHeight,FALSE);

			 // Don't call DefFrameProc()
			 return 0;
		  }
		case WM_COMMAND:
		  {
	  switch ( wParam )
		 {
			case EC_FILENEW:
			case EC_FILEOPEN:
		{
						// Create LEdit child
		  MDICREATESTRUCT csWindow;
		  csWindow.szClass  = "LEdit";
		  csWindow.szTitle  =
			 ( wParam == EC_FILEOPEN ) ? (LPSTR) Header : NULL;
		  csWindow.hOwner   = hInst;
		  csWindow.x        = CW_USEDEFAULT;
		  csWindow.y        = CW_USEDEFAULT;
		  csWindow.cx       = CW_USEDEFAULT;
		  csWindow.cy       = CW_USEDEFAULT;
		  csWindow.style    = WS_HSCROLL | WS_VSCROLL |
									 ES_MDICHILD | ES_CANCHANGEFONT |
						ES_USESHORTNAME | ES_FILELOWER;
		  csWindow.lParam   = NULL;
				 HWND Child = SendMessage(WndClient,WM_MDICREATE,0,
			 (LONG) &csWindow);

		  if ( Child )
			 {
							 // Change a little LEdit behaviour
				SendMessage(Child,EM_SETFILEFILTER,0,Header+15);
				SendMessage(Child,EM_SETFONT,
				  GetStockObject(DEVICE_DEFAULT_FONT),0L);
				SendMessage(Wnd,EM_SETSYNTAX,0,1);
#include "ledit__s.inc"
				SetFocus(Child);
			 }
		  return 0;
			  }
			case EC_WINDOWTILE:
		{
						// Tile children
		  SendMessage(WndClient,WM_MDITILE,0,0L);
						return 0;
			  }
			case EC_WINDOWCASCADE:
		{
						// Cascade children
		  SendMessage(WndClient,WM_MDICASCADE,0,0L);
                  return 0;
	        }
	      case EC_WINDOWICONS:
		{
                  // Arrange icons
		  SendMessage(WndClient,WM_MDIICONARRANGE,0,0L);
                  return 0;
	        }
	      case EC_WINDOWCLOSEALL:
		{
                  // If it's impossible to close then do nothing
		  if ( !CanClose() )
		    return 0;

                  // Take first child
		  HWND Child = SendMessage(WndClient,WM_MDIGETACTIVE,0,0L);
		  while ( Child )
		    {
                      // Destroy the child
		      SendMessage(WndClient,WM_MDIDESTROY,Child,0L);

                      // Take next child
		      Child = SendMessage(WndClient,WM_MDIGETACTIVE,0,0L);
		    }
                  return 0;
                }
	      case EC_HELPABOUT:
		{
                  // Show copyright message
		  MessageBox(Wnd,
		    "LEdit MDI demonstration\r\n(c) 1995 Andrey B. Yastrebov",
                    "About LEDIT_E2",MB_OK | MB_ICONINFORMATION);
                  return 0;
                }
	      case EC_FILEEXIT:
		{
                  // Close the window if it's possible
		  SendMessage(Wnd,WM_CLOSE,0,0L);
                  return 0;
                }
	    }
	  if ( (wParam > START_WIN) && (wParam < END_WIN) )
	    {
              // Handle LEdit notifications
	      switch ( HIWORD(lParam) )
	        {
		  case EN_SETFOCUS:
                    // Set insertion mode according to current state
		    SendMessage(LOWORD(lParam),EM_SETINSERTMODE,
		      InsertMode,0L);
                    // Pass next to change status bar
		  case EN_CHANGE:
		    {
                      // Show modify status
		      WORD MStatus =
		        SendMessage(LOWORD(lParam),EM_GETMODIFY,0,0L);
		      SetWindowText(WndModify,
			(MStatus) ? MODIFIED : UNMODIFIED);

                      // Show current position
		      POS CurPos;
		      LEDITPOSITION LPos;
		      SendMessage(LOWORD(lParam),EM_GETSEL,0,(LONG) &LPos);
		      CurPos.Line = LPos.EndLine;
		      CurPos.Pos  = LPos.EndPosition;
		      wvsprintf((LPSTR) &Buffer,LINE_INFO,&CurPos);
		      SetWindowText(WndStatus, (LPSTR) &Buffer);
		      break;
                    }
		  case EN_INSERTMODE:
		    {
		      // Change insertion mode and show it
                      InsertMode = EMP_SET;
		      SetWindowText(WndInsert,INSERT_MODE);
                      break;
                    }
		  case EN_OVERWRITEMODE:
		    {
		      // Change insertion mode and show it
		      InsertMode = EMP_CLEAR;
		      SetWindowText(WndInsert,OVERWRITE_MODE);
                      break;
		    } 
		  case EN_CREATED:
		    {
                      // Increase number of LEdit windows
		      NumWin++;
                      break;
                    }
	          case EN_DESTROY:
		    {
                      // Decrease number of LEdit windows
		      NumWin--;

                      // Correct status bar view if there are no windows
		      if ( !NumWin )
		        SetWindowText(WndModify,NULL);
		        SetWindowText(WndStatus,NOTHING_OPEN);
                      break;
		    } 
		}

	      // Return zero for all unhanled LEdit notifications
              // because DefFrameProc () does it wrong
			if ( HIWORD(lParam) != 0 )
			  return 0;
	    }
	  else
	    {
              // pass the Comand to active MDI child
	      if ( NumWin )
	        {
		  HWND Child = SendMessage(WndClient,WM_MDIGETACTIVE,0,0L);
	          SendMessage(Child,WM_COMMAND,wParam,lParam);
                }
            }
          break;
        }
      case WM_INITMENU:
        {
	  if ( NumWin )
	    {
              // Let active LEdit window works with menu
              HWND Child = SendMessage(WndClient,WM_MDIGETACTIVE,0,0L);
	      SendMessage(Child,EM_ENABLEMENU,wParam,0L);
	    }
	  else

            // Disable all menu items
	    DisableMenu(wParam);
	  break;
        }
      case WM_CLOSE:
      case WM_QUERYENDSESSION:
	{
	  // If LEdit windows report that they can be closed
          // then let DefFrameProc() decides
          if ( CanClose() )
	    break;

          // Otherwise don't allow to close
          return 0;
        }
      case WM_DESTROY:
	{
          // Stop the application
	  PostQuitMessage(0);
	  break;
        }
    }
  // Call DefFrameProc() for the rest of messages
  return DefFrameProc(Wnd,WndClient,Msg,wParam,lParam);
}

// Main Windows function
#pragma argsused
int PASCAL WinMain (HINSTANCE hInstance,
		    HINSTANCE hPrevInst,
		    LPSTR     lpszCmdLine,
		    int       nCmdShow)

{
  // To ensure static loading of LEDIT.DLL
  LVer();

  // Don't allow multiple instances
  if ( hPrevInst != 0 )
    return 0;

  // Determine constants
  hInst = hInstance;
  StatusBarHeight = GetSystemMetrics(SM_CYMENU);
  InsertWidth = GetSystemMetrics(SM_CXVSCROLL)*8;

  // Register frame window class
  WNDCLASS wc;
  wc.style         = CS_HREDRAW | CS_VREDRAW;
  wc.lpfnWndProc   = (WNDPROC) FrameProc;
  wc.cbClsExtra    = 0;
  wc.cbWndExtra    = 0;
  wc.hInstance     = hInstance;
  wc.hIcon         = LoadIcon(0,IDI_APPLICATION);
  wc.hCursor       = LoadCursor(0,IDC_ARROW);
  wc.hbrBackground = (HBRUSH) (COLOR_APPWORKSPACE + 1);
  wc.lpszMenuName  = "STD_MDI_MENU";
  wc.lpszClassName = "LEditFrame";
  RegisterClass(&wc);

  // Create main window
  HWND Wnd = CreateWindow("LEditFrame",
			  "MDI Editor",
			  WS_OVERLAPPEDWINDOW,
			  CW_USEDEFAULT, CW_USEDEFAULT,
			  CW_USEDEFAULT, CW_USEDEFAULT,
			  0, 0, hInstance, NULL);
  if ( Wnd )
    {
      // Show window
      ShowWindow(Wnd,SW_SHOW);

      // Run message loop
      while ( GetMessage(&Msg,0,0,0) )
        {
	  if ( !TranslateMDISysAccel(WndClient,&Msg) )
            {
              TranslateMessage(&Msg);
	      DispatchMessage(&Msg);
            }
        }
    }
return 0;
}