/*  Project leowl_3
    xor@hawk.usr.pu.ru
    Copyright  1996. Andrey B. Yastrebov. All Rights Reserved.

    SUBSYSTEM:    leowl_3.exe Application
    FILE:         leowl_3d.cpp
    AUTHOR:       Andrey B. Yastrebov


    OVERVIEW
    ========
    Source file for implementation of leowl_3Dialog (TDialog).
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include "leowl_3.h"
#include "leowl_3d.h"


//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(leowl_3Dialog, TDialog)
//{{leowl_3DialogRSP_TBL_BEGIN}}
    EV_BN_CLICKED(IDB_TEXT1TO2, Text_1_to_2),
    EV_BN_CLICKED(IDB_TEXT2TO1, Text_2_to_1),
    EV_BN_CLICKED(IDB_SEL1TO2, Sel_1_to_2),
    EV_BN_CLICKED(IDB_SEL2TO1, Sel_2_to_1),
//{{leowl_3DialogRSP_TBL_END}}
END_RESPONSE_TABLE;


//{{leowl_3Dialog Implementation}}


//////////////////////////////////////////////////////////
// leowl_3Dialog
// ==========
// Construction/Destruction handling.
leowl_3Dialog::leowl_3Dialog (TWindow *parent, TResId resId, TModule *module)
    : TDialog(parent, resId, module)
{
   LEdit1 = new TLEdit(this,ID_LEDIT1);
   LEdit2 = new TLEdit(this,ID_LEDIT2);
}


leowl_3Dialog::~leowl_3Dialog ()
{
    Destroy();
}


void leowl_3Dialog::Text_1_to_2 ()
{
    HANDLE H = LEdit1->GetText();
    if (H)
      {
        LEdit2->SetText(H);
        GlobalFree(H);
      }
    LEdit2->SetFocus();
}


void leowl_3Dialog::Text_2_to_1 ()
{
    HANDLE H = LEdit2->GetText();
    if (H)
      {
        LEdit1->SetText(H);
        GlobalFree(H);
      }
    LEdit1->SetFocus();
}


void leowl_3Dialog::Sel_1_to_2 ()
{
    if (LEdit1->IsSelection())
      {
        HANDLE H = LEdit1->GetSelText();
        if (H)
          {
            LEdit2->SetSelText(H);
            GlobalFree(H);
          }
      }
    else
      LEdit2->DeleteSelection();
    LEdit2->SetFocus();
}


void leowl_3Dialog::Sel_2_to_1 ()
{
    if (LEdit2->IsSelection())
      {
        HANDLE H = LEdit2->GetSelText();
        if (H)
          {
            LEdit1->SetSelText(H);
            GlobalFree(H);
          }
      }
    else
      LEdit1->DeleteSelection();
    LEdit1->SetFocus();

}

