// SetDPI 1.10
// written by Thomas Lopatic 1995-08-21
// This program is beerware and if you are using it, you are completely
// on your own. No responsibilities are taken for anything.

#define STRICT
#include <windows.h>
#include <toolhelp.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

/* open a debug window? */
#undef DEBUG

/* adjust values close to 96 or 120 dpi? some drivers need this. dunno why. */
/* [117, 132] -> 120, [94, 106] -> 96 */
#define ROUND

#define NUMVALS 5

char app_name[] = "SetDPI 1.10 by Thomas Lopatic";

int SetScreenCaps (int cap, int new_val)
{
	HDC dc;
	int old_vals[NUMVALS], res, ret_val = 0, i, old_val;
	long p, a, c;
	SYSHEAPINFO shi;
	LOCALENTRY le;
	WINDEBUGINFO wdi;

	if ((dc = GetDC (0)) != 0) {
		for (i = 0; i < NUMVALS; old_vals[i++] = GetDeviceCaps (dc, i * 2));
		shi.dwSize = sizeof (shi);

		if (SystemHeapInfo (&shi) != 0) {
			le.dwSize = sizeof (le);

			if (LocalFirst (&le, shi.hGDISegment) != 0) {
				do {
					if (le.wSize < cap + 2)
						continue;

					a = (p = (((long)shi.hGDISegment) << 16) + le.wAddress);
					a += le.wSize - cap;

					do {
						do {
							for (i = 0; i < NUMVALS && *((int far *)(p + i * 2)) == old_vals[i]; i++);
							p += 2;
						 } while (i < NUMVALS && p < a);

						 if (i == NUMVALS) {
							c = p + cap - 2;
							if (*(int far *)c == GetDeviceCaps (dc, cap)) {
								old_val = *(int far *)c;
								*(int far *)c = new_val;
								if (GetDeviceCaps (dc, cap) == new_val)
									ret_val = 1;
								else
									*(int far *)c = old_val;
							}
						}
					} while (p < a && ret_val == 0);
				} while (LocalNext (&le) != 0 && ret_val == 0);

				if (ret_val != 1)
					MessageBox (0, "Sorry! This program does not run with your version of Windows."
						" It has been tested with Windows 3.1, Windows for Workgroups 3.11 and"
						" a beta version of Windows 95.", app_name, MB_OK);

			} else
				MessageBox (0, "Cannot locate first object on the GDI heap.",
					app_name, MB_OK);
		} else
			MessageBox (0, "Cannot get info for the USER and GDI heaps.",
				app_name, MB_OK);

		ReleaseDC (0, dc);

	} else
		MessageBox (0, "Cannot get the device context for the screen.",
			app_name, MB_OK);

	return ret_val;
}

int pascal WinMain (HINSTANCE inst, HINSTANCE prev, LPSTR line, int show)
{
	HDC dc;
	int cx, cy, match, sx, sy;

	static int xdpi, ydpi, x, y, quiet;
	static struct options {
		char *key; int *val; int init;
	} options[] = {
		{ "xdpi", &xdpi, 0 },
		{ "ydpi", &ydpi, 0 },
		{ "x", &x, 0 },
		{ "y", &y, 0 },
		{ "quiet", &quiet, 0 },
		{ 0, 0, 0 }
	};

	int i, k, l;
	char buff[100];

	for (l = 0; options[l].key != 0; l++)
		*options[l].val = options[l].init;

	i = 0;
	match = 1;

	while (line[i] != 0) {
		while (line[i] != 0 && line [i] != '/')
			i++;
		if (line[i] != 0) {
			for (k = 0; k < sizeof (buff) - 1 && line[i] != 0 && line[i] != 32 && line[i] != 9; k++, i++)
				buff[k] = line[i];
			buff[k] = 0;
			if (buff[0] != '/' && buff[0] != 0){
				MessageBox (0, "Command line options must begin with a '/'.",
					app_name, MB_OK);
				match = 0;
				break;
			} else
				if (buff[0] != 0) {
					for (k = 0; buff[k] != 0 && buff[k] != ':'; k++);
					if (buff[k] != ':') {
						MessageBox (0, "Illegal command line option.", app_name, MB_OK);
						match = 0;
						break;
					} else {
						buff[k] = 0;
						for (l = 0; options[l].key != 0 && stricmp (options[l].key, &buff[1]) != 0; l++);
						if (options[l].key == 0) {
							MessageBox (0, "Unknown command line option.", app_name, MB_OK);
							match = 0;
							break;
						} else
							*options[l].val = atoi (&buff[k + 1]);
					}
				}
		}
	}

	if (match != 0) {
		dc = GetDC (0);
		cx = GetDeviceCaps (dc, HORZRES);
		cy = GetDeviceCaps (dc, VERTRES);
		ReleaseDC (0, dc);

		if (xdpi == 0 && ydpi != 0)
			xdpi = ydpi;

		if (ydpi == 0 && xdpi != 0)
			ydpi = xdpi;

		if ((x == 0 && y != 0) || (x != 0 && y == 0))
			MessageBox (0, "You specified /x without /y or /y without /x.", app_name, MB_OK);
		else
			if (xdpi == 0)
				MessageBox (0, "You must at least specify either /xdpi or /ydpi.", app_name, MB_OK);
			else {
				if (x != 0) {
					xdpi = ((long)xdpi * (long)cx) / (long)x + 1;
					ydpi = ((long)ydpi * (long)cy) / (long)y + 1;
				}
#ifdef ROUND
				if (xdpi >= 117 && xdpi <= 132)
					xdpi = 120;
				else
					if (xdpi >= 94 && xdpi <= 106)
						xdpi = 96;

				if (ydpi >= 117 && ydpi <= 132)
					ydpi = 120;
				else
					if (ydpi >= 94 && ydpi <= 106)
						ydpi = 96;
#endif
				sx = ((long)cx * 254L) / ((long)xdpi * 10L);
				sy = ((long)cy * 254L) / ((long)ydpi * 10L);
#ifdef DEBUG
				{
					sprintf (buff, "%d mm x %d mm", sx, sy);
					MessageBox (0, buff, "Debug", MB_OK);
					for (l = 0; options[l].key != 0; l++) {
						sprintf (buff, "%s = %d", options[l].key, *options[l].val);
						MessageBox (0, buff, "Debug", MB_OK);
					}
				}
#endif
				if (SetScreenCaps (HORZSIZE, sx) != 0 && SetScreenCaps (VERTSIZE, sy) != 0 &&
						SetScreenCaps (LOGPIXELSX, xdpi) != 0 &&
						SetScreenCaps (LOGPIXELSY, ydpi) != 0 && quiet == 0) {
					sprintf (buff, "%d mm x %d mm, %d DPI x %d DPI", sx, sy, xdpi, ydpi);
					MessageBox (0, buff, app_name, MB_OK);
				}
			}
	}

	return 0;
}

