typedef struct _tagNewExeFormat
{										// Offset (from beginning of Windows header)
										//			  - and usage
	int		wSignature;			// 0h	- should be 'NE'' (0x454e)
	BYTE		cLinkVersion;		// 02h - Linker version number
	BYTE		cLinkRevision;		// 03h - Linker revision number
	int		wEntryTableOffset;// 04h - Offset to the Entry table
	int		wEntryTableSize;	//	06h - length of the entry table in bytes
	DWORD		dwReserved; 		// 08h - Reserved DWORD
	WORD		wFlags;        	// 0Ch - Flags that describe the contents of the executable file

/*
Bit	Meaning
0	The linker sets this bit if the executable-file format is SINGLEDATA. An executable file with this format contains one data
	segment. This bit is set if the file is a dynamic-link library (DLL).
1	The linker sets this bit if the executable-file format is MULTIPLEDATA. An executable file with this format contains multiple
	data segments. This bit is set if the file is a Windows application.

	If neither bit 0 nor bit 1 is set, the executable-file format is NOAUTODATA. An executable file with this format does not
	contain an automatic data segment.

2	Reserved.
3	Reserved.
8	Reserved.
9	Reserved.
11	If this bit is set, the first segment in the executable file contains code that loads the application.
13	If this bit is set, the linker detects errors at link time but still creates an executable file.
14	Reserved.
15	If this bit is set, the executable file is a library module.
*/
	WORD		wAutoDataSegNum; 	// 0Eh - autoomatic data segment number (0Eh is 0
										//			if  the SINGLEDATA and MULTIPLEDATA bits are cleared
	WORD		wHeapSize;			// 10h - initial size (in bytes) of the local heap
	WORD		wStackSize;			// 12h - initial size of the stack.  This value is zero if
										//			SS!=DS
	DWORD		dwCS_IP;				// 014h -segment:offset value of CS:IP
	DWORD    dwSS_SP;				// 018h -segment:offset value of SS:SP
										// 		the value specified in SS is an index to the module's
										// 		segment table. The first entry in the segment table
										//			corresponds to segment number 1
										//			If SS addresses the automatic data segment and SP is
										//			0, SP is set to the address obtained by adding the size
										//			of the automatic datasegment (wHeapSize-I think) to the
										//			size of the stack (wStackSize)
	WORD		wSegmentEntries;	// 1Ch - number of entries in the segment table
	WORD		wModuleReferenceEntries;//1Eh - number of entries in the module-reference table
	WORD		wNonResidentNameSize;// 20h - number of bytes in the nonresident-name table
	WORD		wSegmentOffset;	// 22h - 22h to 2Ch specify relative offsets (from beginning of Windows header)
	WORD		wResourceOffset;  //	24h -	to various tables (SegmentOffset table, Resource table, etc)
	WORD		wResidentNamesOffset;// 26h -
	WORD		wModuleReferenceOffset;// 28h -
	WORD		wImportedNamesOffset;// 2Ah -
	WORD		wMoveableEntryPoints;// 30h - number of moveable entry points
	WORD		wShiftCount;	  	// 32h - a shift count that is used to align the logical sector. (see SDK)
	WORD		wResourceSegments;// 34h - the number of resource segments
	BYTE    	cOS;					// 36h - specifies the operating system
/*

Bit	Meaning

0	Operating system format is unknown.
1	Reserved.
2	Operating system is Microsoft Windows.
3	Reserved.
4	Reserved.
*/
	BYTE		cInfoEx;				// 37h - additional information about the executable file. It can be one or more of the following values:
/*
Bit	Meaning

1	If this bit is set, the executable file contains a Windows 2.x application that runs in version 3.x protected mode.
2	If this bit is set, the executable file contains a Windows 2.x application that supports proportional fonts.
3	If this bit is set, the executable file contains a fast-load area.
*/
	WORD		wFastLoadOffset;	// 38h - offset (in SECTORS) to the fast load area
	WORD		wFastLoadSize;		// 3Ah - Size (in SECTORS) of the fast-load area
	WORD    	wReserved;			// 3Ch - Reserved WORD
	WORD		wExpectedVersion;	// 3Eh - The expected Windows version number

} NEWEXEFORMAT;

//	Flags for the wFlags variable:

#define NE_SINGLEDATA		0x0001	// The linker sets this bit if the executable-file format is SINGLEDATA.
#define NE_MULTIPLEDATA		0x0002	// The linker sets this bit if the executable-file format is MULTIPLEDATA.
#define NE_LOADSEGMENT		0x0800	// If this bit is set, the first segment in the executable file contains code that loads the application.
#define NE_RUNTIMEERRORS	0x2000	// If this bit is set, the linker detects errors at link time but still creates an executable file.
#define NE_LIBRARY			0x8000	// If this bit is set, the executable file is a library module.


