7  
' Mosaic.
' Calc average color of every rect painting in the destination the RGB value.
' For a better and faster result use 24 bit output.

' Input:	4-8-24 bit
' Output:	4-8-24 bit

' Author:	Andrea Benoni			 rev:	1.2


string    	inpFile,outFile
DevCon	Ibmp,Obmp
RGB	pix
float  	x,y,xm,ym,xt,yt,s,t,r,g,b

s=6						' rect side
t=1						' black line thick
inpFile="Testi.bmp"				' input file
outFile="Testo.bmp"				' output file

Ibmp=LoadImage(inpFile)				' legge l'immagine
xm=Ibmp.Width/s
ym=Ibmp.Height/s
Obmp=CreateImage(Ibmp.Width,Ibmp.Height,24)'Ibmp.BitCount)
				   ' or substitute Ibmp.BitCount with 24

if((Ibmp.BitCount=8)	|(Ibmp.BitCount=4))			' if 4 or 8 bit copy palette
  For y=0 to 255
     pix=GetPalette(Ibmp,y)
     SetPalette(Obmp,y,pix)
  Next y
Endif

t=t+1
For y=0 to ym
   DspWhile("Mosaic",100/ym*y)
   For x=0 to xm
      r=0
      g=0
      b=0
      for yt=y*s to y*s+s-1			' calc orig RGB average
         for xt=x*s to x*s+s-1	
            pix=GetPixel(Ibmp,xt,yt)
            r=r+pix.Red
            g=g+pix.Green
            b=b+pix.Blue
         next xt
      next yt
      pix.Red=r/s/s
      pix.Green=g/s/s
      pix.Blue=b/s/s

      for yt=y*s to y*s+s-t
         for xt=x*s to x*s+s-t	
            SetPixel(Obmp,xt,yt,pix)		' set average RGB on output
         next xt
      next yt
   Next x
Next y
Preview(Ibmp,inpFile,5,5,Ibmp.Width+6,Ibmp.Height+20)
Preview(Obmp,outFile,320,5,Obmp.Width+6,Obmp.Height+20)

SaveImage(Obmp,outFile)		' Save output image
DspWhile("",0)
DspMes("End")