// links.cpp : implementation file
//

#include "stdafx.h"
#include "vogon.h"

#include "CntrInfo.h"
#include "CntrItem.h"
#include "links.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CHyperlinkDlg dialog


CHyperlinkDlg::CHyperlinkDlg(_DWebster* pWebsterDispatch, CWnd* pParent /*=NULL*/)
	: CDialog(CHyperlinkDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CHyperlinkDlg)
	m_stringLink = _T("");
	//}}AFX_DATA_INIT

   // Stash the Webster OCX dispatch pointer
   m_pWebsterDispatch = pWebsterDispatch;
}


void CHyperlinkDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CHyperlinkDlg)
	DDX_Control(pDX, IDC_STATIC_HYPERLINKCOUNT, m_staticLinkCount);
	DDX_Control(pDX, IDC_LIST_LINKS, m_listboxLinks);
	DDX_Control(pDX, IDC_EDIT_LINK, m_editLink);
	DDX_Text(pDX, IDC_EDIT_LINK, m_stringLink);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CHyperlinkDlg, CDialog)
	//{{AFX_MSG_MAP(CHyperlinkDlg)
	ON_LBN_SELCHANGE(IDC_LIST_LINKS, OnSelchangeListLinks)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CHyperlinkDlg message handlers

/////////////////////////////////////////////////////////////////////////////
//
BOOL CHyperlinkDlg::OnInitDialog() 
{
   CDialog::OnInitDialog();

   // Get the current page URL
   CString stringURL(m_pWebsterDispatch->GetPageURL());

   // Get the hyperlink count for the current visible page:
   int linkCount = m_pWebsterDispatch->GetLinkCount(stringURL);

   // Show hyperlink count in the static
   TCHAR fmtBuf[64];
   m_staticLinkCount.SetWindowText(CString(itoa(linkCount, fmtBuf, 10)));

   // Fill the list box with hyperinks:
   for (int index = 0; index < linkCount; index++)
   {  // Add each string to the listbox, which is unsorted
      m_listboxLinks.AddString(m_pWebsterDispatch->GetLinkURL(stringURL, index));
   }

   // TODO: Add extra initialization here
   return TRUE;  // return TRUE unless you set the focus to a control
                 // EXCEPTION: OCX Property Pages should return FALSE
}

/////////////////////////////////////////////////////////////////////////////
//
void CHyperlinkDlg::OnSelchangeListLinks() 
{
   if (m_listboxLinks.GetCurSel() != LB_ERR)
   {  // Get the selected item
      m_listboxLinks.GetText(m_listboxLinks.GetCurSel(), m_stringLink);
      // Copy to the edit control
      m_editLink.SetWindowText(m_stringLink);
   }
}
