// vcdemvw.cpp : implementation of the CVcdemoView class
//

#include "stdafx.h"
#include <stdlib.h>
#include "vcdemo.h"

#include "vcdemdoc.h"
#include "vcdemvw.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CVcdemoView

IMPLEMENT_DYNCREATE(CVcdemoView, CFormView)

BEGIN_MESSAGE_MAP(CVcdemoView, CFormView)
	//{{AFX_MSG_MAP(CVcdemoView)
	ON_WM_CREATE()
	ON_WM_TIMER()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVcdemoView construction/destruction

CVcdemoView::CVcdemoView()
	: CFormView(CVcdemoView::IDD)
{
	//{{AFX_DATA_INIT(CVcdemoView)
	m_speed = NULL;
	m_direction = NULL;
	//}}AFX_DATA_INIT
	// TODO: add construction code here
}

CVcdemoView::~CVcdemoView()
{
}

void CVcdemoView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CVcdemoView)
	DDX_VBControl(pDX, IDC_SPEED, m_speed);
	DDX_VBControl(pDX, IDC_DIRECTION, m_direction);
	//}}AFX_DATA_MAP
	
	SetTimer(1,55,NULL);
}

/////////////////////////////////////////////////////////////////////////////
// CVcdemoView diagnostics

#ifdef _DEBUG
void CVcdemoView::AssertValid() const
{
	CFormView::AssertValid();
}

void CVcdemoView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

CVcdemoDoc* CVcdemoView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CVcdemoDoc)));
	return (CVcdemoDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CVcdemoView message handlers

int CVcdemoView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFormView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	return 0;
}

void CVcdemoView::OnTimer(UINT nIDEvent)
{
float speed, direction;

	CFormView::OnTimer(nIDEvent);
	
	speed = m_speed->GetFloatProperty("NeedleValue");
	direction = m_direction->GetFloatProperty("NeedleValue");
	
	speed += (float) rand()/ (float) RAND_MAX * (float) 4 - (float) 2;
	direction += (float) rand()/ (float) RAND_MAX * (float) 6 - (float) 3;
	
	if (direction<0) direction += 360;
	if (direction>360) direction -= 360;
	
	m_speed->SetFloatProperty("NeedleValue",speed);
	
	m_direction->SetNumProperty("TicID",0);
	m_direction->SetFloatProperty("TicFloatOffset",-direction);
	m_direction->SetNumProperty("TicID",1);
	m_direction->SetFloatProperty("TicFloatOffset",-direction);
	m_direction->SetFloatProperty("NeedleValue",direction);
}

void CVcdemoView::OnDestroy()
{
	CFormView::OnDestroy();
	
	KillTimer(1);
	
}
