//  CHangman.cpp
//
//  Jasen N. Tenney
//	21 December 1995
//  
//  Functions for the CHangman class.
//
#include "stdafx.h"
#include "Hangman.h"

CHangman::CHangman()
{
	// Do initialization here
	m_CurrentDictionary.RemoveAll();
	m_CurrentDictionary.SetSize( 7000, 2000);	// Set initial size and grow by size
	srand( (unsigned)time( NULL ) );			// Seed random number generator
	m_NumValidGuesses = 10;						// Set number of valid guesses
	Reset();									
} 

CHangman::~CHangman()
{
}

void CHangman::LoadNewWord()
{
	UINT Index;

	Index				= rand() % m_WordCount;	// Get index of new word
	m_CurrentWord		= m_CurrentDictionary.GetAt(Index);	// Load new word
	m_CurrentGuess		= InitCurrentGuess();	// Initialize current guess "_ _..."
	m_GuessesRemaining	= m_NumValidGuesses;	// Reset guesses remaining
	m_TotalGuesses		= 0;					// Total guesses so far
}

BOOL CHangman::CheckLetter(char Letter)
{
	BOOL LetterAdded   = FALSE;
	int Size  =0;
	int Index =0;

	Size = m_CurrentWord.GetLength();	// Get length of current word
    for(Index=0; Index<Size; Index++)	// Step through word to check		
	{
		if( m_CurrentWord[Index] == Letter )	// If we hit a letter then
		{
			m_CurrentGuess.SetAt( (Index*2), Letter);	// Set current guess to
			LetterAdded = TRUE;							// letter and change bool
		}
	}
	if( LetterAdded == FALSE )
		DecrementGuessRemain();		// If no letter added decrement guesses remaining

	IncrementTotalGuesses();		// Increment total guesses so far
	return( LetterAdded );			// Return TRUE/FALSE if letter added or not
}

UINT CHangman::GetGamesPlayed()
{
	return( m_GamesPlayed );		// Return number of games played so far
}

UINT CHangman::GetGamesWon()
{
	return( m_GamesWon );			// Return number of games won so far
}

UINT CHangman::GetPercentage()
{
	if( m_GamesPlayed != 0 )		// Only do divide if games played not zero
		m_Percentage = (UINT)(((float)m_GamesWon / (float)m_GamesPlayed) * 100);
	return( m_Percentage );			// Return the percentage
}

CString CHangman::InitCurrentGuess()
{
	int Index = 0;
	CString Temp;					// Use a temporary string

	for(Index=0; Index < m_CurrentWord.GetLength(); Index++)
		if( Index == ( m_CurrentWord.GetLength() - 1 ) )
			Temp += "_";	// If last the just put "_" and not "_ "
		else
			Temp += "_ ";	// Make string look like "_ _ _ _"
	
	return( Temp );			// Return it to calling function
}

CString CHangman::GetCurrentGuess()
{
	return( m_CurrentGuess );	// Return the current # of guesses so far
}

void CHangman::Reset()
{
	m_GamesPlayed		= 0;	// Reset all variables to reflect new game
	m_GamesWon			= 0; 
	m_Percentage		= 0;
}

UINT CHangman::GetGuessRemain()
{
	return( m_GuessesRemaining );	// Return the # of guesses remaining
}

BOOL CHangman::CheckWordCompleted()
{
	BOOL WordCompleted = TRUE;
	int Size  =0;
	int Index =0;

	Size = m_CurrentWord.GetLength();	// Get length of current word
    for(Index=0; Index<Size; Index++)
	{
		if( m_CurrentWord[Index] != m_CurrentGuess.GetAt( Index*2 ) )
			WordCompleted = FALSE;	// If all letter do not match then not completed
	}
	return( WordCompleted );	// Return TRUE/FALSE if guess is completed or not
}

void CHangman::IncrementGamesWon()
{
	m_GamesWon++;				// Increment # of games won
}

void CHangman::IncrementGamesPlayed()
{
	m_GamesPlayed++;			// Increment # of games played
}

CString CHangman::GetHintLetter()
{
	CString Letter;
	int Size  =0;
	int Index =0;

	Size = m_CurrentWord.GetLength();
    for(Index=0; Index<Size; Index++)
	 	if( m_CurrentGuess.GetAt( Index*2 ) == '_' )
		{
			Letter = m_CurrentWord.GetAt( Index );	// On first '_' return the
			break;									// letter that should be there
		}
	return( Letter );
}

void CHangman::DecrementGuessRemain()
{	
	if( m_GuessesRemaining > 0 )	// As long as guesses remaining is greater than
		m_GuessesRemaining--;		// zero you can subtract from it
}

CString CHangman::GetCurrentWord()
{
	return( m_CurrentWord );		// Return current word
}

void CHangman::IncrementTotalGuesses()
{
	m_TotalGuesses++;				// Increment # of total guesses so far
}

UINT CHangman::GetTotalGuesses()
{
	return( m_TotalGuesses );		// Return total guesses so far
}

BOOL CHangman::LoadDictionary()
{
	CStdioFile f;
	CFileException exception;
	BOOL openStatus = FALSE;
	BOOL fileStatus = TRUE;
	char* pFileName = "hangman.dic";
	UINT Index = 0;

	// open file for reading
	openStatus = f.Open(pFileName,
			CFile::modeRead, &exception);
	if (!openStatus)
	{
		CString strMsg;
		char tmpStr[30];

		_itoa( exception.m_cause, tmpStr, 10 );
		strMsg =  "Error opening data file. Code: ";
		strMsg += tmpStr;
		strMsg += ".";
		MessageBox(NULL, strMsg, NULL, MB_ICONINFORMATION | MB_OK);
		return( FALSE );
	} 
	else
	{
		CString tmpStr;
		do
		{
			try
			{
				fileStatus = f.ReadString(tmpStr);
				if(fileStatus == TRUE)
				{
					m_CurrentDictionary.SetAt(Index,tmpStr);
					Index++;
				}
				
			}
			catch (CFileException exception)
			{
				CString strMsg;
				char tmpStr[30];

				_itoa( exception.m_cause, tmpStr, 10 );
				strMsg =  "Error reading data file. Code: ";
				strMsg += tmpStr;
				strMsg += ".";
				MessageBox(NULL, strMsg, NULL, MB_ICONINFORMATION | MB_OK);
				return( FALSE );
			}
		}
		while (fileStatus == TRUE); 
		f.Close();
	}
	m_WordCount = Index;
	return( TRUE );
}

void CHangman::LoadErrorDictionary()
{
	UINT Index;
    for(Index= 0; Index<100; Index++)	// Upon error load dictionary to this
 	  m_CurrentDictionary.SetAt(Index,"JASENNTENNEY");
 	m_WordCount=Index;
}
