{********************************************}
{*                                          *}
{*  PRCNT25.PAS generated from PRCNT25.VBX  *}
{*                                          *}
{********************************************}

unit Prcnt25;

interface

uses SysUtils, Classes, Graphics, Forms, Controls, VBXCtrl, BIVBX;

{ $DEFINE InitTPrcnt}
{^- Remove space to enable default init data -- See documentation. }

type
  TPrcntChangeEvent = procedure (Sender: TObject) of object;

  { TPrcnt }

  TPrcnt = class(TVBXControl)
  protected
    FOnChange: TPrcntChangeEvent;
    { Event handler }
    procedure HandleVBXEvent(var Message: TWMVBXFireEvent); override;
    procedure DefineProperties(Filer: TFiler); override;
  public
    constructor Create(AOwner: TComponent); override;

    property Index: TVBInteger index 0 read GetIntProp;
    property FontName: TVBString index 13 read GetStringProp write
      SetStringProp;
    property FontBold: Boolean index 14 read GetBoolProp write SetBoolProp;
    property FontItalic: Boolean index 15 read GetBoolProp write SetBoolProp;
    property FontStrikethru: Boolean index 16 read GetBoolProp write
      SetBoolProp;
    property FontUnderline: Boolean index 17 read GetBoolProp write
      SetBoolProp;
    property FontSize: Single index 18 read GetSingleProp write SetSingleProp;
    property AVersion: Single index 19 read GetSingleProp write SetSingleProp;
    property Redraw: Boolean index 55 read GetBoolProp write SetBoolProp;
    property RedrawStatic: Boolean index 56 read GetBoolProp write
      SetBoolProp;
    property ZLoad: TVBInteger index 60 read GetIntProp write SetIntProp;
  published
    property Enabled;
    property Visible;
    property MousePointer: TVBEnum index 8 read GetEnumProp write SetEnumProp
      default 0;
    property TabOrder;
    property TabStop;
    property About: TVBString index 20 read GetStringProp {NoRT}write
      SetStringProp stored False;
    property BevelWidth: TVBInteger index 21 read GetIntProp write SetIntProp;
    property BevelInner: TVBEnum index 22 read GetEnumProp write SetEnumProp;
    property BevelOuter: TVBEnum index 23 read GetEnumProp write SetEnumProp;
    property BorderWidth: TVBInteger index 24 read GetIntProp write
      SetIntProp;
    property Max: Single index 25 read GetSingleProp write SetSingleProp;
    property Min: Single index 26 read GetSingleProp write SetSingleProp;
    property Value: Single index 27 read GetSingleProp write SetSingleProp;
    property BackColor: TColor index 28 read GetColorProp write SetColorProp;
    property BackPicture: TVBPic index 29 read GetPictureProp write
      SetPictureProp stored False;
    property OnColor: TColor index 30 read GetColorProp write SetColorProp;
    property OnPicture: TVBPic index 31 read GetPictureProp write
      SetPictureProp stored False;
    property OffColor: TColor index 32 read GetColorProp write SetColorProp;
    property OffPicture: TVBPic index 33 read GetPictureProp write
      SetPictureProp stored False;
    property BarBorder: Single index 34 read GetSingleProp write
      SetSingleProp;
    property BarInner: Single index 35 read GetSingleProp write SetSingleProp;
    property BarOuter: Single index 36 read GetSingleProp write SetSingleProp;
    property Orientation: TVBEnum index 37 read GetEnumProp write SetEnumProp;
    property Direction: TVBEnum index 38 read GetEnumProp write SetEnumProp;
    property MouseControl: Boolean index 39 read GetBoolProp write
      SetBoolProp;
    property Percent: Single index 40 read GetSingleProp write SetSingleProp;
    property PercentColor: TColor index 41 read GetColorProp write
      SetColorProp;
    property PercentStyle: TVBEnum index 42 read GetEnumProp write
      SetEnumProp;
    property PercentFontID: TVBInteger index 43 read GetIntProp write
      SetIntProp;
    property ShapeStyle: TVBEnum index 44 read GetEnumProp write SetEnumProp;
    property Shape: TVBString index 45 read GetStringProp write SetStringProp;
    property DisplayMode: TVBEnum index 46 read GetEnumProp write SetEnumProp;
    property Captions: TVBInteger index 47 read GetIntProp write SetIntProp;
    property CaptionID: TVBInteger index 48 read GetIntProp write SetIntProp;
    property Caption: TVBString index 49 read GetStringProp write
      SetStringProp stored False;
    property CaptionX: Single index 50 read GetSingleProp write SetSingleProp
      stored False;
    property CaptionY: Single index 51 read GetSingleProp write SetSingleProp
      stored False;
    property CaptionColor: TColor index 52 read GetColorProp write
      SetColorProp stored False;
    property CaptionFontID: TVBInteger index 53 read GetIntProp write
      SetIntProp stored False;
    property AutoRedraw: Boolean index 54 read GetBoolProp write SetBoolProp;
    property FontID: TVBInteger index 57 read GetIntProp write SetIntProp;
    property Fonts: TVBInteger index 58 read GetIntProp write SetIntProp
      stored False;
    property FontDialog_: TVBString index 59 read GetStringProp {NoRT}write
      SetStringProp stored False;
    property OnClick;
    property OnDragDrop;
    property OnEndDrag;
    property OnDragOver;
    property OnEnter;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnExit;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnChange: TPrcntChangeEvent read FOnChange write FOnChange;
  end;

procedure Register;

implementation

{ Default form data for TPrcnt }

{$IFDEF InitTPrcnt}

const
  TPrcntInitLen = 192;

procedure TPrcntInitData; near; assembler;
asm
	DB	$00,$00,$00,$02,$06,$FF,$FF,$07,$FF,$FF,$08,$00,$09,$00,$00,$0A
	DB	$00,$00,$0B,$00,$0C,$05,$50,$72,$63,$6E,$74,$13,$62,$10,$20,$40
	DB	$15,$02,$00,$16,$01,$17,$02,$18,$02,$00,$19,$00,$00,$C8,$42,$1A
	DB	$00,$00,$00,$00,$1B,$00,$00,$48,$42,$1C,$C0,$C0,$C0,$00,$1E,$00
	DB	$00,$6E,$00,$20,$FF,$FF,$FF,$00,$22,$CD,$CC,$CC,$3D,$23,$CD,$CC
	DB	$4C,$3E,$24,$CD,$CC,$4C,$3F,$25,$00,$26,$00,$27,$FF,$FF,$28,$00
	DB	$00,$48,$42,$29,$00,$00,$00,$00,$2A,$00,$2B,$00,$00,$2C,$00,$2D
	DB	$00,$2E,$00,$2F,$00,$00,$30,$00,$00,$31,$32,$33,$34,$35,$36,$FF
	DB	$FF,$39,$00,$00,$3C,$C8,$D3,$00,$00,$00,$00,$01,$00,$10,$00,$07
	DB	$00,$00,$00,$00,$00,$BC,$02,$00,$00,$00,$00,$01,$02,$02,$22,$53
	DB	$79,$73,$74,$65,$6D,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$FF
end;

{$ENDIF}

{ TPrcnt }

constructor TPrcnt.Create(AOwner: TComponent);
begin
  FVBXFile := StrNew('PRCNT25.VBX');
  FVBXClass := StrNew('PRCNT');
  SetBounds(0, 0, 80, 32);
  inherited Create(AOwner);
  ControlStyle := ControlStyle - [csCaptureMouse, csClickEvents];
  TabStop := True;
  FVBXFlags := [vfLoadMessage];
  {$IFDEF InitTPrcnt}
  FHForm := VBXCreateFormFile(TPrcntInitLen, @TPrcntInitData);
  {$ENDIF}
end;

procedure TPrcnt.HandleVBXEvent(var Message: TWMVBXFireEvent);
begin
  case Message.VBXEvent^.EventIndex of
    0: DispatchNotifyEvent(OnClick);
    1: begin end; { VCL Handles OnDragDrop }
    2: begin end; { VCL Handles OnDragOver }
    3: begin end; { VCL Handles OnGotFocus }
    4: DispatchKeyEvent(OnKeyDown, Message);
    5: DispatchKeyPressedEvent(OnKeyPress, Message);
    6: DispatchKeyEvent(OnKeyUp, Message);
    7: begin end; { VCL Handles OnLostFocus }
    8: DispatchMouseEvent(OnMouseDown, Message);
    9: DispatchMouseMoveEvent(OnMouseMove, Message);
    10: DispatchMouseEvent(OnMouseUp, Message);
    11: DispatchCustomEvent(FOnChange, Message, 11);
  end;
end;

procedure TPrcnt.DefineProperties(Filer: TFiler);
begin
  inherited DefineProperties(Filer);
  HandleProperty('AVersion', Filer, 19);
  HandleBinaryProperty('BackPicture_Data', Filer, 29);
  HandleBinaryProperty('OnPicture_Data', Filer, 31);
  HandleBinaryProperty('OffPicture_Data', Filer, 33);
  HandleBinaryProperty('Caption_Data', Filer, 49);
  HandleBinaryProperty('CaptionX_Data', Filer, 50);
  HandleBinaryProperty('CaptionY_Data', Filer, 51);
  HandleBinaryProperty('CaptionColor_Data', Filer, 52);
  HandleBinaryProperty('CaptionFontID_Data', Filer, 53);
  HandleBinaryProperty('ZLoad', Filer, 60);
end;

{ Designer registration }
procedure Register;
begin
  RegisterComponents('VBX', [
    TPrcnt]);
end;

end.
