/*     Script Remover 1.10 - written by Th. Lopatic 17-Apr-1995     */

/* This program relies on a heuristic and on undocumented features. */
/*   Use it at your own risk and TEST your stripped applications.   */
/*   Send suggestions etc. to lopatic@informatik.uni-muenchen.de.   */

#include <io.h>
#include <fcntl.h>
#include <string.h>

char title[] = "remscr 1.10 - by Thomas Lopatic (lopatic@informatik.uni-muenchen.de)";
char usage[] = "\nusage: remscr [/c] book_file";
char open_err[] = "\nerror - cannot open book file";
char read_err[] = "\nerror - cannot read from book file";
char write_err[] = "\nerror - cannot write to book file";
char seek_err[] = "\nerror - cannot seek in book file";
char len_err[] = "\nerror - size info of script is too low (try the /c option)";
char no_err[] = "\nmarked scripts have been cleared";
char magic[] = "-- REMOVE THIS SCRIPT";
char input[20000];

#define SEEK_ERROR { \
	write (1, seek_err, sizeof (seek_err) - 1); \
	ret = 3; \
	goto exit_loop; \
}

#define WRITE_ERROR { \
	write (1, write_err, sizeof (write_err) - 1); \
	ret = 4; \
	goto exit_loop; \
}

#define READ_ERROR { \
	write (1, read_err, sizeof (read_err) - 1); \
	ret = 5; \
	goto exit_loop; \
}

int c_opt;
struct {
	char *optstr;
	int *optadr;
} optlist[] = {
	{ "/c", &c_opt },
	{ 0, 0 }
};

int main (int ac, char *av[])
{
	int fh, ret, len, i, k;
	unsigned slen;
	unsigned char c;

	c_opt = 0;
	write (1, title, sizeof (title) - 1);
	if (ac < 2 || ac > 3) {
		write (1, usage, sizeof (usage) - 1);
		ret = 1;
	} else {
		for (i = 1; i < ac - 1; i++) {
			for (k = 0; optlist[k].optstr != 0; k++)
				if (strcmp (optlist[k].optstr, av[i]) == 0)
					break;
			if (optlist[k].optadr != 0)
				*optlist[k].optadr = 1;
			else {
				write (1, usage, sizeof (usage) - 1);
				ret = 1;
				break;
			}
		}
		if (i == ac - 1) {
			if ((fh = open (av[i], O_BINARY | O_RDWR)) < 0) {
				write (1, open_err, sizeof (open_err) - 1);
				ret = 2;
			} else {
				while ((len = read (fh, input, sizeof (input))) > 0) {
					for (i = 0; i < len - sizeof (magic) + 1; i++) {
						for (k = 0; k < sizeof (magic) - 1 && magic[k] == input[i + k]; k++);
						if (k == sizeof (magic) - 1) {
							if (c_opt == 0) {
								if (lseek (fh, (long)i - (long)len - 2L, SEEK_CUR) < 0)
									SEEK_ERROR;
								if (read (fh, &slen, sizeof (slen)) != sizeof (slen))
									READ_ERROR;
								if (slen < sizeof (magic)) {
									write (1, len_err, sizeof (len_err) - 1);
									ret = 6;
									goto exit_loop;
								}
								if (lseek (fh, -2L, SEEK_CUR) < 0)
									SEEK_ERROR;
								slen += 2;
								c = 0x00;
							} else {
								if (lseek (fh, (long)i - (long)len, SEEK_CUR) < 0)
									SEEK_ERROR;
								slen = 0;
								do {
									if ((k = read (fh, &c, 1)) != 1)
										READ_ERROR;
									slen++;
								} while (c != 0);
								if (lseek (fh, -(long)slen, SEEK_CUR) < 0)
									SEEK_ERROR;
								slen -= 1;
								c = 0xe0;
							}
							while (slen-- != 0)
								if (write (fh, &c, 1) != 1)
									WRITE_ERROR;
							goto next_while;
						}
					}
next_while:
				}
				ret = 0;
				write (1, no_err, sizeof (no_err) - 1);
exit_loop:
				close (fh);
			}
		}
	}
	return ret;
}
