////////////////////////////////////////////////////////////////////////////////////
// Internet Global Phone Project
// phonevw.h : interface of the CPhoneView class                             
//
// The Phoneview class is responsible for user interface handling and low level 
// audio handling (including compression/decompression via GSM).
//
////////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 1993-1994	microWonders Inc.  All rights reserved.
//                                                                         
// AN OPEN INVITION TO BUILD UPON AND CONTRIBUTE TO THE PUBLIC TECHNOLOGY POOL:
// You are encouraged to redistribute, and build upon the technologies presented 
// in this source module and the accompanying article in Dr. Dobb's Journal provided 
// all the conditions listed in the MUSTREAD.TXT file, included with this 
// distribution, are met.
////////////////////////////////////////////////////////////////////////////////////

#include "mmsystem.h"                                          
#include "gsm.h"

//
// To enable 16 bit sound record and playback, uncomment the following two defines.
// Note it is also possible (although there's almost no reason to) enable assymetrical
//  sampling/playback sample widths.
//                          
// 16 bits input sampling                       
//#define HIGH_FIDELITY   
// 16 bits output 
//#define HIGH_FI_OUT

// an out of memory error, specific to IGP
#define IGP_NOMEM		1

// custom messages to signify completing of recording and compression
#define	PHONEMSG_RECORD_DONE	WM_USER+100 
#define PHONEMSG_COMPRESS_DONE	WM_USER+102                          

// various buffer size definitions
#define PHONE_WAVEIN_BUFSIZE	12000L
#define PHONE_WAVEOUT_BUFSIZE	12000L  // ** must be multiple of GSM_FRAME_SIZE
#define COMPRESSED_BUFSIZE		200000L 
#define GSM_FRAME_SIZE			160  
                              
// Ports to listen/connect                              
// IGP_PORT is compatible with UNIX current atalk and mtalk utilities
// IGP_P2 is used in testing. By dovtailing StartListener() and Connect() port numbers,
//
//   and creating two mphones, one can do testing on a loopback.
//
#define IGP_PORT	5101      
#define IGP_P2		5104

/*
 * Data Types
 */
typedef struct waveInst {
    HANDLE hWaveInst;
    HANDLE hWaveHdr;
    HANDLE hWaveData;
    BOOL LastBlock;
} WAVEINST;


typedef WAVEINST FAR *LPWAVEINST;   
typedef struct threadState{  
ULONG		maxIter;
ULONG		linearCount;
ULONG		i;
LPWAVEHDR	lpWaveHdr;
HPSTR		lpData;  
BOOL		doneBuffer;
} TSTATE;     

typedef struct dthrdState{
ULONG	linear;
UINT	b;
HPSTR	CompressedBuf;
ULONG	CompBufSize;
ULONG	i;
LPWAVEHDR lpWaveHdr; 
LPWAVEINST lpWaveInst;
HPSTR lpData;
} DTSTATE;

typedef TSTATE FAR *LPTSTATE;
class CPhoneView : public CEditView
{
protected: // create from serialization only
	CPhoneView();
	DECLARE_DYNCREATE(CPhoneView)

// Attributes
public:
	CPhoneDoc* GetDocument();  

protected:
    BOOL m_recording; 
    BOOL m_transmitting; 
    BOOL m_compressing;  
    
    BOOL m_compressWork;
    BOOL m_decompressWork;
    
    HWAVEIN m_hWaveIn; 
    HWAVEOUT m_hWaveOut; 
    CDWordArray  m_bufList;
    gsm m_hGsm;
    gsm_frame m_GsmBuf;
    gsm_signal m_sample[GSM_FRAME_SIZE]; 
    
    HGLOBAL m_hCompress;
    HGLOBAL m_hspeechBuffer;
    HPSTR m_CompressedBuf;
    unsigned long m_CompBufSize;
	
	TSTATE	m_state;  // background thread states variables    
	DTSTATE m_dstate;  // background decompression thread states
	// Sockets                  
	BOOL m_ListenerStarted;
	CTalkListenServer m_TalkListener;
	CTalkClient m_TalkClient;  
	WSADDRESS m_ClientAddress; 
	WSADDRESS m_ListenerAddress;

// Operations
public:
    LRESULT ExpandWaveOut(HGLOBAL hMem, HPSTR buffer, ULONG bufLength);    
// Implementation
public:
	virtual ~CPhoneView();
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

      
	BOOL DoIdleProcessing(void);   // this is the idle loop backgroup process
protected:
    BOOL MakeWaveInBuffer( HWAVEIN hWaveIn, LPWAVEHDR &newBuf, DWORD dwBufSize);  // Create a New buffer
    BOOL MakeWaveOutBuffer(HWAVEIN hWaveIn, HWAVEOUT hWaveOut, LPWAVEHDR &newBuf, DWORD dwBufSize); 
    BOOL DestroyWaveInBuffer(HWAVEIN hWaveIn, LPWAVEHDR oldBuf);   
    BOOL DestroyWaveOutBuffer(HWAVEOUT hWaveOut, LPWAVEHDR oldBuf); 
    LRESULT CompressPartialBuffer(LPTSTATE state);
    LRESULT PlayWaveInBuffer(LPWAVEHDR); 
    LRESULT CompressABuffer(HPSTR lpData, DWORD lsize);  
    void AddOut(LPSTR,  UINT);
// Generated message map functions
protected:
	//{{AFX_MSG(CPhoneView) 
	afx_msg LRESULT OnWaveInClose(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnWaveInOpen(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnWaveInData(WPARAM wParam, LPARAM lParam);    
	afx_msg LRESULT OnWaveOutDone(WPARAM wParam, LPARAM lParam);
    afx_msg LRESULT OnRecordDone(WPARAM wParam, LPARAM lParam); 
    afx_msg LRESULT OnCompressDone(WPARAM wParam, LPARAM lParam);
    afx_msg LRESULT OnClientNotify(WPARAM wParam, LPARAM lParam);
	afx_msg void OnUpdatePhRecord(CCmdUI* pCmdUI);
	afx_msg void OnUpdatePhSend(CCmdUI* pCmdUI);
	afx_msg void OnPhRecord();
	afx_msg void OnPhSend();
	afx_msg void OnFileOpen();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in phonevw.cpp
inline CPhoneDoc* CPhoneView::GetDocument()
   { return (CPhoneDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
